/* application.c generated by valac 0.10.1, the Vala compiler
 * generated from application.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009-2010  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <xfconf/xfconf.h>
#include <libxfce4util/libxfce4util.h>
#include <signal.h>
#include <gdk/gdk.h>
#include <color.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <config.h>


#define XNP_TYPE_APPLICATION (xnp_application_get_type ())
#define XNP_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_APPLICATION, XnpApplication))
#define XNP_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_APPLICATION, XnpApplicationClass))
#define XNP_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_APPLICATION))
#define XNP_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_APPLICATION))
#define XNP_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_APPLICATION, XnpApplicationClass))

typedef struct _XnpApplication XnpApplication;
typedef struct _XnpApplicationClass XnpApplicationClass;
typedef struct _XnpApplicationPrivate XnpApplicationPrivate;

#define XNP_TYPE_WINDOW (xnp_window_get_type ())
#define XNP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_WINDOW, XnpWindow))
#define XNP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_WINDOW, XnpWindowClass))
#define XNP_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_WINDOW))
#define XNP_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_WINDOW))
#define XNP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_WINDOW, XnpWindowClass))

typedef struct _XnpWindow XnpWindow;
typedef struct _XnpWindowClass XnpWindowClass;
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

#define XNP_TYPE_NOTE (xnp_note_get_type ())
#define XNP_NOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_NOTE, XnpNote))
#define XNP_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_NOTE, XnpNoteClass))
#define XNP_IS_NOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_NOTE))
#define XNP_IS_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_NOTE))
#define XNP_NOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_NOTE, XnpNoteClass))

typedef struct _XnpNote XnpNote;
typedef struct _XnpNoteClass XnpNoteClass;
typedef struct _XnpNotePrivate XnpNotePrivate;

#define XNP_TYPE_HYPERTEXT_VIEW (xnp_hypertext_view_get_type ())
#define XNP_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView))
#define XNP_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))
#define XNP_IS_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_IS_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_HYPERTEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))

typedef struct _XnpHypertextView XnpHypertextView;
typedef struct _XnpHypertextViewClass XnpHypertextViewClass;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _XnpApplication {
	GObject parent_instance;
	XnpApplicationPrivate * priv;
};

struct _XnpApplicationClass {
	GObjectClass parent_class;
};

struct _XnpApplicationPrivate {
	GSList* window_list;
	char* notes_path;
	char* _config_file;
	XfconfChannel* xfconf_channel;
};

struct _XnpNote {
	GtkBin parent_instance;
	XnpNotePrivate * priv;
	GtkScrolledWindow* scrolled_window;
	XnpHypertextView* text_view;
};

struct _XnpNoteClass {
	GtkBinClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	XnpApplication * self;
	GtkMenu* menu;
};


static gpointer xnp_application_parent_class = NULL;

GType xnp_application_get_type (void) G_GNUC_CONST;
GType xnp_window_get_type (void) G_GNUC_CONST;
#define XNP_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XNP_TYPE_APPLICATION, XnpApplicationPrivate))
enum  {
	XNP_APPLICATION_DUMMY_PROPERTY,
	XNP_APPLICATION_CONFIG_FILE
};
static void _g_slist_free_g_object_unref (GSList* self);
XnpApplication* xnp_application_new (const char* config_file);
XnpApplication* xnp_application_construct (GType object_type, const char* config_file);
static void xnp_application_quit (XnpApplication* self);
static void _xnp_application_quit_xfce_posix_signal_handler_callback (gint signal, gpointer self);
static void xnp_application_update_color (XnpApplication* self);
static void _lambda19_ (XnpApplication* self);
static void __lambda19__xfconf_channel_property_changed (XfconfChannel* _sender, const char* p0, GValue* p1, gpointer self);
static void _lambda20_ (XnpApplication* self);
static void __lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
XnpWindow* xnp_application_create_window (XnpApplication* self, const char* name);
void xnp_application_save_notes (XnpApplication* self);
XnpWindow* xnp_window_new (void);
XnpWindow* xnp_window_construct (GType object_type);
void xnp_window_set_above (XnpWindow* self, gboolean value);
void xnp_window_set_sticky (XnpWindow* self, gboolean value);
static gboolean xnp_application_window_name_exists (XnpApplication* self, const char* name);
void xnp_window_set_name (XnpWindow* self, const char* value);
gint xnp_window_compare_func (XnpWindow* self, XnpWindow* win2);
void xnp_window_set_window_list (XnpWindow* self, GSList* list);
const char* xnp_window_get_name (XnpWindow* self);
static void xnp_application_load_window_data (XnpApplication* self, XnpWindow* window);
static void _lambda21_ (XnpWindow* win, const char* action, XnpApplication* self);
static void xnp_application_rename_window (XnpApplication* self, XnpWindow* window);
static void xnp_application_delete_window (XnpApplication* self, XnpWindow* window);
void xnp_application_open_settings_dialog (XnpApplication* self);
void xnp_application_open_about_dialog (XnpApplication* self);
static void __lambda21__xnp_window_action (XnpWindow* _sender, const char* action, gpointer self);
GType xnp_note_get_type (void) G_GNUC_CONST;
static void _lambda23_ (XnpWindow* win, XnpNote* note, XnpApplication* self);
static void xnp_application_save_note (XnpApplication* self, XnpWindow* window, XnpNote* note);
static void __lambda23__xnp_window_save_data (XnpWindow* _sender, XnpNote* note, gpointer self);
static void _lambda24_ (XnpWindow* win, XnpNote* note, XnpApplication* self);
GType xnp_hypertext_view_get_type (void) G_GNUC_CONST;
const char* xnp_note_get_name (XnpNote* self);
static void __lambda24__xnp_window_note_inserted (XnpWindow* _sender, XnpNote* note, gpointer self);
static void _lambda25_ (XnpWindow* win, XnpNote* note, XnpApplication* self);
static void __lambda25__xnp_window_note_deleted (XnpWindow* _sender, XnpNote* note, gpointer self);
static void _lambda26_ (XnpWindow* win, XnpNote* note, const char* old_name, XnpApplication* self);
static gboolean xnp_application_name_is_valid (XnpApplication* self, const char* name);
void xnp_note_set_name (XnpNote* self, const char* value);
static void __lambda26__xnp_window_note_renamed (XnpWindow* _sender, XnpNote* note, const char* old_name, gpointer self);
XnpNote* xnp_window_insert_note (XnpWindow* self);
const char* xnp_application_get_config_file (XnpApplication* self);
void xnp_window_move_note (XnpWindow* self, const char* note_name, gint page);
void xnp_window_set_current_page (XnpWindow* self, gint page);
void xnp_application_save_windows_configuration (XnpApplication* self);
void xnp_window_get_geometry (XnpWindow* self, gint* winx, gint* winy, gint* width, gint* height);
char** xnp_window_get_note_names (XnpWindow* self, int* result_length1);
gint xnp_window_get_current_page (XnpWindow* self);
gboolean xnp_window_get_above (XnpWindow* self);
gboolean xnp_window_get_sticky (XnpWindow* self);
void xnp_window_save_notes (XnpWindow* self);
gint xnp_window_get_n_pages (XnpWindow* self);
void xnp_application_show_hide_notes (XnpApplication* self);
void xnp_window_hide (XnpWindow* self);
static void _lambda22_ (GtkAboutDialog* dialog, const char* uri, XnpApplication* self);
static void __lambda22__gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self);
GtkMenu* xnp_application_context_menu (XnpApplication* self);
static void _lambda27_ (Block1Data* _data1_);
static void _lambda28_ (GtkWidget* w, XnpApplication* self);
static void __lambda28__gtk_callback (GtkWidget* widget, gpointer self);
static void _lambda29_ (GtkMenuItem* i, XnpApplication* self);
static void __lambda29__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda30_ (XnpApplication* self);
static void __lambda30__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda27__gtk_widget_show (GtkWidget* _sender, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void xnp_application_set_config_file (XnpApplication* self, const char* value);
static GObject * xnp_application_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void xnp_application_finalize (GObject* obj);
static void xnp_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void xnp_application_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static void _xnp_application_quit_xfce_posix_signal_handler_callback (gint signal, gpointer self) {
	xnp_application_quit (self);
}


static void _lambda19_ (XnpApplication* self) {
	xnp_application_update_color (self);
}


static void __lambda19__xfconf_channel_property_changed (XfconfChannel* _sender, const char* p0, GValue* p1, gpointer self) {
	_lambda19_ (self);
}


static void _lambda20_ (XnpApplication* self) {
	xnp_application_update_color (self);
}


static void __lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda20_ (self);
}


XnpApplication* xnp_application_construct (GType object_type, const char* config_file) {
	XnpApplication * self = NULL;
	char* notesgtkrc;
	XfconfChannel* _tmp0_;
	char* name;
	gboolean found;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (config_file != NULL, NULL);
	self = (XnpApplication*) g_object_new (object_type, "config-file", config_file, NULL);
	notesgtkrc = g_strdup_printf ("%s/xfce4/xfce4-notes.gtkrc", g_get_user_config_dir ());
	gtk_rc_parse (notesgtkrc);
	{
		xfce_posix_signal_handler_init (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		xfce_posix_signal_handler_set_handler ((gint) SIGTERM, _xnp_application_quit_xfce_posix_signal_handler_callback, self, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		xfce_posix_signal_handler_set_handler ((gint) SIGINT, _xnp_application_quit_xfce_posix_signal_handler_callback, self, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("application.vala:48: Unable to connect to UNIX signals. %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_free0 (notesgtkrc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		xfconf_init (&_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == XFCONF_ERROR) {
				goto __catch1_xfconf_error;
			}
			_g_free0 (notesgtkrc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally1;
	__catch1_xfconf_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("application.vala:55: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (notesgtkrc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->xfconf_channel = (_tmp0_ = xfconf_channel_new_with_property_base ("xfce4-panel", "/plugins/notes"), _g_object_unref0 (self->priv->xfconf_channel), _tmp0_);
	xnp_application_update_color (self);
	g_signal_connect_object (self->priv->xfconf_channel, "property-changed::/global/background-color", (GCallback) __lambda19__xfconf_channel_property_changed, self, 0);
	g_signal_connect_object ((GObject*) gtk_settings_get_default (), "notify::gtk-theme-name", (GCallback) __lambda20__g_object_notify, self, 0);
	name = NULL;
	found = FALSE;
	{
		GDir* dir;
		dir = g_dir_open (self->priv->notes_path, (guint) 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		while (TRUE) {
			char* _tmp1_;
			XnpWindow* _tmp2_;
			if (!((name = (_tmp1_ = g_strdup (g_dir_read_name (dir)), _g_free0 (name), _tmp1_)) != NULL)) {
				break;
			}
			_tmp2_ = xnp_application_create_window (self, name);
			_g_object_unref0 (_tmp2_);
			found = TRUE;
		}
		_g_dir_close0 (dir);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_mkdir_with_parents (self->priv->notes_path, 0700);
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (name);
		_g_free0 (notesgtkrc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	if (found == FALSE) {
		XnpWindow* _tmp3_;
		_tmp3_ = xnp_application_create_window (self, NULL);
		_g_object_unref0 (_tmp3_);
	}
	_g_free0 (name);
	_g_free0 (notesgtkrc);
	return self;
}


XnpApplication* xnp_application_new (const char* config_file) {
	return xnp_application_construct (XNP_TYPE_APPLICATION, config_file);
}


static void xnp_application_update_color (XnpApplication* self) {
	char* color;
	g_return_if_fail (self != NULL);
	color = xfconf_channel_get_string (self->priv->xfconf_channel, "/global/background-color", "#F7EB96");
	if (_vala_strcmp0 (color, "GTK+") == 0) {
		GtkInvisible* style_widget;
		GdkColor _tmp0_;
		char* _tmp1_;
		style_widget = g_object_ref_sink ((GtkInvisible*) gtk_invisible_new ());
		color = (_tmp1_ = gdk_color_to_string ((_tmp0_ = gtk_widget_get_style ((GtkWidget*) style_widget)->bg[GTK_STATE_NORMAL], &_tmp0_)), _g_free0 (color), _tmp1_);
		_g_object_unref0 (style_widget);
	}
	color_set_background (color);
	_g_free0 (color);
}


static void xnp_application_quit (XnpApplication* self) {
	g_return_if_fail (self != NULL);
	xnp_application_save_notes (self);
	gtk_main_quit ();
}


/**
 * create_window:
 *
 * Creates a new Xnp.Window and stores it inside window_list.
 * If a name is given, it assumes it can load existing notes.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda21_ (XnpWindow* win, const char* action, XnpApplication* self) {
	g_return_if_fail (win != NULL);
	g_return_if_fail (action != NULL);
	if (_vala_strcmp0 (action, "rename") == 0) {
		xnp_application_rename_window (self, win);
	} else {
		if (_vala_strcmp0 (action, "delete") == 0) {
			xnp_application_delete_window (self, win);
		} else {
			if (_vala_strcmp0 (action, "create-new-window") == 0) {
				XnpWindow* new_win;
				new_win = xnp_application_create_window (self, NULL);
				gtk_widget_show ((GtkWidget*) new_win);
				_g_object_unref0 (new_win);
			} else {
				if (_vala_strcmp0 (action, "properties") == 0) {
					xnp_application_open_settings_dialog (self);
				} else {
					if (_vala_strcmp0 (action, "about") == 0) {
						xnp_application_open_about_dialog (self);
					}
				}
			}
		}
	}
}


static void __lambda21__xnp_window_action (XnpWindow* _sender, const char* action, gpointer self) {
	_lambda21_ (_sender, action, self);
}


static void _lambda23_ (XnpWindow* win, XnpNote* note, XnpApplication* self) {
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	xnp_application_save_note (self, win, note);
}


static void __lambda23__xnp_window_save_data (XnpWindow* _sender, XnpNote* note, gpointer self) {
	_lambda23_ (_sender, note, self);
}


static void _lambda24_ (XnpWindow* win, XnpNote* note, XnpApplication* self) {
	char* path;
	GError * _inner_error_ = NULL;
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	xfconf_g_property_bind (self->priv->xfconf_channel, "/global/font-description", G_TYPE_STRING, note->text_view, "font");
	path = g_strdup_printf ("%s/%s/%s", self->priv->notes_path, xnp_window_get_name (win), xnp_note_get_name (note));
	{
		g_file_set_contents (path, "", (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (path);
}


static void __lambda24__xnp_window_note_inserted (XnpWindow* _sender, XnpNote* note, gpointer self) {
	_lambda24_ (_sender, note, self);
}


static void _lambda25_ (XnpWindow* win, XnpNote* note, XnpApplication* self) {
	char* path;
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	path = g_strdup_printf ("%s/%s/%s", self->priv->notes_path, xnp_window_get_name (win), xnp_note_get_name (note));
	g_unlink (path);
	_g_free0 (path);
}


static void __lambda25__xnp_window_note_deleted (XnpWindow* _sender, XnpNote* note, gpointer self) {
	_lambda25_ (_sender, note, self);
}


static void _lambda26_ (XnpWindow* win, XnpNote* note, const char* old_name, XnpApplication* self) {
	char* old_path;
	char* new_path;
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	g_return_if_fail (old_name != NULL);
	if (!xnp_application_name_is_valid (self, xnp_note_get_name (note))) {
		xnp_note_set_name (note, old_name);
		return;
	}
	old_path = g_strdup_printf ("%s/%s/%s", self->priv->notes_path, xnp_window_get_name (win), old_name);
	new_path = g_strdup_printf ("%s/%s/%s", self->priv->notes_path, xnp_window_get_name (win), xnp_note_get_name (note));
	g_rename (old_path, new_path);
	_g_free0 (new_path);
	_g_free0 (old_path);
}


static void __lambda26__xnp_window_note_renamed (XnpWindow* _sender, XnpNote* note, const char* old_name, gpointer self) {
	_lambda26_ (_sender, note, old_name, self);
}


XnpWindow* xnp_application_create_window (XnpApplication* self, const char* name) {
	XnpWindow* result = NULL;
	XnpWindow* window;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	window = g_object_ref_sink (xnp_window_new ());
	if (name == NULL) {
		gint width;
		gint height;
		gboolean _tmp0_ = FALSE;
		xnp_window_set_above (window, xfconf_channel_get_bool (self->priv->xfconf_channel, "/new-window/always-on-top", FALSE));
		xnp_window_set_sticky (window, xfconf_channel_get_bool (self->priv->xfconf_channel, "/new-window/sticky", TRUE));
		width = (gint) xfconf_channel_get_int (self->priv->xfconf_channel, "/new-window/width", (gint32) 0);
		height = (gint) xfconf_channel_get_int (self->priv->xfconf_channel, "/new-window/height", (gint32) 0);
		if (width > 0) {
			_tmp0_ = height > 0;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gtk_window_resize ((GtkWindow*) window, width, height);
		}
	}
	if (name == NULL) {
		char* window_name;
		gint len;
		window_name = g_strdup (_ ("Notes"));
		len = (gint) g_slist_length (self->priv->window_list);
		{
			gint id;
			id = 1;
			{
				gboolean _tmp1_;
				_tmp1_ = TRUE;
				while (TRUE) {
					if (!_tmp1_) {
						id++;
					}
					_tmp1_ = FALSE;
					if (!(id <= (len + 1))) {
						break;
					}
					if (id > 1) {
						char* _tmp2_;
						window_name = (_tmp2_ = g_strdup_printf (_ ("Notes %d"), id), _g_free0 (window_name), _tmp2_);
					}
					if (!xnp_application_window_name_exists (self, window_name)) {
						break;
					}
				}
			}
		}
		xnp_window_set_name (window, window_name);
		_g_free0 (window_name);
	} else {
		xnp_window_set_name (window, name);
	}
	self->priv->window_list = g_slist_insert_sorted (self->priv->window_list, _g_object_ref0 (window), (GCompareFunc) xnp_window_compare_func);
	{
		GSList* win_collection;
		GSList* win_it;
		win_collection = self->priv->window_list;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* win;
			win = _g_object_ref0 ((XnpWindow*) win_it->data);
			{
				xnp_window_set_window_list (win, self->priv->window_list);
				_g_object_unref0 (win);
			}
		}
	}
	if (name == NULL) {
		{
			char* window_path;
			char* note_path;
			window_path = g_strdup_printf ("%s/%s", self->priv->notes_path, xnp_window_get_name (window));
			g_mkdir_with_parents (window_path, 0700);
			note_path = g_strdup_printf ("%s/%s", window_path, _ ("Notes"));
			g_file_set_contents (note_path, "", (gssize) (-1), &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (note_path);
				_g_free0 (window_path);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch3_g_file_error;
				}
				_g_free0 (note_path);
				_g_free0 (window_path);
				_g_object_unref0 (window);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			xnp_application_load_window_data (self, window);
			_g_free0 (note_path);
			_g_free0 (window_path);
		}
		goto __finally3;
		__catch3_g_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("application.vala:169: Unable to initialize a notes group: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (window);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	} else {
		xnp_application_load_window_data (self, window);
	}
	xfconf_g_property_bind (self->priv->xfconf_channel, "/global/skip-taskbar-hint", G_TYPE_BOOLEAN, window, "skip-taskbar-hint");
	xfconf_g_property_bind (self->priv->xfconf_channel, "/global/tabs-position", G_TYPE_INT, window, "tabs-position");
	g_signal_connect_object (window, "action", (GCallback) __lambda21__xnp_window_action, self, 0);
	g_signal_connect_object (window, "save-data", (GCallback) __lambda23__xnp_window_save_data, self, 0);
	g_signal_connect_object (window, "note-inserted", (GCallback) __lambda24__xnp_window_note_inserted, self, 0);
	g_signal_connect_object (window, "note-deleted", (GCallback) __lambda25__xnp_window_note_deleted, self, 0);
	g_signal_connect_object (window, "note-renamed", (GCallback) __lambda26__xnp_window_note_renamed, self, 0);
	result = window;
	return result;
}


/**
 * load_window_data:
 *
 * Load existing notes and configuration inside the window.
 */
static void xnp_application_load_window_data (XnpApplication* self, XnpWindow* window) {
	char* name;
	char* path;
	GKeyFile* keyfile;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	name = NULL;
	path = g_strdup_printf ("%s/%s", self->priv->notes_path, xnp_window_get_name (window));
	{
		GDir* dir;
		dir = g_dir_open (path, (guint) 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch5_g_file_error;
			}
			_g_free0 (path);
			_g_free0 (name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		while (TRUE) {
			char* _tmp0_;
			if (!((name = (_tmp0_ = g_strdup (g_dir_read_name (dir)), _g_free0 (name), _tmp0_)) != NULL)) {
				break;
			}
			{
				char* contents;
				char* filename;
				char* _tmp1_ = NULL;
				char* _tmp2_;
				XnpNote* note;
				GtkTextBuffer* buffer;
				contents = NULL;
				filename = g_strdup_printf ("%s/%s", path, name);
				g_file_get_contents (filename, &_tmp1_, NULL, &_inner_error_);
				contents = (_tmp2_ = _tmp1_, _g_free0 (contents), _tmp2_);
				if (_inner_error_ != NULL) {
					_g_free0 (filename);
					_g_free0 (contents);
					if (_inner_error_->domain == G_FILE_ERROR) {
						goto __catch6_g_file_error;
					}
					_g_free0 (filename);
					_g_free0 (contents);
					_g_dir_close0 (dir);
					_g_free0 (path);
					_g_free0 (name);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				note = xnp_window_insert_note (window);
				xnp_note_set_name (note, name);
				buffer = _g_object_ref0 (gtk_text_view_get_buffer ((GtkTextView*) note->text_view));
				gtk_text_buffer_set_text (buffer, contents, -1);
				xfconf_g_property_bind (self->priv->xfconf_channel, "/global/font-description", G_TYPE_STRING, note->text_view, "font");
				_g_object_unref0 (buffer);
				_g_object_unref0 (note);
				_g_free0 (filename);
				_g_free0 (contents);
			}
			goto __finally6;
			__catch6_g_file_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					g_warning ("application.vala:256: %s", e->message);
					_g_error_free0 (e);
				}
			}
			__finally6:
			if (_inner_error_ != NULL) {
				_g_dir_close0 (dir);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch5_g_file_error;
				}
				_g_dir_close0 (dir);
				_g_free0 (path);
				_g_free0 (name);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_dir_close0 (dir);
	}
	goto __finally5;
	__catch5_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	keyfile = g_key_file_new ();
	{
		gint winx;
		gint winy;
		gint width;
		gint height;
		gint tabs_order_length1;
		gint _tabs_order_size_;
		char** _tmp4_;
		gsize _tmp3_;
		char** tabs_order;
		gint last_page;
		gboolean above;
		gboolean sticky;
		gint _tmp5_;
		double opacity;
		gboolean visible;
		g_key_file_load_from_file (keyfile, self->priv->_config_file, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		winx = g_key_file_get_integer (keyfile, xnp_window_get_name (window), "PosX", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		winy = g_key_file_get_integer (keyfile, xnp_window_get_name (window), "PosY", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		width = g_key_file_get_integer (keyfile, xnp_window_get_name (window), "Width", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		height = g_key_file_get_integer (keyfile, xnp_window_get_name (window), "Height", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		tabs_order = (_tmp4_ = g_key_file_get_string_list (keyfile, xnp_window_get_name (window), "TabsOrder", &_tmp3_, &_inner_error_), tabs_order_length1 = _tmp3_, _tabs_order_size_ = tabs_order_length1, _tmp4_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		last_page = g_key_file_get_integer (keyfile, xnp_window_get_name (window), "LastTab", &_inner_error_);
		if (_inner_error_ != NULL) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch7_g_error;
		}
		above = g_key_file_get_boolean (keyfile, xnp_window_get_name (window), "Above", &_inner_error_);
		if (_inner_error_ != NULL) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch7_g_error;
		}
		sticky = g_key_file_get_boolean (keyfile, xnp_window_get_name (window), "Sticky", &_inner_error_);
		if (_inner_error_ != NULL) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch7_g_error;
		}
		_tmp5_ = g_key_file_get_integer (keyfile, xnp_window_get_name (window), "Transparency", &_inner_error_);
		if (_inner_error_ != NULL) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch7_g_error;
		}
		opacity = 1 - (((double) _tmp5_) / 100);
		visible = g_key_file_get_boolean (keyfile, xnp_window_get_name (window), "Visible", &_inner_error_);
		if (_inner_error_ != NULL) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch7_g_error;
		}
		gtk_window_move ((GtkWindow*) window, winx, winy);
		gtk_window_resize ((GtkWindow*) window, width, height);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					if (!_tmp6_) {
						i++;
					}
					_tmp6_ = FALSE;
					if (!(i < tabs_order_length1)) {
						break;
					}
					xnp_window_move_note (window, tabs_order[i], i);
				}
			}
		}
		xnp_window_set_current_page (window, last_page);
		xnp_window_set_above (window, above);
		xnp_window_set_sticky (window, sticky);
		gtk_window_set_opacity ((GtkWindow*) window, opacity);
		if (visible) {
			gtk_widget_show ((GtkWidget*) window);
		}
		tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			gtk_widget_show ((GtkWidget*) window);
			_g_error_free0 (e);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (keyfile);
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_key_file_free0 (keyfile);
	_g_free0 (path);
	_g_free0 (name);
}


/**
 * save_windows_configuration:
 *
 * Save window configuration inside rc file.
 */
void xnp_application_save_windows_configuration (XnpApplication* self) {
	GKeyFile* keyfile;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	keyfile = g_key_file_new ();
	{
		char* contents;
		{
			GSList* win_collection;
			GSList* win_it;
			win_collection = self->priv->window_list;
			for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
				XnpWindow* win;
				win = _g_object_ref0 ((XnpWindow*) win_it->data);
				{
					gint winx = 0;
					gint winy = 0;
					gint width = 0;
					gint height = 0;
					gint tabs_order_length1;
					gint _tabs_order_size_;
					char** _tmp1_;
					gint _tmp0_;
					char** tabs_order;
					gint last_page;
					gint transparency;
					gboolean visible;
					xnp_window_get_geometry (win, &winx, &winy, &width, &height);
					tabs_order = (_tmp1_ = xnp_window_get_note_names (win, &_tmp0_), tabs_order_length1 = _tmp0_, _tabs_order_size_ = tabs_order_length1, _tmp1_);
					last_page = xnp_window_get_current_page (win);
					transparency = (gint) ((1 - gtk_window_get_opacity ((GtkWindow*) win)) * 100);
					visible = (gboolean) (GTK_WIDGET_FLAGS ((GtkWidget*) win) & GTK_VISIBLE);
					g_key_file_set_integer (keyfile, xnp_window_get_name (win), "PosX", winx);
					g_key_file_set_integer (keyfile, xnp_window_get_name (win), "PosY", winy);
					g_key_file_set_integer (keyfile, xnp_window_get_name (win), "Width", width);
					g_key_file_set_integer (keyfile, xnp_window_get_name (win), "Height", height);
					g_key_file_set_string_list (keyfile, xnp_window_get_name (win), "TabsOrder", (const gchar* const*) tabs_order, tabs_order_length1);
					g_key_file_set_integer (keyfile, xnp_window_get_name (win), "LastTab", last_page);
					g_key_file_set_boolean (keyfile, xnp_window_get_name (win), "Above", xnp_window_get_above (win));
					g_key_file_set_boolean (keyfile, xnp_window_get_name (win), "Sticky", xnp_window_get_sticky (win));
					g_key_file_set_double (keyfile, xnp_window_get_name (win), "Transparency", (double) transparency);
					g_key_file_set_boolean (keyfile, xnp_window_get_name (win), "Visible", visible);
					tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (win);
				}
			}
		}
		contents = g_key_file_to_data (keyfile, NULL, NULL);
		g_file_set_contents (self->priv->_config_file, contents, -1, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (contents);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch8_g_file_error;
			}
			_g_free0 (contents);
			_g_key_file_free0 (keyfile);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (contents);
	}
	goto __finally8;
	__catch8_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_message ("application.vala:325: Unable to save window configuration from %s: %s", self->priv->_config_file, e->message);
			_g_error_free0 (e);
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (keyfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_key_file_free0 (keyfile);
}


/**
 * save_notes:
 *
 * Save the contents of every existing notes.
 */
void xnp_application_save_notes (XnpApplication* self) {
	g_return_if_fail (self != NULL);
	{
		GSList* win_collection;
		GSList* win_it;
		win_collection = self->priv->window_list;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* win;
			win = _g_object_ref0 ((XnpWindow*) win_it->data);
			{
				xnp_window_save_notes (win);
				_g_object_unref0 (win);
			}
		}
	}
}


/**
 * save_note:
 *
 * Save the contents of the given note.
 */
static void xnp_application_save_note (XnpApplication* self, XnpWindow* window, XnpNote* note) {
	char* path;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_return_if_fail (note != NULL);
	path = g_strdup_printf ("%s/%s/%s", self->priv->notes_path, xnp_window_get_name (window), xnp_note_get_name (note));
	{
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		GtkTextBuffer* buffer;
		char* contents;
		buffer = _g_object_ref0 (gtk_text_view_get_buffer ((GtkTextView*) note->text_view));
		gtk_text_buffer_get_bounds (buffer, &start, &end);
		contents = g_strdup (gtk_text_buffer_get_text (buffer, &start, &end, TRUE));
		g_file_set_contents (path, contents, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (contents);
			_g_object_unref0 (buffer);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch9_g_file_error;
			}
			_g_free0 (contents);
			_g_object_unref0 (buffer);
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (contents);
		_g_object_unref0 (buffer);
	}
	goto __finally9;
	__catch9_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("application.vala:355: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (path);
}


/**
 * rename_window:
 *
 * Renames the window name.
 */
static void xnp_application_rename_window (XnpApplication* self, XnpWindow* window) {
	GtkDialog* dialog;
	GtkEntry* entry;
	gint res;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	dialog = g_object_ref_sink ((GtkDialog*) gtk_dialog_new_with_buttons (_ ("Rename group"), (GtkWindow*) window, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_NO_SEPARATOR, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_OK, NULL));
	gtk_dialog_set_default_response (dialog, (gint) GTK_RESPONSE_OK);
	gtk_window_set_resizable ((GtkWindow*) dialog, FALSE);
	gtk_window_set_icon_name ((GtkWindow*) dialog, GTK_STOCK_EDIT);
	gtk_container_set_border_width ((GtkContainer*) dialog, (guint) 4);
	gtk_container_set_border_width ((GtkContainer*) dialog->vbox, (guint) 6);
	entry = g_object_ref_sink ((GtkEntry*) gtk_entry_new ());
	gtk_entry_set_text (entry, xnp_window_get_name (window));
	gtk_entry_set_activates_default (entry, TRUE);
	gtk_container_add ((GtkContainer*) dialog->vbox, (GtkWidget*) entry);
	gtk_widget_show_all ((GtkWidget*) dialog->vbox);
	res = gtk_dialog_run (dialog);
	gtk_widget_hide ((GtkWidget*) dialog);
	if (res == GTK_RESPONSE_OK) {
		const char* name;
		name = gtk_entry_get_text (entry);
		if (xnp_application_window_name_exists (self, name)) {
			GtkMessageDialog* error_dialog;
			error_dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _ ("The name %s is already in use"), name));
			gtk_dialog_run ((GtkDialog*) error_dialog);
			gtk_object_destroy ((GtkObject*) error_dialog);
			_g_object_unref0 (error_dialog);
		} else {
			char* old_path;
			char* new_path;
			if (!xnp_application_name_is_valid (self, name)) {
				_g_object_unref0 (entry);
				_g_object_unref0 (dialog);
				return;
			}
			old_path = g_strdup_printf ("%s/%s", self->priv->notes_path, xnp_window_get_name (window));
			new_path = g_strdup_printf ("%s/%s", self->priv->notes_path, name);
			xnp_window_set_name (window, name);
			g_rename (old_path, new_path);
			self->priv->window_list = g_slist_sort (self->priv->window_list, (GCompareFunc) xnp_window_compare_func);
			_g_free0 (new_path);
			_g_free0 (old_path);
		}
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (entry);
	_g_object_unref0 (dialog);
}


/**
 * delete_window:
 *
 * Delete the window.
 */
static void xnp_application_delete_window (XnpApplication* self, XnpWindow* window) {
	char* name;
	char* path;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (xnp_window_get_n_pages (window) >= 1) {
		GtkMessageDialog* dialog;
		gint res;
		dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _ ("Are you sure you want to delete this group?")));
		res = gtk_dialog_run ((GtkDialog*) dialog);
		gtk_object_destroy ((GtkObject*) dialog);
		if (res != GTK_RESPONSE_YES) {
			_g_object_unref0 (dialog);
			return;
		}
		_g_object_unref0 (dialog);
	}
	name = NULL;
	path = g_strdup_printf ("%s/%s", self->priv->notes_path, xnp_window_get_name (window));
	{
		GDir* dir;
		dir = g_dir_open (path, (guint) 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch10_g_file_error;
			}
			_g_free0 (path);
			_g_free0 (name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		while (TRUE) {
			char* _tmp0_;
			char* filename;
			if (!((name = (_tmp0_ = g_strdup (g_dir_read_name (dir)), _g_free0 (name), _tmp0_)) != NULL)) {
				break;
			}
			filename = g_strdup_printf ("%s/%s", path, name);
			g_unlink (filename);
			_g_free0 (filename);
		}
		g_rmdir (path);
		_g_dir_close0 (dir);
	}
	goto __finally10;
	__catch10_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->window_list = g_slist_remove (self->priv->window_list, window);
	gtk_object_destroy ((GtkObject*) window);
	if (g_slist_length (self->priv->window_list) >= 1) {
		{
			GSList* win_collection;
			GSList* win_it;
			win_collection = self->priv->window_list;
			for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
				XnpWindow* win;
				win = _g_object_ref0 ((XnpWindow*) win_it->data);
				{
					xnp_window_set_window_list (win, self->priv->window_list);
					_g_object_unref0 (win);
				}
			}
		}
	} else {
		XnpWindow* new_win;
		new_win = xnp_application_create_window (self, NULL);
		gtk_widget_show ((GtkWidget*) new_win);
		_g_object_unref0 (new_win);
	}
	_g_free0 (path);
	_g_free0 (name);
}


/**
 * window_name_exists:
 *
 * Verify if the given name already exists in the window list.
 */
static gboolean xnp_application_window_name_exists (XnpApplication* self, const char* name) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	{
		GSList* win_collection;
		GSList* win_it;
		win_collection = self->priv->window_list;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* win;
			win = _g_object_ref0 ((XnpWindow*) win_it->data);
			{
				if (_vala_strcmp0 (xnp_window_get_name (win), name) == 0) {
					result = TRUE;
					_g_object_unref0 (win);
					return result;
				}
				_g_object_unref0 (win);
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * name_is_valid:
 *
 * Verify if the given name is valid for window and notes.
 */
static gboolean xnp_application_name_is_valid (XnpApplication* self, const char* name) {
	gboolean result = FALSE;
	gboolean res;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	res = g_regex_match_simple ("^[^*|/\\:\"<>?]+$", name, 0, 0);
	if (!res) {
		GtkMessageDialog* error_dialog;
		char* _tmp0_;
		error_dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _ ("The name \"%s\" is invalid."), name));
		gtk_message_dialog_format_secondary_markup (error_dialog, _tmp0_ = g_strdup_printf (_ ("The invalid characters are: %s"), "<tt>*|/\\:\"&lt;&gt;?</tt>"), NULL);
		_g_free0 (_tmp0_);
		gtk_dialog_run ((GtkDialog*) error_dialog);
		gtk_object_destroy ((GtkObject*) error_dialog);
		_g_object_unref0 (error_dialog);
	}
	result = res;
	return result;
}


/**
 * show_hide_notes:
 *
 * Show all the notes or hide them if they are all shown.
 */
void xnp_application_show_hide_notes (XnpApplication* self) {
	gboolean invisible_found;
	gboolean visible_found;
	gboolean active_found;
	g_return_if_fail (self != NULL);
	invisible_found = FALSE;
	visible_found = FALSE;
	active_found = FALSE;
	{
		GSList* win_collection;
		GSList* win_it;
		win_collection = self->priv->window_list;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* win;
			win = _g_object_ref0 ((XnpWindow*) win_it->data);
			{
				gboolean _tmp0_;
				if ((g_object_get ((GtkWindow*) win, "is-active", &_tmp0_, NULL), _tmp0_)) {
					active_found = TRUE;
				}
				if (!((gboolean) (GTK_WIDGET_FLAGS ((GtkWidget*) win) & GTK_VISIBLE))) {
					invisible_found = TRUE;
				} else {
					visible_found = TRUE;
				}
				_g_object_unref0 (win);
			}
		}
	}
	{
		GSList* win_collection;
		GSList* win_it;
		win_collection = self->priv->window_list;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* win;
			win = _g_object_ref0 ((XnpWindow*) win_it->data);
			{
				gboolean _tmp1_ = FALSE;
				if (!active_found) {
					_tmp1_ = visible_found;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					if ((gboolean) (GTK_WIDGET_FLAGS ((GtkWidget*) win) & GTK_VISIBLE)) {
						gtk_window_present ((GtkWindow*) win);
					}
				} else {
					if (invisible_found) {
						gtk_widget_show ((GtkWidget*) win);
					} else {
						xnp_window_hide (win);
					}
				}
				_g_object_unref0 (win);
			}
		}
	}
}


/**
 * open_settings_dialog:
 *
 * Open the settings dialog.
 */
void xnp_application_open_settings_dialog (XnpApplication* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gdk_spawn_command_line_on_screen (gdk_screen_get_default (), "xfce4-notes-settings", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* error_dialog;
			error_dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _ ("Unable to open the settings dialog")));
			gtk_message_dialog_format_secondary_text (error_dialog, "%s", e->message, NULL);
			gtk_dialog_run ((GtkDialog*) error_dialog);
			gtk_object_destroy ((GtkObject*) error_dialog);
			_g_object_unref0 (error_dialog);
			_g_error_free0 (e);
		}
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
 * open_about_dialog:
 *
 * Open the about dialog.
 */
static void _lambda22_ (GtkAboutDialog* dialog, const char* uri, XnpApplication* self) {
	char* command;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (uri != NULL);
	command = NULL;
	{
		char* _tmp0_;
		command = (_tmp0_ = g_strdup_printf ("exo-open %s", uri), _g_free0 (command), _tmp0_);
		gdk_spawn_command_line_on_screen (gdk_screen_get_default (), command, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
		_g_free0 (command);
		return;
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_free0 (command);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		char* _tmp1_;
		command = (_tmp1_ = g_strdup_printf ("firefox %s", uri), _g_free0 (command), _tmp1_);
		gdk_spawn_command_line_on_screen (gdk_screen_get_default (), command, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		_g_free0 (command);
		return;
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_free0 (command);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (command);
}


static void __lambda22__gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self) {
	_lambda22_ (about, link_, self);
}


void xnp_application_open_about_dialog (XnpApplication* self) {
	gint authors_length1;
	gint _authors_size_;
	char** _tmp1_;
	char** _tmp0_ = NULL;
	char** authors;
	g_return_if_fail (self != NULL);
	gtk_about_dialog_set_url_hook (__lambda22__gtk_about_dialog_activate_link_func, g_object_ref (self), g_object_unref);
	authors = (_tmp1_ = (_tmp0_ = g_new0 (char*, 3 + 1), _tmp0_[0] = g_strdup ("(c) 2006-2010 Mike Massonnet"), _tmp0_[1] = g_strdup ("(c) 2003 Jakob Henriksson"), _tmp0_[2] = NULL, _tmp0_), authors_length1 = 3, _authors_size_ = authors_length1, _tmp1_);
	gtk_show_about_dialog (NULL, "program-name", _ ("Notes"), "logo-icon-name", "xfce4-notes-plugin", "comments", _ ("Ideal for your quick notes"), "version", PACKAGE_VERSION, "copyright", "Copyright © 2003-2010 The Xfce development team", "license", xfce_get_license_text (XFCE_LICENSE_TEXT_GPL), "website", "http://goodies.xfce.org/projects/panel-plugins/xfce4-notes-plugin", "website-label", "goodies.xfce.org", "authors", authors, "translator-credits", _ ("translator-credits"), NULL, NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


/**
 * context_menu:
 *
 * Provides a GtkMenu to be used for right click context menus
 * like in trayicons. Its items are destroyed/refreshed every
 * time the menu is shown.
 */
static void _lambda28_ (GtkWidget* w, XnpApplication* self) {
	g_return_if_fail (w != NULL);
	gtk_object_destroy ((GtkObject*) w);
}


static void __lambda28__gtk_callback (GtkWidget* widget, gpointer self) {
	_lambda28_ (widget, self);
}


static void _lambda29_ (GtkMenuItem* i, XnpApplication* self) {
	XnpWindow* w;
	g_return_if_fail (i != NULL);
	w = _g_object_ref0 ((XnpWindow*) g_object_get_data ((GObject*) i, "window"));
	gtk_window_present ((GtkWindow*) w);
	_g_object_unref0 (w);
}


static void __lambda29__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda29_ (_sender, self);
}


static void _lambda30_ (XnpApplication* self) {
	XnpWindow* new_win;
	new_win = xnp_application_create_window (self, NULL);
	gtk_widget_show ((GtkWidget*) new_win);
	_g_object_unref0 (new_win);
}


static void __lambda30__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda30_ (self);
}


static void _lambda27_ (Block1Data* _data1_) {
	XnpApplication * self;
	GtkSeparatorMenuItem* mi_sep;
	GtkImageMenuItem* mi_add;
	GtkImage* image;
	self = _data1_->self;
	gtk_container_foreach ((GtkContainer*) _data1_->menu, __lambda28__gtk_callback, self);
	{
		GSList* win_collection;
		GSList* win_it;
		win_collection = self->priv->window_list;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* win;
			win = _g_object_ref0 ((XnpWindow*) win_it->data);
			{
				GtkMenuItem* mi;
				mi = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label (xnp_window_get_name (win)));
				g_object_set_data_full ((GObject*) mi, "window", (void*) win, NULL);
				g_signal_connect_object (mi, "activate", (GCallback) __lambda29__gtk_menu_item_activate, self, 0);
				gtk_menu_shell_append ((GtkMenuShell*) _data1_->menu, (GtkWidget*) mi);
				_g_object_unref0 (mi);
				_g_object_unref0 (win);
			}
		}
	}
	mi_sep = g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ());
	gtk_menu_shell_append ((GtkMenuShell*) _data1_->menu, (GtkWidget*) ((GtkMenuItem*) mi_sep));
	mi_add = g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_ ("_Add a new group")));
	g_signal_connect_object ((GtkMenuItem*) mi_add, "activate", (GCallback) __lambda30__gtk_menu_item_activate, self, 0);
	image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_ADD, GTK_ICON_SIZE_MENU));
	gtk_image_menu_item_set_image (mi_add, (GtkWidget*) image);
	gtk_menu_shell_append ((GtkMenuShell*) _data1_->menu, (GtkWidget*) ((GtkMenuItem*) mi_add));
	gtk_widget_show_all ((GtkWidget*) _data1_->menu);
	_g_object_unref0 (image);
	_g_object_unref0 (mi_add);
	_g_object_unref0 (mi_sep);
}


static void __lambda27__gtk_widget_show (GtkWidget* _sender, gpointer self) {
	_lambda27_ (self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->menu);
		g_slice_free (Block1Data, _data1_);
	}
}


GtkMenu* xnp_application_context_menu (XnpApplication* self) {
	GtkMenu* result = NULL;
	Block1Data* _data1_;
	g_return_val_if_fail (self != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->menu = g_object_ref_sink ((GtkMenu*) gtk_menu_new ());
	g_signal_connect_data ((GtkWidget*) _data1_->menu, "show", (GCallback) __lambda27__gtk_widget_show, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	result = _g_object_ref0 (_data1_->menu);
	block1_data_unref (_data1_);
	return result;
}


const char* xnp_application_get_config_file (XnpApplication* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_config_file;
	return result;
}


static void xnp_application_set_config_file (XnpApplication* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_config_file = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_config_file), _tmp0_);
	g_object_notify ((GObject *) self, "config-file");
}


static GObject * xnp_application_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XnpApplication * self;
	parent_class = G_OBJECT_CLASS (xnp_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = XNP_APPLICATION (obj);
	{
		char* _tmp0_;
		self->priv->notes_path = (_tmp0_ = g_strdup_printf ("%s/notes", g_get_user_data_dir ()), _g_free0 (self->priv->notes_path), _tmp0_);
	}
	return obj;
}


static void xnp_application_class_init (XnpApplicationClass * klass) {
	xnp_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XnpApplicationPrivate));
	G_OBJECT_CLASS (klass)->get_property = xnp_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = xnp_application_set_property;
	G_OBJECT_CLASS (klass)->constructor = xnp_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_APPLICATION_CONFIG_FILE, g_param_spec_string ("config-file", "config-file", "config-file", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void xnp_application_instance_init (XnpApplication * self) {
	self->priv = XNP_APPLICATION_GET_PRIVATE (self);
}


static void xnp_application_finalize (GObject* obj) {
	XnpApplication * self;
	self = XNP_APPLICATION (obj);
	{
		XfconfChannel* _tmp1_;
		xnp_application_save_windows_configuration (self);
		self->priv->xfconf_channel = (_tmp1_ = NULL, _g_object_unref0 (self->priv->xfconf_channel), _tmp1_);
		xfconf_shutdown ();
		{
			GSList* win_collection;
			GSList* win_it;
			win_collection = self->priv->window_list;
			for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
				XnpWindow* win;
				win = _g_object_ref0 ((XnpWindow*) win_it->data);
				{
					XnpWindow* _tmp2_;
					gtk_object_destroy ((GtkObject*) win);
					win = (_tmp2_ = NULL, _g_object_unref0 (win), _tmp2_);
					_g_object_unref0 (win);
				}
			}
		}
	}
	__g_slist_free_g_object_unref0 (self->priv->window_list);
	_g_free0 (self->priv->notes_path);
	_g_free0 (self->priv->_config_file);
	_g_object_unref0 (self->priv->xfconf_channel);
	G_OBJECT_CLASS (xnp_application_parent_class)->finalize (obj);
}


GType xnp_application_get_type (void) {
	static volatile gsize xnp_application_type_id__volatile = 0;
	if (g_once_init_enter (&xnp_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XnpApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpApplication), 0, (GInstanceInitFunc) xnp_application_instance_init, NULL };
		GType xnp_application_type_id;
		xnp_application_type_id = g_type_register_static (G_TYPE_OBJECT, "XnpApplication", &g_define_type_info, 0);
		g_once_init_leave (&xnp_application_type_id__volatile, xnp_application_type_id);
	}
	return xnp_application_type_id__volatile;
}


static void xnp_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	XnpApplication * self;
	self = XNP_APPLICATION (object);
	switch (property_id) {
		case XNP_APPLICATION_CONFIG_FILE:
		g_value_set_string (value, xnp_application_get_config_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void xnp_application_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	XnpApplication * self;
	self = XNP_APPLICATION (object);
	switch (property_id) {
		case XNP_APPLICATION_CONFIG_FILE:
		xnp_application_set_config_file (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




