#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "xdemorse.h"

/* Speed and squelch spin buttond */
extern GtkSpinButton
  *gbl_speed,
  *gbl_squelch;

/* Global widgets */
extern GtkWidget
  *gbl_rx_scrolledwindow,
  *gbl_scope,
  *gbl_scope_label;

GtkWidget *error_dialog = NULL;

/* Text buffer for text viewer */
GtkTextBuffer *gbl_rx_text_buffer;

/* Runtime config data */
extern rc_data_t rc_data;

/* Waterfall window pixbuf */
extern GdkPixbuf *gbl_wfall_pixbuf;
extern guchar *gbl_wfall_pixels;
extern gint
  gbl_wfall_rowstride,
  gbl_wfall_n_channels,
  gbl_wfall_width,
  gbl_wfall_height;


/*  Error_Dialog()
 *
 *  Opens an error dialog box
 */

  void
Error_Dialog( char *message )
{
  GtkWidget *label;

  if( error_dialog != NULL ) return;
  error_dialog = create_error_dialog();
  label = lookup_widget( error_dialog, "error_message" );
  gtk_label_set_text( GTK_LABEL(label), message );
  gtk_widget_show( error_dialog );
}


void
on_main_window_destroy(
	GtkObject       *object,
	gpointer         user_data)
{
  Cleanup();
  gtk_main_quit();
}


gboolean
on_main_window_delete_event(
	GtkWidget       *widget,
	GdkEvent        *event,
	gpointer         user_data)
{
  return FALSE;
}


gboolean
on_scope_expose_event(
	GtkWidget       *widget,
	GdkEventExpose  *event,
	gpointer         user_data)
{
  /* Draw scope background */
  gdk_draw_rectangle( widget->window,
	  widget->style->white_gc,
	  TRUE, 4, 4, 255, 80 );

  /* Draw scope frame */
  gdk_draw_rectangle( widget->window,
	  widget->style->black_gc,
	  FALSE, 3, 3, 256, 81 );

  gtk_label_set_text( GTK_LABEL(gbl_scope_label), "Signal Input" );

  return TRUE;
}


gboolean
on_scope_button_press_event(
	GtkWidget       *widget,
	GdkEventButton  *event,
	gpointer         user_data)
{
  switch( event->button )
  {
	case 1: /* Button 1 pressed */
	  Toggle_Flag( DISPLAY_SIGNAL );
	  Clear_Flag( DISPLAY_DETECTOR );
	  break;

	case 2: /* Button 3 pressed */
	  Clear_Flag( DISPLAY_SIGNAL );
	  Clear_Flag( DISPLAY_DETECTOR );
	  break;

	case 3: /* Button 2 pressed */
	  Toggle_Flag( DISPLAY_DETECTOR );
	  Clear_Flag( DISPLAY_SIGNAL );

  } /* switch( event->button ) */

  /* Set scope label */
  if( isFlagSet(DISPLAY_SIGNAL) )
	gtk_label_set_text( GTK_LABEL(gbl_scope_label), "Signal Input" );
  else
	if( isFlagSet(DISPLAY_DETECTOR) )
	  gtk_label_set_text( GTK_LABEL(gbl_scope_label), "Detector Output" );
	else
	  gtk_label_set_text( GTK_LABEL(gbl_scope_label), "Stopped" );

  return TRUE;
}


void
on_speed_changed(
	GtkEditable     *editable,
	gpointer         user_data)
{
  rc_data.unit_elem = gtk_spin_button_get_value_as_int( gbl_speed );
  rc_data.unit_elem = (60 * rc_data.tone_freq) /
	(50 * CYCLES_PER_FRAG * rc_data.unit_elem);
}


void
on_squelch_changed(
	GtkEditable     *editable,
	gpointer         user_data)
{
  rc_data.det_thr = (int)gtk_spin_button_get_value( gbl_squelch );
}


void
on_err_quit_clicked(
	GtkButton       *button,
	gpointer         user_data)
{
  Cleanup();
  gtk_main_quit();
}


void
on_clear_clicked(
	GtkButton       *button,
	gpointer         user_data)
{
  gtk_text_buffer_set_text( gbl_rx_text_buffer, "", -1 );
}


gboolean
on_waterfall_expose_event(
	GtkWidget       *widget,
	GdkEventExpose  *event,
	gpointer         user_data)
{
  if( gbl_wfall_pixbuf == NULL )
	return( TRUE );

  gdk_draw_pixbuf(
	  widget->window, NULL, gbl_wfall_pixbuf,
	  event->area.x, event->area.y,
	  event->area.x, event->area.y,
	  event->area.width, event->area.height,
	  GDK_RGB_DITHER_NONE, 0, 0 );

  return TRUE;
}


  gboolean
on_waterfall_button_press_event(
	GtkWidget       *widget,
	GdkEventButton  *event,
	gpointer         user_data)
{
  if( event->button == 1 )
  {
	if( isFlagSet(CAT_SETUP) )
	  Tune_Tcvr( event->x );
  }
  else
	Toggle_Flag( REVERSE_VIDEO );

  return TRUE;
}


  void
on_err_ok_button_clicked(
	GtkButton       *button,
	gpointer         user_data)
{
  gtk_widget_destroy( error_dialog );
}


void
on_wpm_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
	Set_Flag( ADAPT_SPEED );
  else
	Clear_Flag( ADAPT_SPEED );
}


void
on_error_dialog_destroy                (GtkObject       *object,
                                        gpointer         user_data)
{
  error_dialog = NULL;
}


gboolean
on_error_dialog_delete_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  return TRUE;
}


void
on_waterfall_size_allocate             (GtkWidget       *widget,
                                        GdkRectangle    *allocation,
                                        gpointer         user_data)
{
  /* Destroy existing pixbuff */
  if( gbl_wfall_pixbuf != NULL )
  {
	g_object_unref( G_OBJECT(gbl_wfall_pixbuf) );
	gbl_wfall_pixbuf = NULL;
  }

  /* Create waterfall pixbuf */
  gbl_wfall_pixbuf = gdk_pixbuf_new(
	  GDK_COLORSPACE_RGB, FALSE, 8,
	  allocation->width, allocation->height );
  if( gbl_wfall_pixbuf == NULL )
  {
	Error_Dialog( "Failed to create pixbuf for waterfall" );
	return;
  }

  gbl_wfall_pixels = gdk_pixbuf_get_pixels( gbl_wfall_pixbuf );
  gbl_wfall_width  = gdk_pixbuf_get_width ( gbl_wfall_pixbuf );
  gbl_wfall_height = gdk_pixbuf_get_height( gbl_wfall_pixbuf );
  gbl_wfall_rowstride  = gdk_pixbuf_get_rowstride( gbl_wfall_pixbuf );
  gbl_wfall_n_channels = gdk_pixbuf_get_n_channels( gbl_wfall_pixbuf );
  Clear_Pixbuf();
}


  void
on_rx_togglebutton_toggled			(GtkToggleButton *togglebutton,
									gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) &&
	  isFlagSet(ENABLE_RECEIVE) )
	gtk_idle_add( Print_Character, "RX" );
  else
	g_idle_remove_by_data( "RX" );
}

