/*
 * Copyright (C) 2016 Igalia S.L.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "ViewBackend.h"
#include <cairo.h>
#include <glib.h>
#include <unordered_map>

namespace WPEToolingBackends {

class HeadlessViewBackend final : public ViewBackend {
public:
    HeadlessViewBackend(uint32_t width, uint32_t height);
    virtual ~HeadlessViewBackend();

    cairo_surface_t* createSnapshot();

private:
    cairo_surface_t* createEGLSnapshot();
#if WPE_FDO_CHECK_VERSION(1, 5, 0)
    cairo_surface_t* createSHMSnapshot();
#endif

    void displayBuffer(struct wpe_fdo_egl_exported_image*) override;
#if WPE_FDO_CHECK_VERSION(1, 5, 0)
    void displayBuffer(struct wpe_fdo_shm_exported_buffer*) override;
#endif

    void performUpdate();

    struct {
        struct wpe_fdo_egl_exported_image* pendingImage { nullptr };
        struct wpe_fdo_egl_exported_image* lockedImage { nullptr };
    } m_egl;

#if WPE_FDO_CHECK_VERSION(1, 5, 0)
    struct {
        struct wpe_fdo_shm_exported_buffer* pendingBuffer { nullptr };
        struct wpe_fdo_shm_exported_buffer* lockedBuffer { nullptr };
    } m_shm;
#endif

    GSource* m_updateSource { nullptr };
    gint64 m_frameRate { G_USEC_PER_SEC / 60 };
};

} // namespace WPEToolingBackends
