/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.texture;

import java.util.HashMap;
import org.web3d.image.NIOBufferImage;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLComposedTextureNodeType;
import org.web3d.vrml.nodes.VRMLEnvironmentTextureNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTexture2DNodeType;
import org.web3d.vrml.nodes.VRMLTextureNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseTextureNode;

public class BaseComposedCubeMapTexture
extends BaseTextureNode
implements VRMLEnvironmentTextureNodeType,
VRMLComposedTextureNodeType {
    protected static final int FIELD_FRONT = 1;
    protected static final int FIELD_BACK = 2;
    protected static final int FIELD_LEFT = 3;
    protected static final int FIELD_RIGHT = 4;
    protected static final int FIELD_TOP = 5;
    protected static final int FIELD_BOTTOM = 6;
    protected static final int LAST_COMPOSED_ENVTEXTURE_INDEX = 6;
    protected static final int NUM_FIELDS = 7;
    private static final String TEXTURE_PROTO_MSG = "Proto does not describe a Texture object";
    private static final String TEXTURE_NODE_MSG = "Node does not describe a Texture object";
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    protected VRMLTexture2DNodeType vfFront;
    protected VRMLProtoInstance pFront;
    protected VRMLTexture2DNodeType vfBack;
    protected VRMLProtoInstance pBack;
    protected VRMLTexture2DNodeType vfLeft;
    protected VRMLProtoInstance pLeft;
    protected VRMLTexture2DNodeType vfRight;
    protected VRMLProtoInstance pRight;
    protected VRMLTexture2DNodeType vfTop;
    protected VRMLProtoInstance pTop;
    protected VRMLTexture2DNodeType vfBottom;
    protected VRMLProtoInstance pBottom;

    protected BaseComposedCubeMapTexture() {
        super("ComposedCubeMapTexture");
        this.hasChanged = new boolean[7];
    }

    protected BaseComposedCubeMapTexture(VRMLNodeType vRMLNodeType) {
        this();
    }

    public int getTextureType() {
        return 2;
    }

    public int getNumberTextures() {
        return 6;
    }

    public void getTextures(int n, VRMLTextureNodeType[] vRMLTextureNodeTypeArray) {
        vRMLTextureNodeTypeArray[n] = this.vfFront;
        vRMLTextureNodeTypeArray[n + 1] = this.vfBack;
        vRMLTextureNodeTypeArray[n + 2] = this.vfLeft;
        vRMLTextureNodeTypeArray[n + 3] = this.vfRight;
        vRMLTextureNodeTypeArray[n + 4] = this.vfTop;
        vRMLTextureNodeTypeArray[n + 5] = this.vfBottom;
    }

    public NIOBufferImage getImage() {
        return null;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 71;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pFront != null ? this.pFront : this.vfFront;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pBack != null ? this.pBack : this.vfBack;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pLeft != null ? this.pLeft : this.vfLeft;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pRight != null ? this.pRight : this.vfRight;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pTop != null ? this.pTop : this.vfTop;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pBottom != null ? this.pBottom : this.vfBottom;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    if (this.pFront != null) {
                        vRMLNodeType.setValue(n2, this.pFront);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfFront);
                    break;
                }
                case 2: {
                    if (this.pBack != null) {
                        vRMLNodeType.setValue(n2, this.pBack);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfBack);
                    break;
                }
                case 3: {
                    if (this.pLeft != null) {
                        vRMLNodeType.setValue(n2, this.pLeft);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfLeft);
                    break;
                }
                case 4: {
                    if (this.pRight != null) {
                        vRMLNodeType.setValue(n2, this.pRight);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfRight);
                    break;
                }
                case 5: {
                    if (this.pTop != null) {
                        vRMLNodeType.setValue(n2, this.pTop);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfTop);
                    break;
                }
                case 6: {
                    if (this.pBottom != null) {
                        vRMLNodeType.setValue(n2, this.pBottom);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfBottom);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.setTextureNode(n, vRMLNodeType);
                if (this.inSetup) break;
                this.hasChanged[n] = true;
                this.fireFieldChanged(n);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    protected void setTextureNode(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLProtoInstance vRMLProtoInstance = null;
        VRMLTexture2DNodeType vRMLTexture2DNodeType = null;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            if (!(vRMLNodeType2 instanceof VRMLTexture2DNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_PROTO_MSG);
            }
            vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
            vRMLTexture2DNodeType = (VRMLTexture2DNodeType)vRMLNodeType2;
        } else {
            if (!(vRMLNodeType instanceof VRMLTexture2DNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_NODE_MSG);
            }
            vRMLTexture2DNodeType = (VRMLTexture2DNodeType)vRMLNodeType;
        }
        switch (n) {
            case 1: {
                this.pFront = vRMLProtoInstance;
                this.vfFront = vRMLTexture2DNodeType;
                break;
            }
            case 2: {
                this.pBack = vRMLProtoInstance;
                this.vfBack = vRMLTexture2DNodeType;
                break;
            }
            case 3: {
                this.pBack = vRMLProtoInstance;
                this.vfBack = vRMLTexture2DNodeType;
                break;
            }
            case 4: {
                this.pRight = vRMLProtoInstance;
                this.vfRight = vRMLTexture2DNodeType;
                break;
            }
            case 5: {
                this.pTop = vRMLProtoInstance;
                this.vfTop = vRMLTexture2DNodeType;
                break;
            }
            case 6: {
                this.pBottom = vRMLProtoInstance;
                this.vfBottom = vRMLTexture2DNodeType;
            }
        }
    }

    static {
        nodeFields = new int[]{2, 1, 3, 4, 5, 6, 0};
        fieldDecl = new VRMLFieldDeclaration[7];
        fieldMap = new HashMap(21);
        BaseComposedCubeMapTexture.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseComposedCubeMapTexture.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "front");
        BaseComposedCubeMapTexture.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "back");
        BaseComposedCubeMapTexture.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "left");
        BaseComposedCubeMapTexture.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFNode", "right");
        BaseComposedCubeMapTexture.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFNode", "top");
        BaseComposedCubeMapTexture.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFNode", "bottom");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("front", n);
        fieldMap.put("set_front", n);
        fieldMap.put("front_changed", n);
        n = new Integer(2);
        fieldMap.put("back", n);
        fieldMap.put("set_back", n);
        fieldMap.put("back_changed", n);
        n = new Integer(3);
        fieldMap.put("left", n);
        fieldMap.put("set_left", n);
        fieldMap.put("left_changed", n);
        n = new Integer(6);
        fieldMap.put("bottom", n);
        fieldMap.put("set_bottom", n);
        fieldMap.put("bottom_changed", n);
        n = new Integer(4);
        fieldMap.put("right", n);
        fieldMap.put("set_right", n);
        fieldMap.put("right_changed", n);
        n = new Integer(5);
        fieldMap.put("top", n);
        fieldMap.put("set_top", n);
        fieldMap.put("top_changed", n);
    }
}

