/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.lang;

import java.util.Map;

public class ComponentInfo {
    private final String name;
    private final int level;
    private final String title;
    private final String providerUrl;
    private final Map packageNames;

    public ComponentInfo(String string, int n) {
        this(string, n, null, null, null);
    }

    public ComponentInfo(String string, int n, String string2, String string3, Map map) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Level <= 0");
        }
        this.name = string;
        this.level = n;
        this.title = string2;
        this.providerUrl = string3;
        this.packageNames = map;
    }

    public ComponentInfo(ComponentInfo componentInfo, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Level <= 0");
        }
        this.name = componentInfo.name;
        this.level = n;
        this.title = componentInfo.title;
        this.providerUrl = componentInfo.providerUrl;
        this.packageNames = componentInfo.packageNames;
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public String getTitle() {
        return this.title;
    }

    public String getProviderURL() {
        return this.providerUrl;
    }

    public String getPackage(String string) {
        return (String)this.packageNames.get(string);
    }

    public String toX3DString() {
        return "COMPONENT " + this.name + ':' + this.level;
    }
}

