/*
 * Decompiled with CFR 0.152.
 */
package rdr;

public abstract class OutStream {
    protected byte[] b;
    protected int ptr;
    protected int end;

    public final int check(int itemSize, int nItems) {
        if (this.ptr + itemSize * nItems > this.end) {
            if (this.ptr + itemSize > this.end) {
                return this.overrun(itemSize, nItems);
            }
            nItems = (this.end - this.ptr) / itemSize;
        }
        return nItems;
    }

    public final void check(int itemSize) {
        if (this.ptr + itemSize > this.end) {
            this.overrun(itemSize, 1);
        }
    }

    public final void writeU8(int u) {
        this.check(1);
        this.b[this.ptr++] = (byte)u;
    }

    public final void writeU16(int u) {
        this.check(2);
        this.b[this.ptr++] = (byte)(u >> 8);
        this.b[this.ptr++] = (byte)u;
    }

    public final void writeU32(int u) {
        this.check(4);
        this.b[this.ptr++] = (byte)(u >> 24);
        this.b[this.ptr++] = (byte)(u >> 16);
        this.b[this.ptr++] = (byte)(u >> 8);
        this.b[this.ptr++] = (byte)u;
    }

    public final void writeS8(int s) {
        this.writeU8(s);
    }

    public final void writeS16(int s) {
        this.writeU16(s);
    }

    public final void writeS32(int s) {
        this.writeU32(s);
    }

    public final void writeString(String str) {
        int len = str.length();
        this.writeU32(len);
        int i = 0;
        while (i < len) {
            int j = i + this.check(1, len - i);
            while (i < j) {
                this.b[this.ptr++] = (byte)str.charAt(i++);
            }
        }
    }

    public final void pad(int bytes) {
        while (bytes-- > 0) {
            this.writeU8(0);
        }
    }

    public final void skip(int bytes) {
        while (bytes > 0) {
            int n = this.check(1, bytes);
            this.ptr += n;
            bytes -= n;
        }
    }

    public void writeBytes(byte[] data, int offset, int length) {
        int offsetEnd = offset + length;
        while (offset < offsetEnd) {
            int n = this.check(1, offsetEnd - offset);
            System.arraycopy(data, offset, this.b, this.ptr, n);
            this.ptr += n;
            offset += n;
        }
    }

    public final void writeOpaque8(int u) {
        this.writeU8(u);
    }

    public final void writeOpaque16(int u) {
        this.writeU16(u);
    }

    public final void writeOpaque32(int u) {
        this.writeU32(u);
    }

    public final void writeOpaque24A(int u) {
        this.check(3);
        this.b[this.ptr++] = (byte)(u >> 24);
        this.b[this.ptr++] = (byte)(u >> 16);
        this.b[this.ptr++] = (byte)(u >> 8);
    }

    public final void writeOpaque24B(int u) {
        this.check(3);
        this.b[this.ptr++] = (byte)(u >> 16);
        this.b[this.ptr++] = (byte)(u >> 8);
        this.b[this.ptr++] = (byte)u;
    }

    public abstract int length();

    public void flush() {
    }

    public final byte[] getbuf() {
        return this.b;
    }

    public final int getptr() {
        return this.ptr;
    }

    public final int getend() {
        return this.end;
    }

    public final void setptr(int p) {
        this.ptr = p;
    }

    protected abstract int overrun(int var1, int var2);

    protected OutStream() {
    }
}

