/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#ifndef _TCONFIGDIALOG_H_
#define _TCONFIGDIALOG_H_

#include <QtGui>
#include "TPages.h"
#include "TFontChoser.h"
#include "TUserSettings.h"

class QListWidget;
class QListWidgetItem;
class QStackedWidget;

class TConfigDialog : public QDialog
{
    Q_OBJECT

public:
    TConfigDialog();
    void ReadSettings();

    TMainPage *page1;
    TFontsPage *page2;
	TFileInfoPage *page3;
	TColorPage *page4;
    TUserSettings *settings;

    QPushButton *closeButton;
    QPushButton *applyButton;
    QPushButton *okButton;

    QListWidget *contentsWidget;
    QStackedWidget *pagesWidget;

private slots:
    void changePage(QListWidgetItem *current, QListWidgetItem *previous);
    void S_WriteSettings();
    void S_WriteSettingsOk();

signals:
    void applySettings();

private:
    void createIcons();
    
};

#endif
