/*****************************************************************************

	unsort - reorder files semi-randomly
	Copyright (C) 2008  Wessel Dankers <wsl@fruit.je>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

*****************************************************************************/

#include <stdlib.h>
#include <math.h>

#include <stdio.h>
#include <stdint.h>
#include <inttypes.h>

#include "msort.h"

static void msort32_update(uint32_t *dd, uint32_t count, uint32_t o) {
	uint32_t d, d1, d2;
	uint32_t o1, o2;

	if(!count)
		return;

	d = dd[o];

	for(;;) {
		o1 = o * 2 + 1;
		if(o1 >= count)
			break;
		d1 = dd[o1];

		o2 = o * 2 + 2;
		if(o2 < count) {
			d2 = dd[o2];
			if(d2 > d1) {
				o1 = o2;
				d1 = d2;
			}
		}

		if(d > d1)
			break;

		dd[o1] = d;
		dd[o] = d1;
		o = o1;
	}
}

void msort32(uint32_t *dd, uint32_t count) {
	uint32_t u = count / 2;

	if(!dd || !u)
		return;

	do msort32_update(dd, count, u);
		while(u--);

	while(count-- > 1) {
		u = dd[0];
		dd[0] = dd[count];
		dd[count] = u;
		msort32_update(dd, count, 0);
	}
}
