/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2020 Marvell International Ltd.
 *
 * Definitions for enumerations used with Octeon CSRs.
 */

#ifndef __CVMX_CSR_ENUMS_H__
#define __CVMX_CSR_ENUMS_H__

typedef enum {
	CVMX_IPD_OPC_MODE_STT = 0LL,
	CVMX_IPD_OPC_MODE_STF = 1LL,
	CVMX_IPD_OPC_MODE_STF1_STT = 2LL,
	CVMX_IPD_OPC_MODE_STF2_STT = 3LL
} cvmx_ipd_mode_t;

/**
 * Enumeration representing the amount of packet processing
 * and validation performed by the input hardware.
 */
typedef enum {
	CVMX_PIP_PORT_CFG_MODE_NONE = 0ull,
	CVMX_PIP_PORT_CFG_MODE_SKIPL2 = 1ull,
	CVMX_PIP_PORT_CFG_MODE_SKIPIP = 2ull
} cvmx_pip_port_parse_mode_t;

/**
 * This enumeration controls how a QoS watcher matches a packet.
 *
 * @deprecated  This enumeration was used with cvmx_pip_config_watcher which has
 *              been deprecated.
 */
typedef enum {
	CVMX_PIP_QOS_WATCH_DISABLE = 0ull,
	CVMX_PIP_QOS_WATCH_PROTNH = 1ull,
	CVMX_PIP_QOS_WATCH_TCP = 2ull,
	CVMX_PIP_QOS_WATCH_UDP = 3ull
} cvmx_pip_qos_watch_types;

/**
 * This enumeration is used in PIP tag config to control how
 * POW tags are generated by the hardware.
 */
typedef enum {
	CVMX_PIP_TAG_MODE_TUPLE = 0ull,
	CVMX_PIP_TAG_MODE_MASK = 1ull,
	CVMX_PIP_TAG_MODE_IP_OR_MASK = 2ull,
	CVMX_PIP_TAG_MODE_TUPLE_XOR_MASK = 3ull
} cvmx_pip_tag_mode_t;

/**
 * Tag type definitions
 */
typedef enum {
	CVMX_POW_TAG_TYPE_ORDERED = 0L,
	CVMX_POW_TAG_TYPE_ATOMIC = 1L,
	CVMX_POW_TAG_TYPE_NULL = 2L,
	CVMX_POW_TAG_TYPE_NULL_NULL = 3L
} cvmx_pow_tag_type_t;

/**
 * LCR bits 0 and 1 control the number of bits per character. See the following table for encodings:
 *
 * - 00 = 5 bits (bits 0-4 sent)
 * - 01 = 6 bits (bits 0-5 sent)
 * - 10 = 7 bits (bits 0-6 sent)
 * - 11 = 8 bits (all bits sent)
 */
typedef enum {
	CVMX_UART_BITS5 = 0,
	CVMX_UART_BITS6 = 1,
	CVMX_UART_BITS7 = 2,
	CVMX_UART_BITS8 = 3
} cvmx_uart_bits_t;

typedef enum {
	CVMX_UART_IID_NONE = 1,
	CVMX_UART_IID_RX_ERROR = 6,
	CVMX_UART_IID_RX_DATA = 4,
	CVMX_UART_IID_RX_TIMEOUT = 12,
	CVMX_UART_IID_TX_EMPTY = 2,
	CVMX_UART_IID_MODEM = 0,
	CVMX_UART_IID_BUSY = 7
} cvmx_uart_iid_t;

#endif /* __CVMX_CSR_ENUMS_H__ */
