# FindTeradata.cmake

SET(TERADATA_FOUND "NO")

MESSAGE(STATUS "Looking for Teradata...")

IF (NOT TERADATA_PATH_LIB)
    MESSAGE(FATAL_ERROR "Please set path to cliv2 LIBRARIES with -DTERADATA_PATH_LIB")
ENDIF (NOT TERADATA_PATH_LIB)

IF (NOT TERADATA_PATH_INCLUDES)
    MESSAGE(FATAL_ERROR "Please set path to cliv2 INCLUDES with -DTERADATA_PATH_INCLUDES")
ENDIF (NOT TERADATA_PATH_INCLUDES)

FIND_LIBRARY(
    TERADATA_LIBRARY_LIBCLIV2
    NAMES libcliv2 wincli32
    PATHS ${TERADATA_PATH_LIB}
)

FIND_LIBRARY(
    TERADATA_LIBRARY_LIBTDUSR
    NAMES libtdusr
    PATHS ${TERADATA_LIBRARY_LIBTDUSR}
)

SET (TERADATA_LIBRARIES "${TERADATA_LIBRARY_LIBCLIV2}")
# teradata doesn't distribute a .lib for this one on windows
IF (TERADATA_LIBRARY_LIBTDUSR)
    SET (TERADATA_LIBRARIES "${TERADATA_LIBRARIES} ${TERADATA_LIBRARY_LIBTDUSR}")
ENDIF (TERADATA_LIBRARY_LIBTDUSR)

MESSAGE(STATUS "Teradata Libraries: ${TERADATA_LIBRARIES}")

#TRY_RUN(TDRUNRESULT TDCOMPILERESULT
#    ${CMAKE_BINARY_DIR}
#    ${CMAKE_SOURCE_DIR}/cmake/modules/TeradataTest.c
#    CMAKE_FLAGS "-DINCLUDE_DIRECTORIES:STRING=${TERADATA_PATH_INCLUDES}"
#    OUTPUT_VARIABLE TDOUTPUTVAR)

#IF (NOT TDCOMPILERESULT)
#    MESSAGE(STATUS "Compile Result: ${TDCOMPILERESULT}")
#    MESSAGE(STATUS "Run Result: ${TDRUNRESULT}")
#    MESSAGE(STATUS "Output: ${TDOUTPUTVAR}")
#    MESSAGE(FATAL_ERROR "Failed to run a simple Teradata compile test. Please double-check TERADATA_PATH_LIB and TERADATA_PATH_INCLUDES are set correctly.")
#ENDIF (NOT TDCOMPILERESULT)

IF (NOT TERADATA_LIBRARIES)
   SET(TERADATA_LIBRARIES "${TERADATA_PATH_LIB} ${TERADATA_LIBRARY_LIBTDUSR}")
ENDIF (NOT TERADATA_LIBRARIES)

SET(TERADATA_FOUND "YES")
