COMPILEUSB=no
INTERNALBROWSER=yes
AUTHORIZELINUXQSTYLES=yes


TEMPLATE	= app
LANGUAGE	= C++
TARGET	 = texmaker


TEXMAKERVERSION=6.0.1
DEFINES += TEXMAKERVERSION=$${TEXMAKERVERSION}

equals(QT_MAJOR_VERSION, 6) {
QT += core gui widgets xml network printsupport concurrent core-private qml core5compat
} else {
equals(QT_MAJOR_VERSION, 5){
greaterThan(QT_MINOR_VERSION, 6) {
QT += core gui widgets xml network printsupport concurrent core-private qml
} else {
message("Qt>=5.7 is required.")
}
}
}

equals(INTERNALBROWSER,yes){
QT += webenginewidgets
}


CONFIG	+= qt hide_symbols warn_off rtti_off exceptions_off c++11 release
CONFIG -= precompile_header

gcc {
    QMAKE_CXXFLAGS_WARN_ON += -Wno-unused-parameter
}

msvc {
    QMAKE_CXXFLAGS_WARN_ON += -wd"4267"
}

DEFINES += \
    OPJ_STATIC \
    PNG_PREFIX \
    PNG_USE_READ_MACROS \
    V8_DEPRECATION_WARNINGS \
    NOMINMAX \
    FT2_BUILD_LIBRARY


INCLUDEPATH += \
    3rdparty/ \
    3rdparty/pdfium/ \
    3rdparty/pdfium \
    3rdparty/pdfium/third_party/ \
    3rdparty/pdfium/third_party/freetype/include \
    3rdparty/pdfium/third_party/freetype/include/freetype \
    3rdparty/pdfium/fpdfsdk \
    3rdparty/pdfium/third_party/zlib_v128

###############################

HEADERS	+= src/texmaker.h \
    src/theme.h \
    src/dropshadowlabel.h \
	src/geticon.h \
	src/documentview.h \
	src/pageitem.h \
	src/presentationview.h \
	src/texmakerapp.h \
	src/minisplitter.h \
	src/playerbutton.h \
	src/symbollistwidget.h \
	src/icondelegate.h \
	src/latexeditor.h \
	src/latexhighlighter.h \
	src/latexeditorview.h \
	src/linenumberwidget.h \
	src/lightlatexeditor.h \
	src/lightlatexhighlighter.h \
	src/lightlinenumberwidget.h \
	src/sourceview.h \
	src/logeditor.h \
	src/loghighlighter.h \
	src/findwidget.h \
	src/gotolinewidget.h \
	src/lightfindwidget.h \
	src/lightgotolinewidget.h \
	src/replacewidget.h \
	src/structdialog.h \
	src/filechooser.h \
	src/graphicfilechooser.h \
	src/tabbingdialog.h \
	src/arraydialog.h \
	src/tabdialog.h \
	src/letterdialog.h \
	src/addoptiondialog.h \
	src/quickdocumentdialog.h \
	src/quickxelatexdialog.h \
	src/usermenudialog.h \
	src/usertooldialog.h \
	src/refdialog.h \
	src/configdialog.h \
	src/aboutdialog.h \
	src/spellerdialog.h \
	src/xmltagslistwidget.h \
	src/blockdata.h \
	src/keysequencedialog.h \
	src/pdfviewerwidget.h \
	src/pdfviewer.h \
	src/userquickdialog.h \
	src/encodingdialog.h \
	src/usercompletiondialog.h \
	src/texdocdialog.h \
	src/textblockselection.h \
	src/scandialog.h \
	src/exportdialog.h \
	src/usertagslistwidget.h \
	src/addtagdialog.h \
	src/versiondialog.h \
	src/unicodedialog.h \
	src/unicodeview.h \
	src/githelper.h \
	src/x11fontdialog.h \
	src/quickbeamerdialog.h \
	src/cmdparser.h \
    src/qpdfdocument.h \
    src/qpdfdocument_p.h \
    src/qpdfdocumentrenderoptions.h \
    src/qpdfnamespace.h \
    src/qpdfbookmarkmodel.h \
	3rdparty/synctex/synctex_parser.h \
	3rdparty/synctex/synctex_parser_utils.h \
	3rdparty/synctex/synctex_version.h \
	3rdparty/synctex/synctex_parser_advanced.h \
	3rdparty/hunspell/affentry.hxx \
	3rdparty/hunspell/affixmgr.hxx \
	3rdparty/hunspell/atypes.hxx \
	3rdparty/hunspell/baseaffix.hxx \
	3rdparty/hunspell/csutil.hxx \
	3rdparty/hunspell/filemgr.hxx \
	3rdparty/hunspell/hashmgr.hxx \
	3rdparty/hunspell/htypes.hxx \
	3rdparty/hunspell/hunvisapi.h \
	3rdparty/hunspell/hunspell.h \
	3rdparty/hunspell/hunspell.hxx \
	3rdparty/hunspell/hunzip.hxx \
	3rdparty/hunspell/langnum.hxx \
	3rdparty/hunspell/phonet.hxx \
	3rdparty/hunspell/replist.hxx \
	3rdparty/hunspell/suggestmgr.hxx \
	3rdparty/hunspell/utf_info.hxx \
	3rdparty/hunspell/w_char.hxx \
	3rdparty/singleapp/qtlocalpeer.h \
	3rdparty/singleapp/qtlockedfile.h \
	3rdparty/singleapp/qtsingleapplication.h \
	3rdparty/singleapp/qtsinglecoreapplication.h \
	3rdparty/encodingprober/CharDistribution.h \
	3rdparty/encodingprober/ChineseGroupProber.h \
	3rdparty/encodingprober/ctype_test_p.h \
	3rdparty/encodingprober/JapaneseGroupProber.h \
	3rdparty/encodingprober/JpCntx.h \
	3rdparty/encodingprober/nsBig5Prober.h \
	3rdparty/encodingprober/nsCharSetProber.h \
	3rdparty/encodingprober/nsCodingStateMachine.h \
	3rdparty/encodingprober/nsEscCharsetProber.h \
	3rdparty/encodingprober/nsEUCJPProber.h \
	3rdparty/encodingprober/nsEUCKRProber.h \
	3rdparty/encodingprober/nsEUCTWProber.h \
	3rdparty/encodingprober/nsGB2312Prober.h \
	3rdparty/encodingprober/nsHebrewProber.h \
	3rdparty/encodingprober/nsLatin1Prober.h \
	3rdparty/encodingprober/nsMBCSGroupProber.h \
	3rdparty/encodingprober/nsPkgInt.h \
	3rdparty/encodingprober/nsSBCharSetProber.h \
	3rdparty/encodingprober/nsSBCSGroupProber.h \
	3rdparty/encodingprober/nsSJISProber.h \
	3rdparty/encodingprober/nsUniversalDetector.h \
	3rdparty/encodingprober/qencodingprober.h \
	3rdparty/encodingprober/UnicodeGroupProber.h \
    3rdparty/pdfium/third_party/bigint/BigInteger.hh \
    3rdparty/pdfium/third_party/bigint/BigIntegerLibrary.hh \
    3rdparty/pdfium/third_party/bigint/BigIntegerUtils.hh \
    3rdparty/pdfium/third_party/bigint/BigUnsigned.hh \
    3rdparty/pdfium/third_party/bigint/NumberlikeArray.hh \
    3rdparty/pdfium/third_party/bigint/BigUnsignedInABase.hh \
    3rdparty/pdfium/third_party/base/logging.h \
    3rdparty/pdfium/third_party/base/macros.h \
    3rdparty/pdfium/third_party/base/numerics/safe_conversions.h \
    3rdparty/pdfium/third_party/base/numerics/safe_conversions_impl.h \
    3rdparty/pdfium/third_party/base/numerics/safe_math.h \
    3rdparty/pdfium/third_party/base/numerics/safe_math_impl.h \
    3rdparty/pdfium/third_party/base/stl_util.h \
    3rdparty/pdfium/third_party/libjpeg/cderror.h \
    3rdparty/pdfium/third_party/libjpeg/cdjpeg.h \
    3rdparty/pdfium/third_party/libjpeg/jchuff.h \
    3rdparty/pdfium/third_party/libjpeg/jconfig.h \
    3rdparty/pdfium/third_party/libjpeg/jdct.h \
    3rdparty/pdfium/third_party/libjpeg/jdhuff.h \
    3rdparty/pdfium/third_party/libjpeg/jerror.h \
    3rdparty/pdfium/third_party/libjpeg/jinclude.h \
    3rdparty/pdfium/third_party/libjpeg/jmemsys.h \
    3rdparty/pdfium/third_party/libjpeg/jmorecfg.h \
    3rdparty/pdfium/third_party/libjpeg/jpegint.h \
    3rdparty/pdfium/third_party/libjpeg/jpeglib.h \
    3rdparty/pdfium/third_party/libjpeg/jversion.h \
    3rdparty/pdfium/third_party/libjpeg/transupp.h \
    3rdparty/pdfium/third_party/lcms/include/lcms2.h \
    3rdparty/pdfium/third_party/lcms/include/lcms2_plugin.h \
    3rdparty/pdfium/third_party/agg23/agg_basics.h \
    3rdparty/pdfium/third_party/agg23/agg_clip_liang_barsky.h \
    3rdparty/pdfium/third_party/agg23/agg_conv_dash.h \
    3rdparty/pdfium/third_party/agg23/agg_conv_stroke.h \
    3rdparty/pdfium/third_party/agg23/agg_curves.h \
    3rdparty/pdfium/third_party/agg23/agg_path_storage.h \
    3rdparty/pdfium/third_party/agg23/agg_rasterizer_scanline_aa.h \
    3rdparty/pdfium/third_party/agg23/agg_renderer_scanline.h \
    3rdparty/pdfium/third_party/agg23/agg_rendering_buffer.h \
    3rdparty/pdfium/third_party/agg23/agg_scanline_u.h \
    3rdparty/pdfium/third_party/freetype/include/freetype/freetype.h \
    3rdparty/pdfium/third_party/freetype/include/freetype/ftmm.h \
    3rdparty/pdfium/third_party/freetype/include/freetype/ftotval.h \
    3rdparty/pdfium/third_party/freetype/include/freetype/ftoutln.h \
    3rdparty/pdfium/third_party/freetype/include/freetype/internal/ftobjs.h \
    3rdparty/pdfium/third_party/freetype/include/freetype/internal/ftstream.h \
    3rdparty/pdfium/third_party/freetype/include/freetype/internal/tttypes.h \
    3rdparty/pdfium/third_party/freetype/include/freetype/tttables.h \
    3rdparty/pdfium/third_party/freetype/include/ft2build.h \
    3rdparty/pdfium/third_party/freetype/src/base/ftbase.h \
    3rdparty/pdfium/third_party/freetype/src/cff/cffobjs.h \
    3rdparty/pdfium/third_party/freetype/src/cff/cfftypes.h \
    3rdparty/pdfium/fpdfsdk/cba_annotiterator.h \
    3rdparty/pdfium/fpdfsdk/cfx_systemhandler.h \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_annot.h \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_annothandlermgr.h \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_annotiterator.h \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_baannot.h \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_baannothandler.h \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_datetime.h \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_formfillenvironment.h \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_interform.h \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_pageview.h \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_widget.h \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_widgethandler.h \
    3rdparty/pdfium/fpdfsdk/fsdk_actionhandler.h \
    3rdparty/pdfium/fpdfsdk/fsdk_pauseadapter.h \
    3rdparty/pdfium/fpdfsdk/pdfsdk_fieldaction.h \
    3rdparty/pdfium/public/fpdf_dataavail.h \
    3rdparty/pdfium/public/fpdf_doc.h \
    3rdparty/pdfium/public/fpdf_edit.h \
    3rdparty/pdfium/public/fpdf_ext.h \
    3rdparty/pdfium/public/fpdf_flatten.h \
    3rdparty/pdfium/public/fpdf_formfill.h \
    3rdparty/pdfium/public/fpdf_fwlevent.h \
    3rdparty/pdfium/public/fpdf_ppo.h \
    3rdparty/pdfium/public/fpdf_progressive.h \
    3rdparty/pdfium/public/fpdf_save.h \
    3rdparty/pdfium/public/fpdf_searchex.h \
    3rdparty/pdfium/public/fpdf_sysfontinfo.h \
    3rdparty/pdfium/public/fpdf_text.h \
    3rdparty/pdfium/public/fpdf_transformpage.h \
    3rdparty/pdfium/public/fpdfview.h \
    3rdparty/pdfium/core/fdrm/crypto/fx_crypt.h \
    3rdparty/pdfium/core/fpdfdoc/cline.h \
    3rdparty/pdfium/core/fpdfdoc/clines.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_aaction.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_action.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_actionfields.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_annot.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_annotlist.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_apsettings.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_bookmark.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_bookmarktree.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_defaultappearance.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_dest.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_docjsactions.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_filespec.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_formcontrol.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_formfield.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_iconfit.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_interform.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_link.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_linklist.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_metadata.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_nametree.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_numbertree.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_occontext.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_pagelabel.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_variabletext.h \
    3rdparty/pdfium/core/fpdfdoc/cpdf_viewerpreferences.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_arraytemplate.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_color.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_dash.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_floatrect.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_fontmap.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_generateap.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_line.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_lineinfo.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_secprops.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_section.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_sectioninfo.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_word.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_wordinfo.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_wordplace.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_wordprops.h \
    3rdparty/pdfium/core/fpdfdoc/cpvt_wordrange.h \
    3rdparty/pdfium/core/fpdfdoc/csection.h \
    3rdparty/pdfium/core/fpdfdoc/ctypeset.h \
    3rdparty/pdfium/core/fpdfdoc/fpdf_tagged.h \
    3rdparty/pdfium/core/fpdfdoc/ipdf_formnotify.h \
    3rdparty/pdfium/core/fpdfdoc/ipvt_fontmap.h \
    3rdparty/pdfium/core/fpdfdoc/tagged_int.h \
    3rdparty/pdfium/core/fpdfapi/cmaps/cmap_int.h \
    3rdparty/pdfium/core/fpdfapi/cpdf_modulemgr.h \
    3rdparty/pdfium/core/fpdfapi/cpdf_pagerendercontext.h \
    3rdparty/pdfium/core/fpdfapi/edit/cpdf_creator.h \
    3rdparty/pdfium/core/fpdfapi/edit/cpdf_pagecontentgenerator.h \
    3rdparty/pdfium/core/fpdfapi/edit/editint.h \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_cidfont.h \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_font.h \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_fontencoding.h \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_simplefont.h \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_truetypefont.h \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_type1font.h \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_type3char.h \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_type3font.h \
    3rdparty/pdfium/core/fpdfapi/font/font_int.h \
    3rdparty/pdfium/core/fpdfapi/font/ttgsubtable.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_allstates.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_clippath.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_color.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_colorspace.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_colorstate.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_contentmark.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_contentmarkitem.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_countedobject.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_docpagedata.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_form.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_formobject.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_generalstate.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_graphicstates.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_image.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_imageobject.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_meshstream.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_page.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_pagemodule.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_pageobject.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_pageobjectholder.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_pageobjectlist.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_path.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_pathobject.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_pattern.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_shadingobject.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_shadingpattern.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_streamcontentparser.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_textobject.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_textstate.h \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_tilingpattern.h \
    3rdparty/pdfium/core/fpdfapi/page/pageint.h \
    3rdparty/pdfium/core/fpdfapi/parser/cfdf_document.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_array.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_boolean.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_crypto_handler.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_data_avail.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_dictionary.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_document.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_hint_tables.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_indirect_object_holder.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_linearized_header.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_name.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_null.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_number.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_object.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_parser.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_reference.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_security_handler.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_simple_parser.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_stream.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_stream_acc.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_string.h \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_syntax_parser.h \
    3rdparty/pdfium/core/fpdfapi/parser/fpdf_parser_decode.h \
    3rdparty/pdfium/core/fpdfapi/parser/fpdf_parser_utility.h \
    3rdparty/pdfium/core/fpdfapi/render/cpdf_docrenderdata.h \
    3rdparty/pdfium/core/fpdfapi/render/cpdf_pagerendercache.h \
    3rdparty/pdfium/core/fpdfapi/render/cpdf_progressiverenderer.h \
    3rdparty/pdfium/core/fpdfapi/render/cpdf_rendercontext.h \
    3rdparty/pdfium/core/fpdfapi/render/cpdf_renderoptions.h \
    3rdparty/pdfium/core/fpdfapi/render/cpdf_textrenderer.h \
    3rdparty/pdfium/core/fpdfapi/render/cpdf_type3cache.h \
    3rdparty/pdfium/core/fpdfapi/render/cpdf_type3glyphs.h \
    3rdparty/pdfium/core/fpdfapi/render/render_int.h \
    3rdparty/pdfium/core/fpdftext/cpdf_linkextract.h \
    3rdparty/pdfium/core/fpdftext/cpdf_textpage.h \
    3rdparty/pdfium/core/fpdftext/cpdf_textpagefind.h \
    3rdparty/pdfium/core/fpdftext/unicodenormalizationdata.h \
    3rdparty/pdfium/core/fxcodec/JBig2_DocumentContext.h \
    3rdparty/pdfium/core/fxcodec/codec/ccodec_basicmodule.h \
    3rdparty/pdfium/core/fxcodec/codec/ccodec_faxmodule.h \
    3rdparty/pdfium/core/fxcodec/codec/ccodec_flatemodule.h \
    3rdparty/pdfium/core/fxcodec/codec/ccodec_iccmodule.h \
    3rdparty/pdfium/core/fxcodec/codec/ccodec_jbig2module.h \
    3rdparty/pdfium/core/fxcodec/codec/ccodec_jpegmodule.h \
    3rdparty/pdfium/core/fxcodec/codec/ccodec_jpxmodule.h \
    3rdparty/pdfium/core/fxcodec/codec/ccodec_scanlinedecoder.h \
    3rdparty/pdfium/core/fxcodec/codec/codec_int.h \
    3rdparty/pdfium/core/fxcodec/fx_codec.h \
    3rdparty/pdfium/core/fxcodec/fx_codec_def.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_ArithDecoder.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_ArithIntDecoder.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_BitStream.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_Context.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_Define.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_GrdProc.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_GrrdProc.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_GsidProc.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_HtrdProc.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_HuffmanDecoder.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_HuffmanTable.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_HuffmanTable_Standard.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_Image.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_List.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_Page.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_PatternDict.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_PddProc.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_SddProc.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_Segment.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_SymbolDict.h \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_TrdProc.h \
    3rdparty/pdfium/core/fxcrt/cfx_observable.h \
    3rdparty/pdfium/core/fxcrt/cfx_retain_ptr.h \
    3rdparty/pdfium/core/fxcrt/cfx_shared_copy_on_write.h \
    3rdparty/pdfium/core/fxcrt/cfx_string_c_template.h \
    3rdparty/pdfium/core/fxcrt/cfx_string_data_template.h \
    3rdparty/pdfium/core/fxcrt/cfx_string_pool_template.h \
    3rdparty/pdfium/core/fxcrt/cfx_weak_ptr.h \
    3rdparty/pdfium/core/fxcrt/extension.h \
    3rdparty/pdfium/core/fxcrt/fx_basic.h \
    3rdparty/pdfium/core/fxcrt/fx_bidi.h \
    3rdparty/pdfium/core/fxcrt/fx_coordinates.h \
    3rdparty/pdfium/core/fxcrt/fx_ext.h \
    3rdparty/pdfium/core/fxcrt/fx_memory.h \
    3rdparty/pdfium/core/fxcrt/fx_safe_types.h \
    3rdparty/pdfium/core/fxcrt/fx_stream.h \
    3rdparty/pdfium/core/fxcrt/fx_string.h \
    3rdparty/pdfium/core/fxcrt/fx_system.h \
    3rdparty/pdfium/core/fxcrt/fx_ucd.h \
    3rdparty/pdfium/core/fxcrt/fx_xml.h \
    3rdparty/pdfium/core/fxcrt/fxcrt_posix.h \
    3rdparty/pdfium/core/fxcrt/fxcrt_windows.h \
    3rdparty/pdfium/core/fxcrt/plex.h \
    3rdparty/pdfium/core/fxcrt/xml_int.h \
    3rdparty/pdfium/core/fxge/cfx_facecache.h \
    3rdparty/pdfium/core/fxge/cfx_fontcache.h \
    3rdparty/pdfium/core/fxge/cfx_fontmapper.h \
    3rdparty/pdfium/core/fxge/cfx_fontmgr.h \
    3rdparty/pdfium/core/fxge/cfx_fxgedevice.h \
    3rdparty/pdfium/core/fxge/cfx_gemodule.h \
    3rdparty/pdfium/core/fxge/cfx_graphstate.h \
    3rdparty/pdfium/core/fxge/cfx_graphstatedata.h \
    3rdparty/pdfium/core/fxge/cfx_pathdata.h \
    3rdparty/pdfium/core/fxge/cfx_renderdevice.h \
    3rdparty/pdfium/core/fxge/cfx_substfont.h \
    3rdparty/pdfium/core/fxge/cfx_unicodeencoding.h \
    3rdparty/pdfium/core/fxge/cfx_windowsdevice.h \
    3rdparty/pdfium/core/fxge/dib/dib_int.h \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/chromefontdata.h \
    3rdparty/pdfium/core/fxge/fx_dib.h \
    3rdparty/pdfium/core/fxge/fx_font.h \
    3rdparty/pdfium/core/fxge/fx_freetype.h \
    3rdparty/pdfium/core/fxge/ge/cfx_cliprgn.h \
    3rdparty/pdfium/core/fxge/ge/cfx_folderfontinfo.h \
    3rdparty/pdfium/core/fxge/ge/cttfontdesc.h \
    3rdparty/pdfium/core/fxge/ge/fx_text_int.h \
    3rdparty/pdfium/core/fxge/ifx_renderdevicedriver.h \
    3rdparty/pdfium/core/fxge/ifx_systemfontinfo.h \
    3rdparty/pdfium/core/fxge/win32/cfx_windowsdib.h \
    3rdparty/pdfium/core/fxge/agg/fx_agg_driver.h \
    3rdparty/pdfium/fpdfsdk/fxedit/fx_edit.h \
    3rdparty/pdfium/fpdfsdk/fxedit/fxet_edit.h \
    3rdparty/pdfium/fpdfsdk/fxedit/fxet_list.h \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_Button.h \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_Caret.h \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_ComboBox.h \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_Edit.h \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_EditCtrl.h \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_FontMap.h \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_Icon.h \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_ListBox.h \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_ScrollBar.h \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_SpecialButton.h \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_Utils.h \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_Wnd.h \
    3rdparty/pdfium/fpdfsdk/pdfwindow/cpwl_color.h \
    3rdparty/pdfium/fpdfsdk/formfiller/cba_fontmap.h \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_checkbox.h \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_combobox.h \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_formfiller.h \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_interactiveformfiller.h \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_listbox.h \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_pushbutton.h \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_radiobutton.h \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_textfield.h


SOURCES	+= src/main.cpp \
    src/dropshadowlabel.cpp \
	src/geticon.cpp \
	src/texmakerapp.cpp \
	src/texmaker.cpp \
	src/documentview.cpp \
	src/pageitem.cpp \
	src/presentationview.cpp \
	src/minisplitter.cpp \
	src/playerbutton.cpp \
	src/symbollistwidget.cpp \
	src/icondelegate.cpp \
	src/latexeditor.cpp \
	src/latexhighlighter.cpp \
	src/latexeditorview.cpp \
	src/linenumberwidget.cpp \
	src/lightlatexeditor.cpp \
	src/lightlatexhighlighter.cpp \
	src/lightlinenumberwidget.cpp \
	src/sourceview.cpp \
	src/logeditor.cpp \
	src/loghighlighter.cpp \
	src/findwidget.cpp \
	src/gotolinewidget.cpp \
	src/lightfindwidget.cpp \
	src/lightgotolinewidget.cpp \
	src/replacewidget.cpp \
	src/structdialog.cpp \
	src/filechooser.cpp \
	src/graphicfilechooser.cpp \
	src/tabbingdialog.cpp \
	src/arraydialog.cpp \
	src/tabdialog.cpp \
	src/letterdialog.cpp \
	src/addoptiondialog.cpp \
	src/quickdocumentdialog.cpp \
	src/quickxelatexdialog.cpp \
	src/usermenudialog.cpp \
	src/usertooldialog.cpp \
	src/refdialog.cpp \
	src/configdialog.cpp \
	src/aboutdialog.cpp \
	src/spellerdialog.cpp \
	src/xmltagslistwidget.cpp \
	src/blockdata.cpp \
	src/keysequencedialog.cpp \
	src/pdfviewerwidget.cpp \
	src/pdfviewer.cpp \
	src/userquickdialog.cpp \
	src/encodingdialog.cpp \
	src/usercompletiondialog.cpp \
	src/texdocdialog.cpp \
	src/scandialog.cpp \
	src/exportdialog.cpp \
	src/usertagslistwidget.cpp \
	src/addtagdialog.cpp \
	src/versiondialog.cpp \
	src/unicodedialog.cpp \
	src/unicodeview.cpp \
	src/quickbeamerdialog.cpp \
	src/githelper.cpp \
	src/x11fontdialog.cpp \
	src/cmdparser.cpp \
    src/jsbridge.cpp \
    src/qpdfdocument.cpp \
    src/qpdfbookmarkmodel.cpp \
    3rdparty/synctex/synctex_parser.c \
	3rdparty/synctex/synctex_parser_utils.c \
	3rdparty/hunspell/affentry.cxx \
	3rdparty/hunspell/affixmgr.cxx \
	3rdparty/hunspell/csutil.cxx \
	3rdparty/hunspell/filemgr.cxx \
	3rdparty/hunspell/hashmgr.cxx \
	3rdparty/hunspell/hunspell.cxx \
	3rdparty/hunspell/hunzip.cxx \
	3rdparty/hunspell/phonet.cxx \
	3rdparty/hunspell/replist.cxx \
	3rdparty/hunspell/suggestmgr.cxx \
	3rdparty/singleapp/qtlocalpeer.cpp \
	3rdparty/singleapp/qtlockedfile.cpp \
	3rdparty/singleapp/qtsingleapplication.cpp \
	3rdparty/singleapp/qtsinglecoreapplication.cpp \
	3rdparty/encodingprober/CharDistribution.cpp \
	3rdparty/encodingprober/ChineseGroupProber.cpp \
	3rdparty/encodingprober/JapaneseGroupProber.cpp \
	3rdparty/encodingprober/JpCntx.cpp \
	3rdparty/encodingprober/LangBulgarianModel.cpp \
	3rdparty/encodingprober/LangCyrillicModel.cpp \
	3rdparty/encodingprober/LangGreekModel.cpp \
	3rdparty/encodingprober/LangHebrewModel.cpp \
	3rdparty/encodingprober/LangHungarianModel.cpp \
	3rdparty/encodingprober/LangThaiModel.cpp \
	3rdparty/encodingprober/nsBig5Prober.cpp \
	3rdparty/encodingprober/nsCharSetProber.cpp \
	3rdparty/encodingprober/nsEscCharsetProber.cpp \
	3rdparty/encodingprober/nsEscSM.cpp \
	3rdparty/encodingprober/nsEUCJPProber.cpp \
	3rdparty/encodingprober/nsEUCKRProber.cpp \
	3rdparty/encodingprober/nsEUCTWProber.cpp \
	3rdparty/encodingprober/nsGB2312Prober.cpp \
	3rdparty/encodingprober/nsHebrewProber.cpp \
	3rdparty/encodingprober/nsLatin1Prober.cpp \
	3rdparty/encodingprober/nsMBCSGroupProber.cpp \
	3rdparty/encodingprober/nsMBCSSM.cpp \
	3rdparty/encodingprober/nsSBCharSetProber.cpp \
	3rdparty/encodingprober/nsSBCSGroupProber.cpp \
	3rdparty/encodingprober/nsSJISProber.cpp \
	3rdparty/encodingprober/nsUniversalDetector.cpp \
	3rdparty/encodingprober/qencodingprober.cpp \
	3rdparty/encodingprober/UnicodeGroupProber.cpp \
    3rdparty/pdfium/third_party/bigint/BigInteger.cc \
    3rdparty/pdfium/third_party/bigint/BigIntegerUtils.cc \
    3rdparty/pdfium/third_party/bigint/BigUnsigned.cc \
    3rdparty/pdfium/third_party/bigint/BigUnsignedInABase.cc \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jcapimin.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jcapistd.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jccoefct.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jccolor.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jcdctmgr.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jchuff.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jcinit.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jcmainct.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jcmarker.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jcmaster.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jcomapi.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jcparam.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jcphuff.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jcprepct.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jcsample.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jctrans.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jdapimin.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jdapistd.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jdcoefct.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jdcolor.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jddctmgr.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jdhuff.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jdinput.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jdmainct.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jdmarker.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jdmaster.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jdmerge.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jdphuff.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jdpostct.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jdsample.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jdtrans.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jerror.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jfdctfst.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jfdctint.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jidctfst.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jidctint.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jidctred.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jmemmgr.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jmemnobs.c \
    3rdparty/pdfium/third_party/libjpeg/fpdfapi_jutils.c \
    3rdparty/pdfium/third_party/lcms/src/cmsalpha.c \
    3rdparty/pdfium/third_party/lcms/src/cmscam02.c \
    3rdparty/pdfium/third_party/lcms/src/cmscgats.c \
    3rdparty/pdfium/third_party/lcms/src/cmscnvrt.c \
    3rdparty/pdfium/third_party/lcms/src/cmserr.c \
    3rdparty/pdfium/third_party/lcms/src/cmsgamma.c \
    3rdparty/pdfium/third_party/lcms/src/cmsgmt.c \
    3rdparty/pdfium/third_party/lcms/src/cmshalf.c \
    3rdparty/pdfium/third_party/lcms/src/cmsintrp.c \
    3rdparty/pdfium/third_party/lcms/src/cmsio0.c \
    3rdparty/pdfium/third_party/lcms/src/cmsio1.c \
    3rdparty/pdfium/third_party/lcms/src/cmslut.c \
    3rdparty/pdfium/third_party/lcms/src/cmsmd5.c \
    3rdparty/pdfium/third_party/lcms/src/cmsmtrx.c \
    3rdparty/pdfium/third_party/lcms/src/cmsnamed.c \
    3rdparty/pdfium/third_party/lcms/src/cmsopt.c \
    3rdparty/pdfium/third_party/lcms/src/cmspack.c \
    3rdparty/pdfium/third_party/lcms/src/cmspcs.c \
    3rdparty/pdfium/third_party/lcms/src/cmsplugin.c \
    3rdparty/pdfium/third_party/lcms/src/cmsps2.c \
    3rdparty/pdfium/third_party/lcms/src/cmssamp.c \
    3rdparty/pdfium/third_party/lcms/src/cmssm.c \
    3rdparty/pdfium/third_party/lcms/src/cmstypes.c \
    3rdparty/pdfium/third_party/lcms/src/cmsvirt.c \
    3rdparty/pdfium/third_party/lcms/src/cmswtpnt.c \
    3rdparty/pdfium/third_party/lcms/src/cmsxform.c \
    3rdparty/pdfium/third_party/libopenjpeg20/bio.c \
    3rdparty/pdfium/third_party/libopenjpeg20/cio.c \
    3rdparty/pdfium/third_party/libopenjpeg20/dwt.c \
    3rdparty/pdfium/third_party/libopenjpeg20/event.c \
    3rdparty/pdfium/third_party/libopenjpeg20/function_list.c \
    3rdparty/pdfium/third_party/libopenjpeg20/image.c \
    3rdparty/pdfium/third_party/libopenjpeg20/invert.c \
    3rdparty/pdfium/third_party/libopenjpeg20/j2k.c \
    3rdparty/pdfium/third_party/libopenjpeg20/jp2.c \
    3rdparty/pdfium/third_party/libopenjpeg20/mct.c \
    3rdparty/pdfium/third_party/libopenjpeg20/mqc.c \
    3rdparty/pdfium/third_party/libopenjpeg20/openjpeg.c \
    3rdparty/pdfium/third_party/libopenjpeg20/opj_clock.c \
    3rdparty/pdfium/third_party/libopenjpeg20/pi.c \
    3rdparty/pdfium/third_party/libopenjpeg20/raw.c \
    3rdparty/pdfium/third_party/libopenjpeg20/t1.c \
    3rdparty/pdfium/third_party/libopenjpeg20/t2.c \
    3rdparty/pdfium/third_party/libopenjpeg20/tcd.c \
    3rdparty/pdfium/third_party/libopenjpeg20/tgt.c \
    3rdparty/pdfium/third_party/zlib_v128/adler32.c \
    3rdparty/pdfium/third_party/zlib_v128/compress.c \
    3rdparty/pdfium/third_party/zlib_v128/crc32.c \
    3rdparty/pdfium/third_party/zlib_v128/deflate.c \
    3rdparty/pdfium/third_party/zlib_v128/gzclose.c \
    3rdparty/pdfium/third_party/zlib_v128/gzlib.c \
    3rdparty/pdfium/third_party/zlib_v128/gzread.c \
    3rdparty/pdfium/third_party/zlib_v128/gzwrite.c \
    3rdparty/pdfium/third_party/zlib_v128/infback.c \
    3rdparty/pdfium/third_party/zlib_v128/inffast.c \
    3rdparty/pdfium/third_party/zlib_v128/inflate.c \
    3rdparty/pdfium/third_party/zlib_v128/inftrees.c \
    3rdparty/pdfium/third_party/zlib_v128/trees.c \
    3rdparty/pdfium/third_party/zlib_v128/uncompr.c \
    3rdparty/pdfium/third_party/zlib_v128/zutil.c \
    3rdparty/pdfium/third_party/agg23/agg_curves.cpp \
    3rdparty/pdfium/third_party/agg23/agg_path_storage.cpp \
    3rdparty/pdfium/third_party/agg23/agg_rasterizer_scanline_aa.cpp \
    3rdparty/pdfium/third_party/agg23/agg_vcgen_dash.cpp \
    3rdparty/pdfium/third_party/agg23/agg_vcgen_stroke.cpp \
    3rdparty/pdfium/third_party/freetype/src/base/ftbase.c \
    3rdparty/pdfium/third_party/freetype/src/base/ftbitmap.c \
    3rdparty/pdfium/third_party/freetype/src/base/ftglyph.c \
    3rdparty/pdfium/third_party/freetype/src/base/ftinit.c \
    3rdparty/pdfium/third_party/freetype/src/base/ftlcdfil.c \
    3rdparty/pdfium/third_party/freetype/src/base/ftmm.c \
    3rdparty/pdfium/third_party/freetype/src/base/ftsystem.c \
    3rdparty/pdfium/third_party/freetype/src/cff/cff.c \
    3rdparty/pdfium/third_party/freetype/src/cid/type1cid.c \
    3rdparty/pdfium/third_party/freetype/src/psaux/psaux.c \
    3rdparty/pdfium/third_party/freetype/src/pshinter/pshinter.c \
    3rdparty/pdfium/third_party/freetype/src/psnames/psmodule.c \
    3rdparty/pdfium/third_party/freetype/src/raster/raster.c \
    3rdparty/pdfium/third_party/freetype/src/sfnt/sfnt.c \
    3rdparty/pdfium/third_party/freetype/src/smooth/smooth.c \
    3rdparty/pdfium/third_party/freetype/src/truetype/truetype.c \
    3rdparty/pdfium/third_party/freetype/src/type1/type1.c \
    3rdparty/pdfium/fpdfsdk/cba_annotiterator.cpp \
    3rdparty/pdfium/fpdfsdk/cfx_systemhandler.cpp \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_annot.cpp \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_annothandlermgr.cpp \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_annotiterator.cpp \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_baannot.cpp \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_baannothandler.cpp \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_datetime.cpp \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_formfillenvironment.cpp \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_interform.cpp \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_pageview.cpp \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_widget.cpp \
    3rdparty/pdfium/fpdfsdk/cpdfsdk_widgethandler.cpp \
    3rdparty/pdfium/fpdfsdk/fpdf_dataavail.cpp \
    3rdparty/pdfium/fpdfsdk/fpdf_ext.cpp \
    3rdparty/pdfium/fpdfsdk/fpdf_flatten.cpp \
    3rdparty/pdfium/fpdfsdk/fpdf_progressive.cpp \
    3rdparty/pdfium/fpdfsdk/fpdf_searchex.cpp \
    3rdparty/pdfium/fpdfsdk/fpdf_sysfontinfo.cpp \
    3rdparty/pdfium/fpdfsdk/fpdf_transformpage.cpp \
    3rdparty/pdfium/fpdfsdk/fpdfdoc.cpp \
    3rdparty/pdfium/fpdfsdk/fpdfeditimg.cpp \
    3rdparty/pdfium/fpdfsdk/fpdfeditpage.cpp \
    3rdparty/pdfium/fpdfsdk/fpdfformfill.cpp \
    3rdparty/pdfium/fpdfsdk/fpdfppo.cpp \
    3rdparty/pdfium/fpdfsdk/fpdfsave.cpp \
    3rdparty/pdfium/fpdfsdk/fpdftext.cpp \
    3rdparty/pdfium/fpdfsdk/fpdfview.cpp \
    3rdparty/pdfium/fpdfsdk/fsdk_actionhandler.cpp \
    3rdparty/pdfium/fpdfsdk/fsdk_pauseadapter.cpp \
    3rdparty/pdfium/fpdfsdk/pdfsdk_fieldaction.cpp \
    3rdparty/pdfium/core/fdrm/crypto/fx_crypt.cpp \
    3rdparty/pdfium/core/fdrm/crypto/fx_crypt_aes.cpp \
    3rdparty/pdfium/core/fdrm/crypto/fx_crypt_sha.cpp \
    3rdparty/pdfium/core/fpdfdoc/cline.cpp \
    3rdparty/pdfium/core/fpdfdoc/clines.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_aaction.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_action.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_actionfields.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_annot.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_annotlist.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_apsettings.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_bookmark.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_bookmarktree.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_defaultappearance.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_dest.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_docjsactions.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_filespec.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_formcontrol.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_formfield.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_iconfit.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_interform.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_link.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_linklist.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_metadata.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_nametree.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_numbertree.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_occontext.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_pagelabel.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_variabletext.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpdf_viewerpreferences.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpvt_color.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpvt_fontmap.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpvt_generateap.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpvt_sectioninfo.cpp \
    3rdparty/pdfium/core/fpdfdoc/cpvt_wordinfo.cpp \
    3rdparty/pdfium/core/fpdfdoc/csection.cpp \
    3rdparty/pdfium/core/fpdfdoc/ctypeset.cpp \
    3rdparty/pdfium/core/fpdfdoc/doc_tagged.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/CNS1/Adobe-CNS1-UCS2_5.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/CNS1/B5pc-H_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/CNS1/B5pc-V_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/CNS1/CNS-EUC-H_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/CNS1/CNS-EUC-V_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/CNS1/ETen-B5-H_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/CNS1/ETen-B5-V_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/CNS1/ETenms-B5-H_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/CNS1/ETenms-B5-V_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/CNS1/HKscs-B5-H_5.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/CNS1/HKscs-B5-V_5.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/CNS1/UniCNS-UCS2-H_3.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/CNS1/UniCNS-UCS2-V_3.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/CNS1/UniCNS-UTF16-H_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/CNS1/cmaps_cns1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/GB1/Adobe-GB1-UCS2_5.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/GB1/GB-EUC-H_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/GB1/GB-EUC-V_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/GB1/GBK-EUC-H_2.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/GB1/GBK-EUC-V_2.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/GB1/GBK2K-H_5.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/GB1/GBK2K-V_5.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/GB1/GBKp-EUC-H_2.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/GB1/GBKp-EUC-V_2.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/GB1/GBpc-EUC-H_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/GB1/GBpc-EUC-V_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/GB1/UniGB-UCS2-H_4.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/GB1/UniGB-UCS2-V_4.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/GB1/cmaps_gb1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/83pv-RKSJ-H_1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/90ms-RKSJ-H_2.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/90ms-RKSJ-V_2.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/90msp-RKSJ-H_2.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/90msp-RKSJ-V_2.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/90pv-RKSJ-H_1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/Add-RKSJ-H_1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/Add-RKSJ-V_1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/Adobe-Japan1-UCS2_4.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/EUC-H_1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/EUC-V_1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/Ext-RKSJ-H_2.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/Ext-RKSJ-V_2.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/H_1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/UniJIS-UCS2-HW-H_4.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/UniJIS-UCS2-HW-V_4.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/UniJIS-UCS2-H_4.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/UniJIS-UCS2-V_4.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/V_1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Japan1/cmaps_japan1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Korea1/Adobe-Korea1-UCS2_2.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Korea1/KSC-EUC-H_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Korea1/KSC-EUC-V_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Korea1/KSCms-UHC-HW-H_1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Korea1/KSCms-UHC-HW-V_1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Korea1/KSCms-UHC-H_1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Korea1/KSCms-UHC-V_1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Korea1/KSCpc-EUC-H_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Korea1/UniKS-UCS2-H_1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Korea1/UniKS-UCS2-V_1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Korea1/UniKS-UTF16-H_0.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/Korea1/cmaps_korea1.cpp \
    3rdparty/pdfium/core/fpdfapi/cmaps/fpdf_cmaps.cpp \
    3rdparty/pdfium/core/fpdfapi/cpdf_modulemgr.cpp \
    3rdparty/pdfium/core/fpdfapi/cpdf_pagerendercontext.cpp \
    3rdparty/pdfium/core/fpdfapi/edit/cpdf_pagecontentgenerator.cpp \
    3rdparty/pdfium/core/fpdfapi/edit/fpdf_edit_create.cpp \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_cidfont.cpp \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_font.cpp \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_fontencoding.cpp \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_simplefont.cpp \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_truetypefont.cpp \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_type1font.cpp \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_type3char.cpp \
    3rdparty/pdfium/core/fpdfapi/font/cpdf_type3font.cpp \
    3rdparty/pdfium/core/fpdfapi/font/fpdf_font.cpp \
    3rdparty/pdfium/core/fpdfapi/font/fpdf_font_cid.cpp \
    3rdparty/pdfium/core/fpdfapi/font/ttgsubtable.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_allstates.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_clippath.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_color.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_colorspace.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_colorstate.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_contentmark.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_contentmarkitem.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_contentparser.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_docpagedata.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_form.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_formobject.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_generalstate.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_graphicstates.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_image.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_imageobject.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_meshstream.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_page.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_pagemodule.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_pageobject.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_pageobjectholder.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_pageobjectlist.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_path.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_pathobject.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_pattern.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_shadingobject.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_shadingpattern.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_streamcontentparser.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_streamparser.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_textobject.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_textstate.cpp \
    3rdparty/pdfium/core/fpdfapi/page/cpdf_tilingpattern.cpp \
    3rdparty/pdfium/core/fpdfapi/page/fpdf_page_colors.cpp \
    3rdparty/pdfium/core/fpdfapi/page/fpdf_page_func.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cfdf_document.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_array.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_boolean.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_crypto_handler.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_data_avail.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_dictionary.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_document.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_hint_tables.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_indirect_object_holder.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_linearized_header.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_name.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_null.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_number.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_object.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_parser.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_reference.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_security_handler.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_simple_parser.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_stream.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_stream_acc.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_string.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/cpdf_syntax_parser.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/fpdf_parser_decode.cpp \
    3rdparty/pdfium/core/fpdfapi/parser/fpdf_parser_utility.cpp \
    3rdparty/pdfium/core/fpdfapi/render/cpdf_docrenderdata.cpp \
    3rdparty/pdfium/core/fpdfapi/render/cpdf_type3cache.cpp \
    3rdparty/pdfium/core/fpdfapi/render/cpdf_type3glyphs.cpp \
    3rdparty/pdfium/core/fpdfapi/render/fpdf_render.cpp \
    3rdparty/pdfium/core/fpdfapi/render/fpdf_render_cache.cpp \
    3rdparty/pdfium/core/fpdfapi/render/fpdf_render_image.cpp \
    3rdparty/pdfium/core/fpdfapi/render/fpdf_render_loadimage.cpp \
    3rdparty/pdfium/core/fpdfapi/render/fpdf_render_pattern.cpp \
    3rdparty/pdfium/core/fpdfapi/render/fpdf_render_text.cpp \
    3rdparty/pdfium/core/fpdftext/cpdf_linkextract.cpp \
    3rdparty/pdfium/core/fpdftext/cpdf_textpage.cpp \
    3rdparty/pdfium/core/fpdftext/cpdf_textpagefind.cpp \
    3rdparty/pdfium/core/fpdftext/unicodenormalizationdata.cpp \
    3rdparty/pdfium/core/fxcodec/codec/fx_codec.cpp \
    3rdparty/pdfium/core/fxcodec/codec/fx_codec_fax.cpp \
    3rdparty/pdfium/core/fxcodec/codec/fx_codec_flate.cpp \
    3rdparty/pdfium/core/fxcodec/codec/fx_codec_icc.cpp \
    3rdparty/pdfium/core/fxcodec/codec/fx_codec_jbig.cpp \
    3rdparty/pdfium/core/fxcodec/codec/fx_codec_jpeg.cpp \
    3rdparty/pdfium/core/fxcodec/codec/fx_codec_jpx_opj.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_ArithDecoder.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_ArithIntDecoder.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_BitStream.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_Context.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_GrdProc.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_GrrdProc.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_GsidProc.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_HtrdProc.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_HuffmanDecoder.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_HuffmanTable.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_HuffmanTable_Standard.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_Image.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_PatternDict.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_PddProc.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_SddProc.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_Segment.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_SymbolDict.cpp \
    3rdparty/pdfium/core/fxcodec/jbig2/JBig2_TrdProc.cpp \
    3rdparty/pdfium/core/fxcrt/fx_basic_array.cpp \
    3rdparty/pdfium/core/fxcrt/fx_basic_bstring.cpp \
    3rdparty/pdfium/core/fxcrt/fx_basic_buffer.cpp \
    3rdparty/pdfium/core/fxcrt/fx_basic_coords.cpp \
    3rdparty/pdfium/core/fxcrt/fx_basic_gcc.cpp \
    3rdparty/pdfium/core/fxcrt/fx_basic_list.cpp \
    3rdparty/pdfium/core/fxcrt/fx_basic_memmgr.cpp \
    3rdparty/pdfium/core/fxcrt/fx_basic_plex.cpp \
    3rdparty/pdfium/core/fxcrt/fx_basic_utf.cpp \
    3rdparty/pdfium/core/fxcrt/fx_basic_util.cpp \
    3rdparty/pdfium/core/fxcrt/fx_basic_wstring.cpp \
    3rdparty/pdfium/core/fxcrt/fx_bidi.cpp \
    3rdparty/pdfium/core/fxcrt/fx_extension.cpp \
    3rdparty/pdfium/core/fxcrt/fx_ucddata.cpp \
    3rdparty/pdfium/core/fxcrt/fx_unicode.cpp \
    3rdparty/pdfium/core/fxcrt/fx_xml_composer.cpp \
    3rdparty/pdfium/core/fxcrt/fx_xml_parser.cpp \
    3rdparty/pdfium/core/fxcrt/fxcrt_posix.cpp \
    3rdparty/pdfium/core/fxcrt/fxcrt_stream.cpp \
    3rdparty/pdfium/core/fxcrt/fxcrt_windows.cpp \
    3rdparty/pdfium/core/fxge/dib/fx_dib_composite.cpp \
    3rdparty/pdfium/core/fxge/dib/fx_dib_convert.cpp \
    3rdparty/pdfium/core/fxge/dib/fx_dib_engine.cpp \
    3rdparty/pdfium/core/fxge/dib/fx_dib_main.cpp \
    3rdparty/pdfium/core/fxge/dib/fx_dib_transform.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitDingbats.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitFixed.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitFixedBold.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitFixedBoldItalic.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitFixedItalic.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitSans.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitSansBold.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitSansBoldItalic.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitSansItalic.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitSansMM.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitSerif.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitSerifBold.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitSerifBoldItalic.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitSerifItalic.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitSerifMM.cpp \
    3rdparty/pdfium/core/fxge/fontdata/chromefontdata/FoxitSymbol.cpp \
    3rdparty/pdfium/core/fxge/freetype/fx_freetype.cpp \
    3rdparty/pdfium/core/fxge/ge/cfx_cliprgn.cpp \
    3rdparty/pdfium/core/fxge/ge/cfx_facecache.cpp \
    3rdparty/pdfium/core/fxge/ge/cfx_folderfontinfo.cpp \
    3rdparty/pdfium/core/fxge/ge/cfx_font.cpp \
    3rdparty/pdfium/core/fxge/ge/cfx_fontcache.cpp \
    3rdparty/pdfium/core/fxge/ge/cfx_fontmapper.cpp \
    3rdparty/pdfium/core/fxge/ge/cfx_fontmgr.cpp \
    3rdparty/pdfium/core/fxge/ge/cfx_gemodule.cpp \
    3rdparty/pdfium/core/fxge/ge/cfx_graphstate.cpp \
    3rdparty/pdfium/core/fxge/ge/cfx_graphstatedata.cpp \
    3rdparty/pdfium/core/fxge/ge/cfx_pathdata.cpp \
    3rdparty/pdfium/core/fxge/ge/cfx_renderdevice.cpp \
    3rdparty/pdfium/core/fxge/ge/cfx_substfont.cpp \
    3rdparty/pdfium/core/fxge/ge/cfx_unicodeencoding.cpp \
    3rdparty/pdfium/core/fxge/ge/cttfontdesc.cpp \
    3rdparty/pdfium/core/fxge/ge/fx_ge_fontmap.cpp \
    3rdparty/pdfium/core/fxge/ge/fx_ge_linux.cpp \
    3rdparty/pdfium/core/fxge/ge/fx_ge_text.cpp \
    3rdparty/pdfium/core/fxge/ifx_renderdevicedriver.cpp \
    3rdparty/pdfium/core/fxge/agg/fx_agg_driver.cpp \
    3rdparty/pdfium/fpdfsdk/fxedit/fxet_ap.cpp \
    3rdparty/pdfium/fpdfsdk/fxedit/fxet_edit.cpp \
    3rdparty/pdfium/fpdfsdk/fxedit/fxet_list.cpp \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_Button.cpp \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_Caret.cpp \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_ComboBox.cpp \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_Edit.cpp \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_EditCtrl.cpp \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_FontMap.cpp \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_Icon.cpp \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_ListBox.cpp \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_ScrollBar.cpp \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_SpecialButton.cpp \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_Utils.cpp \
    3rdparty/pdfium/fpdfsdk/pdfwindow/PWL_Wnd.cpp \
    3rdparty/pdfium/fpdfsdk/formfiller/cba_fontmap.cpp \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_checkbox.cpp \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_combobox.cpp \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_formfiller.cpp \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_interactiveformfiller.cpp \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_listbox.cpp \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_pushbutton.cpp \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_radiobutton.cpp \
    3rdparty/pdfium/fpdfsdk/formfiller/cffl_textfield.cpp
    
equals(INTERNALBROWSER,yes){
DEFINES += INTERNAL_BROWSER
HEADERS	+= src/browser.h
SOURCES	+= src/browser.cpp
}   

RESOURCES += texmaker.qrc
FORMS   += src/findwidget.ui\
	src/gotolinewidget.ui \
	src/replacewidget.ui \
	src/structdialog.ui \
	src/filechooser.ui \
	src/graphicfilechooser.ui \
	src/tabbingdialog.ui \
	src/arraydialog.ui \
	src/tabdialog.ui \
	src/letterdialog.ui \
	src/addoptiondialog.ui \
	src/quickdocumentdialog.ui \
	src/quickxelatexdialog.ui \
	src/usermenudialog.ui \
	src/usertooldialog.ui \
	src/refdialog.ui \
	src/aboutdialog.ui \
	src/configdialog.ui \
	src/spellerdialog.ui \
	src/keysequencedialog.ui \
	src/userquickdialog.ui \
	src/encodingdialog.ui \
	src/usercompletiondialog.ui \
	src/texdocdialog.ui \
	src/scandialog.ui \
	src/exportdialog.ui \
	src/addtagdialog.ui \
	src/versiondialog.ui \
	src/unicodedialog.ui \
	src/quickbeamerdialog.ui \
	src/x11fontdialog.ui
TRANSLATIONS += translations/texmaker/texmaker_fr.ts \
	translations/texmaker/texmaker_de.ts \
	translations/texmaker/texmaker_es.ts \
	translations/texmaker/texmaker_gl.ts \
	translations/texmaker/texmaker_it.ts \
	translations/texmaker/texmaker_ru.ts \
	translations/texmaker/texmaker_zh_CN.ts \
	translations/texmaker/texmaker_zh_TW.ts \
	translations/texmaker/texmaker_cs.ts \
	translations/texmaker/texmaker_pt.ts \
	translations/texmaker/texmaker_pt_BR.ts \
	translations/texmaker/texmaker_nl.ts  \
	translations/texmaker/texmaker_hu.ts  \
	translations/texmaker/texmaker_fa.ts  \
	translations/texmaker/texmaker_pl.ts  \
	translations/texmaker/texmaker_vi_VN.ts \
	translations/texmaker/texmaker_da.ts \
	translations/texmaker/texmaker_ca.ts \
	translations/texmaker/texmaker_sr.ts \
	translations/texmaker/texmaker_el.ts \
	translations/texmaker/texmaker_se.ts \
	translations/texmaker/texmaker_ar.ts \
	translations/texmaker/texmaker_lv.ts \
	translations/texmaker/texmaker_uk.ts
################################
unix:!macx {
UI_DIR = .ui
MOC_DIR = .moc
OBJECTS_DIR = .obj
isEmpty( PREFIX ) {
    PREFIX=/usr
}
isEmpty( DESKTOPDIR ) {
    DESKTOPDIR=/usr/share/applications
}
isEmpty( ICONDIR ) {
    ICONDIR=/usr/share/pixmaps
}
isEmpty( METAINFODIR ) {
    METAINFODIR=/usr/share/metainfo
}

DEFINES += PREFIX=\\\"$${PREFIX}\\\"
DEFINES +=_FX_CPU_=_FX_X64_
DEFINES += HAVE_UNISTD_H


INCLUDEPATH +=$${QTDIR}/include/
 

equals(AUTHORIZELINUXQSTYLES,yes){
DEFINES += AUTHORIZE_LINUX_QSTYLES
}


target.path = $${PREFIX}/bin
utilities.path = $${PREFIX}/share/texmaker
desktop.path = $${DESKTOPDIR}
icon.path = $${ICONDIR}
metainfo.path = $${METAINFODIR}

#DEFINES += DEBIAN_SPELLDIR

INSTALLS = target
SOURCES	+= 3rdparty/singleapp/qtlockedfile_unix.cpp

utilities.files = datas/doc/doc10.png \
	datas/doc/doc11.png \
	datas/doc/doc12.png \
	datas/doc/doc13.png \
	datas/doc/doc14.png \
	datas/doc/doc15.png \
	datas/doc/doc16.png \
	datas/doc/doc17.png \
	datas/doc/doc1.png \
	datas/doc/doc20.png \
	datas/doc/doc21.png \
	datas/doc/doc22.png \
	datas/doc/doc2.png \
	datas/doc/doc3.png \
	datas/doc/doc4.png \
	datas/doc/doc5.png \
	datas/doc/doc6bis.png \
	datas/doc/doc6.png \
	datas/doc/doc7.png \
	datas/doc/doc8.png \
	datas/doc/doc9.png \
	datas/doc/latexhelp.html \
	datas/doc/usermanual_en.html \
	datas/doc/usermanual_fr.html \
	AUTHORS \
	COPYING \
	datas/CHANGELOG.txt \
	datas/distrib/linux/texmaker16x16.png \
	datas/distrib/linux/texmaker22x22.png \
	datas/distrib/linux/texmaker32x32.png \
	datas/distrib/linux/texmaker48x48.png \
	datas/distrib/linux/texmaker64x64.png \
	datas/distrib/linux/texmaker128x128.png \
	datas/distrib/linux/texmaker.svg \
	datas/scripts/titlecase_selection.tms \
	datas/scripts/hardwordwrap_selection_80col.tms \
	translations/qt/qt_ar.qm \
    translations/qt/qt_ca.qm \
    translations/qt/qt_cs.qm \
    translations/qt/qt_da.qm \
    translations/qt/qt_de.qm \
    translations/qt/qt_en.qm \
    translations/qt/qt_es.qm \
    translations/qt/qt_fa.qm \
    translations/qt/qt_fi.qm \
    translations/qt/qt_fr.qm \
    translations/qt/qt_gl.qm \
    translations/qt/qt_he.qm \
    translations/qt/qt_hu.qm \
    translations/qt/qt_it.qm \
    translations/qt/qt_ja.qm \
    translations/qt/qt_ko.qm \
    translations/qt/qt_lt.qm \
    translations/qt/qt_pl.qm \
    translations/qt/qt_pt.qm \
    translations/qt/qt_ru.qm \
    translations/qt/qt_sk.qm \
    translations/qt/qt_sl.qm \
    translations/qt/qt_sv.qm \
    translations/qt/qt_uk.qm \
    translations/qt/qt_zh_CN.qm \
    translations/qt/qt_zh_TW.qm \
	translations/texmaker/texmaker_de.qm \
	translations/texmaker/texmaker_es.qm \
	translations/texmaker/texmaker_fr.qm \
	translations/texmaker/texmaker_gl.qm \
	translations/texmaker/texmaker_it.qm \
	translations/texmaker/texmaker_pt.qm \
	translations/texmaker/texmaker_pt_BR.qm \
	translations/texmaker/texmaker_ru.qm \
	translations/texmaker/texmaker_zh_CN.qm \
	translations/texmaker/texmaker_zh_TW.qm \
	translations/texmaker/texmaker_cs.qm \
	translations/texmaker/texmaker_nl.qm \
	translations/texmaker/texmaker_fa.qm \
	translations/texmaker/texmaker_pl.qm \
	translations/texmaker/texmaker_hu.qm \
	translations/texmaker/texmaker_sr.qm \
	translations/texmaker/texmaker_el.qm \
	translations/texmaker/texmaker_se.qm \
	translations/texmaker/texmaker_ar.qm \
	translations/texmaker/texmaker_lv.qm \
	translations/texmaker/texmaker_uk.qm \
	translations/texmaker/texmaker_vi_VN.qm \
	datas/dictionaries/nl_NL.aff \
	datas/dictionaries/nl_NL.dic \
	datas/dictionaries/de_DE.aff \
	datas/dictionaries/de_DE.dic \
	datas/dictionaries/en_GB.aff \
	datas/dictionaries/en_GB.dic \
	datas/dictionaries/en_US.aff \
	datas/dictionaries/en_US.dic \
	datas/dictionaries/es_ES.aff \
	datas/dictionaries/es_ES.dic \
	datas/dictionaries/fr_FR.aff \
	datas/dictionaries/fr_FR.dic \
	datas/dictionaries/it_IT.aff \
	datas/dictionaries/it_IT.dic \
	datas/dictionaries/it_IT_README.txt \
	datas/dictionaries/hu_HU.aff \
	datas/dictionaries/hu_HU.dic \
	datas/dictionaries/README_hu_HU.txt \
	datas/dictionaries/cs_CZ.aff \
	datas/dictionaries/cs_CZ.dic \
	datas/dictionaries/pl_PL.aff \
	datas/dictionaries/pl_PL.dic \
	datas/dictionaries/pt_PT.aff \
	datas/dictionaries/pt_PT.dic \
	datas/dictionaries/ca_CA.aff \
	datas/dictionaries/ca_CA.dic \
	datas/dictionaries/README_pt_PT.txt \
	datas/dictionaries/README_pl.txt \
	datas/dictionaries/README_cs_CZ.txt \
	datas/dictionaries/README_de_DE_frami.txt \
	datas/dictionaries/README_DIC_fr_FR.txt \
	datas/dictionaries/README_es_ES.txt \
	datas/dictionaries/README_en_US.txt
INSTALLS += utilities

desktop.files = datas/distrib/linux/texmaker.desktop
INSTALLS += desktop

icon.files = datas/distrib/linux/texmaker.png
INSTALLS += icon

isEmpty(NO_APPDATA) {
metainfo.files = datas/distrib/linux/texmaker.metainfo.xml
INSTALLS += metainfo
}
}
################################
win32 {
UI_DIR = .ui
MOC_DIR = .moc
OBJECTS_DIR = .obj

SOURCES	+= 3rdparty/singleapp/qtlockedfile_win.cpp
SOURCES += \
      3rdparty/pdfium/core/fxge/win32/fx_win32_device.cpp \
      3rdparty/pdfium/core/fxge/win32/fx_win32_dib.cpp \
      3rdparty/pdfium/core/fxge/win32/fx_win32_dwrite.cpp \
      3rdparty/pdfium/core/fxge/win32/fx_win32_gdipext.cpp \
      3rdparty/pdfium/core/fxge/win32/fx_win32_print.cpp

HEADERS += \
    3rdparty/pdfium/core/fxge/win32/dwrite_int.h \
    3rdparty/pdfium/core/fxge/win32/win32_int.h

LIBS_PRIVATE += -ladvapi32 -lgdi32 -luser32 -lshlwapi

RC_FILE = datas/distrib/win/win.rc

equals(COMPILEUSB,no){
target.path = texmakerwin64
utilities.path = texmakerwin64
others.path = texmakerwin64
platforms.path = texmakerwin64\platforms
printsupport.path = texmakerwin64\printsupport
} else {
DEFINES += USB_VERSION
target.path = texmakerwin64usb
utilities.path = texmakerwin64usb
others.path = texmakerwin64usb
platforms.path = texmakerwin64usb\platforms
printsupport.path = texmakerwin64usb\printsupport
}

}
###############################
macx {
UI_DIR = .ui
MOC_DIR = .moc
OBJECTS_DIR = .obj

LIBS_PRIVATE += -framework AppKit -framework CoreFoundation
DEFINES += HAVE_UNISTD_H

QMAKE_MAC_SDK=macosx

#QMAKE_MACOSX_DEPLOYMENT_TARGET = 10.8
target.path = Texmaker


INSTALLS = target
SOURCES	+= 3rdparty/singleapp/qtlockedfile_unix.cpp
SOURCES += \
        3rdparty/pdfium/core/fxge/apple/fx_apple_platform.cpp \
        3rdparty/pdfium/core/fxge/apple/fx_mac_imp.cpp \
        3rdparty/pdfium/core/fxge/apple/fx_quartz_device.cpp
HEADERS += \
        3rdparty/pdfium/core/fxge/apple/apple_int.h

utilities.path = Contents/Resources
utilities.files = datas/distrib/mac/qt_menu.nib \
	datas/distrib/mac/openTerminal.command \
    datas/doc/doc10.png \
	datas/doc/doc11.png \
	datas/doc/doc12.png \
	datas/doc/doc13.png \
	datas/doc/doc14.png \
	datas/doc/doc15.png \
	datas/doc/doc16.png \
	datas/doc/doc17.png \
	datas/doc/doc1.png \
	datas/doc/doc20.png \
	datas/doc/doc21.png \
	datas/doc/doc22.png \
	datas/doc/doc2.png \
	datas/doc/doc3.png \
	datas/doc/doc4.png \
	datas/doc/doc5.png \
	datas/doc/doc6bis.png \
	datas/doc/doc6.png \
	datas/doc/doc7.png \
	datas/doc/doc8.png \
	datas/doc/doc9.png \
	datas/doc/latexhelp.html \
	datas/doc/usermanual_en.html \
	datas/doc/usermanual_fr.html \
	datas/scripts/titlecase_selection.tms \
	datas/scripts/hardwordwrap_selection_80col.tms \
	AUTHORS \
	COPYING \
	datas/CHANGELOG.txt \
	translations/qt/qt_ar.qm \
    translations/qt/qt_ca.qm \
    translations/qt/qt_cs.qm \
    translations/qt/qt_da.qm \
    translations/qt/qt_de.qm \
    translations/qt/qt_en.qm \
    translations/qt/qt_es.qm \
    translations/qt/qt_fa.qm \
    translations/qt/qt_fi.qm \
    translations/qt/qt_fr.qm \
    translations/qt/qt_gl.qm \
    translations/qt/qt_he.qm \
    translations/qt/qt_hu.qm \
    translations/qt/qt_it.qm \
    translations/qt/qt_ja.qm \
    translations/qt/qt_ko.qm \
    translations/qt/qt_lt.qm \
    translations/qt/qt_pl.qm \
    translations/qt/qt_pt.qm \
    translations/qt/qt_ru.qm \
    translations/qt/qt_sk.qm \
    translations/qt/qt_sl.qm \
    translations/qt/qt_sv.qm \
    translations/qt/qt_uk.qm \
    translations/qt/qt_zh_CN.qm \
    translations/qt/qt_zh_TW.qm \
	translations/texmaker/texmaker_de.qm \
	translations/texmaker/texmaker_es.qm \
	translations/texmaker/texmaker_fr.qm \
	translations/texmaker/texmaker_gl.qm \
	translations/texmaker/texmaker_it.qm \
	translations/texmaker/texmaker_pt.qm \
	translations/texmaker/texmaker_pt_BR.qm \
	translations/texmaker/texmaker_ru.qm \
	translations/texmaker/texmaker_zh_CN.qm \
	translations/texmaker/texmaker_zh_TW.qm \
	translations/texmaker/texmaker_cs.qm \
	translations/texmaker/texmaker_nl.qm \
	translations/texmaker/texmaker_fa.qm \
	translations/texmaker/texmaker_pl.qm \
	translations/texmaker/texmaker_hu.qm \
	translations/texmaker/texmaker_sr.qm \
	translations/texmaker/texmaker_el.qm \
	translations/texmaker/texmaker_se.qm \
	translations/texmaker/texmaker_ar.qm \
	translations/texmaker/texmaker_lv.qm \
	translations/texmaker/texmaker_uk.qm \
	translations/texmaker/texmaker_vi_VN.qm \
	datas/dictionaries/nl_NL.aff \
	datas/dictionaries/nl_NL.dic \
	datas/dictionaries/de_DE.aff \
	datas/dictionaries/de_DE.dic \
	datas/dictionaries/en_GB.aff \
	datas/dictionaries/en_GB.dic \
	datas/dictionaries/en_US.aff \
	datas/dictionaries/en_US.dic \
	datas/dictionaries/es_ES.aff \
	datas/dictionaries/es_ES.dic \
	datas/dictionaries/fr_FR.aff \
	datas/dictionaries/fr_FR.dic \
	datas/dictionaries/it_IT.aff \
	datas/dictionaries/it_IT.dic \
	datas/dictionaries/it_IT_README.txt \
	datas/dictionaries/hu_HU.aff \
	datas/dictionaries/hu_HU.dic \
	datas/dictionaries/README_hu_HU.txt \
	datas/dictionaries/cs_CZ.aff \
	datas/dictionaries/cs_CZ.dic \
	datas/dictionaries/pl_PL.aff \
	datas/dictionaries/pl_PL.dic \
	datas/dictionaries/pt_PT.aff \
	datas/dictionaries/pt_PT.dic \
	datas/dictionaries/ca_CA.aff \
	datas/dictionaries/ca_CA.dic \
	datas/dictionaries/README_pt_PT.txt \
	datas/dictionaries/README_pl.txt \
	datas/dictionaries/README_cs_CZ.txt \
	datas/dictionaries/README_de_DE_frami.txt \
	datas/dictionaries/README_DIC_fr_FR.txt \
	datas/dictionaries/README_es_ES.txt \
	datas/dictionaries/README_en_US.txt
QMAKE_BUNDLE_DATA += utilities
INSTALLS += utilities
ICON = datas/distrib/mac/texmaker.icns
QMAKE_INFO_PLIST =datas/distrib/mac/Info.plist
}
