(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     42233,        774]
NotebookOptionsPosition[     41547,        745]
NotebookOutlinePosition[     41892,        760]
CellTagsIndexPosition[     41849,        757]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Authored", " ", "with", " ", "Mathematica", " ", "10.0"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.6458668238795233`*^9, 3.645866848402766*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.6458649024825478`*^9, 3.6458649062577543`*^9}, {
  3.645864952496236*^9, 3.645864978267481*^9}, {3.6458651008604965`*^9, 
  3.6458651068665066`*^9}, {3.6458668165007105`*^9, 3.6458668209779177`*^9}}],

Cell[BoxData["\<\"C:\\\\SVN_HgbThesis_SourceForge\\\\trunk\\\\images\"\>"], \
"Output",
 CellChangeTimes->{3.6458651139489193`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", " ", "=", " ", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], ",", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"7", "/", "3"}], ")"}], "x"}], "]"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"3.5", " ", "Pi"}]}], "}"}], ",", " ", 
    RowBox[{"PlotStyle", " ", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Darker", "[", "Blue", "]"}], ",", " ", "Thick"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Darker", "[", "Green", "]"}], ",", " ", "Dashed", ",", 
         "Thick"}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", " ", 
       RowBox[{"FontSize", " ", "\[Rule]", " ", "11"}]}], "}"}]}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "0.3"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.645865197892667*^9, 3.64586524534795*^9}, {
  3.6458652756276035`*^9, 3.6458652906036296`*^9}, {3.6458654057006316`*^9, 
  3.645865467975941*^9}, {3.645865525337242*^9, 3.6458656151466*^9}, {
  3.6458656880455275`*^9, 3.6458657739548783`*^9}, {3.645865816558553*^9, 
  3.6458658172293544`*^9}, {3.645865859645829*^9, 3.64586586037903*^9}, {
  3.645866008844491*^9, 3.645866041729349*^9}, {3.6458661091682673`*^9, 
  3.6458661379035177`*^9}, {3.645866205794837*^9, 3.645866212830449*^9}, {
  3.645866574918686*^9, 3.6458665896919117`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 
     NCache[
      Rational[2, 3], 0.6666666666666666]], Thickness[Large], Opacity[1.], 
    LineBox[CompressedData["
1:eJwVmnk4lF8bx8k21ixhBikzlFAiS9nOnT2iokRJUlJpoYUWISqlxZr8Itmy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     "]]}, 
   {RGBColor[0, 
     NCache[
      Rational[2, 3], 0.6666666666666666], 0], Thickness[Large], Opacity[1.], 
    Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwUW3k4lG8Xtq/Z9yXGoBRFKSQ8p0IiEiVbkoQiSaKypFREWdIqyVJEpY1Q
eH5RKtn3su+GmXnte3zvN//Mda7nec+5z/qe2zWU3M7anGRjYWEJ4GBh+f+3
ac3dl1YKsUabllbJD4GOijkf/5zqjTSpaiKYlHXLSlXCUoPR0URx8+UVArmW
eN4+UHgdvX3V/qbgH4Gey/hxuabGoObk9F0TSwSa1jcAPeMEdMz+6ZrsBQJJ
noJQKLyHQvwFpbtnCaT30PizmcYjdHrZ9GziFIGcvpvNWac+QVF2mYoVBIHC
pvZvcxB/hiQXH+sFjRGoLv5loZZxGnqs//R35hCBerM2tm5bSUejK3r0Q70E
mix9PaNX+BxNn2N/d7WdQOwtm8UN/TOR7Ktnmzc1E0ic8W7rLo2X6IBVydUj
NQTSkcs/uy/1FarKCpLcgAlktlU31tLxDdJIyL1f94lADvuKXh8Uf4tarJPc
594QqPRL17SG8Xv0PVAvojyJQKY/FDk0lT6g/463UE7FE6i2wVVsy8oHBOMr
2bE3CNRD69uyvTAPBV+mbHH0JZDXjPIu3fv5iDN69x0WNwJNsJy03uH/CT0Z
QgnrDxOITXrY11CjEN3Xsz8xv4NAKqZjr0xSvyDp5ctur/4x0euDGl/2hhYj
C0al0lEGE20/eqZyn2MJ6ukEt4QOJjINIEYsxTFyvqh36VoRE22rXxBVN/6K
9gkGjMeeYaJ5uyTZ1x++IpYZuWRnByYq7tCnblIqQzZ1F5XeGjORyUjwFs2V
MpT6to9vQIaJ7Fb/HdAu/IbaQ9RYHpYykOyNlCN5676j+Y4AsfuZDNTFh45t
v/8dCR8faZaNZSBPyXBfXf8K9N0xaK7UiYEubmK7s1PjJ+LsfMt6YYKOnjhx
Ve5J/Y2euKkvz3PRUXFGnZ2wdBUyCF/uXR4YQx1jSf0dcVWIvj8NB5eNIfkQ
zX8XrlSjwo2Sc/TgMZSSbK/10qUWrdlAH387MorqfQ9b3IytR+2yuPpQDg31
3f2c4FNZj9JiPqY5htPQ5CfFNhuuBlTXpN06dJiGRFdp7ophDaiPn7h7f3UE
2cSFhRWeaUQNr9RW3SxHUNPbrPej+5tRyi5/j8uNQ2igcc18XVQzSnrBy2+e
PoSm584ZFXxrRtF72Uvf+A0hCTD4HWHQgrZZhbNvXzOE7OrqBuQ1WtGVQLbT
R40GUev4gtQB/j9omySZnbh+9HfL/rCPvzoQVz/vm0td3Wh15ebDNNZO9EO6
/BT/mW6kUvX1XdyOTuQ2fCxYdqkL+Xro9ntnd6KLY6e5CiW6EPsTqpnKrS5U
2GUppGrSgSSvLUeZq/QgnVeRi2dj2xCMNdh86e9FAxxCz33b6tDdkitDyW6D
aNdmBacjQZHoo0bode6wQfSxpiBfZvAManpymer/eBB5a6uU1PGew1KXL7js
rRtEfkbJ0wfgHk7W8W6ZMBxCHZu1jqfI5eDMt3YVpjLDSP5m140r/4pxUdqm
zPHaEXTtqJaz7M4a/FdY3dhpbATtsWNuitCuxctX1Pq+c9GQ5/mlzAKJOmzk
oqzwxJCGxLa2rPasqcdlsjIPTF7RUGK2R+bkXAOuSuS4mXRzFI0csOfxwC24
50b7SWNDOrq7LlE6gKsLPzqpPMjqREdcPZ+VSsO7sLWJtzu+SEd/R12KLi52
4a8cS276eXTUb8L2QofejdMjZF211BnI4ZFYqcVAD3a/6uAoT9Y1Byvf5Yj3
fVj+eNqfPzpMlONH/5NN68NNQLN/eIiJGuNt9wUp9WMTlktHROOZ6OHBV0bs
8f143ZVHh3i4CeQnOq9X7jWAR0JaraanCXQ6jec7F88Qts4VGrbnHUefron/
Xac/hDVSPmbqSo+jgfZIry7vITwQuqQ6s30cud0/vl+4ZggfNoxR8TtH3mf3
lfa4M4x1inOUPEbG0dILWpLU3AgWfW3Vazw3jji3fOExpdIw88lkqjLXBCp8
km68sp+GM4P1Kb3KE0h+zoqTN42GpXZWKjgfm0AndiXs9N8ziueLaHI2LRPo
9wcHd8JvDMuK76nbOjCBKP0S/dx3x/BO3+TrYpMTqI+1PuDthzEcRj3AaBKY
RHzV4sXZk2OYPSav9IjJJKpbSX9lcIaOVQYFzuvZTiJNgbhIHE3Hpshzvczx
SeSg+zW4OouOo6Zk4v+GTCIn8aaGqB46FnS+cvxo3iT6UWSe67efgbU+tUkY
lU2iQ68m3yMPBj4ovLVSoW4SVck2mj+4wsD3vg1s7RmbRFMBfM/a3jGwzCZz
jhPKU+h4+q2JTAEm1o/MKNyzZQoJdha9z1JmYufeZR8VNIXYgu1XNXYwccr9
t82DjlOo64XJQLkbE6usiGd53Z1CL5+1vpF5x8Sm9r5O+1Kn0MJK1vPtZUzs
+eGH0MbcKaRgcflZYyMT53hcvjj2awqVSUVduzfDxL//a9Soap1CHUcjej5x
Epguu6n39eAUMrZh2+woQWDN2u59vqzTiH2r62OqNoGtN+xYsRKaRvMGuw33
7iKwf8TdD5prp5HShncdY1YEztM1kZvQm0a5CgVaeV4EbklIqa03nUah7fnB
rQEEnhubi/hwaBp1xAsQl8IJrJ+aQz/vN408n+rf3fmAwE6L7GmHwqbRnz1T
Xo6pBA45dPTw9tvT6DSzKn8um8ApuZ94JZOm0UkXj4NiHwmMeYRLZ7OmkWr0
Ock3Xwjc43bKvzV/Go1sz+v9Vk5gtpKydYXl00j8Os9dx98ENj53Ie5S9zTa
FFuwfrWNwB6/a/Y4MqbJftnSLNBN4EhVtXn9pWm04LU493iAwC+vXH0txzuD
NHmdLmXQCFz556/rsuQMitry3ngjk8Bj2tskOlVmkHKi/97NkwReE3vnV8nW
GXTwtsa5tzME3jwyFJoCM2jS+/rHN/MEPrAbtl6xmkEGr3XZNiwRuLjJ6Mit
ozNIpTY0yeQfgdU8DUMSfUj9RiXWP1cIfH9hZ9rT4Bm0WPh+7ftV0p/b+hVZ
0TOo0GVpmdxf8FmFHWPvH8+gTxUKjDxS7ninK1z8cgZ947xB1JLP79ujs72i
YAZ9zQrmOUjq/9S8zbGuYgaNJm1DeqR9ZS/tK3+bSTwCFU9vkPjiF7c8HxiY
QeM7N27ZQeL/d1vrF3NqBglsR7y2EwQ+rajJnGebReIxFXqNdAK3vt8kxi46
i74tujcXDZPxNdbQE1CaRazs6XNcfQR+17LxqJTWLPkeG/78uZ3Aa09tuKaE
ZlF4fbhhcxOBo5fWZ6lbzaLe6aRUu2oCz95ZV7X96Cwq2bGHB30n8AmK6gTy
mUUuox5PYosJXPdBWdI8eBYdudIQYULm39CEuvNQ9CzyatFiniDrI6eV4ury
eBZlO/HxjaYQ+Pry2hz/AhLPagp1cxSBJ2Lla0MqZtFm30+36cEEdlGSm77Z
PIsyn61eEztLYD1TaaMnU7OI6/F2wWRbMr9xog3lmnOoNMRH/BnZD/ZUkblq
ozkUYm+/K5uDwN/yhOTbLOeQLoe6nsIU2Z9/1njQvedQ2sWe1n01TGyjzL0o
/nIO/a51rHwfysQ4n1NRsWAO8fqlrJX3YmINMw7jDRVz6P7rTvXpg0zMdYY1
1nBgDtHaXdYRZP8XfVpS8qDMo3Tv3mH5rwy8bt+iqZ/mPPqCNxxizWLgu+3z
3peN5lHEqL38kdsM7MMymx/rPI8kBDW+2R9mYIr5+L6CR/Oo6AuTUk7Oq8jO
gXM8IgtI4qTrhg+dY9ggIPFYleIC8i6+8yXhyxge59ttGb95AWXHzReMPxrD
9nrP1KT3LyDpKIkATZsxrJbo0L0+cgEN3QmULSsdxZVmNfv3/ltAL7MXHzWF
03BYd4g+/5pFRPF0FFyyo+GtgepqtbKL6MqxfVyvNWj4SUYU+xG9RXRXNyX+
XcsI9lnZ/dnj/CKichjyOKqOYMG8gvU3aYvIQekA7+CbIVxm7iFhPr+ILqeF
KYmHDuHAXnF2Qe4lpLA1bPqvxRDuFvTvuq+yhOZjPx3VHhnE705p3H9xbAm9
sAt+qSY/iA8qprF9b15CC5PqJ2fP9eN70dGd7GXLyEY12oW9sBvHxjDxr9pl
dLXYwmqtWTeOvG2THte5jOp2zfIVtXbhy7GynnILy8hF/RVb6Ewndr2bM75V
6x/6anjon5d6B1ZPqmR3S/mHPkgvFHpea8Nl2Xwb/7u8gt5k/Dy2ZrQOX3Q3
2VkqwwLj46o/eX7FY1nWyoHtSixgz1b6sFM1HJc8tYp9o8YCw5R9WZqnjRFb
65HeZF0W0DH6mvVM6C66ve90ZPBhFrhf9jgv8FwOSt0c16iXwALRdpd91twr
RT/m27w/8rDCB97X6ce31qHT949KqAuzgvHrnOsSRXVozda+0nQpVsD/skUv
o3pk7T0mcncdKyyKKhlZWDSgv53/CvyMWeFRYtblny5NiFlG5dgczgoiq/Vu
vOfbkOQdn+SXc6yw6akd16RiD2rvsoC0FVawDPIcY7fvQala6gOPOdng0otO
o4a4HrSxiaYeI8YGX/fpP0xd6UFIzvPLGU02CKraIj3W1ou8so//3erJBouV
btfOX+lHm5YgTN2XDYpMvN70fehHk/spVJULbJDTKerFMtSPQsa7TklEsIF9
jQsYWwygeF3nhbkUNmBxU8trERlERd/tpEta2CCQDxgBsUMoTEqnOL+TDWbv
W7KfKR5CxqckXHMH2MBJKESWe3QI1axpyno2yQaTVZlOCsbDqM/2oO41QXbI
6wwY+zY1jPj6LOz2mrIDGE2EHwYaqtVWX0SW7PBdKaBA2ouG7t3gS9E7xA7v
LmcN+MfRkMKGX4Mb3NhBzVokidZBQ9p+phfWhLHDVa+3IrX+o8h5Be7V57OD
fm3Y7PStMWRic1E+q5gdWidvX9LPGUObM98+Dylnh77lRhHRyjG0aqmQv76e
HUIO5N+6wENH6U+XmkPp7GDxqEyDJZyOYia2uthOsYP21vf9P5PpKMDk9JDa
IjusiFPpikV0ZMJom23k5gDax1GtoHE6GjH4JLVRmQPYQ02zSx0YqD6e8Wx1
AwdUdq5fZfgz0OcBFbVmLQ6I7vlk+zKGgWJuJ+qFG3GAYsGHc8VfGGhzh59D
iwMHZBZbbreXZCIprZe9r1w54MM9ObVmdSZiud596qonB5zWm9D/C0xUr251
WeMCB6SrXgsIPsVEAcHqT67Fc8Ch4eRokXwmOlrrpmz/kAO2HxD4VlFB8jnl
pFebUjhAemE4n7WN1P+bp7jtFQeE32J84F4g9SuCce4HDrjv36/fwEOgEf+g
qogiDpB83R6gJE2gz7JDHZt/cECg+lkBy+0EyvBde5KjhgOOR6vMq+0h0O2y
Q4w/TRxgrSf6Jsqa5Puny/9d7+OAbq2F9IZTJL8tXbzhSOOAzf4XrxRfINBm
0a2CWuMcIHHF8OiGqwRi+Zyq0P6PA0piZr1iHhCIJtCW+Y6DE3JsZnaFpxKo
4biQ5k1+TpD+bu1P7ifoc75pgZMoJ3zQPNM0/oHEwxuGtshwwvWCdGOfLySe
o/k/uCic8HDYMO1UOYEC3tMPdKzjhG6d8MqRShKPg5Nr5DZO8H74W8CnjUCa
b+6OOO/kBMfLKpNnuwgkzVrpt3U3J6yf+aY700/iO8y6wL2PE4L6Sn4ujZD4
Xupd7TzACQVRUgkRDBLf8lnej3accJlWH3Z7gsRnnZUQdZQTJnkGr0rOkPie
d8m4uHPC2027bivNk/jmJdK1vTnBT7o24c0igZJGnvU99eeEvzxr9/cuEyi7
bYMyz2VO8L+PvK6sEKjw58cT/ldJ/2pfdEWuEqii0PB5RxQnLHy5nLNIyk0v
fwyYxnPCzKkXv1pJuf/RQdX3Dzkhe/mngSIpT0a1n5R7xgnWL4256/+R/lw6
mXkjkxPOpWtrMpYIJHiKGCLecMJ+zjMl5xcItNbh0nrHfE64mhlR4j5LII19
7F7fijmB6Plu+N8kgfR33Hm5+Rsn/DpoeOAmk0BmG6Roj35zQl9ULmcBjUBH
ZNI2sDdygtHrR0E2AwTy4FU/feYvJzQLbi+1J+MbsJCX09rLCfc/B878aiXQ
NZrR2C4aJ7xi8Bpk1hEo4c9P9dfjnMAfY/uR8ZNAqb9sfCTnOQGF+V1J/Y9A
uUUdr8NXyXiLbv9RWkCg4mwPxigXFywZaOSZ5RLo9+PxTYcFuQD/feBv9Jys
50scbzes5QK16zZU31gCzZ6KJRJVuMDM/NWll9cIxOkorbWizgWn5W74Hggk
EFVf432DPhfsNT0nO+BEIOdF24/B9lywfej8BU0KydNGO6cGj3FBg6p+arMQ
gS799dxm7ckFKQqJV0dXmOjB5+B8lUAu+FSjnnW8nYnqLmcUVCdyQZUlqoq9
w0RdpzfN6z7hAn7/XcMfLzIRw7FALz2dC3r2fAk2P8FEfDt/FwW+5wL3h2bP
q0leabw0+UWxlgtqQzRjdFsZyGYsZPlWCxcomvLPTZUw0PF2LsPpTi6wyu0w
UX3OQGFfZEt/0rngfiU+N+LLQIXBu/87x8cNrkFhzSv/6GjTcsK3chNu2FjC
dq+PjY5c0gJXc/dzQ5RPTL9f/xiKN3XST7LlhsGPXGl3ysfQZLzKO7/j3BDJ
FDwbcG0MfVIteLI2lBs0jQ2XOZdGETrQ4R+Uxw2bt/dUfmylIb/p/964feEG
2jPdwlPvaSj98YsRyzJuUGfu5iiIpiGOAV8XlTpu+PbikpasAQ39vMhqXj/G
DVrnU0PFk0bQwfR1SurKPNAPVXbee4bRtb38zpIbeUCf5p40IDmM8ujEA9Yt
PPBkdr5llTaEJHWL1rQZ8QCto1VKMW4I/f1tMX/dkQdeHN4vLtE8iE7M+NV2
JfDA/rv5t29aD6ALZl9C77Lwwozh9ih2/l5UdWvST5SHF+ZdTV2Ta3sQ9fcG
97tCvPA1WvLnQGIPqrN8ZH5XgRfMnrjjKLkepGF7QequAS/ErLdovGTVhQaO
ar5PuMgL7pmxlm/d/iKb8xkD8eO8cNaq9sC+LQ1oc0qMRVwPHxx3IVodrGPR
y15ZZfowHzR/eMxrYXIZKavmLJoRfJB5/fb1TZtcsfTrn9lsK3wwqvqDxVY7
EbN95uQJlOOH7gohzRffcnBr85Vvznb8wFahVr7nSikOFwgw3FjFD2psYkd5
herwojW7RGQjP/TFHhRlJtbhC/fu0vv/8sOTF18O3ZSux6fl3j95SuOHpL6s
6R+UBnxoA3NBmHsNjEQMyFluasJqJl6f5natgUiHx4rW29pwfYiz5veCNdD6
+cBR5dFu7HvBlDWjdA0IndA8F6bRg9f4ajWGf18DB6VeHco50YNNj3EEGTSu
gU8Rx/kM6nvw512vSz8y10CU8ykjzexe/Jxr2TJdVQBelglUPLLox7tWBxXD
NQTgW3aIzt2wftw1VztxVFsAVGoPBBq+78fStIz7MrsEwPVvoF6mxAC+89ui
M95ZAP6YirTn/B3AgfFPfK4kCsDJ/j2BzYeGsNitG0ZHkwRAS6vZPe7aEH53
9azwzjQBMP7qy0e8HcJj/nvyZnMF4Mcd7efJvMPY9fDY0plKARDTrbj+tHAY
75PdGePMKgiPdDndUzhoeEhU9ag+jyC4yCdlHif36+v8QprSQoIQtuvaBLal
4dLlvoZGeUFwNDTbaJFG7uPd0bIWeoKwp1Z3b4zuKJZ//jd7x1lBsBWYv65l
PYa79aS2vQ4UhJ99y87rA8ZwerVtqUKYIGwMNXmd/JDc/+eqGtjvCEL3mUYJ
FpI/bDPHS9U5ggAVe1wfHafjua6lG/BBEIq+qW46d5WOP5/XE/5YJAjOBoWX
y1PpGJ6+V3n0UxAGf++zaOikY4vxDEu3IUFwd03efusgAwve6GltYgjCLTGd
0wpnGLhOZq3b3hlBsHkV8UMtioHt9jwI1OAQAlrSBZYnxQzs9iDq2aySEJgc
TZcZUWBiVfXvG05tEIJrBENTRoeJRzBrXruWEJjmZX7+sp+JfWmXf/6HhOBQ
aP1124tMfNngzET0USG4Ua44UPaTiQ3rs4P/uQtBwYn4iIB2JmbxGOL08xGC
6qidMfcYTHwz7pjs4WAh6NjRdUVBmOTXKsnPf1wTAivu7l+RFJL/F7Vt1o8W
grBOTR0XLQLf7Tu4R/GxEBwMj7c8aEXgw0Gx1QmpQuT72tr7jDOBpdf8PsLx
UgjUxb7Hz5wicMp2Yx/aJyG4Lak0axZB4OOV4bNOpULwJjS6VCyOwCrHSsJr
vgvBGuE3z/YlETg7Suf+xyYhGKvY1z6TS2CftecV13UIkf2wo8m7kMCbP7zN
ftQvBOImddT9X0n+a0rX5h8TAntejacPfhE4r12tNHRSCM4mbZa3qCdwkN9J
s/EFIfi9NTT4VBuBn7IdPPWeRRikXa8+nugi8Mr+s7mnOYQhO+3Ukf4BArs+
vDOlzCMMtIUNj41GCVzW+0qvk18YcvxDTNgJAitrVIY+EBIGj3u9JlumSD4e
OFJ2QEwYfOpSb/6cJfDQf1w8vFLCMND5c/bnAoHN+FUty2SFoYxXK2rrMunf
4T13gxWE4cmlAE3OFQLzpR5v3UYVBvvjy/2wSvo7ekWeqSoMv9Vnnw2S8rG4
312eG4SBo/DJ+jlSttkmldarIQx1Y8LrbpCy8R+3E05awlDusfFpHKlPNyxX
tVlbGHjP/omX/EfgjcqLw1a6wqDVq84tu0Rg+Z8mOT/1hcFMaj9P0jyBhc4k
+Ow2EgaLH+EpD2YIzCbaubl4lzCMtmm0CE0SeOaT2sR2E2FI3lpbwskk8IhT
wMe3ZqT+MDaPizQC/2X578KG/SSe/pBeTzJ+1S/49TIOCMPtUiGTJjK+/5kf
WZS3Jf0zycoqIeP/gUgvfmAnDLc2mVNVGgj8aIf+ruijwvB22arGq5zAMV03
2DmOC8OZZSODvV8IHBZR/z3UXRj0HxzemfGBwCeqvczPeQtDrCAltOkZge38
89aM+QpDxgpVIOc+GW8pllp3f2FY50v7+S+arJfjD23tLwnDkeaDFygBBFbi
6pdoCBEG2yWinPAksPirzW0W4cIwc9ls0dCJwAvT351RpDDoRE6NHwECf4ua
PrnuPvm8q79hFAeBCzaBWuojYYiUTpo8NM3EOQ0xozLJwqAmnns6vZ+J4+SV
zwpkCENS4+bC//5jYsd3By9OvxOGl3LRlaIXmNjy8FN93zxhOHkyL5rhysSw
OLI8XCAMlR0fvC3IflY1Dr/aXioMy5pnBhOUmHi8NTe6rEoY5veYh9hWMHB/
yOJ+gzphWDsdsGCdy8AtSqZCnxqF4ZFFxoWm+wz8xbszMfsvaU86adX3BAPf
XOV/Gj8iDNoxLS3/5ul47fpTb104RGBDjWPlgAAdU2W7qqk8IkBsC+6vHSPn
oYAtfYhfBNbZ7Nu57Rc5D6cMNpwVE4GK6Lsm3tfGsDkWzrhCFQEBrP3yBXMU
XzxS+CAVRGDtUlnXaC4Nh5lvync3FgEDR+eUkus0HGGY3qhmJgLpr1W2SzjS
cKzybeH3B0Tggac41Y6dhl8Qx6K/uojAGdZwQR3rEdwQyR3WFyIC0dUHtm1u
GsJtl0OSM8NFQOTVqdaP6UO488zE59PXRcA95vXOKr8hPGLbPjcZIwJjt6gC
RfxDeFXx7Tn2JyLQquj46qnBINYotDupUiQC3h46HH4x/Thy5MV+jxkRqDvf
ZMD9qxundJh2Si+IQPLBvmiGdTf+VDd85veyCOz8rrxhd1sXHijcEKfFIQo1
q0cU0GAn3n3rTf2iqCgUnxqb+j7fjlc25NvFaYnCn6wvsavcbTjQ+5trobco
qAS6GOXm1mIPZl8AX58oKC/dlL4/k4iEDN9fCx0Uhb/KKo8vsiajwpgr8eMj
ouA1zO50gSsd8W6Qf91CiEJA45jRsnAOen3icH/6P1Ew5ecrMRfOR5NtPw7u
lBGDLQnmU8TNMnSl/PVmH2sxiN3qlKFErUdqosEG3bZioN0bkiOaUo/qXPeZ
2xwRg2CzXUeLZRoQdWXwpJ6LGLRg+ektwo2oQk/xKYePGNytzfY9u9CE1uQm
8D+NFIPmtccErn9pQ48eBY5Ul4qBhtc9ycHxbnRou69NTJkY3Iyh6/3e1oOE
G04Wm1WIgcf9zm8tfj0okv9wfHm1GExMsLOxjfSgwDBtvaIOMRi/cEojuqEX
2bqPRz5fFANeauP6sw/7kSDryMTxFTEo2tEgfb6mH1U+7XZSZBOHDXJPv0tz
DqDdrTWaSbziEDjKZmxybgBpmb9pjZMWB48Ppg1cJoNIUOv0+mAdcYgsS9a1
+TOEKquOJ+jpi8PZoPDlJd5hdOOUw9KMoTiY7k2X1dMfRsvpZrV+JuIQjr1q
TjweRmMS64M8DolDqn/4ZT+bEfRzqb/ioL84sCgcE07LpaHrj8i3baA4MGNs
TvG20RBsb0yquiQOGr+5y2ZZRlGBb5nv3qvi8JS969TRg6MoszdV0jBeHDKV
h1pM6KMo4sdRD7Vccbikd49lkJeO6kqvWWa+F4dvt/3cxDfQkfynrG0q+eKQ
/iKZWbOXjj49n2CjFIvDqHLzrf4IOhq9euOZVKU4CBnttwmdpSPdSzk371eL
w7+suSvzIgx03a/2jFi9OLgE5IssaTCQwjEZA6E2cRDRV8y4d5zkLwZv2riG
xGHHmbECge8M9Ey7AV+niUNlcMXWwg4Gom+cy2RjkPrW3vg5NMVAN2V2XViZ
Egf1kfnvNRQm+jzbJDLLKgHl50fZ/gtgIm7mwvx5TglQchDYdTWKiQ4NKvRM
8EjAbKVTffkTJmI2euUyhCRAJX8k5/d/TER9v2w+uFYC2rpNubo4CHT2pdLW
E0oScJJ9KiZNnOSTz0xlelUk4HKAj8KAMoHsYuOHO9QlIPTKM99BIPn8jfwa
R00JGN/LlpdhRaDxkL/5bVslQDv3pkQPyRejvVWuN+2QgCOcXrYNAQRqddvn
bWMoAQHKJj8jwwmk4uhrUwcSgIZNoj/HEKjUrJBStVcCto8uGD5MJRA/dHKb
W0jAAXXFP5BDIHtdNuKHlQRIhVqKe34k+bzq/pLywxIwYC/crPaNQGjtuee7
HCSgZqOixLffBLot/iAGO0vAsxKN0+0NBPrD/8Xf0FUCEs5Xf/L9Q6B17D0O
X05IwMZLRd2h3QQ6v8ixa4enBJzWqf7NM0ig/yY2qBWclgDJAl53oVECCdCs
hLb7SoAq3/3EBJLvO/acn/1wjsT/6PPeuEkCZbU+6tS6QPp7buwszyyBpmtK
vuVelIDjCaX/lucJtKui75VGiATIy08M+CwRKLaEOzHnigTQ4zzk7P8RqD1P
47JahAQ0EmqPS1cIpPb64PHMmxJwYcDLPnWVQAEZgWYq0WR8m0IP/yPlr0lP
NNPvSIDT5GBsMylTEulRggkSELS36u0mUg6LMey7fE8Csk+y6XOR+jojYncO
P5SA5QvUrceWCWQQ0n3P9okECNmWp+gtEuhJgBYTp0jAb9+LUXfnCLToc3Wv
Rjpp7139gs80gRxONqQ+eiEBe/Y5rf4YJ1DhUeVFjmwS//WnWRl0AknZBdie
ey0BlDvy7CwjBAq0+v66860ETKjZq3T2EajJVJLL/KMEtPj/VtzZSSBt5Hns
0yfy/CadX7aVQHd1CwupnyUgfoMG6+U6sp40eUXjSiTg/ckZGadfBMqlvPrm
+U0Cqgreb0grIvMhs7y26YcEvDzleIzrPYF8RCyD4LcEFE7ObmdkEWgDG7FB
pkECOH2VHOAegaIWUcSNZgmYl1SZfn2LQEOT8R0TbaT+32zVT8II9Lx/a1xl
twT8d7pmlMWTQOwdESM6/RJw6XH7nSBHArk1Ne3KGJIAj0F29XOWZLy/B04H
MySg8skRVeYWMn6Znx02LUmA7tdHuyVmmGgxhf/j4xUJyD19oj57gInsHzqv
4WKThPKrPFrljUwkGbVS2sUjCbHZLj433jHR3VO7VeIlJYG/9VnhAXcmmjie
GLosIwny39XjRa2ZyNpxoMVrLXnuIBHlvJOJBCxu3tqlIgmcV/RVI4WZKEqj
kjm5RRJeT+olQj4DDavImR3bLgkK0kNdJk8ZyHStT9pvPUkYiqKJNV9nIHZB
wUPPkSSUPHv69a4NA4URB4sOW0rC/emCvQ9G6OjChz8RhV6S0GWZWCW/OoaG
5m13nPUhz9VFdc06x5A9qmGq+kmCv8qpzvHPY8igqswhMUgS5D5kuRcHjCG2
oVeavjclYdvP+ESrvlEULxPWrvxcEnb7FFTPv6AhNtf5+L9ZkpAIPBlmITQU
kOlvmvBKEp5Zb+mi2NDQEW3P9ysfJGGiLfbZmeURpGBpHfnnqyRsEdhxOdZi
BL0Kp2rHdUtCh1dQ94umIST/I3nEpF8SxtacCurMGEKxAlIpy0OSUCmZXpvj
P4T8k/h5TzNJPIbHXfiEhpBe3nSX8T9JCCm/lTu7exBVDFdEL8pKQUZiwuqR
R/2o18q776SdFDjunrigx9KDBghRiU4HKVhzf7FKOb4bDcd/3nvoqBTcVLn0
9rBiN2I08L7Z7S4Fj9/+yDU06EILdi+DFP2l4PnRxKsH/TqQyLHBNX/uSEFY
8hrRdeVtaNfZY7r7v0uB6X+9Gyop9Sgtzvb21m3SMNO+zW8y+y76FKYiN60r
Df+xb1wSrY5AVWdmsvN3SoMF60ddYU0bNG/x8IfeHmlQ91rduc49HlvztLMh
G2m4+HcHS86nbLwa7nbJwk8aIjTLFosOluKj/uc83F9Lw5evM7vXa9Zh/+O7
Z1TfSYPehPjJV5/qcJS12PXhj9LwiqPIvNuwHudtzk87/UUaGlbbDfdbNOA1
Y/MdfpXSkJy1feP08Sb85US4beiINJQNFwlahrRhmcNx8EBFBuzjQmr5NvZg
MLm9y1RNBtatr0aWJ3uw1/Zbu2fVZSDY2LBxT2oPLpSIMLbTlgHxdQ+U9kn0
YruWQDPJ3TJQtr2u88FSL753xMX6wTEZ6K87mneksB8X73U6aHpCBrQshdOO
MfvxgK69zayHDFzlpBzmVxnA2tI2h+x8ZSDO9522eewAbmgzsZcMlYGWooNr
LFwGsbDjJtcHSTLAU/NnOWpsCOuZbzxumiIDy5D33VluGLvqr3ebTZOBHdX6
z7+bD+O3skrudtkyYK5YqWP7chhbtYt7SRbKwCOw1TR1GcExzstnHzTLAAz4
Tjbn0fCH/Qt+pn9k4DjjauqjThr+azB7brZDBowtrqf2c47ijWvHz9sNyIDS
1YpcocOj+Gdnf5DklAxwlw1ueM0YxVzHfl95ICwLNyvDpY9x0zHOnvnHJS4L
2tUfKynr6PjitGJIkJQsILf/Np0zpuPRWwEX7RVkYcRJilJ8hY5r8taek9WQ
hRONm2sY43QcubqXiNaUBRb1bWLSaxgYzP3PLG2Vhbiu497V6xj4Q3fFqY4d
suDLzZHd6sjAD/j83FL2ysId3Y/8x0oY+MDhpB5BC1ngMAiKa2liYJ7Uby5X
rGThmJbtSvMYA1/eLuPkelgW/CfGNLylmdjFtcyWekIWOG03qQ56M7HUK3r9
XQ/y/LXg/rtXmLhuRtKa/bQs8MH33G93mXh3jPf+AT9Z2C11a7qggInXfRI3
yQyTBZ2lsci6JSbuZkHlktdkYdej4JvP+Ek+anFqV+QNEn+Twp0JWZKf95YY
et2WBWLdaMlaPQKXq498aYuTBdj63H/OhMAhgaL6+xJlYfnZQ2NbWwIz+T11
NibJgsBJQe94HwJn2SXkJT2VhU7XBYdzFwnsmvZlK3+aLAilMZMaIwjcoCOs
Sc+ShRdir47KPSb571X9N86vZOGh2q9bLBkkv69yV6/OlYWaZ6nOHq8J/Ol4
0frcfFn4r039+McSAp993f9CoUgW3uzdaZn0ncBqcwIqccWy8CCm+BBrNYF7
d+mlr2JZYLvS7zDSSOCk224Uv3JZ8DMehgN/CWzbejulp0IWNn9iG9/eQ+A1
1AL5g5WyIFsTcCB5kMDffXqTvlbLgi7n1X3XRkk+XsAvs7WerJdXZyuHmQTW
ZdN5mN4kS/ZT7H9VkwQe3+8qIdZG+hupKb9llsDZD6MTI9ploUPrda34AoHd
+vJEprtk4UyGW23QEoHlNnXHuffJgrt7gYjjPwI3BfEKNg/KgucWibgvKwSO
LdO+bUKThUBFxq7kVQLvFXDh+0SXBfP3n9Ytk7Jo5vsBv3FZ6O42jG0g5S4j
Tqw+LQvrgkQui6z+//cT9o+H5mShPLScUUjqD/R7fT5tSRaKuT4SP0n7u3lZ
rJxXZcFSbM2tXSQ+wXRbNSl2OQjz/PGdSuL/q5/F1sAlB0EHc/J8SP8yGxc7
bvPJQcIJU09F0n9/H6uCvYJysFlpYUKfRmAjzvQENlE5sE4Z88b9ZP2kzHiX
SMjBhIgo8bqTwC06+0wvysiBupP6I/ZWAqfXJlO018qB4qX/bpbXEtjXa3yR
QZGD9zPKnfQfBOZKevj2hJoc9PLftg/5RNbL1rFbChpy8CtQsa6PrIeU30bu
fzTlgN/56aGP6QTW+TcofUBXDpqPLO9NvE1gtgc7pnh3yoFwRZJiRjiBazbf
qf5mJAc6vsnNawMIfNJ12zV9Uzk4J5hWdciBwFoLkc4z++SAa8TvtogFgZcT
2nXeWcqBscdONX0DAt8rvzamelgOxLquC9XJE/jbuvpDIu5ywKIiPy/ZysTx
WEWzylMOXll86db/xsTO9hd5I73lwK07U6n6HRNP31IsXfaXg0XG/DqjKCZW
ZpxZP3JVDn6XviOcydWQeeMra8YNOdgyP2m1Qvb7ZwWJjqO35KD2j5K2CCsT
21gXxzfGywHHwMzBO7UMfO0j32LpMxKf59DE2EkGttrv0nQpQw6GeYJ915kz
sOzg+9xtWXKgy66xp2UTOY8kHU7k5MoB6rsr9GiKjnsvZVXdLyHz/QmHfrxI
xwDGz3za5WD5n7tu1akx/FT7++xwlxwYqhCBa8zG8OI6U6sTfXJg6qOj0aE6
hvMFzP450ORAP4S+SaOHnL/tFk575+RgRlzcJ+XAKBYLtJWiisnDqdsRcday
NDz0yi2u1VweLiRRG06fGMJ7nvUP2VjJg+8unqyqbUM49a67Uc1BeTArN+5t
4BzCTpc8GN/s5eFDpkNsbeYgrjM9bfHBQx6sCo7ZPxsYwJ97z3HfuSYP/hGD
hfus+/EdqatXdn+WB8m1h4Y127vxMv/mfa9L5EEgCfq8fbqxD0u7qORXebC3
GTZX/9eFzWnbMmk/5MHmzRmLnWu7MNeXkar4ZnmQHn9dXHekA4e5WMt2j8vD
zQ98f5wL27DvC8X84PVr4Vhc+Osc7Xp8QLt0NO/eWnA59yM2qOohrrtwT/jU
o7WgcY69XfBgLLYpPK2zNnkteIQe1NgtchnbGUpdu5GxFmJcP+5LjbqBXPb6
ydh9WAuXbm0fWXiZiXydqGZztWuBTT7Iqye2GN2OuPliB78C7OIty+4zqUWC
Fc6/GYIKcOXlVZ1etToUz6M9kSaqAOY8p3Ju5Nahe3e6DfhkFSDLcFdMX2E9
evJQr+mvGnl+OMrm5a9GlPNqlC3EVAEyheT3mv9pRb8arVxLryqA77a6zJDU
btThZ8OufUMBNkZJi2zl6UHjAnaZWVEKsM5HPmcA9SBJs6P0+DgFOPVxcPBa
bg9yK/a+eOKpAhgLe3HFRPWi5edR8TxFCtDz8O4TXs1+JLT7tnZosQKENR93
jnDrR9TuuJYJrABpDoP2uff70T6Zh/LtFQpQ3Z9ZIb7Ujx7cefHyTZMCuH9r
4RYoG0BagWX/2YwrQCDtMc8yGkJ7xCpO/JhSgH/vE2gbfYeQ3btfXAZzCpDy
GTJXngyh0NG6/aorCrB60e13wuwQqnTpbpvjV4Q5DZtym6xh5L53eTx5vSL4
SLsfeD47goIGVhNF1BXh1vbHw1UKNBR9lV335mZF+O+g25k4Uxp6/4Uv9Ox2
Rci0lSrpvkdDK5oyvLv3KELY5o9qyRqj6KG0jtKwiyLo6J25tbp3DJWyn6Bk
uilChll3urnPGBpgxime9FAEz5XwX6LxY0jrO21t/xlF2Kxy6L5Uyxj6ee6p
bHeIImxL8BLtdaIjpnOlTEq4IhQevHaWLYSOxM3mpI9eV4S2aKufT57QkavC
Qan2GEV4N74ktu0PHc1Xcoi3JinCzNkB7TFLBlL4tEXsQYoiOAvJhRafYiDj
NBfRw+mK8GamxYb1BgPFBxUKN2YrQr9Y5tP+IgbaoOIjUFuoCMvxrdL/5En+
I/R4TWyxIiQ9WSd/dBsTBS5+57f8TxH2O3gNaFgwUVmdIt/vH4rAWoFFZYOY
yDG0ketHiyLsWlTLUvzJROFeLFw3/yqC6O63Vyb/MlGm7SZOky5FODTygXUr
g4kmN0Sylw8qAoeR58sZIQJJS+SxXaMpQh5dcv0lCoGMWHpZdzHIcxETdi8t
AsW06LPgaUWAyLjMm1YE+vDVczV0XhHsots6850J1Pb63orBsiL8E1u2OXCa
5Le7gsI6WSlAP9E5gyMIpFogsFLMToGii5ScB3Ekn9Z4HprMSQG7GfPsliQC
dUnVhzjxUmDc3iQv4S2Bzt3xXNbnp8AhH6mja0j+y8G+EiwrQAFOmdZo4iuB
Hl68t7QgSAFBaXGxnZUE2sjcGPxHmAIOxltrmPUEKjnxdbFQlAIFR04/5PtD
IOs/Ry4/EqfAg6TK/bHdBOq3Yi4ESZL6burWXhok+fu365eOSFPggL0PW/Uo
gXj15RZ0ZClAe7JUFUkQKPnt+4uS8qQ/qQekc6YIpKlqNj+zlgIdIzl12nME
KkvqCmpWpMDqdbVBlUUCHRa+MJenRIFZj+K9ocsEGrnBH3RPmQK9GdoMgxUC
hSylzZ5XpUBV9rbqE6sEEjqnF2i7ngL3PVHfBCmPJp7cJraBAp+rFh/R///7
j093Jxs2UiAurkXMjZTT/+B3dzUo8O+M2GEbUl/YMt3XZjMFWNrkj5eQ9hwV
ZTeJalEAOqOMMkg823fvHavfQoEMEelZ9nkCCZ8MyE7QpkCnV/7d7mkC0SPT
PA9up8AiT6CSzgSBfubUqIrokv6LPX7PzSDQ8+ql/jo90p5n5KFDIwQKH1dL
j9enwIUjjWvl+wnkJGbnam1AgRU7PeVjnQTS0YlQEDaiwIaMpJC1rQQSdXjX
UYsowNHJZXykjkCVKXwOB/ZQIItlLs6QzGfmV10pIRMynqqOtqOFBLo24N5c
Y0qB1uzrbGLvCLRjIz5oZU6BRyaJRW3JBBK3pAsJ7qfAWMUNkcC7BBo/K1NT
bUmBbxpOM3GRBHqZf97c8iAFhGsPSev7Eeh6WyqPgC0FztekFVaeIJDrUnVF
1SGyHjOUstrsCCS1S23PfnsKqPX6m53ZSaCbVR07LY5RoGJekDt8hYncCN5F
vuMUuGtSEsDKZCIjUd3CSjcKcAXyyLF1MtHMkYRt5h4UePwsbfP//3/Gvd9k
074z5Ln73w83fJgIuM6P8ZylgI9DoRSvPRPJbUjN/ulH5vfWU1XBPUzU4Luo
ahZA1i/P9JMUKSbatZirsDeYApcVw1j7PzOQ/NqODq5QMn8czbmh6Qw0j3if
VIRRIJ1HfCH5FgO9u3FCyvQaBULPP+XwtiPnj4i0sMkt0n7et1/Wo3S0vP4q
656HFIi6uE7s5dIYcrX4Nr/wiAKfDB88d+sYQ999ucffJVHg5oHQT2+Kx1Bs
/p0uhRQKtK1ftp8LHkNKe5K+LD6nQEN+xJDHzCgydfl44cMHCkilC6/XbKKh
nKuzPqfyKKD9PHtOK5eGhF7scKd8osCXlUdsVZE01DaGbWKLKFAt9k6zbgcN
eV+q0jz9HwUe7lCQoT4eQfH3BmlKNRRwdvZuvWwyjKYL1Hrbaimg7HX9PyeZ
YeTQ7t0WV0+B4Dv39HroQ4hKnaz410SBSHW5Zy13h1D+25WMP+0U8HdZlrrz
dxD9rZRySaBRIA3ZtZU7DCAVVvMGFk4laK+vefJJvhfd/Z0218GlBBlcJnG9
vT2I5cGCfBGPEqhZfeUoyexBHRuzPc+tUQKl6vX1tzR70L1DPP96xZTAITwl
VDu4C3G+rFhfTlWCd1HX8uQe/0VDVntCb4ASTDm4VZUEN6CXyQZqfCFKcPKd
R9I8PEDHxNVvV4QqwYZCKfE5q9tI8rbM+LUrSiC1uOWdiO5FFBE8W7B0TQlK
paLWZVpcxy6O7/YybimR+So6y2byAotLq3jWPVQC53s0hkPlZ3wlkT/zwUcl
+BNZzvLEqRrr8C/y2uYrge9oud3bIzWYfm3kjFCBEtT6l+3Ya1uLHf2/b4/6
rATZMve/XXxeh7cdvPL90lfyvtPvxe4HDXhUcGrAuVYJglXGzw/4tGC76L/K
ymNKEF11LIZS14klszvzORhKkKyYzEfd34VbfvTsHWIqwVvxm8kJP7qwHeew
d/akEiQpibx/X9yNj4RPfdRcVIL7HdrP/9b2YPvANcYGvFSApuXnXhl9WPq+
UMtafipkaYW1HOzow20fRb1W11DhtVmAVo94P3aYkL5dJkyFHrmutSPX+7Gj
j2qTmTQViOYLVyNdB7CTm5H74fVUKL9Ud16R3E/lr+6a1dlA3o9x8+rWHcId
z4yjpNWpIB3m5rDt9BB27jR/3b6ZCjuPsJ96XE3K9kemj+tQYYg+vFMnbhi7
WPld9zWhwn3FJ+ETyyNY4cx5Seu9VBi5e2DjPTUa7ooJfLllHxWSbvFnldjS
sMuvkKrp/VSYyrbrSHtJw8eMb4kHH6KCWc5/fI/3j2JX/fTnkSeo8GwTZ+uj
kDGc7fDlrOtJKqxP8FvKfDaGJy826e/wpMKl5YTebWVj+HoBV/3oaSocUU49
X81Jxy+3ef+z9Cf12fMW9Nyk4wnb6z/XBVDB6rFQb/sLOtY//zRx9QIVLmpd
4bf5RsdV72s3vL9EhYwGh81vVsn7m7fZiV+lgueTk9VCfgysb2WpxLhGxl/f
kr8pmoGvn/Ggf79OhYTzz6hCLxhY8vWja0FRVJBpH5ofbiXvb/iX+zeO9P/l
VJyULhNHmEle/phAhQBc0XjDkomrPDVNbidS4dGUyinPE0zsknm83fAhFYRr
vkxfu8PE15QruNNSqMA+FSMu0s7Ev3d3N1xKpQJviaK9EIOJxd3mn9qkU+GL
6EOesBUmzkzduI0jkwqhA2JnXykSmMB7VjuyqCDySDTmlCaB9bqdK/OzqXBa
ZLT7gRGBK9fGuXq+ocKtRoa8kROBxQxfqsNbKugoiIcXeBHY2fnrrPR7KrAl
84o+u0BgZtLU7co8Kvx65d5ccIfAup/X2Gd8osLW9LEHI48IHP5HVTmkkAoT
T25m3cwg9UnbF20qJuunMWiKt4DUp3vuOlcpFXz26zYxSXSZdtEHujEVbgx2
WcFPEu+FDNnCr1QYD6ozWCH5s9794sH4cjJ+nbKX1Uh+fTWv+d2p71Tgfnx5
sJTk35WNzODdP6hQ5+Po+pXk52JT3HvlflHhHr2xRpPk786iSqLTlVQQ+vdW
io/k9y+26HdWVVHh+D5PFWuS/zOtbV++qKHC51fUXtZZ0h8/n/NhdVQ4eeuL
geIC6U/cDaMjDVQIoharvVwi8K/cFF6tJrI/mo49Tv5HYNGagiaeFirI2ybe
WF4hsBOj7llvKxUsa6aHfqwS+Pma0dOf/1ChQ6ypaIWUdf48DjjfTtYLt+P4
K1L++WJfmEYnFWK9ab2t5POO/guRg11UaBz7m3CN1D9mlJ2Q0kOFetcEztek
/RB+hydH+qiQWXTJ+ND//77RxvNCeIC038VnH0ziT31emPtrkAp+Ud8tlKYI
vPWcV+G1YSr8ldy2yZQg+b2hdNlOGhVaD43yj44S2I7v5+/pUSroG9xYWDNE
4JGWoOY3dCrw5ebwvu0h8KWM9d0eTCooKfPa1P0lMJ9f64jiOBVuHjoy6tdE
4GSDyMm2CSrkt9vS46sJ/F/zEKfFDBVsdwalHCglsE36AyGOOdJeq9FtZj6B
B3xNZUrmqeDsMOMi8IbA3DyZGprLVOhcfWf8+zGBHzUd1hn5R4X5sWsvTscR
eGMaJ6StUuGfcMfN6OsEttI/aSvGrgwn+vpD9p8hcA+XxNEqDmW4kRdEMF0J
fK7xm8cNLmWoi3NKET1E4Hs+KpfneJVB3HTgWpcegdtT+lPbhZVBxu9IYuwy
E/t4J+bcE1UGn+CvXLvoTLyiuyfPUlwZftDb7gSS/UatT/+BpZQhY9VpxLuQ
ib3Y3ZgZCspw//v7/EgfJl6sFZl3piiDkde7Z472THw7+SurJFUZtij+nfyw
h4nfbleSiFJVhvqp4yoz0kw869mz00dDGT6UjFj+KmHgqG3xJqqblcHlqLVA
PTk/ZFnhQJemMog0qHIfv8PAhknP3Ky1leF6Wq+OnBM5b6pcbm3TV4a4j7q/
2CfoWHRLZ8vyXmWgWK4OcnLT8ZvnaYLt+5RB9qrpgNzgGDaT9jAtslAG7aJ8
9zfkfAxbZeZfOKAMT+dehJiQ83SsmuU+004ZKhNtbjjTRvG30yq2PSeVAW6r
Fn19Rc7jrpHoUk9liOdp/t57lYYXD74pSz6lDBdCf7+KOkLDW3bobHU4owwe
O45s9GWl4RRuM5GGAGWYaM0OzT0wgoOee9eWRyjDna+DC7hlCItKa3Gn31AG
1h6c8+7FEM6NmTYKjyTz+Si6cnvAEB7wD801iFGGxKYFDlbhIWy9K+5O/l1l
8HthdT9/9yDe2PXBIiuN9Pf2lwHf+/24Q2rxRzRWhr7ikvwQZjf+T++w0b6v
yhDh2v7GNbQbP3d4l8ddrgxrlhz3lfF3Y+8nHmnXK5Rh0JmzgnN9F15UaLwc
Vq0MR6rcfn090oFl1r3e5N+uDK5RRYsfM9qw3TaXRIc5ZbAWnbwjMFWH66zL
XNQ0VSBKW8D9meBtbOivLdilpQLSGaoOUdoXcU7i85LErSowX38/bMdfFxTR
clN+dbsKeC4Mb7nYl4B0nC3+NhuoQH+YcPNQ/0uU7Nl0OMJcBXidEhscHYqR
V9jQ/q6TKhAtcUZjsrcaNT87spzoqQI+hZfn5v/UoN1ff77ad0oF7mXsY79R
X4vkOF7x5fuowIOw8pLY7jpUc+vsz5jzKtD+Z7fj5K8GtO3+/J4dV1XgjO2V
boP4FrT6im/nvWQVsLi4L7etuRMFBsRLn01RgYuca5JkrbsQ3UBydl+qCkw/
o8XW/OpCbdVK71czVGDbjU+5EV+60TtCb733K1Kf51jM5O8e5KbtKbb7swqs
uJWvt37ch9qW6OPyxSpgGranNay+D1l986+ZK1GBk+3L7od5+5H+4bBbb76q
wFe1T1yzQf1ILOj+qvQvFRDr69SiWQ+gb5/Lx4hWFSi5F7z+y/gg0o/Y96vy
jwp81PJoG6cOoXcWtZkv2lXAY+VQZ+mhIfS04+9xp24VSD+oBpSCIRS4MtFa
MaQCzjqSrt2Bw2j9bsq3pzMqMMwxb3CndwSl8GWmXZxTASfZeZXuNTQk3qh+
xXZBBVhOJHz5oktDLO66+rz/VMBs4WejyG1y375h9S7gfw1XaVCTVxQVZDAz
WFQYcQQdcbmAK2hFxAL3CsEdKLhRcQkZpSKLC8iiATdsXIiKohBcQFnUFKHa
BGjcRTHIgKIIjiyFqGxJvkeVQlUg/X6eH/e9+8459809ZkBlyQXCCc7deKJS
cmmlNZBVd5GV+WYdLkd5mflYoHLTrJSVB3QoUKnqHtsASYamvrXP0eHRHG7k
QlsgVcHPAwmtOjwYL0qaNhlIeznXuTZEj2iQyP+eAqTJu7lOmqjHIbFclTUN
6IpEu6Xygh4l/q8No5348/CEJ3upx3gQbh6cAxS6YvsplYcBF1wU7StzAeo/
UzflAZ9XekcnXYiZB/Rh0WbrgF0G3DOgqulyBaqOvBUu4PNO9BtHrPcAqq35
NFBtNODs5cKQNC+g6Z1ZcZY2HOofiOJXEdDSXl+qm8lhuEJe/MQHKFLtL+bW
8nnskIV98QqgzUpDweo8Dqf2O3rsWAXkkrozWFXCoTZSGAz+QIf/07yQazgU
BSeduRgIVBjv9Kqrm8NJNfLCdauBFoq9G9Z857DFp0QzZi2Qd9Um6WILPv86
s2HHgoE+hjW1XpnO0DbfYqLPBiDj20jLUQsZvrN1ch8K4flwDTEYfRmuMw/d
HbsFqMuxt1ksYjhWkiRzDgXa3W2WUhfJsO4f+c1uMVD4n4vNKhIYBjW/bhOF
AX3z3Pfa8TTDMavZoN12oMBTLs8y5AxfaSxsG8KBnsQdb+T3Fzzl5bTgbATQ
5TRTQ28hQz+lMMgvCkif6fimTcVw5IzQaMFOoEnDz4X7PeDzeHbSifJdQNcy
OJlbBcNlJ0ueuMcCpc2NMpHWMRxh8qaldy/QsQmuNvr3DCvi2LfieKD2bjfh
y1aGR/UW4yISge6kxMS4tDMUip1+dNgPdE/fLxulYzj8nTCgTQIkyOo4EMkY
PvELjbiUDNSoiXdb+oXhwfIk6fqDQB7lPXnZfQzRPSvX6jDQxMlF6r1fGSpy
0peZpAA1V1Z4mg/w+V9w2sCOArmP5xb2DjJM3nn8bIsUaE3z2mtoZNhZf8St
+jhQlDE8ppPHQV7JTXdP8nzlv7rB8fhefsIhhQwoxHuHdxCPHX6IcZCfBrLL
DPSxHmJ4JjaqSpoGlFrQeHsuf9+3xl93xZ3j33syI+MW389WH/HYbeeBRq/x
N5Hy/dYoNqpXZwBll5oa739m6G61fou3HOjQi57cII5hXmKg2dyLQJQlM/ft
YmjZtvLmpMu8X+7+Ruc/MExYtsTfMpvXu/JxtE8zQ20xfRnI4fWuCbkdUM9w
1bifMnXXgB5cvzFTXcOwJNnV830e778V88yO8HrZtztrNQVAd83KtiruMzzp
N0NaegOo5sbsfS5Khn3KabMKFLx/r6tjxyoYiiZMqk0vBDKx+0v6SzbD+Tpr
uz1/ACl7w+uMUoZXgiwfie4APQp7miLez1CgFmwLUAIdsWhZBNEMm44NFs0q
A+oZcUFTFcjr79Dh3fEQqMFKKMsfw7BH1tbx9jGQ/TtJwuhhDDf825j6tJyv
N0xsajZwOOfpq/qrz4ESH148dPU5h/Wh6h0bXwKVCrQODTEcUqVy1Mpanr+I
ihzRJg4VLsVK9zf8/Dg9rw5YwuEBY+6QTQNfv950fCg//06XZWdrW4Bafe3M
NxUb8KzZMbdHrfz/pbE9PzndgAMRh5uKtEBN1Y1vAxIMWLso3iG1HWhANSZf
52XAfe9E6iUc8Pvf7N9dnunxI4Zsce0BOhdt/zEoX4/+19eaTfvM+08TnPoh
RY9T4lb4m/QBpU99/CjIW4+pzcIvrB/oxdd52fPs9dgnxMyWr0CdurC0I4M6
FBW6e1Z/BzoYdWnpkvc6rLKer707CJRX+il2f4kO/we1rC+e
     "]]}},
  AspectRatio->0.3,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontFamily -> "Times", FontSize -> 11},
  Method->{"DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None},
  PlotRange->{{0, 10.995574287564276`}, {-0.9999999943783768, 
    0.9999999999999748}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.6458661462651324`*^9, 3.645866225248071*^9, {3.645866580191495*^9, 
   3.645866590425113*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<mathematica-example.pdf\>\"", ",", " ", "p"}], "]"}]], "Input",
 CellChangeTimes->{{3.645866229616079*^9, 3.6458662395688963`*^9}, {
  3.6458663311722574`*^9, 3.6458663331222606`*^9}}],

Cell[BoxData["\<\"mathematica-example.pdf\"\>"], "Output",
 CellChangeTimes->{3.6458662455905066`*^9, 3.6458663569435024`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteFileName", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.645866337209468*^9, 3.645866353371096*^9}}],

Cell[BoxData["\<\"C:\\\\SVN_HgbThesis_SourceForge\\\\trunk\\\\images\\\\\
mathematica-example.pdf\"\>"], "Output",
 CellChangeTimes->{{3.6458663432154784`*^9, 3.6458663586439056`*^9}}]
}, Open  ]]
},
WindowSize->{955, 722},
WindowMargins->{{193, Automatic}, {Automatic, 0}},
FrontEndVersion->"10.0 for Microsoft Windows (64-bit) (December 4, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 198, 4, 31, "Input"],
Cell[CellGroupData[{
Cell[781, 28, 326, 5, 31, "Input"],
Cell[1110, 35, 131, 2, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1278, 42, 1614, 38, 72, "Input"],
Cell[2895, 82, 37873, 637, 122, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40805, 724, 238, 4, 31, "Input"],
Cell[41046, 730, 126, 1, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41209, 736, 135, 2, 31, "Input"],
Cell[41347, 740, 184, 2, 31, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
