/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.TeXBoolean;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class UserBoolean
implements TeXBoolean {
    private boolean value;

    public UserBoolean(boolean bl) {
        this.value = bl;
    }

    @Override
    public Object clone() {
        return new UserBoolean(this.value);
    }

    @Override
    public boolean booleanValue() {
        return this.value;
    }

    public void setValue(boolean bl) {
        this.value = bl;
    }

    @Override
    public String format() {
        return String.format("\\if%s", this.value);
    }

    public String toString() {
        return String.format("%s[value=%d]", this.getClass().getSimpleName(), this.value);
    }

    @Override
    public String toString(TeXParser teXParser) {
        return String.format("%cif%s", teXParser.getEscChar(), this.value);
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return teXParser.getListener().createString(String.format("%cif%s", teXParser.getEscChar(), this.value));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.add(0, new TeXCsRef("if" + this.value));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        teXObjectList.add(0, new TeXCsRef("if" + this.value));
    }

    @Override
    public boolean isPar() {
        return false;
    }
}

