/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.swt;

import java.awt.Component;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class PSWTMouseEvent
extends java.awt.event.MouseEvent {
    private static final int SWT_BUTTON1 = 1;
    private static final int SWT_BUTTON2 = 2;
    private static final int SWT_BUTTON3 = 3;
    private static final long serialVersionUID = 1L;
    private static Component fakeSrc = new Component(){};
    protected MouseEvent swtEvent;
    protected int clickCount;

    public PSWTMouseEvent(MouseEvent me, int type, int clickCount) {
        super(fakeSrc, type, me.time, 0, me.x, me.y, clickCount, me.button == 3, me.button);
        this.swtEvent = me;
        this.clickCount = clickCount;
    }

    public Object getSource() {
        return this.swtEvent.getSource();
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public int getButton() {
        switch (this.swtEvent.button) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public boolean isShiftDown() {
        return (this.swtEvent.stateMask & 0x20000) != 0;
    }

    public boolean isControlDown() {
        return (this.swtEvent.stateMask & 0x40000) != 0;
    }

    public boolean isAltDown() {
        return (this.swtEvent.stateMask & 0x10000) != 0;
    }

    public int getModifiers() {
        int modifiers = 0;
        if (this.swtEvent != null) {
            if ((this.swtEvent.stateMask & 0x10000) != 0) {
                modifiers |= 8;
            }
            if ((this.swtEvent.stateMask & 0x40000) != 0) {
                modifiers |= 2;
            }
            if ((this.swtEvent.stateMask & 0x20000) != 0) {
                modifiers |= 1;
            }
            if (this.swtEvent.button == 1 || (this.swtEvent.stateMask & 0x80000) != 0) {
                modifiers |= 0x10;
            }
            if (this.swtEvent.button == 2 || (this.swtEvent.stateMask & 0x100000) != 0) {
                modifiers |= 8;
            }
            if (this.swtEvent.button == 3 || (this.swtEvent.stateMask & 0x200000) != 0) {
                modifiers |= 4;
            }
        }
        return modifiers;
    }

    public int getModifiersEx() {
        int modifiers = 0;
        if (this.swtEvent != null) {
            if ((this.swtEvent.stateMask & 0x10000) != 0) {
                modifiers |= 0x200;
            }
            if ((this.swtEvent.stateMask & 0x40000) != 0) {
                modifiers |= 0x80;
            }
            if ((this.swtEvent.stateMask & 0x20000) != 0) {
                modifiers |= 0x40;
            }
            if (this.swtEvent.button == 1 || (this.swtEvent.stateMask & 0x80000) != 0) {
                modifiers |= 0x400;
            }
            if (this.swtEvent.button == 2 || (this.swtEvent.stateMask & 0x100000) != 0) {
                modifiers |= 0x800;
            }
            if (this.swtEvent.button == 3 || (this.swtEvent.stateMask & 0x200000) != 0) {
                modifiers |= 0x1000;
            }
        }
        return modifiers;
    }

    public Widget getWidget() {
        return this.swtEvent.widget;
    }

    public Display getDisplay() {
        return this.swtEvent.display;
    }

    public Object getData() {
        return this.swtEvent.data;
    }
}

