use core:debug;
use core:io;
use core:lang;

// Type for storing a sentence.
class Statement {
	Str noun;
	Str verb;

	init(Str noun, Str verb) {
		init() {
			noun = noun;
			verb = verb;
		}
	}

	Str toS() {
		"Statement: " # noun # ", " # verb;
	}
}

void testSimple() on Compiler {
	Str s = "bird";

	Parser<Noun> parser;
	parser.parse(s, Url());
	if (parser.hasError)
		parser.throwError;
}

Bool testSentence() on Compiler {
	Str s = "do birds fly?";

	Parser<Sentence> parser;
	parser.parse(s, Url());
	if (parser.hasError)
		parser.throwError;

	var tfm = parser.tree.transform();
	"Statement: bird, fly" == tfm.toS;
}

Str testManualTfm(Str s) on Compiler {
	Parser<Sentence> parser;
	parser.parse(s, Url());
	if (parser.hasError)
		parser.throwError;

	Sentence tree = parser.tree();
	if (tree as PluralAssert) {
		return "Plural " + tree.noun.transform();
	} else if (tree as SingularAssert) {
		return "Singular " + tree.noun.transform();
	} else if (tree as Question) {
		return "Question " + tree.noun.transform();
	} else {
		return "Unknown";
	}
}

Bool testMaybe() on Compiler {
	Str s = "do birds fly?";

	Parser<EmptySentence> parser;
	parser.parse(s, Url());
	var tree = parser.tree;
	Statement? tfm = tree.transform;

	if (tfm) {
		"Statement: bird, fly" == tfm.toS;
	} else {
		false;
	}
}

Bool testArray() on Compiler {
	Str s = "do birds fly? do cats sleep?";

	Parser<Paragraph> parser;
	parser.parse(s, Url());
	Statement[] tfm = parser.tree.transform;
	"[Statement: bird, fly, Statement: cat, sleep]" == tfm.toS;
}

Bool testCall() on Compiler {
	Str s = "do birds fly? do cats sleep?";

	Parser<ParCall> parser;
	parser.parse(s, Url());
	Statement[] tfm = parser.tree.transform;
	"[Statement: bird, fly, Statement: cat, sleep]" == tfm.toS;
}

Bool testCallMaybe() on Compiler {
	Str s = "do birds fly? do cats sleep?";

	Parser<MaybeCall> parser;
	parser.parse(s, Url());
	Statement[] tfm = parser.tree.transform;
	"[Statement: bird, fly, Statement: cat, sleep]" == tfm.toS;
}

Nat testRaw() on Compiler {
	Str s = "do birds fly? do cats sleep?";

	Parser<RawSentence> parser;
	parser.parse(s, Url());
	Sentence[] tfm = parser.tree.transform;
	tfm.count;
}

Nat testRawCall() on Compiler {
	Str s = "do birds fly? do cats sleep?";

	Parser<RawCall> parser;
	parser.parse(s, Url());
	Sentence[] tfm = parser.tree.transform;
	tfm.count;
}

Bool testCapture() on Compiler {
	Str s = "(fly bird)";

	Parser<Capture> parser;
	parser.parse(s, Url());
	Str tfm = parser.tree.transform;
	"fly bird" == tfm;
}

Bool testRawCapture() on Compiler {
	Str s = "(fly bird)";

	Parser<RawCapture> parser;
	parser.parse(s, Url());
	SStr tfm = parser.tree.transform;
	"fly bird" == tfm.v;
}

void testParams() on Compiler {
	Str s = "a : fly bird";

	Parser<PrefixWords> parser;
	parser.parse(s, Url());
	StrBuf[] tfm = parser.tree.transform;
	"[a fly, a bird]" == tfm.toS();
}
