/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import java.util.Iterator;

public class UnitRepresentation
implements Iterator<UnitRepresentation> {
    private final boolean mayHaveSIPrefixes;
    private final boolean mayHaveBinaryPrefixes;
    private final boolean isDeprecated;
    private final String abbreviation;
    private UnitRepresentation nextRep = null;
    private static final long serialVersionUID = 43L;

    UnitRepresentation(boolean bl, boolean bl2, boolean bl3, String string) {
        if (string == null) {
            throw new IllegalArgumentException("a Representation must have a non-null abbreviation");
        }
        this.mayHaveSIPrefixes = bl;
        this.mayHaveBinaryPrefixes = bl2;
        this.isDeprecated = bl3;
        this.abbreviation = string;
        assert (string != null);
    }

    public String toString() {
        return this.abbreviation;
    }

    public String toDebugString() {
        return this.abbreviation + "[" + (this.mayHaveSIPrefixes ? "s" : "") + (this.mayHaveBinaryPrefixes ? "b" : "") + (this.isDeprecated ? "d" : "") + "]";
    }

    public boolean mayHaveSIPrefixes() {
        return this.mayHaveSIPrefixes;
    }

    public boolean mayHaveBinaryPrefixes() {
        return this.mayHaveBinaryPrefixes;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    public boolean hasNext() {
        return this.nextRep != null;
    }

    @Override
    public UnitRepresentation next() {
        return this.nextRep;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported in UnitRepresentation");
    }

    boolean add(UnitRepresentation unitRepresentation) {
        if (this.nextRep != null) {
            unitRepresentation.add(this.nextRep);
            this.nextRep = unitRepresentation;
        } else {
            this.nextRep = unitRepresentation;
        }
        return true;
    }
}

