/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  gengetopt --unamed-opts=REALM [PRINCIPAL] --no-handle-help --no-handle-error --no-handle-version --input ./shisa.ggo --file-name shisa_cmd 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "shisa_cmd.h"

const char *gengetopt_args_info_purpose = "Manipulate information stored in the Shisa user database.";

const char *gengetopt_args_info_usage = "Usage: shisa [OPTION]... [REALM [PRINCIPAL]]...";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "\nOperations:",
  "  -a, --add                     Add realm or principal to database.",
  "  -d, --dump                    Dump entries in database.",
  "  -n, --key-add                 Add new key to a principal in database.",
  "      --key-remove              Remove a key from a principal in database.",
  "  -l, --list                    List entries in database.",
  "  -m, --modify                  Modify principal entry in database.",
  "  -r, --remove                  Remove realm or principal from database.",
  "\nParameters:",
  "  -f, --force                   Allow removal of non-empty realms.\n                                    (default=off)",
  "      --enabled                 Only dump or list enabled principals.\n                                    (default=off)",
  "      --disabled                Only dump or list disabled principals.\n                                    (default=off)",
  "      --keys                    Print cryptographic key and password in hostkey\n                                  format.  (default=off)",
  "\nValues:",
  "  -E, --encryption-type=STRING  Override default key encryption type.  Valid\n                                  values include 'aes128', 'aes256', 'aes'\n                                  (same as 'aes256'), '3des', 'des-md5',\n                                  'des-md4', 'des-crc', 'des' (same as\n                                  'des-md5'), and 'arcfour'.",
  "      --key-version=NUMBER      Version of key.",
  "      --password[=STRING]       Derive key from this password.",
  "      --priority=NUMBER         Specify key priority, used to differentiate\n                                  between keys when multiple keys are eligible\n                                  for use.  Higher value means higher priority.\n                                  (default is 0, which mean a random key of the\n                                  best etype is chosen)",
  "      --random                  Use a random key.  (default)",
  "      --salt=STRING             Use specified salt for deriving key.  Defaults\n                                  to concatenation of realm and (unwrapped)\n                                  principal name.",
  "      --string-to-key-parameter=HEX\n                                Encryption algorithm specific parameter for\n                                  password derivation.  Currently only the AES\n                                  algorithm can utilize this, where it is\n                                  interpreted as the iteration count of the\n                                  PKCS#5 PBKDF2 key deriver.",
  "\nOther options:",
  "  -c, --configuration-file=FILE Use specified configuration file.",
  "  -o, --library-options=STRING  Parse string as configuration file statement.",
  "  -v, --verbose                 Produce verbose output.\n                                    (default=off)",
  "  -q, --quiet                   Don't produce any diagnostic output.\n                                    (default=off)",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_LONG
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->add_given = 0 ;
  args_info->dump_given = 0 ;
  args_info->key_add_given = 0 ;
  args_info->key_remove_given = 0 ;
  args_info->list_given = 0 ;
  args_info->modify_given = 0 ;
  args_info->remove_given = 0 ;
  args_info->force_given = 0 ;
  args_info->enabled_given = 0 ;
  args_info->disabled_given = 0 ;
  args_info->keys_given = 0 ;
  args_info->encryption_type_given = 0 ;
  args_info->key_version_given = 0 ;
  args_info->password_given = 0 ;
  args_info->priority_given = 0 ;
  args_info->random_given = 0 ;
  args_info->salt_given = 0 ;
  args_info->string_to_key_parameter_given = 0 ;
  args_info->configuration_file_given = 0 ;
  args_info->library_options_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->quiet_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->force_flag = 0;
  args_info->enabled_flag = 0;
  args_info->disabled_flag = 0;
  args_info->keys_flag = 0;
  args_info->encryption_type_arg = NULL;
  args_info->encryption_type_orig = NULL;
  args_info->key_version_orig = NULL;
  args_info->password_arg = NULL;
  args_info->password_orig = NULL;
  args_info->priority_orig = NULL;
  args_info->salt_arg = NULL;
  args_info->salt_orig = NULL;
  args_info->string_to_key_parameter_arg = NULL;
  args_info->string_to_key_parameter_orig = NULL;
  args_info->configuration_file_arg = NULL;
  args_info->configuration_file_orig = NULL;
  args_info->library_options_arg = NULL;
  args_info->library_options_orig = NULL;
  args_info->verbose_flag = 0;
  args_info->quiet_flag = 0;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->add_help = gengetopt_args_info_help[3] ;
  args_info->dump_help = gengetopt_args_info_help[4] ;
  args_info->key_add_help = gengetopt_args_info_help[5] ;
  args_info->key_remove_help = gengetopt_args_info_help[6] ;
  args_info->list_help = gengetopt_args_info_help[7] ;
  args_info->modify_help = gengetopt_args_info_help[8] ;
  args_info->remove_help = gengetopt_args_info_help[9] ;
  args_info->force_help = gengetopt_args_info_help[11] ;
  args_info->enabled_help = gengetopt_args_info_help[12] ;
  args_info->disabled_help = gengetopt_args_info_help[13] ;
  args_info->keys_help = gengetopt_args_info_help[14] ;
  args_info->encryption_type_help = gengetopt_args_info_help[16] ;
  args_info->key_version_help = gengetopt_args_info_help[17] ;
  args_info->password_help = gengetopt_args_info_help[18] ;
  args_info->priority_help = gengetopt_args_info_help[19] ;
  args_info->random_help = gengetopt_args_info_help[20] ;
  args_info->salt_help = gengetopt_args_info_help[21] ;
  args_info->string_to_key_parameter_help = gengetopt_args_info_help[22] ;
  args_info->configuration_file_help = gengetopt_args_info_help[24] ;
  args_info->library_options_help = gengetopt_args_info_help[25] ;
  args_info->verbose_help = gengetopt_args_info_help[26] ;
  args_info->quiet_help = gengetopt_args_info_help[27] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(gengetopt_args_info_purpose);
	size_t len_usage = strlen(gengetopt_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", gengetopt_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", gengetopt_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(gengetopt_args_info_description) > 0) {
		printf("%s\n\n", gengetopt_args_info_description);
	}
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  unsigned int i;
  free_string_field (&(args_info->encryption_type_arg));
  free_string_field (&(args_info->encryption_type_orig));
  free_string_field (&(args_info->key_version_orig));
  free_string_field (&(args_info->password_arg));
  free_string_field (&(args_info->password_orig));
  free_string_field (&(args_info->priority_orig));
  free_string_field (&(args_info->salt_arg));
  free_string_field (&(args_info->salt_orig));
  free_string_field (&(args_info->string_to_key_parameter_arg));
  free_string_field (&(args_info->string_to_key_parameter_orig));
  free_string_field (&(args_info->configuration_file_arg));
  free_string_field (&(args_info->configuration_file_orig));
  free_string_field (&(args_info->library_options_arg));
  free_string_field (&(args_info->library_options_orig));
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->add_given)
    write_into_file(outfile, "add", 0, 0 );
  if (args_info->dump_given)
    write_into_file(outfile, "dump", 0, 0 );
  if (args_info->key_add_given)
    write_into_file(outfile, "key-add", 0, 0 );
  if (args_info->key_remove_given)
    write_into_file(outfile, "key-remove", 0, 0 );
  if (args_info->list_given)
    write_into_file(outfile, "list", 0, 0 );
  if (args_info->modify_given)
    write_into_file(outfile, "modify", 0, 0 );
  if (args_info->remove_given)
    write_into_file(outfile, "remove", 0, 0 );
  if (args_info->force_given)
    write_into_file(outfile, "force", 0, 0 );
  if (args_info->enabled_given)
    write_into_file(outfile, "enabled", 0, 0 );
  if (args_info->disabled_given)
    write_into_file(outfile, "disabled", 0, 0 );
  if (args_info->keys_given)
    write_into_file(outfile, "keys", 0, 0 );
  if (args_info->encryption_type_given)
    write_into_file(outfile, "encryption-type", args_info->encryption_type_orig, 0);
  if (args_info->key_version_given)
    write_into_file(outfile, "key-version", args_info->key_version_orig, 0);
  if (args_info->password_given)
    write_into_file(outfile, "password", args_info->password_orig, 0);
  if (args_info->priority_given)
    write_into_file(outfile, "priority", args_info->priority_orig, 0);
  if (args_info->random_given)
    write_into_file(outfile, "random", 0, 0 );
  if (args_info->salt_given)
    write_into_file(outfile, "salt", args_info->salt_orig, 0);
  if (args_info->string_to_key_parameter_given)
    write_into_file(outfile, "string-to-key-parameter", args_info->string_to_key_parameter_orig, 0);
  if (args_info->configuration_file_given)
    write_into_file(outfile, "configuration-file", args_info->configuration_file_orig, 0);
  if (args_info->library_options_given)
    write_into_file(outfile, "library-options", args_info->library_options_orig, 0);
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", 0, 0 );
  if (args_info->quiet_given)
    write_into_file(outfile, "quiet", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  FIX_UNUSED (args_info);
  FIX_UNUSED (prog_name);
  return EXIT_SUCCESS;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_LONG:
    if (val) *((long *)field) = (long)strtol (val, &stop_char, 0);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_LONG:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "add",	0, NULL, 'a' },
        { "dump",	0, NULL, 'd' },
        { "key-add",	0, NULL, 'n' },
        { "key-remove",	0, NULL, 0 },
        { "list",	0, NULL, 'l' },
        { "modify",	0, NULL, 'm' },
        { "remove",	0, NULL, 'r' },
        { "force",	0, NULL, 'f' },
        { "enabled",	0, NULL, 0 },
        { "disabled",	0, NULL, 0 },
        { "keys",	0, NULL, 0 },
        { "encryption-type",	1, NULL, 'E' },
        { "key-version",	1, NULL, 0 },
        { "password",	2, NULL, 0 },
        { "priority",	1, NULL, 0 },
        { "random",	0, NULL, 0 },
        { "salt",	1, NULL, 0 },
        { "string-to-key-parameter",	1, NULL, 0 },
        { "configuration-file",	1, NULL, 'c' },
        { "library-options",	1, NULL, 'o' },
        { "verbose",	0, NULL, 'v' },
        { "quiet",	0, NULL, 'q' },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVadnlmrfE:c:o:vq", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->help_given),
              &(local_args_info.help_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "help", 'h',
              additional_error))
            goto failure;
          cmdline_parser_free (&local_args_info);
          return 0;
        
          break;
        case 'V':	/* Print version and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->version_given),
              &(local_args_info.version_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "version", 'V',
              additional_error))
            goto failure;
          cmdline_parser_free (&local_args_info);
          return 0;
        
          break;
        case 'a':	/* Add realm or principal to database..  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->add_given),
              &(local_args_info.add_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "add", 'a',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* Dump entries in database..  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->dump_given),
              &(local_args_info.dump_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "dump", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'n':	/* Add new key to a principal in database..  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->key_add_given),
              &(local_args_info.key_add_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "key-add", 'n',
              additional_error))
            goto failure;
        
          break;
        case 'l':	/* List entries in database..  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->list_given),
              &(local_args_info.list_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "list", 'l',
              additional_error))
            goto failure;
        
          break;
        case 'm':	/* Modify principal entry in database..  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->modify_given),
              &(local_args_info.modify_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "modify", 'm',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* Remove realm or principal from database..  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->remove_given),
              &(local_args_info.remove_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "remove", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* Allow removal of non-empty realms.
.  */
        
        
          if (update_arg((void *)&(args_info->force_flag), 0, &(args_info->force_given),
              &(local_args_info.force_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "force", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'E':	/* Override default key encryption type.  Valid values include 'aes128', 'aes256', 'aes' (same as 'aes256'), '3des', 'des-md5', 'des-md4', 'des-crc', 'des' (same as 'des-md5'), and 'arcfour'..  */
        
        
          if (update_arg( (void *)&(args_info->encryption_type_arg), 
               &(args_info->encryption_type_orig), &(args_info->encryption_type_given),
              &(local_args_info.encryption_type_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "encryption-type", 'E',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Use specified configuration file..  */
        
        
          if (update_arg( (void *)&(args_info->configuration_file_arg), 
               &(args_info->configuration_file_orig), &(args_info->configuration_file_given),
              &(local_args_info.configuration_file_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "configuration-file", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Parse string as configuration file statement..  */
        
        
          if (update_arg( (void *)&(args_info->library_options_arg), 
               &(args_info->library_options_orig), &(args_info->library_options_given),
              &(local_args_info.library_options_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "library-options", 'o',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* Produce verbose output.
.  */
        
        
          if (update_arg((void *)&(args_info->verbose_flag), 0, &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "verbose", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'q':	/* Don't produce any diagnostic output.
.  */
        
        
          if (update_arg((void *)&(args_info->quiet_flag), 0, &(args_info->quiet_given),
              &(local_args_info.quiet_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "quiet", 'q',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* Remove a key from a principal in database..  */
          if (strcmp (long_options[option_index].name, "key-remove") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->key_remove_given),
                &(local_args_info.key_remove_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "key-remove", '-',
                additional_error))
              goto failure;
          
          }
          /* Only dump or list enabled principals.
.  */
          else if (strcmp (long_options[option_index].name, "enabled") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->enabled_flag), 0, &(args_info->enabled_given),
                &(local_args_info.enabled_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "enabled", '-',
                additional_error))
              goto failure;
          
          }
          /* Only dump or list disabled principals.
.  */
          else if (strcmp (long_options[option_index].name, "disabled") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->disabled_flag), 0, &(args_info->disabled_given),
                &(local_args_info.disabled_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "disabled", '-',
                additional_error))
              goto failure;
          
          }
          /* Print cryptographic key and password in hostkey format..  */
          else if (strcmp (long_options[option_index].name, "keys") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->keys_flag), 0, &(args_info->keys_given),
                &(local_args_info.keys_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "keys", '-',
                additional_error))
              goto failure;
          
          }
          /* Version of key..  */
          else if (strcmp (long_options[option_index].name, "key-version") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->key_version_arg), 
                 &(args_info->key_version_orig), &(args_info->key_version_given),
                &(local_args_info.key_version_given), optarg, 0, 0, ARG_LONG,
                check_ambiguity, override, 0, 0,
                "key-version", '-',
                additional_error))
              goto failure;
          
          }
          /* Derive key from this password..  */
          else if (strcmp (long_options[option_index].name, "password") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->password_arg), 
                 &(args_info->password_orig), &(args_info->password_given),
                &(local_args_info.password_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "password", '-',
                additional_error))
              goto failure;
          
          }
          /* Specify key priority, used to differentiate between keys when multiple keys are eligible for use.  Higher value means higher priority.  (default is 0, which mean a random key of the best etype is chosen).  */
          else if (strcmp (long_options[option_index].name, "priority") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->priority_arg), 
                 &(args_info->priority_orig), &(args_info->priority_given),
                &(local_args_info.priority_given), optarg, 0, 0, ARG_LONG,
                check_ambiguity, override, 0, 0,
                "priority", '-',
                additional_error))
              goto failure;
          
          }
          /* Use a random key.  (default).  */
          else if (strcmp (long_options[option_index].name, "random") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->random_given),
                &(local_args_info.random_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "random", '-',
                additional_error))
              goto failure;
          
          }
          /* Use specified salt for deriving key.  Defaults to concatenation of realm and (unwrapped) principal name..  */
          else if (strcmp (long_options[option_index].name, "salt") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->salt_arg), 
                 &(args_info->salt_orig), &(args_info->salt_given),
                &(local_args_info.salt_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "salt", '-',
                additional_error))
              goto failure;
          
          }
          /* Encryption algorithm specific parameter for password derivation.  Currently only the AES algorithm can utilize this, where it is interpreted as the iteration count of the PKCS#5 PBKDF2 key deriver..  */
          else if (strcmp (long_options[option_index].name, "string-to-key-parameter") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->string_to_key_parameter_arg), 
                 &(args_info->string_to_key_parameter_orig), &(args_info->string_to_key_parameter_given),
                &(local_args_info.string_to_key_parameter_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "string-to-key-parameter", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



	FIX_UNUSED(check_required);

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */

      i = optind;
      while (i < argc)
        if (argv[i++] == argv[0]) {
          found_prog_name = 1;
          break;
        }
      i = 0;

      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        if (argv[optind++] != argv[0])
          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;
    }

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
