# Sanitizers Support

The rustc compiler contains basic support for following sanitizers:

* [AddressSanitizer][clang-asan] a faster memory error detector. Can
  detect out-of-bounds access to heap, stack, and globals, use after free, use
  after return, double free, invalid free, memory leaks.
* [LeakSanitizer][clang-lsan] a run-time memory leak detector.
* [MemorySanitizer][clang-msan] a detector of uninitialized reads.
* [ThreadSanitizer][clang-tsan] a fast data race detector.

## How to use the sanitizers?

To enable a sanitizer compile with `-Zsanitizer=...` option, where value is one
of `address`, `leak`, `memory` or `thread`. For more details how to use
sanitizers please refer to [the unstable book](https://doc.rust-lang.org/unstable-book/).

## How are sanitizers implemented in rustc?

The implementation of sanitizers relies entirely on LLVM. It consists of
compile time instrumentation passes and runtime libraries. The role rustc plays
in the implementation is limited to the execution of the following steps:

1. The sanitizer runtime libraries are part of the [compiler-rt] project, and
   [will be built as an LLVM subproject][sanitizer-build] when enabled in
   `config.toml`:

   ```toml
   [build]
   sanitizers = true
   ```

   The runtimes are [placed into target libdir][sanitizer-copy].

2. During LLVM code generation, the functions intended for instrumentation are
   [marked][sanitizer-attribute] with `SanitizeAddress`, `SanitizeMemory`, or
   `SanitizeThread` attribute. Currently those attributes are applied in
   indiscriminate manner. but in principle they could be used to perform
   instrumentation selectively.

3. The LLVM IR generated by rustc is instrumented by [dedicated LLVM
   passes][sanitizer-pass], different for each sanitizer. Instrumentation
   passes are invoked after optimization passes.

4. When producing an executable, the sanitizer specific runtime library is
   [linked in][sanitizer-link]. The libraries are searched for in target libdir
   relative to default system root, so that this process is not affected
   by sysroot overrides used for example by cargo `-Zbuild-std` functionality.

[compiler-rt]: https://github.com/llvm/llvm-project/tree/master/compiler-rt
[sanitizer-build]: https://github.com/rust-lang/rust/blob/87c3eedffba64830b67e54e75dd479f9fd83cc7d/src/bootstrap/native.rs#L220-L225
[sanitizer-copy]: https://github.com/rust-lang/rust/blob/87c3eedffba64830b67e54e75dd479f9fd83cc7d/src/bootstrap/compile.rs#L269-L321
[sanitizer-attribute]: https://github.com/rust-lang/rust/blob/1.38.0/src/librustc_codegen_llvm/declare.rs#L53-L66
[sanitizer-pass]: https://github.com/rust-lang/rust/blob/1.38.0/src/librustc_codegen_ssa/back/write.rs#L406-L420
[sanitizer-link]: https://github.com/rust-lang/rust/blob/87c3eedffba64830b67e54e75dd479f9fd83cc7d/src/librustc_codegen_ssa/back/link.rs#L729-L770

## Additional Information

* [Sanitizers project page](https://github.com/google/sanitizers/wiki/)
* [AddressSanitizer in Clang][clang-asan]
* [LeakSanitizer in Clang][clang-lsan]
* [MemorySanitizer in Clang][clang-msan]
* [ThreadSanitizer in Clang][clang-tsan]

[clang-asan]: https://clang.llvm.org/docs/AddressSanitizer.html
[clang-lsan]: https://clang.llvm.org/docs/LeakSanitizer.html
[clang-msan]: https://clang.llvm.org/docs/MemorySanitizer.html
[clang-tsan]: https://clang.llvm.org/docs/ThreadSanitizer.html
