### New features

* [#9615](https://github.com/rubocop/rubocop/pull/9615): Add new `Style/StringChars` cop. ([@koic][])
* [#9629](https://github.com/rubocop/rubocop/issues/9629): Add `AllowParenthesesInStringInterpolation` configuration to `Style/MethodCallWithArgsParentheses` to allow parenthesized calls in string interpolation. ([@gsamokovarov][])
* [#9219](https://github.com/rubocop/rubocop/pull/9219): Allow excluding some constants from Style/Documentation. ([@fsateler][])
* Add `AllowNil` option for `Lint/SuppressedException` to allow/disallow `rescue nil`. ([@corroded][])

### Bug fixes

* [#9560](https://github.com/rubocop/rubocop/pull/9560): Fix an error for `Lint/ClassMethodsDefinitions` when defining class methods with `class << self` with comment only body. ([@koic][])
* [#9551](https://github.com/rubocop/rubocop/issues/9551): Fix a false positive for `Style/UnlessLogicalOperators` when using `||` operator and invoked method name includes "or" in the conditional branch. ([@koic][])
* [#9620](https://github.com/rubocop/rubocop/pull/9620): Allow parentheses in operator methods calls for `Style/MethodCallWithArgsParentheses` `EnforcedStyle: omit_parentheses`. ([@gsamokovarov][])
* [#9622](https://github.com/rubocop/rubocop/issues/9622): Fixed `Style/BisectedAttrAccessor` autocorrection to handle multiple bisected attrs in the same macro. ([@dvandersluis][])
* [#9606](https://github.com/rubocop/rubocop/issues/9606): Fix an error for `Layout/IndentationConsistency` when using access modifier at the top level. ([@koic][])
* [#9619](https://github.com/rubocop/rubocop/pull/9619): Fix infinite loop between `Layout/IndentationWidth` and `Layout/RescueEnsureAlignment` autocorrection. ([@dvandersluis][])
* [#9633](https://github.com/rubocop/rubocop/pull/9633): Fix an incorrect auto-correct for `Lint/NumberConversion` when `to_i` method in symbol form. ([@koic][])
* [#9616](https://github.com/rubocop/rubocop/pull/9616): Fix an incorrect auto-correct for `Style/EvalWithLocation` when using `#instance_eval` with a string argument in parentheses. ([@koic][])
* [#9429](https://github.com/rubocop/rubocop/issues/9429): Fix `Style/NegatedIfElseCondition` autocorrect to keep comments in correct branch. ([@tejasbubane][])
* [#9631](https://github.com/rubocop/rubocop/issues/9631): Fix an incorrect auto-correct for `Style/RedundantReturn` when using `return` with splat argument. ([@koic][])
* [#9627](https://github.com/rubocop/rubocop/issues/9627): Fix an incorrect auto-correct for `Style/StructInheritance` when extending instance of Struct without `do` ... `end` and class body is empty. ([@koic][])
* [#5953](https://github.com/rubocop/rubocop/issues/5953): Fix a false positive for `Style/AccessModifierDeclarations` when using `module_function` with symbol. ([@koic][])
* [#9593](https://github.com/rubocop/rubocop/issues/9593): Fix an error when processing a directory is named `{}`. ([@koic][])
* [#9599](https://github.com/rubocop/rubocop/issues/9599): Fix an error for `Style/CaseLikeIf` when using `include?` without a receiver. ([@koic][])
* [#9582](https://github.com/rubocop/rubocop/issues/9582): Fix incorrect auto-correct for `Style/ClassEqualityComparison` when comparing `Module#name` for equality. ([@koic][])
* [#9603](https://github.com/rubocop/rubocop/issues/9603): Fix a false positive for `Style/SoleNestedConditional` when using nested modifier on value assigned in condition. ([@koic][])
* [#9598](https://github.com/rubocop/rubocop/pull/9598): Fix RuboCop::MagicComment#valid_shareable_constant_value?. ([@kachick][])
* [#9625](https://github.com/rubocop/rubocop/pull/9625): Allow parentheses in yield arguments with `Style/MethodCallWithArgsParentheses` `EnforcedStyle: omit_parentheses` to fix invalid Ruby auto-correction. ([@gsamokovarov][])
* [#9558](https://github.com/rubocop/rubocop/issues/9558): Fix inconsistency when dealing with URIs that are wrapped in single quotes vs double quotes. ([@dvandersluis][])
* [#9613](https://github.com/rubocop/rubocop/issues/9613): Fix a false positive for `Style/RedundantSelf` when a self receiver on an lvalue of mlhs arguments. ([@koic][])
* [#9586](https://github.com/rubocop/rubocop/issues/9586): Update `Naming/RescuedExceptionsVariableName` to not register on inner rescues when nested. ([@dvandersluis][])

### Changes

* [#9487](https://github.com/rubocop/rubocop/issues/9487): Mark Naming/MemoizedInstanceVariableName as unsafe. ([@marcandre][])
* [#9601](https://github.com/rubocop/rubocop/issues/9601): Make `Style/RedundantBegin` aware of redundant `begin`/`end` blocks around memoization. ([@koic][])
* [#9617](https://github.com/rubocop/rubocop/issues/9617): Disable suggested extensions when using the `--stdin` option. ([@dvandersluis][])

[@koic]: https://github.com/koic
[@gsamokovarov]: https://github.com/gsamokovarov
[@fsateler]: https://github.com/fsateler
[@corroded]: https://github.com/corroded
[@dvandersluis]: https://github.com/dvandersluis
[@tejasbubane]: https://github.com/tejasbubane
[@kachick]: https://github.com/kachick
[@marcandre]: https://github.com/marcandre
