/*************************************************** */
/* Rule Set Based Access Control                     */
/*                                                   */
/* Author and (c) 1999-2007: Amon Ott <ao@rsbac.org> */
/*                                                   */
/* Last modified: 16/May/2007                        */
/*************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/getname.h>
#include "nls.h"

int main(int argc, char ** argv)
{
  int res = 0;
  int scripting = 0;
  char * progname = argv[0];

  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 's':
                scripting=1;
                break;
              case 'h':
                printf("Use: %s [-s]\n", progname);
                exit(0);
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
                exit(1);
            }
          pos++;
        }
      argv++;
      argc--;
    }
  res = rsbac_version();
  if(res<0)
    error_exit(res);

  if(scripting)
    printf("%u.%u.%u %u.%u.%u %s\n",
           RSBAC_VERSION_MAJOR,
           RSBAC_VERSION_MID,
           RSBAC_VERSION_MINOR,
           res >> 16,
           res >> 8 & 255,
           res & 255,
           RSBAC_VERSION);
  else
    printf("Tools: %u.%u.%u, Kernel: %u.%u.%u, Tools-String: %s\n",
           RSBAC_VERSION_MAJOR,
           RSBAC_VERSION_MID,
           RSBAC_VERSION_MINOR,
           res >> 16,
           res >> 8 & 255,
           res & 255,
           RSBAC_VERSION);
  return 0;
}
