// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from EventService.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl._event {
  public class Service : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("event.Service:1.0.0", null);

    public Service(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Service(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Service StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Service(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int INVALID_CHANNEL = 1;

    public class CreateChannelResult {
      public Com.Raritan.Idl._event.Channel _ret_;
    }

    public CreateChannelResult createChannel() {
      JsonObject _parameters = null;
      var _result = RpcCall("createChannel", _parameters);
      var _ret = new CreateChannelResult();
      _ret._ret_ = Com.Raritan.Idl._event.Channel.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
      return _ret;
    }

    public AsyncRequest createChannel(AsyncRpcResponse<CreateChannelResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return createChannel(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest createChannel(AsyncRpcResponse<CreateChannelResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("createChannel", _parameters,
        _result => {
          try {
            var _ret = new CreateChannelResult();
            _ret._ret_ = Com.Raritan.Idl._event.Channel.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DestroyChannelResult {
      public int _ret_;
    }

    public DestroyChannelResult destroyChannel(Com.Raritan.Idl._event.Channel channel) {
      var _parameters = new LightJson.JsonObject();
      _parameters["channel"] = channel != null ? channel.Encode() : JsonValue.Null;

      var _result = RpcCall("destroyChannel", _parameters);
      var _ret = new DestroyChannelResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest destroyChannel(Com.Raritan.Idl._event.Channel channel, AsyncRpcResponse<DestroyChannelResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return destroyChannel(channel, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest destroyChannel(Com.Raritan.Idl._event.Channel channel, AsyncRpcResponse<DestroyChannelResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["channel"] = channel != null ? channel.Encode() : JsonValue.Null;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("destroyChannel", _parameters,
        _result => {
          try {
            var _ret = new DestroyChannelResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class PushEventResult {
    }

    public PushEventResult pushEvent(Com.Raritan.Idl.idl.Event _event) {
      var _parameters = new LightJson.JsonObject();
      _parameters["event"] = ValueObjectCodec.Encode(_event);

      var _result = RpcCall("pushEvent", _parameters);
      var _ret = new PushEventResult();
      return _ret;
    }

    public AsyncRequest pushEvent(Com.Raritan.Idl.idl.Event _event, AsyncRpcResponse<PushEventResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return pushEvent(_event, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest pushEvent(Com.Raritan.Idl.idl.Event _event, AsyncRpcResponse<PushEventResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["event"] = ValueObjectCodec.Encode(_event);
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("pushEvent", _parameters,
        _result => {
          try {
            var _ret = new PushEventResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class PushEventsResult {
    }

    public PushEventsResult pushEvents(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.idl.Event> events) {
      var _parameters = new LightJson.JsonObject();
      _parameters["events"] = new JsonArray(events.Select(
        _value => (JsonValue)(ValueObjectCodec.Encode(_value))));

      var _result = RpcCall("pushEvents", _parameters);
      var _ret = new PushEventsResult();
      return _ret;
    }

    public AsyncRequest pushEvents(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.idl.Event> events, AsyncRpcResponse<PushEventsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return pushEvents(events, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest pushEvents(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.idl.Event> events, AsyncRpcResponse<PushEventsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["events"] = new JsonArray(events.Select(
          _value => (JsonValue)(ValueObjectCodec.Encode(_value))));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("pushEvents", _parameters,
        _result => {
          try {
            var _ret = new PushEventsResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
