% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{ci}
\alias{use_travis}
\alias{use_travis_badge}
\alias{use_appveyor}
\alias{use_appveyor_badge}
\alias{use_gitlab_ci}
\alias{use_circleci}
\alias{use_circleci_badge}
\title{Continuous integration setup and badges}
\usage{
use_travis(browse = rlang::is_interactive(), ext = c("com", "org"))

use_travis_badge(ext = c("com", "org"), repo_spec = NULL)

use_appveyor(browse = rlang::is_interactive())

use_appveyor_badge(repo_spec = NULL)

use_gitlab_ci()

use_circleci(browse = rlang::is_interactive(), image = "rocker/verse:latest")

use_circleci_badge(repo_spec = NULL)
}
\arguments{
\item{browse}{Open a browser window to enable automatic builds for the
package.}

\item{ext}{Which travis website to use. Defaults to \code{"com"} for
https://www.travis-ci.com/. Change to \code{"org"} for https://travis-ci.org.}

\item{repo_spec}{Optional GitHub repo specification in this form: \code{owner/repo}. This can usually be inferred from the GitHub remotes of active project.}

\item{image}{The Docker image to use for build. Must be available on
\href{https://hub.docker.com}{DockerHub}. The
\href{https://hub.docker.com/r/rocker/verse}{rocker/verse} image includes
TeXLive, pandoc, and the tidyverse packages. For a minimal image, try
\href{https://hub.docker.com/r/rocker/r-ver}{rocker/r-ver}. To specify a version
of R, change the tag from \code{latest} to the version you want, e.g.
\verb{rocker/r-ver:3.5.3}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Some of these functions are now soft-deprecated since the tidyverse team has
started using \href{https://github.com/features/actions}{GitHub Actions (GHA)} for
continuous integration (CI). See \code{\link[=use_github_actions]{use_github_actions()}} for help configuring
GHA. GHA functionality in usethis is actively maintained and exercised, which
is no longer true for Travis-CI or AppVeyor.

Sets up third-party continuous integration (CI) services for an R package
that is developed on GitHub or, perhaps, GitLab. These functions
\itemize{
\item Add service-specific configuration files and add them to \code{.Rbuildignore}.
\item Activate a service or give the user a detailed prompt.
\item Provide the markdown to insert a badge into README.
}
}
\section{\code{use_travis()}}{

Adds a basic \code{.travis.yml} to the top-level directory of a package. This is a
configuration file for the \href{https://www.travis-ci.com/}{Travis CI} continuous
integration service.
}

\section{\code{use_travis_badge()}}{

Only adds the Travis CI badge. Use for a project where Travis is already
configured.
}

\section{\code{use_appveyor()}}{

Adds a basic \code{appveyor.yml} to the top-level directory of a package. This is
a configuration file for the \href{https://www.appveyor.com}{AppVeyor} continuous
integration service for Windows.
}

\section{\code{use_appveyor_badge()}}{

Only adds the \href{https://www.appveyor.com}{AppVeyor} badge. Use for a project
where AppVeyor is already configured.
}

\section{\code{use_gitlab_ci()}}{

Adds a basic \code{.gitlab-ci.yml} to the top-level directory of a package. This
is a configuration file for the \href{https://docs.gitlab.com/ee/ci/}{GitLab CI/CD} continuous integration service.
}

\section{\code{use_circleci()}}{

Adds a basic \code{.circleci/config.yml} to the top-level directory of a package.
This is a configuration file for the \href{https://circleci.com/}{CircleCI}
continuous integration service.
}

\section{\code{use_circleci_badge()}}{

Only adds the \href{https://circleci.com/}{Circle CI} badge. Use for a project
where Circle CI is already configured.
}

