% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify-output.R
\name{verify_output}
\alias{verify_output}
\title{Verify output}
\usage{
verify_output(
  path,
  code,
  width = 80,
  crayon = FALSE,
  unicode = FALSE,
  env = caller_env()
)
}
\arguments{
\item{path}{Path to record results.

This should usually be a call to \code{\link[=test_path]{test_path()}} in order to ensure that
the same path is used when run interactively (when the working directory
is typically the project root), and when run as an automated test (when
the working directory will be \code{tests/testthat}).}

\item{code}{Code to execute. This will usually be a multiline expression
contained within \code{{}} (similarly to \code{test_that()} calls).}

\item{width}{Width of console output}

\item{crayon}{Enable crayon package colouring?}

\item{unicode}{Enable cli package UTF-8 symbols? If you set this to
\code{TRUE}, call \code{skip_if(!cli::is_utf8_output())} to disable the
test on your CI platforms that don't support UTF-8 (e.g. Windows).}

\item{env}{The environment to evaluate \code{code} in.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

This function is superseded in favour of \code{expect_snapshot()} and friends.

This is a regression test that records interwoven code and output into a
file, in a similar way to knitting an \code{.Rmd} file (but see caveats below).

\code{verify_output()} is designed particularly for testing print methods and error
messages, where the primary goal is to ensure that the output is helpful to
a human. Obviously, you can't test that with code, so the best you can do is
make the results explicit by saving them to a text file. This makes the output
easy to verify in code reviews, and ensures that you don't change the output
by accident.

\code{verify_output()} is designed to be used with git: to see what has changed
from the previous run, you'll need to use \verb{git diff} or similar.
}
\section{Syntax}{

\code{verify_output()} can only capture the abstract syntax tree, losing all
whitespace and comments. To mildly offset this limitation:
\itemize{
\item Strings are converted to R comments in the output.
\item Strings starting with \verb{# } are converted to headers in the output.
}
}

\section{CRAN}{

On CRAN, \code{verify_output()} will never fail, even if the output changes.
This avoids false positives because tests of print methods and error
messages are often fragile due to implicit dependencies on other packages,
and failure does not imply incorrect computation, just a change in
presentation.
}

\keyword{internal}
