% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-equality.R
\name{equality-expectations}
\alias{equality-expectations}
\alias{expect_equal}
\alias{expect_equivalent}
\alias{expect_identical}
\alias{expect_reference}
\title{Expectation: is the object equal to a value?}
\usage{
expect_equal(object, expected, ..., info = NULL, label = NULL,
  expected.label = NULL)

expect_equivalent(object, expected, ..., info = NULL, label = NULL,
  expected.label = NULL)

expect_identical(object, expected, info = NULL, label = NULL,
  expected.label = NULL, ...)

expect_reference(object, expected, info = NULL, label = NULL,
  expected.label = NULL)
}
\arguments{
\item{object, expected}{Computation and value to compare it to.

Both arguments supports limited unquoting to make it easier to generate
readable failures within a function or for loop. See \link{quasi_label} for
more details.}

\item{...}{For \code{expect_equal()} and \code{expect_equivalent()}, passed on
\code{\link[=compare]{compare()}}, for \code{expect_identical()} passed on to \code{\link[=identical]{identical()}}.
Used to control the details of the comparison.}

\item{info}{Extra information to be included in the message. This argument
is soft-deprecated and should not be used in new code. Instead see
alternatives in \link{quasi_label}.}

\item{label, expected.label}{Used to customise failure messages. For expert
use only.}
}
\description{
\itemize{
\item \code{expect_identical()} compares values with \code{\link[=identical]{identical()}}.
\item \code{expect_equal()} compares values  with \code{\link[=all.equal]{all.equal()}}
\item \code{expect_equivalent()} compares values with \code{\link[=all.equal]{all.equal()}} and
\code{check.attributes = FALSE}
\item \code{expect_reference()} compares the underlying memory addresses.
}
}
\examples{
a <- 10
expect_equal(a, 10)

# Use expect_equal() when testing for numeric equality
sqrt(2) ^ 2 - 1
expect_equal(sqrt(2) ^ 2, 2)
# Neither of these forms take floating point representation errors into
# account
\dontrun{
expect_true(sqrt(2) ^ 2 == 2)
expect_identical(sqrt(2) ^ 2, 2)
}

# You can pass on additional arguments to all.equal:
\dontrun{
# Test the ABSOLUTE difference is within .002
expect_equal(10.01, 10, tolerance = .002, scale = 1)
}

# Test the RELATIVE difference is within .002
x <- 10
expect_equal(10.01, expected = x, tolerance = 0.002, scale = x)

# expect_equivalent ignores attributes
a <- b <- 1:3
names(b) <- letters[1:3]
expect_equivalent(a, b)
}
\seealso{
\code{expect_setequal()} to test for set equality.

Other expectations: \code{\link{comparison-expectations}},
  \code{\link{expect_error}}, \code{\link{expect_length}},
  \code{\link{expect_match}}, \code{\link{expect_message}},
  \code{\link{expect_named}}, \code{\link{expect_null}},
  \code{\link{expect_output}}, \code{\link{expect_silent}},
  \code{\link{inheritance-expectations}},
  \code{\link{logical-expectations}}
}
\concept{expectations}
