% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_tests.R
\name{extract_tests}
\alias{extract_tests}
\title{Extract tests from source}
\usage{
extract_tests(pkg = ".", filter = NULL,
  verbose = getOption("verbose", FALSE), full.path = NA,
  force = FALSE)
}
\arguments{
\item{pkg}{The root directory of the package.}

\item{filter}{If specified, only tests from files matching
this regular expression are extracted.}

\item{verbose}{Print message?}

\item{full.path}{Include full file paths in generated files.
TRUE, indicates full path,
FALSE, indicated only basename, and
NA(default) implies path relative to \code{pkg}.}

\item{force}{Force test extraction even if the generated test file
is newer than the corresponding source file.}
}
\description{
Use this function to extract tests from package source files.
In-source testing blocks are contained in blocks that are prevented
from running when sourced by an \code{if(FALSE){...}} statement.
It also contains a documentation tag to denote a testing block.
}
\details{
The first line of the block should look similar to\preformatted{    if(FALSE){#@testing [optional information]
    ...
    }
}
}
\examples{
\dontrun{
# Extract all files
extract_tests('.')

# Extract only files that start with 'Class-' or 'class-'
extract_tests('.', filter="^[Cc]lass-.*\\\\.[Rr]$")
}
}
