% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{new_node}
\alias{new_node}
\alias{node_car}
\alias{node_cdr}
\alias{node_caar}
\alias{node_cadr}
\alias{node_cdar}
\alias{node_cddr}
\alias{node_poke_car}
\alias{node_poke_cdr}
\alias{node_poke_caar}
\alias{node_poke_cadr}
\alias{node_poke_cdar}
\alias{node_poke_cddr}
\alias{node_tag}
\alias{node_poke_tag}
\title{Helpers for pairlist and language nodes}
\usage{
new_node(car, cdr = NULL)

node_car(x)

node_cdr(x)

node_caar(x)

node_cadr(x)

node_cdar(x)

node_cddr(x)

node_poke_car(x, newcar)

node_poke_cdr(x, newcdr)

node_poke_caar(x, newcar)

node_poke_cadr(x, newcar)

node_poke_cdar(x, newcdr)

node_poke_cddr(x, newcdr)

node_tag(x)

node_poke_tag(x, newtag)
}
\arguments{
\item{car, newcar, cdr, newcdr}{The new CAR or CDR for the node. These
can be any R objects.}

\item{x}{A language or pairlist node. Note that these functions are
barebones and do not perform any type checking.}

\item{newtag}{The new tag for the node. This should be a symbol.}
}
\value{
Setters like \code{node_poke_car()} invisibly return \code{x} modified
in place. Getters return the requested node component.
}
\description{
\strong{Important}: These functions are for expert R programmers only.
You should only use them if you feel comfortable manipulating low
level R data structures at the C level. We export them at R level
in order to make it easy to prototype C code. They don't perform
any type checking and can crash R very easily (try to take the CAR
of an integer vector --- save any important object beforehand!).
}
\seealso{
\code{\link[=duplicate]{duplicate()}} for creating copy-safe objects and
\code{\link[base:pairlist]{base::pairlist()}} for an easier way of creating a linked list of
nodes.
}
\keyword{internal}
