% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degseq.R
\name{is_degseq}
\alias{is_degseq}
\alias{is.degree.sequence}
\title{Check if a degree sequence is valid for a multi-graph}
\usage{
is_degseq(out.deg, in.deg = NULL)
}
\arguments{
\item{out.deg}{Integer vector, the degree sequence for undirected graphs, or
the out-degree sequence for directed graphs.}

\item{in.deg}{\code{NULL} or an integer vector. For undireted graphs, it
should be \code{NULL}. For directed graphs it specifies the in-degrees.}
}
\value{
A logical scalar.
}
\description{
\code{is_degseq} checks whether the given vertex degrees (in- and
out-degrees for directed graphs) can be realized by a graph. Note that the
graph does not have to be simple, it may contain loop and multiple edges.
For undirected graphs, it also checks whether the sum of degrees is even.
For directed graphs, the function checks whether the lengths of the two
degree vectors are equal and whether their sums are also equal. These are
known sufficient and necessary conditions for a degree sequence to be valid.
}
\references{
Hakimi SL: On the realizability of a set of integers as degrees
of the vertices of a simple graph. \emph{J SIAM Appl Math} 10:496-506, 1962.

PL Erdos, I Miklos and Z Toroczkai: A simple Havel-Hakimi type algorithm to
realize graphical degree sequences of directed graphs.  \emph{The Electronic
Journal of Combinatorics} 17(1):R66, 2010.
}
\seealso{
Other graphical degree sequences

g <- sample_gnp(100, 2/100)
is_degseq(degree(g))
is_graphical(degree(g)): \code{\link{is_graphical}}
}
\author{
Tamas Nepusz \email{ntamas@gmail.com}
}
\keyword{graphs}
