% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-device.R
\name{req_oauth_device}
\alias{req_oauth_device}
\alias{oauth_flow_device}
\title{OAuth with device flow}
\usage{
req_oauth_device(
  req,
  client,
  auth_url,
  scope = NULL,
  auth_params = list(),
  token_params = list(),
  cache_disk = FALSE,
  cache_key = NULL
)

oauth_flow_device(
  client,
  auth_url,
  pkce = FALSE,
  scope = NULL,
  auth_params = list(),
  token_params = list()
)
}
\arguments{
\item{req}{A \link{request}.}

\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{auth_url}{Authorization url; you'll need to discover this by reading
the documentation.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{auth_params}{A list containing additional parameters passed to
\code{\link[=oauth_flow_auth_code_url]{oauth_flow_auth_code_url()}}.}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}

\item{cache_disk}{Should the access token be cached on disk? This reduces
the number of times that you need to re-authenticate at the cost of
storing access credentials on disk.

Learn more in \code{vignette("oauth")}}

\item{cache_key}{If you want to cache multiple tokens per app, use this
key to disambiguate them.}

\item{pkce}{Use "Proof Key for Code Exchange"? This adds an extra layer of
security and should always be used if supported by the server.}
}
\value{
\code{req_oauth_device()} returns a modified HTTP \link{request} that will
use OAuth; \code{oauth_flow_device()} returns an \link{oauth_token}.
}
\description{
Authenticate using the OAuth \strong{device flow}, as defined by \href{https://datatracker.ietf.org/doc/html/rfc8628}{RFC 8628}.
It's designed for devices that don't have access to a web browser (if you've
ever authenticated an app on your TV, this is probably the flow you've used),
but it also works well from within R.

Learn more about the overall OAuth authentication flow in \code{vignette("oauth")}.
}
\examples{
req_auth_github <- function(req) {
  req_oauth_device(
    req,
    client = example_github_client(),
    auth_url = "https://github.com/login/device/code"
  )
}

request("https://api.github.com/user") |>
  req_auth_github()
}
