% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_dynamic.R
\name{layout_dynamic}
\alias{layout_dynamic}
\alias{layout_as_dynamic}
\title{dynamic graph layout}
\usage{
layout_as_dynamic(gList, weights = NA, alpha = 0.5, iter = 500, tol = 1e-04)
}
\arguments{
\item{gList}{list of igraph objects. Each network must contain the same set of nodes.}

\item{weights}{possibly a numeric vector with edge weights. If this is NULL and the graph has a weight edge attribute, then the attribute is used. If this is NA then no weights are used (even if the graph has a weight attribute). By default, weights are ignored. See details for more.}

\item{alpha}{weighting of reference layout. See details.}

\item{iter}{number of iterations during stress optimization}

\item{tol}{stopping criterion for stress optimization}
}
\value{
list of coordinates for each graph
}
\description{
Create layouts for longitudinal networks.
}
\details{
The reference layout is calculated based on the union of all graphs. The parameter alpha controls the influence of the reference layout.
For alpha=1, only the reference layout is used and all graphs have the same layout. For alpha=0, the stress layout of each individual graph is used. Values in-between interpolate between the two layouts.

Be careful when using weights. In most cases, the inverse of the edge weights should be used to ensure that the endpoints of an edges with higher weights are closer together (weights=1/E(g)$weight).
}
\examples{
library(igraph)
g1 <- sample_gnp(20, 0.2)
g2 <- sample_gnp(20, 0.2)
g3 <- sample_gnp(20, 0.2)

xy <- layout_as_dynamic(list(g1, g2, g3))

# layout for first network
xy[[1]]
}
\references{
Brandes, U. and Indlekofer, N. and Mader, M. (2012). Visualization methods for longitudinal social networks and stochastic actor-oriented modeling. \emph{Social Networks} 34 (3) 291-308
}
