% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheets_id-class.R
\name{sheets_id}
\alias{sheets_id}
\alias{as_sheets_id}
\title{\code{sheets_id} class}
\usage{
as_sheets_id(x, ...)
}
\arguments{
\item{x}{Something that contains a Google Sheet id: an id string, a
\code{\link[googledrive:as_id]{drive_id}}, a URL, a one-row
\code{\link[googledrive:dribble]{dribble}}, or a \code{googlesheets4_spreadsheet}.}

\item{...}{Other arguments passed down to methods. (Not used.)}
}
\description{
\code{sheets_id} is an S3 class that marks a string as a Google Sheet's id, which
the Sheets API docs refer to as \code{spreadsheetId}.

Any object of class \code{sheets_id} also has the \code{\link[googledrive:as_id]{drive_id}}
class, which is used by \link{googledrive} for the same purpose. This means you
can provide a \code{sheets_id} to \link{googledrive} functions, in order to do anything
with your Sheet that has nothing to do with it being a spreadsheet. Examples:
change the Sheet's name, parent folder, or permissions. Read more about using
\link{googlesheets4} and \link{googledrive} together in \code{vignette("drive-and-sheets")}.
Note that a \code{sheets_id} object is intended to hold \strong{just one} id, while the
parent class \code{drive_id} can be used for multiple ids.

\code{as_sheets_id()} is a generic function that converts various inputs into an
instance of \code{sheets_id}. See more below.

When you print a \code{sheets_id}, we attempt to reveal the Sheet's current
metadata, via \code{\link[=gs4_get]{gs4_get()}}. This can fail for a variety of reasons (e.g. if
you're offline), but the input \code{sheets_id} is always revealed and returned,
invisibly.
}
\section{\code{as_sheets_id()}}{


These inputs can be converted to a \code{sheets_id}:
\itemize{
\item Spreadsheet id, "a string containing letters, numbers, and some special
characters", typically 44 characters long, in our experience. Example:
\verb{1qpyC0XzvTcKT6EISywvqESX3A0MwQoFDE8p-Bll4hps}.
\item A URL, from which we can excavate a spreadsheet or file id. Example:
\code{"https://docs.google.com/spreadsheets/d/1BzfL0kZUz1TsI5zxJF1WNF01IxvC67FbOJUiiGMZ_mQ/edit#gid=1150108545"}.
\item A one-row \code{\link[googledrive:dribble]{dribble}}, a "Drive tibble" used by the
\link{googledrive} package. In general, a \code{dribble} can represent several
files, one row per file. Since googlesheets4 is not vectorized over
spreadsheets, we are only prepared to accept a one-row \code{dribble}.
\itemize{
\item \code{\link[googledrive:drive_get]{googledrive::drive_get("YOUR_SHEET_NAME")}}
is a great way to look up a Sheet via its name.
\item \code{\link[=gs4_find]{gs4_find("YOUR_SHEET_NAME")}} is another good way
to get your hands on a Sheet.
}
\item Spreadsheet meta data, as returned by, e.g., \code{\link[=gs4_get]{gs4_get()}}. Literally,
this is an object of class \code{googlesheets4_spreadsheet}.
}
}

\examples{
\dontshow{if (gs4_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mini_gap_id <- gs4_example("mini-gap")
class(mini_gap_id)
mini_gap_id

as_sheets_id("abc")
\dontshow{\}) # examplesIf}
}
\seealso{
\link[googledrive:as_id]{googledrive::as_id}
}
