% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{tab_settings}
\alias{tab_settings}
\title{Set tabulation marks configuration}
\usage{
tab_settings(x, i = NULL, j = NULL, value = TRUE, part = "body")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{value}{an object generated by \code{\link[officer:fp_tabs]{officer::fp_tabs()}}.}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}
}
\description{
Define tabulation marks configuration.
Specifying the positions and types of tabulation marks in table
paragraphs helps organize content, especially in clinical tables,
by aligning numbers properly.
}
\examples{
library(officer)
library(flextable)

z <- data.frame(
  Statistic = c("Median (Q1 ; Q3)", "Min ; Max"),
  Value = c(
    "\t999.99\t(99.9 ; 99.9)",
    "\t9.99\t(9999.9 ; 99.9)"
  )
)

ts <- fp_tabs(
  fp_tab(pos = 0.4, style = "decimal"),
  fp_tab(pos = 1.4, style = "decimal")
)

zz <- flextable(z)
zz <- tab_settings(zz, j = 2, value = ts)
zz <- width(zz, width = c(1.5, 2))


save_as_docx(zz, path = tempfile(fileext = ".docx"))
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{font}()},
\code{\link{fontsize}()},
\code{\link{highlight}()},
\code{\link{italic}()},
\code{\link{keep_with_next}()},
\code{\link{line_spacing}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{style}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
