% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.emm.R
\name{plot.emmGrid}
\alias{plot.emmGrid}
\alias{plot.summary_emm}
\title{Plot an \code{emmGrid} or \code{summary_emm} object}
\usage{
\method{plot}{emmGrid}(x, y, type, CIs = TRUE, PIs = FALSE,
  comparisons = FALSE, colors = c("black", "blue", "blue", "red"),
  alpha = 0.05, adjust = "tukey", int.adjust = "none", intervals,
  frequentist, ...)

\method{plot}{summary_emm}(x, y, horizontal = TRUE, CIs = TRUE, xlab, ylab,
  layout, colors = c("black", "blue", "blue", "red"), intervals, ...)
}
\arguments{
\item{x}{Object of class \code{emmGrid} or \code{summary_emm}}

\item{y}{(Required but ignored)}

\item{type}{Character value specifying the type of prediction desired
(matching \code{"linear.predictor"}, \code{"link"}, or \code{"response"}).
See details under \code{\link{summary.emmGrid}}.}

\item{CIs}{Logical value. If \code{TRUE}, confidence intervals are
plotted for each estimate.}

\item{PIs}{Logical value. If \code{TRUE}, prediction intervals are
plotted for each estimate. If \code{objecct} is a Bayesian model,
this requires \code{frequentist = TRUE} and \code{sigma =} (some value).
Note that the \code{PIs} option is \emph{not} available with
\code{summary_emm} objects -- only for \code{emmGrid} objects.
Also, prediction intervals are not available
with \code{engine = "lattice"}.}

\item{comparisons}{Logical value. If \code{TRUE}, \dQuote{comparison arrows}
are added to the plot, in such a way that the degree to which arrows
overlap reflects as much as possible the significance of the comparison of
the two estimates. (A warning is issued if this can't be done.)}

\item{colors}{Character vector of color names to use for estimates, CIs, PIs, 
and comparison arrows, respectively. CIs and PIs are rendered with some
transparency, and colors are recycled if the length is less than four;
so all plot elements are visible even if a single color is specified.}

\item{alpha}{The significance level to use in constructing comparison arrows}

\item{adjust}{Character value: Multiplicity adjustment method for comparison arrows \emph{only}.}

\item{int.adjust}{Character value: Multiplicity adjustment method for the plotted confidence intervals \emph{only}.}

\item{intervals}{If specified, it is used to set \code{CIs}. This is the previous
name of \code{CIs} and is provided for backward compatibility.}

\item{frequentist}{Logical value. If there is a posterior MCMC sample and 
\code{frequentist} is non-missing and TRUE, a frequentist summary is used for
obtaining the plot data, rather than the posterior point estimate and HPD
intervals. This argument is ignored when it is not a Bayesian model.}

\item{...}{Additional arguments passed to \code{\link{update.emmGrid}}, 
\code{\link{predict.emmGrid}}, or
\code{\link[lattice:xyplot]{dotplot}}}

\item{horizontal}{Logical value specifying whether the intervals should be
plotted horizontally or vertically}

\item{xlab}{Character label for horizontal axis}

\item{ylab}{Character label for vertical axis}

\item{layout}{Numeric value passed to \code{\link[lattice:xyplot]{dotplot}}}
}
\description{
Methods are provided to plot EMMs as side-by-side CIs, and optionally to display 
  \dQuote{comparison arrows} for displaying pairwise comparisons.
}
\section{Details}{

If any \code{by} variables are in force, the plot is divided into separate
panels. These functions use the \code{\link[lattice:xyplot]{dotplot}} function, and
thus require that the \pkg{lattice} package be installed. For
\code{"summary_emm"} objects, the \code{\dots} arguments in \code{plot}
are passed \emph{only} to \code{dotplot}, whereas for \code{"emmGrid"}
objects, the object is updated using \code{\dots} before summarizing and
plotting.

In plots with \code{comparisons = TRUE}, the resulting arrows are only
approximate, and in some cases may fail to accurately reflect the pairwise
comparisons of the estimates -- especially when estimates having large and
small standard errors are intermingled in just the wrong way. Note that the
maximum and minimum estimates have arrows only in one direction, since there
is no need to compare them with anything higher or lower, respectively.

If \code{adjust} or \code{int.adjust} are not supplied, they default to the 
internal \code{adjust} setting saved in \code{pairs(x)} and \code{x} 
respectively (see \code{\link{update.emmGrid}}).
}

\examples{
warp.lm <- lm(breaks ~ wool * tension, data = warpbreaks)
warp.emm <- emmeans(warp.lm, ~ tension | wool)
plot(warp.emm)
plot(warp.emm, by = NULL, comparisons = TRUE, adjust = "mvt", 
     horizontal = FALSE, colors = "darkgreen")
}
