% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plm-tidiers.R
\name{glance.plm}
\alias{glance.plm}
\title{Glance at a(n) plm object}
\usage{
\method{glance}{plm}(x, ...)
}
\arguments{
\item{x}{A \code{plm} objected returned by \code{\link[plm:plm]{plm::plm()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A one-row \link[tibble:tibble]{tibble::tibble} with columns:

\item{r.squared}{The percent of variance explained by the model}
\item{adj.r.squared}{r.squared adjusted based on the degrees of freedom}
\item{statistic}{F-statistic}
\item{p.value}{p-value from the F test, describing whether the full
regression is significant}
\item{deviance}{deviance}
\item{df.residual}{residual degrees of freedom}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modelling
function. This includes the name of the modelling function or any
arguments passed to the modelling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.
}
\seealso{
\code{\link[=glance]{glance()}}, \code{\link[plm:plm]{plm::plm()}}

Other plm tidiers: 
\code{\link{augment.plm}()},
\code{\link{tidy.plm}()}
}
\concept{plm tidiers}
