% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muhaz_tidiers.R
\name{muhaz_tidiers}
\alias{muhaz_tidiers}
\alias{tidy.muhaz}
\alias{glance.muhaz}
\title{Tidying methods for kernel based hazard rate estimates}
\usage{
\method{tidy}{muhaz}(x, ...)

\method{glance}{muhaz}(x, ...)
}
\arguments{
\item{x}{\code{muhaz} object}

\item{...}{extra arguments (not used)}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy.muhaz} returns a tibble containing two columns:
\code{time} at which the hazard rate was estimated and \code{estimate}.

\code{glance.muhaz} returns a one-row data.frame with the columns
  \item{nobs}{Number of observations used for estimation}
  \item{min.time}{The minimum observed event or censoring time}
  \item{max.time}{The maximum observed event or censoring time}
  \item{min.harzard}{Minimal estimated hazard}
  \item{max.hazard}{Maximal estimated hazard}
}
\description{
These methods tidy the output of \code{muhaz} objects as returned by the
\code{\link[muhaz]{muhaz}} function, which provides kernel based
non-parametric hazard rate estimators.
}
\details{
The "augment" method is not useful and therefore not
available for \code{muhaz} objects.
}
\examples{
if (require("muhaz", quietly = TRUE)) {
  data(ovarian, package="survival")
  x <- muhaz(ovarian$futime, ovarian$fustat)
  tidy(x)
  glance(x)
}

}
