\name{summary.bma}
\alias{summary.bma}
\alias{info.bma}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{  Summary Statistics for a 'bma' Object }
\description{
  Returns a vector with summary statistics for a 'bma' object
}
\usage{
 \method{summary}{bma}(object,...)

## or
info.bma(object,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{ a list/object of class 'bma' that typically results from the function \code{bms} (see \code{\link{bms}} for details) }
  \item{\dots}{further arguments passed to or from other methods}
}
\details{
  \code{info.bma} is equivalent to \code{summary.bma}, its argument \code{bmao} conforms to the argument \code{object}
}
\value{
  A character vector summarizing the results of a call to \code{bms}
  \item{Mean no. of Regressors}{ the posterior mean of model size}
  \item{Draws}{the number of iterations (ex burn-ins)}
  \item{Burnins}{the number of burn-in iterations}
  \item{Time}{the time spent on iterating through the model space}
  \item{No. of models visited}{the number of times a model was accepted (including burn-ins)}
  \item{Modelspace \eqn{2^K}}{the total model space \eqn{2^K}}
  \item{Percentage visited}{\code{No. of models visited/Modelspace*100}}
  \item{Percentage Topmodels}{number of times the best models were drawn in percent of \code{Draws}}
  \item{Corr. PMP}{the correlation between the MCMC frequencies of the best models (the number of times they were drawn) and their marginal likelihoods.}
  \item{No. Obs.}{Number of observations}
  \item{Model Prior}{a character conforming to the argument \code{mprior} of \code{bms}, and the expected prior model size}
  \item{g-prior}{a character corresponding to argument \code{g} of function \code{bms}}
  \item{Shrinkage-Stats}{Posterior expected value und standard deviation (if applicable) of the shrinkage factor. Only included if argument \code{g.stats} of function \code{bms} was set to TRUE}
  
}
%\references{ ~put references to the literature/web site here ~ }
\author{Martin Feldkircher and Stefan Zeugner}
\note{ All of the above statistics can also be directly extracted from the bma object (\code{bmao}). Therefore \code{summary.bma} only returns a character vector.}
\seealso{ \code{\link{bms}} and \code{\link{c.bma}} for functions creating bma objects, \code{\link{print.bma}} makes use of \code{summary.bma}.

Check \url{http://bms.zeugner.eu} for additional help.}
\examples{
  data(datafls)

  m_fixed=bms(datafls,burn=1000,iter=3000,user.int=FALSE, )
  summary(m_fixed)
   
  m_ebl=bms(datafls,burn=1000,iter=3000,user.int=FALSE, g="EBL",g.stats=TRUE)
  info.bma(m_ebl)

}
\keyword{utilities}
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
