% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{TCGAvisualize_PCA}
\alias{TCGAvisualize_PCA}
\title{Principal components analysis (PCA) plot}
\usage{
TCGAvisualize_PCA(dataFilt, dataDEGsFiltLevel, ntopgenes, group1, group2)
}
\arguments{
\item{dataFilt}{A filtered dataframe or numeric matrix where each row represents a gene,
each column represents a sample from function TCGAanalyze_Filtering}

\item{dataDEGsFiltLevel}{table with DEGs, log Fold Change (FC), false discovery rate (FDR),
the gene expression level, etc, from function TCGAanalyze_LevelTab.}

\item{ntopgenes}{number of DEGs genes to plot in PCA}

\item{group1}{a string containing the barcode list of the samples in in control group}

\item{group2}{a string containing the barcode list of the samples in in disease group
the name of the group}
}
\value{
principal components analysis (PCA) plot of PC1 and PC2
}
\description{
TCGAvisualize_PCA performs a principal components analysis (PCA) on the given data matrix
  and returns the results as an object of class prcomp, and shows results in PCA level.
}
\examples{
# normalization of genes
dataNorm <- TCGAbiolinks::TCGAanalyze_Normalization(tabDF = dataBRCA, geneInfo = geneInfo,
method = "geneLength")
# quantile filter of genes
dataFilt <- TCGAanalyze_Filtering(tabDF = dataBRCA, method = "quantile", qnt.cut =  0.25)
# Principal Component Analysis plot for ntop selected DEGs
    # selection of normal samples "NT"
    group1 <- TCGAquery_SampleTypes(colnames(dataFilt), typesample = c("NT"))
    # selection of normal samples "TP"
    group2 <- TCGAquery_SampleTypes(colnames(dataFilt), typesample = c("TP"))
pca <- TCGAvisualize_PCA(dataFilt,dataDEGsFiltLevel, ntopgenes = 200, group1, group2)
}
