% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchPermissions.R
\name{fetchPermissions}
\alias{fetchPermissions}
\title{Fetch project permissions}
\usage{
fetchPermissions(project, url = restUrl(), config = NULL)
}
\arguments{
\item{project}{String containing the project name.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{config}{Deprecated and ignored.}
}
\value{
List containing the permissions for this project.
This has the following elements:
\itemize{
\item \code{owners}, a character vector containing the GitHub users or organizations that are owners of this project.
\item \code{uploaders}, a list of lists specifying the users or organizations who are authorzied to upload to this project.
Each entry is a list with the following fields:
\itemize{
\item \code{id}, a string containing the GitHub user or organization that is authorized to upload.
\item (optional) \code{asset}, a string containing the name of the asset that the uploader is allowed to upload to.
If not provided, there is no restriction on the uploaded asset name.
\item (optional) \code{version}, a string containing the name of the version that the uploader is allowed to upload to.
If not provided, there is no restriction on the uploaded version name.
\item (optional) \code{until}, a \link{POSIXct} object containing the expiry date of this authorization.
If not provided, the authorization does not expire.
\item (optional) \code{trusted}, whether the uploader is trusted.
If not provided, defaults to \code{FALSE}.
}
}
}
\description{
Fetch the permissions for a project.
}
\examples{
fetchPermissions("test-R")

}
\seealso{
\code{\link{setPermissions}}, to set the permissions.
}
\author{
Aaron Lun
}
