/*
//
// Copyright (c) 2002-2014 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//

This file contains the Yacc grammar for GLSL ES.
Based on ANSI C Yacc grammar:
http://www.lysator.liu.se/c/ANSI-C-grammar-y.html

IF YOU MODIFY THIS FILE YOU ALSO NEED TO RUN generate_parser.sh,
WHICH GENERATES THE GLSL ES PARSER (glslang_tab.cpp AND glslang_tab.h).
*/

%{
//
// Copyright (c) 2002-2014 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//

// This file is auto-generated by generate_parser.sh. DO NOT EDIT!

// Ignore errors in auto-generated code.
#if defined(__GNUC__)
#pragma GCC diagnostic ignored "-Wunused-function"
#pragma GCC diagnostic ignored "-Wunused-variable"
#pragma GCC diagnostic ignored "-Wswitch-enum"
#elif defined(_MSC_VER)
#pragma warning(disable: 4065)
#pragma warning(disable: 4189)
#pragma warning(disable: 4244)
#pragma warning(disable: 4505)
#pragma warning(disable: 4701)
#pragma warning(disable: 4702)
#endif

#include "angle_gl.h"
#include "compiler/translator/SymbolTable.h"
#include "compiler/translator/ParseContext.h"
#include "GLSLANG/ShaderLang.h"

#define YYENABLE_NLS 0

%}
%expect 1 /* One shift reduce conflict because of if | else */
%parse-param {TParseContext* context}
%param   {void *scanner}
%define api.pure full
%locations

%code requires {
#define YYLTYPE TSourceLoc
#define YYLTYPE_IS_DECLARED 1
}

%union {
    struct {
        union {
            TString *string;
            float f;
            int i;
            unsigned int u;
            bool b;
        };
        TSymbol* symbol;
    } lex;
    struct {
        TOperator op;
        union {
            TIntermNode* intermNode;
            TIntermNodePair nodePair;
            TIntermTyped* intermTypedNode;
            TIntermAggregate* intermAggregate;
            TIntermSwitch* intermSwitch;
            TIntermCase* intermCase;
        };
        union {
            TPublicType type;
            TPrecision precision;
            TLayoutQualifier layoutQualifier;
            TQualifier qualifier;
            TFunction* function;
            TParameter param;
            TField* field;
            TFieldList* fieldList;
        };
    } interm;
}

%{
extern int yylex(YYSTYPE* yylval, YYLTYPE* yylloc, void* yyscanner);
extern void yyerror(YYLTYPE* yylloc, TParseContext* context, void *scanner, const char* reason);

#define YYLLOC_DEFAULT(Current, Rhs, N)                      \
  do {                                                       \
      if (N) {                                         \
        (Current).first_file = YYRHSLOC(Rhs, 1).first_file;  \
        (Current).first_line = YYRHSLOC(Rhs, 1).first_line;  \
        (Current).last_file = YYRHSLOC(Rhs, N).last_file;    \
        (Current).last_line = YYRHSLOC(Rhs, N).last_line;    \
      }                                                      \
      else {                                                 \
        (Current).first_file = YYRHSLOC(Rhs, 0).last_file;   \
        (Current).first_line = YYRHSLOC(Rhs, 0).last_line;   \
        (Current).last_file = YYRHSLOC(Rhs, 0).last_file;    \
        (Current).last_line = YYRHSLOC(Rhs, 0).last_line;    \
      }                                                      \
  } while (0)

#define VERTEX_ONLY(S, L) {  \
    if (context->shaderType != GL_VERTEX_SHADER) {  \
        context->error(L, " supported in vertex shaders only ", S);  \
        context->recover();  \
    }  \
}

#define FRAG_ONLY(S, L) {  \
    if (context->shaderType != GL_FRAGMENT_SHADER) {  \
        context->error(L, " supported in fragment shaders only ", S);  \
        context->recover();  \
    }  \
}

#define ES2_ONLY(S, L) {  \
    if (context->shaderVersion != 100) {  \
        context->error(L, " supported in GLSL ES 1.00 only ", S);  \
        context->recover();  \
    }  \
}

#define ES3_ONLY(TOKEN, LINE, REASON) {  \
    if (context->shaderVersion != 300) {  \
        context->error(LINE, REASON " supported in GLSL ES 3.00 only ", TOKEN);  \
        context->recover();  \
    }  \
}
%}

%token <lex> INVARIANT HIGH_PRECISION MEDIUM_PRECISION LOW_PRECISION PRECISION
%token <lex> ATTRIBUTE CONST_QUAL BOOL_TYPE FLOAT_TYPE INT_TYPE UINT_TYPE
%token <lex> BREAK CONTINUE DO ELSE FOR IF DISCARD RETURN SWITCH CASE DEFAULT
%token <lex> BVEC2 BVEC3 BVEC4 IVEC2 IVEC3 IVEC4 VEC2 VEC3 VEC4 UVEC2 UVEC3 UVEC4
%token <lex> MATRIX2 MATRIX3 MATRIX4 IN_QUAL OUT_QUAL INOUT_QUAL UNIFORM VARYING
%token <lex> MATRIX2x3 MATRIX3x2 MATRIX2x4 MATRIX4x2 MATRIX3x4 MATRIX4x3
%token <lex> CENTROID FLAT SMOOTH
%token <lex> STRUCT VOID_TYPE WHILE
%token <lex> SAMPLER2D SAMPLERCUBE SAMPLER_EXTERNAL_OES SAMPLER2DRECT SAMPLER2DARRAY
%token <lex> ISAMPLER2D ISAMPLER3D ISAMPLERCUBE ISAMPLER2DARRAY
%token <lex> USAMPLER2D USAMPLER3D USAMPLERCUBE USAMPLER2DARRAY
%token <lex> SAMPLER3D SAMPLER3DRECT SAMPLER2DSHADOW SAMPLERCUBESHADOW SAMPLER2DARRAYSHADOW
%token <lex> LAYOUT

%token <lex> IDENTIFIER TYPE_NAME FLOATCONSTANT INTCONSTANT UINTCONSTANT BOOLCONSTANT
%token <lex> FIELD_SELECTION
%token <lex> LEFT_OP RIGHT_OP
%token <lex> INC_OP DEC_OP LE_OP GE_OP EQ_OP NE_OP
%token <lex> AND_OP OR_OP XOR_OP MUL_ASSIGN DIV_ASSIGN ADD_ASSIGN
%token <lex> MOD_ASSIGN LEFT_ASSIGN RIGHT_ASSIGN AND_ASSIGN XOR_ASSIGN OR_ASSIGN
%token <lex> SUB_ASSIGN

%token <lex> LEFT_PAREN RIGHT_PAREN LEFT_BRACKET RIGHT_BRACKET LEFT_BRACE RIGHT_BRACE DOT
%token <lex> COMMA COLON EQUAL SEMICOLON BANG DASH TILDE PLUS STAR SLASH PERCENT
%token <lex> LEFT_ANGLE RIGHT_ANGLE VERTICAL_BAR CARET AMPERSAND QUESTION

%type <lex> identifier
%type <interm> assignment_operator unary_operator
%type <interm.intermTypedNode> variable_identifier primary_expression postfix_expression
%type <interm.intermTypedNode> expression integer_expression assignment_expression
%type <interm.intermTypedNode> unary_expression multiplicative_expression additive_expression
%type <interm.intermTypedNode> relational_expression equality_expression
%type <interm.intermTypedNode> conditional_expression constant_expression
%type <interm.intermTypedNode> logical_or_expression logical_xor_expression logical_and_expression
%type <interm.intermTypedNode> shift_expression and_expression exclusive_or_expression inclusive_or_expression
%type <interm.intermTypedNode> function_call initializer condition conditionopt

%type <interm.intermNode> translation_unit function_definition
%type <interm.intermNode> statement simple_statement
%type <interm.intermAggregate>  statement_list compound_statement
%type <interm.intermNode> declaration_statement selection_statement expression_statement
%type <interm.intermNode> declaration external_declaration
%type <interm.intermNode> for_init_statement compound_statement_no_new_scope
%type <interm.nodePair> selection_rest_statement for_rest_statement
%type <interm.intermSwitch> switch_statement
%type <interm.intermCase> case_label
%type <interm.intermNode> iteration_statement jump_statement statement_no_new_scope statement_with_scope
%type <interm> single_declaration init_declarator_list

%type <interm> parameter_declaration parameter_declarator parameter_type_specifier
%type <interm.qualifier> parameter_qualifier parameter_type_qualifier 
%type <interm.layoutQualifier> layout_qualifier layout_qualifier_id_list layout_qualifier_id

%type <interm.precision> precision_qualifier
%type <interm.type> type_qualifier fully_specified_type type_specifier storage_qualifier interpolation_qualifier
%type <interm.type> type_specifier_no_prec type_specifier_nonarray
%type <interm.type> struct_specifier
%type <interm.field> struct_declarator
%type <interm.fieldList> struct_declarator_list struct_declaration struct_declaration_list
%type <interm.function> function_header function_declarator function_identifier
%type <interm.function> function_header_with_parameters function_call_header
%type <interm> function_call_header_with_parameters function_call_header_no_parameters function_call_generic function_prototype
%type <interm> function_call_or_method

%type <lex> enter_struct

%start translation_unit
%%

identifier
    : IDENTIFIER
    | TYPE_NAME

variable_identifier
    : IDENTIFIER {
        // The symbol table search was done in the lexical phase
        const TVariable *variable = context->getNamedVariable(@1, $1.string, $1.symbol);

        if (variable->getType().getQualifier() == EvqConst)
        {
            TConstantUnion* constArray = variable->getConstPointer();
            TType t(variable->getType());
            $$ = context->intermediate.addConstantUnion(constArray, t, @1);
        }
        else
        {
            $$ = context->intermediate.addSymbol(variable->getUniqueId(),
                                                 variable->getName(),
                                                 variable->getType(),
                                                 @1);
        }

        // don't delete $1.string, it's used by error recovery, and the pool
        // pop will reclaim the memory
    }
    ;

primary_expression
    : variable_identifier {
        $$ = $1;
    }
    | INTCONSTANT {
        TConstantUnion *unionArray = new TConstantUnion[1];
        unionArray->setIConst($1.i);
        $$ = context->intermediate.addConstantUnion(unionArray, TType(EbtInt, EbpUndefined, EvqConst), @1);
    }
    | UINTCONSTANT {
        TConstantUnion *unionArray = new TConstantUnion[1];
        unionArray->setUConst($1.u);
        $$ = context->intermediate.addConstantUnion(unionArray, TType(EbtUInt, EbpUndefined, EvqConst), @1);
    }
    | FLOATCONSTANT {
        TConstantUnion *unionArray = new TConstantUnion[1];
        unionArray->setFConst($1.f);
        $$ = context->intermediate.addConstantUnion(unionArray, TType(EbtFloat, EbpUndefined, EvqConst), @1);
    }
    | BOOLCONSTANT {
        TConstantUnion *unionArray = new TConstantUnion[1];
        unionArray->setBConst($1.b);
        $$ = context->intermediate.addConstantUnion(unionArray, TType(EbtBool, EbpUndefined, EvqConst), @1);
    }
    | LEFT_PAREN expression RIGHT_PAREN {
        $$ = $2;
    }
    ;

postfix_expression
    : primary_expression {
        $$ = $1;
    }
    | postfix_expression LEFT_BRACKET integer_expression RIGHT_BRACKET {
        $$ = context->addIndexExpression($1, @2, $3);
    }
    | function_call {
        $$ = $1;
    }
    | postfix_expression DOT FIELD_SELECTION {
        $$ = context->addFieldSelectionExpression($1, @2, *$3.string, @3);
    }
    | postfix_expression INC_OP {
        $$ = context->addUnaryMathLValue(EOpPostIncrement, $1, @2);
    }
    | postfix_expression DEC_OP {
        $$ = context->addUnaryMathLValue(EOpPostDecrement, $1, @2);
    }
    ;

integer_expression
    : expression {
        if (context->integerErrorCheck($1, "[]"))
            context->recover();
        $$ = $1;
    }
    ;

function_call
    : function_call_or_method {
        bool fatalError = false;
        $$ = context->addFunctionCallOrMethod($1.function, $1.nodePair.node1, $1.nodePair.node2, @1, &fatalError);
        if (fatalError)
        {
            YYERROR;
        }
    }
    ;

function_call_or_method
    : function_call_generic {
        $$ = $1;
        $$.nodePair.node2 = nullptr;
    }
    | postfix_expression DOT function_call_generic {
        ES3_ONLY("", @3, "methods");
        $$ = $3;
        $$.nodePair.node2 = $1;
    }
    ;

function_call_generic
    : function_call_header_with_parameters RIGHT_PAREN {
        $$ = $1;
    }
    | function_call_header_no_parameters RIGHT_PAREN {
        $$ = $1;
    }
    ;

function_call_header_no_parameters
    : function_call_header VOID_TYPE {
        $$.function = $1;
        $$.nodePair.node1 = nullptr;
    }
    | function_call_header {
        $$.function = $1;
        $$.nodePair.node1 = nullptr;
    }
    ;

function_call_header_with_parameters
    : function_call_header assignment_expression {
        TParameter param = { 0, new TType($2->getType()) };
        $1->addParameter(param);
        $$.function = $1;
        $$.nodePair.node1 = $2;
    }
    | function_call_header_with_parameters COMMA assignment_expression {
        TParameter param = { 0, new TType($3->getType()) };
        $1.function->addParameter(param);
        $$.function = $1.function;
        $$.nodePair.node1 = context->intermediate.growAggregate($1.intermNode, $3, @2);
    }
    ;

function_call_header
    : function_identifier LEFT_PAREN {
        $$ = $1;
    }
    ;

// Grammar Note:  Constructors look like functions, but are recognized as types.

function_identifier
    : type_specifier_no_prec {
        if ($1.array) {
            ES3_ONLY("[]", @1, "array constructor");
        }
        $$ = context->addConstructorFunc($1);
    }
    | IDENTIFIER {
        if (context->reservedErrorCheck(@1, *$1.string))
            context->recover();
        TType type(EbtVoid, EbpUndefined);
        TFunction *function = new TFunction($1.string, type);
        $$ = function;
    }
    | FIELD_SELECTION {
        if (context->reservedErrorCheck(@1, *$1.string))
            context->recover();
        TType type(EbtVoid, EbpUndefined);
        TFunction *function = new TFunction($1.string, type);
        $$ = function;
    }
    ;

unary_expression
    : postfix_expression {
        $$ = $1;
    }
    | INC_OP unary_expression {
        $$ = context->addUnaryMathLValue(EOpPreIncrement, $2, @1);
    }
    | DEC_OP unary_expression {
        $$ = context->addUnaryMathLValue(EOpPreDecrement, $2, @1);
    }
    | unary_operator unary_expression {
        if ($1.op != EOpNull) {
            $$ = context->addUnaryMath($1.op, $2, @1);
        } else
            $$ = $2;
    }
    ;
// Grammar Note:  No traditional style type casts.

unary_operator
    : PLUS  { $$.op = EOpPositive; }
    | DASH  { $$.op = EOpNegative; }
    | BANG  { $$.op = EOpLogicalNot; }
    | TILDE {
        ES3_ONLY("~", @$, "bit-wise operator");
        $$.op = EOpBitwiseNot;
    }
    ;
// Grammar Note:  No '*' or '&' unary ops.  Pointers are not supported.

multiplicative_expression
    : unary_expression { $$ = $1; }
    | multiplicative_expression STAR unary_expression {
        $$ = context->addBinaryMath(EOpMul, $1, $3, @2);
    }
    | multiplicative_expression SLASH unary_expression {
        $$ = context->addBinaryMath(EOpDiv, $1, $3, @2);
    }
    | multiplicative_expression PERCENT unary_expression {
        ES3_ONLY("%", @2, "integer modulus operator");
        $$ = context->addBinaryMath(EOpIMod, $1, $3, @2);
    }
    ;

additive_expression
    : multiplicative_expression { $$ = $1; }
    | additive_expression PLUS multiplicative_expression {
        $$ = context->addBinaryMath(EOpAdd, $1, $3, @2);
    }
    | additive_expression DASH multiplicative_expression {
        $$ = context->addBinaryMath(EOpSub, $1, $3, @2);
    }
    ;

shift_expression
    : additive_expression { $$ = $1; }
    | shift_expression LEFT_OP additive_expression {
        ES3_ONLY("<<", @2, "bit-wise operator");
        $$ = context->addBinaryMath(EOpBitShiftLeft, $1, $3, @2);
    }
    | shift_expression RIGHT_OP additive_expression {
        ES3_ONLY(">>", @2, "bit-wise operator");
        $$ = context->addBinaryMath(EOpBitShiftRight, $1, $3, @2);
    }
    ;

relational_expression
    : shift_expression { $$ = $1; }
    | relational_expression LEFT_ANGLE shift_expression {
        $$ = context->addBinaryMathBooleanResult(EOpLessThan, $1, $3, @2);
    }
    | relational_expression RIGHT_ANGLE shift_expression  {
        $$ = context->addBinaryMathBooleanResult(EOpGreaterThan, $1, $3, @2);
    }
    | relational_expression LE_OP shift_expression  {
        $$ = context->addBinaryMathBooleanResult(EOpLessThanEqual, $1, $3, @2);
    }
    | relational_expression GE_OP shift_expression  {
        $$ = context->addBinaryMathBooleanResult(EOpGreaterThanEqual, $1, $3, @2);
    }
    ;

equality_expression
    : relational_expression { $$ = $1; }
    | equality_expression EQ_OP relational_expression  {
        $$ = context->addBinaryMathBooleanResult(EOpEqual, $1, $3, @2);
    }
    | equality_expression NE_OP relational_expression {
        $$ = context->addBinaryMathBooleanResult(EOpNotEqual, $1, $3, @2);
    }
    ;

and_expression
    : equality_expression { $$ = $1; }
    | and_expression AMPERSAND equality_expression {
        ES3_ONLY("&", @2, "bit-wise operator");
        $$ = context->addBinaryMath(EOpBitwiseAnd, $1, $3, @2);
    }
    ;

exclusive_or_expression
    : and_expression { $$ = $1; }
    | exclusive_or_expression CARET and_expression {
        ES3_ONLY("^", @2, "bit-wise operator");
        $$ = context->addBinaryMath(EOpBitwiseXor, $1, $3, @2);
    }
    ;

inclusive_or_expression
    : exclusive_or_expression { $$ = $1; }
    | inclusive_or_expression VERTICAL_BAR exclusive_or_expression {
        ES3_ONLY("|", @2, "bit-wise operator");
        $$ = context->addBinaryMath(EOpBitwiseOr, $1, $3, @2);
    }
    ;

logical_and_expression
    : inclusive_or_expression { $$ = $1; }
    | logical_and_expression AND_OP inclusive_or_expression {
        $$ = context->addBinaryMathBooleanResult(EOpLogicalAnd, $1, $3, @2);
    }
    ;

logical_xor_expression
    : logical_and_expression { $$ = $1; }
    | logical_xor_expression XOR_OP logical_and_expression  {
        $$ = context->addBinaryMathBooleanResult(EOpLogicalXor, $1, $3, @2);
    }
    ;

logical_or_expression
    : logical_xor_expression { $$ = $1; }
    | logical_or_expression OR_OP logical_xor_expression  {
        $$ = context->addBinaryMathBooleanResult(EOpLogicalOr, $1, $3, @2);
    }
    ;

conditional_expression
    : logical_or_expression { $$ = $1; }
    | logical_or_expression QUESTION expression COLON assignment_expression {
        $$ = context->addTernarySelection($1, $3, $5, @2);
    }
    ;

assignment_expression
    : conditional_expression { $$ = $1; }
    | unary_expression assignment_operator assignment_expression {
        if (context->lValueErrorCheck(@2, "assign", $1))
            context->recover();
        $$ = context->addAssign($2.op, $1, $3, @2);
    }
    ;

assignment_operator
    : EQUAL        { $$.op = EOpAssign; }
    | MUL_ASSIGN   { $$.op = EOpMulAssign; }
    | DIV_ASSIGN   { $$.op = EOpDivAssign; }
    | MOD_ASSIGN   {
        ES3_ONLY("%=", @$, "integer modulus operator");
        $$.op = EOpIModAssign;
    }
    | ADD_ASSIGN   { $$.op = EOpAddAssign; }
    | SUB_ASSIGN   { $$.op = EOpSubAssign; }
    | LEFT_ASSIGN {
        ES3_ONLY("<<=", @$, "bit-wise operator");
        $$.op = EOpBitShiftLeftAssign;
    }
    | RIGHT_ASSIGN {
        ES3_ONLY(">>=", @$, "bit-wise operator");
        $$.op = EOpBitShiftRightAssign;
    }
    | AND_ASSIGN {
        ES3_ONLY("&=", @$, "bit-wise operator");
        $$.op = EOpBitwiseAndAssign;
    }
    | XOR_ASSIGN {
        ES3_ONLY("^=", @$, "bit-wise operator");
        $$.op = EOpBitwiseXorAssign;
    }
    | OR_ASSIGN {
        ES3_ONLY("|=", @$, "bit-wise operator");
        $$.op = EOpBitwiseOrAssign;
    }
    ;

expression
    : assignment_expression {
        $$ = $1;
    }
    | expression COMMA assignment_expression {
        $$ = context->intermediate.addComma($1, $3, @2);
        if ($$ == 0) {
            context->binaryOpError(@2, ",", $1->getCompleteString(), $3->getCompleteString());
            context->recover();
            $$ = $3;
        }
    }
    ;

constant_expression
    : conditional_expression {
        if (context->constErrorCheck($1))
            context->recover();
        $$ = $1;
    }
    ;

enter_struct
    : IDENTIFIER LEFT_BRACE {
        if (context->enterStructDeclaration(@1, *$1.string))
            context->recover();
        $$ = $1;
    }
    ;

declaration
    : function_prototype SEMICOLON   {
        TFunction &function = *($1.function);
        
        TIntermAggregate *prototype = new TIntermAggregate;
        prototype->setType(function.getReturnType());
        prototype->setName(function.getMangledName());
        prototype->setFunctionId(function.getUniqueId());
        
        for (size_t i = 0; i < function.getParamCount(); i++)
        {
            const TParameter &param = function.getParam(i);
            if (param.name != 0)
            {
                TVariable variable(param.name, *param.type);
                
                prototype = context->intermediate.growAggregate(prototype, context->intermediate.addSymbol(variable.getUniqueId(), variable.getName(), variable.getType(), @1), @1);
            }
            else
            {
                prototype = context->intermediate.growAggregate(prototype, context->intermediate.addSymbol(0, "", *param.type, @1), @1);
            }
        }
        
        prototype->setOp(EOpPrototype);
        $$ = prototype;

        context->symbolTable.pop();
    }
    | init_declarator_list SEMICOLON {
        TIntermAggregate *aggNode = $1.intermAggregate;
        if (aggNode && aggNode->getOp() == EOpNull)
            aggNode->setOp(EOpDeclaration);
        $$ = aggNode;
    }
    | PRECISION precision_qualifier type_specifier_no_prec SEMICOLON {
        if (($2 == EbpHigh) && (context->shaderType == GL_FRAGMENT_SHADER) && !context->fragmentPrecisionHigh) {
            context->error(@1, "precision is not supported in fragment shader", "highp");
            context->recover();
        }
        if (!context->symbolTable.setDefaultPrecision( $3, $2 )) {
            context->error(@1, "illegal type argument for default precision qualifier", getBasicString($3.type));
            context->recover();
        }
        $$ = 0;
    }
    | type_qualifier enter_struct struct_declaration_list RIGHT_BRACE SEMICOLON {
        ES3_ONLY(getQualifierString($1.qualifier), @1, "interface blocks");
        $$ = context->addInterfaceBlock($1, @2, *$2.string, $3, NULL, @$, NULL, @$);
    }
    | type_qualifier enter_struct struct_declaration_list RIGHT_BRACE IDENTIFIER SEMICOLON {
        ES3_ONLY(getQualifierString($1.qualifier), @1, "interface blocks");
        $$ = context->addInterfaceBlock($1, @2, *$2.string, $3, $5.string, @5, NULL, @$);
    }
    | type_qualifier enter_struct struct_declaration_list RIGHT_BRACE IDENTIFIER LEFT_BRACKET constant_expression RIGHT_BRACKET SEMICOLON {
        ES3_ONLY(getQualifierString($1.qualifier), @1, "interface blocks");
        $$ = context->addInterfaceBlock($1, @2, *$2.string, $3, $5.string, @5, $7, @6);
    }
    | type_qualifier SEMICOLON {
        context->parseGlobalLayoutQualifier($1);
        $$ = 0;
    }
    ;

function_prototype
    : function_declarator RIGHT_PAREN  {
        //
        // Multiple declarations of the same function are allowed.
        //
        // If this is a definition, the definition production code will check for redefinitions
        // (we don't know at this point if it's a definition or not).
        //
        // Redeclarations are allowed.  But, return types and parameter qualifiers must match.
        //
        TFunction* prevDec = static_cast<TFunction*>(context->symbolTable.find($1->getMangledName(), context->shaderVersion));
        if (prevDec) {
            if (prevDec->getReturnType() != $1->getReturnType()) {
                context->error(@2, "overloaded functions must have the same return type", $1->getReturnType().getBasicString());
                context->recover();
            }
            for (size_t i = 0; i < prevDec->getParamCount(); ++i) {
                if (prevDec->getParam(i).type->getQualifier() != $1->getParam(i).type->getQualifier()) {
                    context->error(@2, "overloaded functions must have the same parameter qualifiers", $1->getParam(i).type->getQualifierString());
                    context->recover();
                }
            }
        }

        //
        // Check for previously declared variables using the same name.
        //
        TSymbol *prevSym = context->symbolTable.find($1->getName(), context->shaderVersion);
        if (prevSym)
        {
            if (!prevSym->isFunction())
            {
                context->error(@2, "redefinition", $1->getName().c_str(), "function");
                context->recover();
            }
        }
        else
        {
            // Insert the unmangled name to detect potential future redefinition as a variable.
            TFunction *function = new TFunction(NewPoolTString($1->getName().c_str()), $1->getReturnType());
            context->symbolTable.getOuterLevel()->insertUnmangled(function);
        }

        //
        // If this is a redeclaration, it could also be a definition,
        // in which case, we want to use the variable names from this one, and not the one that's
        // being redeclared.  So, pass back up this declaration, not the one in the symbol table.
        //
        $$.function = $1;

        // We're at the inner scope level of the function's arguments and body statement.
        // Add the function prototype to the surrounding scope instead.
        context->symbolTable.getOuterLevel()->insert($$.function);
    }
    ;

function_declarator
    : function_header {
        $$ = $1;
    }
    | function_header_with_parameters {
        $$ = $1;
    }
    ;


function_header_with_parameters
    : function_header parameter_declaration {
        // Add the parameter
        $$ = $1;
        if ($2.param.type->getBasicType() != EbtVoid)
            $1->addParameter($2.param);
        else
            delete $2.param.type;
    }
    | function_header_with_parameters COMMA parameter_declaration {
        //
        // Only first parameter of one-parameter functions can be void
        // The check for named parameters not being void is done in parameter_declarator
        //
        if ($3.param.type->getBasicType() == EbtVoid) {
            //
            // This parameter > first is void
            //
            context->error(@2, "cannot be an argument type except for '(void)'", "void");
            context->recover();
            delete $3.param.type;
        } else {
            // Add the parameter
            $$ = $1;
            $1->addParameter($3.param);
        }
    }
    ;

function_header
    : fully_specified_type IDENTIFIER LEFT_PAREN {
        if ($1.qualifier != EvqGlobal && $1.qualifier != EvqTemporary) {
            context->error(@2, "no qualifiers allowed for function return", getQualifierString($1.qualifier));
            context->recover();
        }
        // make sure a sampler is not involved as well...
        if (context->samplerErrorCheck(@2, $1, "samplers can't be function return values"))
            context->recover();

        // Add the function as a prototype after parsing it (we do not support recursion)
        TFunction *function;
        TType type($1);
        function = new TFunction($2.string, type);
        $$ = function;
        
        context->symbolTable.push();
    }
    ;

parameter_declarator
    // Type + name
    : type_specifier identifier {
        if ($1.type == EbtVoid) {
            context->error(@2, "illegal use of type 'void'", $2.string->c_str());
            context->recover();
        }
        if (context->reservedErrorCheck(@2, *$2.string))
            context->recover();
        TParameter param = {$2.string, new TType($1)};
        $$.param = param;
    }
    | type_specifier identifier LEFT_BRACKET constant_expression RIGHT_BRACKET {
        // Check that we can make an array out of this type
        if (context->arrayTypeErrorCheck(@3, $1))
            context->recover();

        if (context->reservedErrorCheck(@2, *$2.string))
            context->recover();

        int size;
        if (context->arraySizeErrorCheck(@3, $4, size))
            context->recover();
        $1.setArraySize(size);

        TType* type = new TType($1);
        TParameter param = { $2.string, type };
        $$.param = param;
    }
    ;

parameter_declaration
    //
    // The only parameter qualifier a parameter can have are
    // IN_QUAL, OUT_QUAL, INOUT_QUAL, or CONST.
    //

    //
    // Type + name
    //
    : parameter_type_qualifier parameter_qualifier parameter_declarator {
        $$ = $3;
        if (context->paramErrorCheck(@3, $1, $2, $$.param.type))
            context->recover();
    }
    | parameter_qualifier parameter_declarator {
        $$ = $2;
        if (context->parameterSamplerErrorCheck(@2, $1, *$2.param.type))
            context->recover();
        if (context->paramErrorCheck(@2, EvqTemporary, $1, $$.param.type))
            context->recover();
    }
    //
    // Only type
    //
    | parameter_type_qualifier parameter_qualifier parameter_type_specifier {
        $$ = $3;
        if (context->paramErrorCheck(@3, $1, $2, $$.param.type))
            context->recover();
    }
    | parameter_qualifier parameter_type_specifier {
        $$ = $2;
        if (context->parameterSamplerErrorCheck(@2, $1, *$2.param.type))
            context->recover();
        if (context->paramErrorCheck(@2, EvqTemporary, $1, $$.param.type))
            context->recover();
    }
    ;

parameter_qualifier
    : /* empty */ {
        $$ = EvqIn;
    }
    | IN_QUAL {
        $$ = EvqIn;
    }
    | OUT_QUAL {
        $$ = EvqOut;
    }
    | INOUT_QUAL {
        $$ = EvqInOut;
    }
    ;

parameter_type_specifier
    : type_specifier {
        TParameter param = { 0, new TType($1) };
        $$.param = param;
    }
    ;

init_declarator_list
    : single_declaration {
        $$ = $1;
    }
    | init_declarator_list COMMA identifier {
        $$ = $1;
        $$.intermAggregate = context->parseDeclarator($$.type, $1.intermAggregate, @3, *$3.string);
    }
    | init_declarator_list COMMA identifier LEFT_BRACKET constant_expression RIGHT_BRACKET {
        $$ = $1;
        $$.intermAggregate = context->parseArrayDeclarator($$.type, $1.intermAggregate, @3, *$3.string, @4, $5);
    }
    | init_declarator_list COMMA identifier LEFT_BRACKET RIGHT_BRACKET EQUAL initializer {
        ES3_ONLY("[]", @3, "implicitly sized array");
        $$ = $1;
        $$.intermAggregate = context->parseArrayInitDeclarator($$.type, $1.intermAggregate, @3, *$3.string, @4, nullptr, @6, $7);
    }
    | init_declarator_list COMMA identifier LEFT_BRACKET constant_expression RIGHT_BRACKET EQUAL initializer {
        ES3_ONLY("=", @7, "first-class arrays (array initializer)");
        $$ = $1;
        $$.intermAggregate = context->parseArrayInitDeclarator($$.type, $1.intermAggregate, @3, *$3.string, @4, $5, @7, $8);
    }
    | init_declarator_list COMMA identifier EQUAL initializer {
        $$ = $1;
        $$.intermAggregate = context->parseInitDeclarator($$.type, $1.intermAggregate, @3, *$3.string, @4, $5);
    }
    ;

single_declaration
    : fully_specified_type {
        $$.type = $1;
        $$.intermAggregate = context->parseSingleDeclaration($$.type, @1, "");
    }
    | fully_specified_type identifier {
        $$.type = $1;
        $$.intermAggregate = context->parseSingleDeclaration($$.type, @2, *$2.string);
    }
    | fully_specified_type identifier LEFT_BRACKET constant_expression RIGHT_BRACKET {
        $$.type = $1;
        $$.intermAggregate = context->parseSingleArrayDeclaration($$.type, @2, *$2.string, @3, $4);
    }
    | fully_specified_type identifier LEFT_BRACKET RIGHT_BRACKET EQUAL initializer {
        ES3_ONLY("[]", @3, "implicitly sized array");
        $$.type = $1;
        $$.intermAggregate = context->parseSingleArrayInitDeclaration($$.type, @2, *$2.string, @3, nullptr, @5, $6);
    }
    | fully_specified_type identifier LEFT_BRACKET constant_expression RIGHT_BRACKET EQUAL initializer {
        ES3_ONLY("=", @6, "first-class arrays (array initializer)");
        $$.type = $1;
        $$.intermAggregate = context->parseSingleArrayInitDeclaration($$.type, @2, *$2.string, @3, $4, @6, $7);
    }
    | fully_specified_type identifier EQUAL initializer {
        $$.type = $1;
        $$.intermAggregate = context->parseSingleInitDeclaration($$.type, @2, *$2.string, @3, $4);
    }
    | INVARIANT IDENTIFIER {
        // $$.type is not used in invariant declarations.
        $$.intermAggregate = context->parseInvariantDeclaration(@1, @2, $2.string, $2.symbol);
    }
    ;

fully_specified_type
    : type_specifier {
        $$ = $1;

        if ($1.array) {
            ES3_ONLY("[]", @1, "first-class-array");
            if (context->shaderVersion != 300) {
                $1.clearArrayness();
            }
        }
    }
    | type_qualifier type_specifier  {
        $$ = context->addFullySpecifiedType($1.qualifier, $1.layoutQualifier, $2);
    }
    ;

interpolation_qualifier
    : SMOOTH {
        $$.qualifier = EvqSmooth;
    }
    | FLAT {
        $$.qualifier = EvqFlat;
    }
    ;

parameter_type_qualifier
    : CONST_QUAL {
        $$ = EvqConst;
    }
    ;

type_qualifier
    : ATTRIBUTE {
        VERTEX_ONLY("attribute", @1);
        ES2_ONLY("attribute", @1);
        if (context->globalErrorCheck(@1, context->symbolTable.atGlobalLevel(), "attribute"))
            context->recover();
        $$.setBasic(EbtVoid, EvqAttribute, @1);
    }
    | VARYING {
        ES2_ONLY("varying", @1);
        if (context->globalErrorCheck(@1, context->symbolTable.atGlobalLevel(), "varying"))
            context->recover();
        if (context->shaderType == GL_VERTEX_SHADER)
            $$.setBasic(EbtVoid, EvqVaryingOut, @1);
        else
            $$.setBasic(EbtVoid, EvqVaryingIn, @1);
    }
    | INVARIANT VARYING {
        ES2_ONLY("varying", @1);
        if (context->globalErrorCheck(@1, context->symbolTable.atGlobalLevel(), "invariant varying"))
            context->recover();
        if (context->shaderType == GL_VERTEX_SHADER)
            $$.setBasic(EbtVoid, EvqInvariantVaryingOut, @1);
        else
            $$.setBasic(EbtVoid, EvqInvariantVaryingIn, @1);
    }
    | storage_qualifier {
        if ($1.qualifier != EvqConst && !context->symbolTable.atGlobalLevel()) {
            context->error(@1, "Local variables can only use the const storage qualifier.", getQualifierString($1.qualifier));
            context->recover();
        } else {
            $$.setBasic(EbtVoid, $1.qualifier, @1);
        }
    }
    | interpolation_qualifier storage_qualifier {
        $$ = context->joinInterpolationQualifiers(@1, $1.qualifier, @2, $2.qualifier);
    }
    | interpolation_qualifier {
        context->error(@1, "interpolation qualifier requires a fragment 'in' or vertex 'out' storage qualifier", getInterpolationString($1.qualifier));
        context->recover();
        
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtVoid, qual, @1);
    }
    | layout_qualifier {
        $$.qualifier = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.layoutQualifier = $1;
    }
    | layout_qualifier storage_qualifier {
        $$.setBasic(EbtVoid, $2.qualifier, @2);
        $$.layoutQualifier = $1;
    }
    ;

storage_qualifier
    : CONST_QUAL {
        $$.qualifier = EvqConst;
    }
    | IN_QUAL {
        ES3_ONLY("in", @1, "storage qualifier");
        $$.qualifier = (context->shaderType == GL_FRAGMENT_SHADER) ? EvqFragmentIn : EvqVertexIn;
    }
    | OUT_QUAL {
        ES3_ONLY("out", @1, "storage qualifier");
        $$.qualifier = (context->shaderType == GL_FRAGMENT_SHADER) ? EvqFragmentOut : EvqVertexOut;
    }
    | CENTROID IN_QUAL {
        ES3_ONLY("centroid in", @1, "storage qualifier");
        if (context->shaderType == GL_VERTEX_SHADER)
        {
            context->error(@1, "invalid storage qualifier", "it is an error to use 'centroid in' in the vertex shader");
            context->recover();
        }
        $$.qualifier = (context->shaderType == GL_FRAGMENT_SHADER) ? EvqCentroidIn : EvqVertexIn;
    }
    | CENTROID OUT_QUAL {
        ES3_ONLY("centroid out", @1, "storage qualifier");
        if (context->shaderType == GL_FRAGMENT_SHADER)
        {
            context->error(@1, "invalid storage qualifier", "it is an error to use 'centroid out' in the fragment shader");
            context->recover();
        }
        $$.qualifier = (context->shaderType == GL_FRAGMENT_SHADER) ? EvqFragmentOut : EvqCentroidOut;
    }
    | UNIFORM {
        if (context->globalErrorCheck(@1, context->symbolTable.atGlobalLevel(), "uniform"))
            context->recover();
        $$.qualifier = EvqUniform;
    }
    ;

type_specifier
    : type_specifier_no_prec {
        $$ = $1;

        if ($$.precision == EbpUndefined) {
            $$.precision = context->symbolTable.getDefaultPrecision($1.type);
            if (context->precisionErrorCheck(@1, $$.precision, $1.type)) {
                context->recover();
            }
        }
    }
    | precision_qualifier type_specifier_no_prec {
        $$ = $2;
        $$.precision = $1;

        if (!SupportsPrecision($2.type)) {
            context->error(@1, "illegal type for precision qualifier", getBasicString($2.type));
            context->recover();
        }
    }
    ;

precision_qualifier
    : HIGH_PRECISION {
        $$ = EbpHigh;
    }
    | MEDIUM_PRECISION {
        $$ = EbpMedium;
    }
    | LOW_PRECISION  {
        $$ = EbpLow;
    }
    ;

layout_qualifier
    : LAYOUT LEFT_PAREN layout_qualifier_id_list RIGHT_PAREN {
        ES3_ONLY("layout", @1, "qualifier");
        $$ = $3;
    }
    ;

layout_qualifier_id_list
    : layout_qualifier_id {
        $$ = $1;
    }
    | layout_qualifier_id_list COMMA layout_qualifier_id {
        $$ = context->joinLayoutQualifiers($1, $3);
    }
    ;

layout_qualifier_id
    : IDENTIFIER {
        $$ = context->parseLayoutQualifier(*$1.string, @1);
    }
    | IDENTIFIER EQUAL INTCONSTANT {
        $$ = context->parseLayoutQualifier(*$1.string, @1, *$3.string, $3.i, @3);
    }
    | IDENTIFIER EQUAL UINTCONSTANT {
        $$ = context->parseLayoutQualifier(*$1.string, @1, *$3.string, $3.i, @3);
    }
    ;

type_specifier_no_prec
    : type_specifier_nonarray {
        $$ = $1;
    }
    | type_specifier_nonarray LEFT_BRACKET RIGHT_BRACKET {
        ES3_ONLY("[]", @2, "implicitly sized array");
        $$ = $1;
        $$.setArraySize(0);
    }
    | type_specifier_nonarray LEFT_BRACKET constant_expression RIGHT_BRACKET {
        $$ = $1;

        if (context->arrayTypeErrorCheck(@2, $1))
            context->recover();
        else {
            int size;
            if (context->arraySizeErrorCheck(@2, $3, size))
                context->recover();
            $$.setArraySize(size);
        }
    }
    ;

type_specifier_nonarray
    : VOID_TYPE {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtVoid, qual, @1);
    }
    | FLOAT_TYPE {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtFloat, qual, @1);
    }
    | INT_TYPE {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtInt, qual, @1);
    }
    | UINT_TYPE {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtUInt, qual, @1);
    }
    | BOOL_TYPE {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtBool, qual, @1);
    }
    | VEC2 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtFloat, qual, @1);
        $$.setAggregate(2);
    }
    | VEC3 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtFloat, qual, @1);
        $$.setAggregate(3);
    }
    | VEC4 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtFloat, qual, @1);
        $$.setAggregate(4);
    }
    | BVEC2 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtBool, qual, @1);
        $$.setAggregate(2);
    }
    | BVEC3 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtBool, qual, @1);
        $$.setAggregate(3);
    }
    | BVEC4 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtBool, qual, @1);
        $$.setAggregate(4);
    }
    | IVEC2 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtInt, qual, @1);
        $$.setAggregate(2);
    }
    | IVEC3 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtInt, qual, @1);
        $$.setAggregate(3);
    }
    | IVEC4 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtInt, qual, @1);
        $$.setAggregate(4);
    }
    | UVEC2 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtUInt, qual, @1);
        $$.setAggregate(2);
    }
    | UVEC3 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtUInt, qual, @1);
        $$.setAggregate(3);
    }
    | UVEC4 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtUInt, qual, @1);
        $$.setAggregate(4);
    }
    | MATRIX2 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtFloat, qual, @1);
        $$.setMatrix(2, 2);
    }
    | MATRIX3 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtFloat, qual, @1);
        $$.setMatrix(3, 3);
    }
    | MATRIX4 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtFloat, qual, @1);
        $$.setMatrix(4, 4);
    }
    | MATRIX2x3 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtFloat, qual, @1);
        $$.setMatrix(2, 3);
    }
    | MATRIX3x2 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtFloat, qual, @1);
        $$.setMatrix(3, 2);
    }
    | MATRIX2x4 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtFloat, qual, @1);
        $$.setMatrix(2, 4);
    }
    | MATRIX4x2 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtFloat, qual, @1);
        $$.setMatrix(4, 2);
    }
    | MATRIX3x4 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtFloat, qual, @1);
        $$.setMatrix(3, 4);
    }
    | MATRIX4x3 {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtFloat, qual, @1);
        $$.setMatrix(4, 3);
    }
    | SAMPLER2D {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtSampler2D, qual, @1);
    }
    | SAMPLER3D {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtSampler3D, qual, @1);
    }
    | SAMPLERCUBE {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtSamplerCube, qual, @1);
    }
    | SAMPLER2DARRAY {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtSampler2DArray, qual, @1);
    }
    | ISAMPLER2D {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtISampler2D, qual, @1);
    }
    | ISAMPLER3D {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtISampler3D, qual, @1);
    }
    | ISAMPLERCUBE {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtISamplerCube, qual, @1);
    }
    | ISAMPLER2DARRAY {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtISampler2DArray, qual, @1);
    }
    | USAMPLER2D {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtUSampler2D, qual, @1);
    }
    | USAMPLER3D {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtUSampler3D, qual, @1);
    }
    | USAMPLERCUBE {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtUSamplerCube, qual, @1);
    }
    | USAMPLER2DARRAY {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtUSampler2DArray, qual, @1);
    }
    | SAMPLER2DSHADOW {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtSampler2DShadow, qual, @1);
    }
    | SAMPLERCUBESHADOW {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtSamplerCubeShadow, qual, @1);
    }
    | SAMPLER2DARRAYSHADOW {
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtSampler2DArrayShadow, qual, @1);
    }
    | SAMPLER_EXTERNAL_OES {
        if (!context->supportsExtension("GL_OES_EGL_image_external")) {
            context->error(@1, "unsupported type", "samplerExternalOES");
            context->recover();
        }
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtSamplerExternalOES, qual, @1);
    }
    | SAMPLER2DRECT {
        if (!context->supportsExtension("GL_ARB_texture_rectangle")) {
            context->error(@1, "unsupported type", "sampler2DRect");
            context->recover();
        }
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtSampler2DRect, qual, @1);
    }
    | struct_specifier {
        $$ = $1;
        $$.qualifier = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
    }
    | TYPE_NAME {
        //
        // This is for user defined type names.  The lexical phase looked up the
        // type.
        //
        TType& structure = static_cast<TVariable*>($1.symbol)->getType();
        TQualifier qual = context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary;
        $$.setBasic(EbtStruct, qual, @1);
        $$.userDef = &structure;
    }
    ;

struct_specifier
    : STRUCT identifier LEFT_BRACE { if (context->enterStructDeclaration(@2, *$2.string)) context->recover(); } struct_declaration_list RIGHT_BRACE {
        $$ = context->addStructure(@1, @2, $2.string, $5);
    }
    | STRUCT LEFT_BRACE { if (context->enterStructDeclaration(@2, *$2.string)) context->recover(); } struct_declaration_list RIGHT_BRACE {
        $$ = context->addStructure(@1, @$, NewPoolTString(""), $4);
    }
    ;

struct_declaration_list
    : struct_declaration {
        $$ = $1;
    }
    | struct_declaration_list struct_declaration {
        $$ = $1;
        for (size_t i = 0; i < $2->size(); ++i) {
            TField* field = (*$2)[i];
            for (size_t j = 0; j < $$->size(); ++j) {
                if ((*$$)[j]->name() == field->name()) {
                    context->error(@2, "duplicate field name in structure:", "struct", field->name().c_str());
                    context->recover();
                }
            }
            $$->push_back(field);
        }
    }
    ;

struct_declaration
    : type_specifier struct_declarator_list SEMICOLON {
        $$ = context->addStructDeclaratorList($1, $2);
    }
    | type_qualifier type_specifier struct_declarator_list SEMICOLON {
        // ES3 Only, but errors should be handled elsewhere
        $2.qualifier = $1.qualifier;
        $2.layoutQualifier = $1.layoutQualifier;
        $$ = context->addStructDeclaratorList($2, $3);
    }
    ;

struct_declarator_list
    : struct_declarator {
        $$ = NewPoolTFieldList();
        $$->push_back($1);
    }
    | struct_declarator_list COMMA struct_declarator {
        $$->push_back($3);
    }
    ;

struct_declarator
    : identifier {
        if (context->reservedErrorCheck(@1, *$1.string))
            context->recover();

        TType* type = new TType(EbtVoid, EbpUndefined);
        $$ = new TField(type, $1.string, @1);
    }
    | identifier LEFT_BRACKET constant_expression RIGHT_BRACKET {
        if (context->reservedErrorCheck(@1, *$1.string))
            context->recover();

        TType* type = new TType(EbtVoid, EbpUndefined);
        int size;
        if (context->arraySizeErrorCheck(@3, $3, size))
            context->recover();
        type->setArraySize(size);

        $$ = new TField(type, $1.string, @1);
    }
    ;

initializer
    : assignment_expression { $$ = $1; }
    ;

declaration_statement
    : declaration { $$ = $1; }
    ;

statement
    : compound_statement  { $$ = $1; }
    | simple_statement    { $$ = $1; }
    ;

// Grammar Note:  Labeled statements for SWITCH only; 'goto' is not supported.

simple_statement
    : declaration_statement { $$ = $1; }
    | expression_statement  { $$ = $1; }
    | selection_statement   { $$ = $1; }
    | switch_statement      { $$ = $1; }
    | case_label            { $$ = $1; }
    | iteration_statement   { $$ = $1; }
    | jump_statement        { $$ = $1; }
    ;

compound_statement
    : LEFT_BRACE RIGHT_BRACE { $$ = 0; }
    | LEFT_BRACE { context->symbolTable.push(); } statement_list { context->symbolTable.pop(); } RIGHT_BRACE {
        if ($3 != 0) {
            $3->setOp(EOpSequence);
            $3->setLine(@$);
        }
        $$ = $3;
    }
    ;

statement_no_new_scope
    : compound_statement_no_new_scope { $$ = $1; }
    | simple_statement                { $$ = $1; }
    ;

statement_with_scope
    : { context->symbolTable.push(); } compound_statement_no_new_scope { context->symbolTable.pop(); $$ = $2; }
    | { context->symbolTable.push(); } simple_statement                { context->symbolTable.pop(); $$ = $2; }
    ;

compound_statement_no_new_scope
    // Statement that doesn't create a new scope, for selection_statement, iteration_statement
    : LEFT_BRACE RIGHT_BRACE {
        $$ = 0;
    }
    | LEFT_BRACE statement_list RIGHT_BRACE {
        if ($2) {
            $2->setOp(EOpSequence);
            $2->setLine(@$);
        }
        $$ = $2;
    }
    ;

statement_list
    : statement {
        $$ = context->intermediate.makeAggregate($1, @$);
    }
    | statement_list statement {
        $$ = context->intermediate.growAggregate($1, $2, @$);
    }
    ;

expression_statement
    : SEMICOLON  { $$ = 0; }
    | expression SEMICOLON  { $$ = static_cast<TIntermNode*>($1); }
    ;

selection_statement
    : IF LEFT_PAREN expression RIGHT_PAREN selection_rest_statement {
        if (context->boolErrorCheck(@1, $3))
            context->recover();
        $$ = context->intermediate.addSelection($3, $5, @1);
    }
    ;

selection_rest_statement
    : statement_with_scope ELSE statement_with_scope {
        $$.node1 = $1;
        $$.node2 = $3;
    }
    | statement_with_scope {
        $$.node1 = $1;
        $$.node2 = 0;
    }
    ;

switch_statement
    : SWITCH LEFT_PAREN expression RIGHT_PAREN { ++context->mSwitchNestingLevel; } compound_statement {
        $$ = context->addSwitch($3, $6, @1);
        --context->mSwitchNestingLevel;
    }
    ;

case_label
    : CASE constant_expression COLON {
        $$ = context->addCase($2, @1);
    }
    | DEFAULT COLON {
        $$ = context->addDefault(@1);
    }
    ;

condition
    // In 1996 c++ draft, conditions can include single declarations
    : expression {
        $$ = $1;
        if (context->boolErrorCheck($1->getLine(), $1))
            context->recover();
    }
    | fully_specified_type identifier EQUAL initializer {
        TIntermNode *intermNode;
        if (context->boolErrorCheck(@2, $1))
            context->recover();

        if (!context->executeInitializer(@2, *$2.string, $1, $4, &intermNode))
            $$ = $4;
        else {
            context->recover();
            $$ = 0;
        }
    }
    ;

iteration_statement
    : WHILE LEFT_PAREN { context->symbolTable.push(); ++context->mLoopNestingLevel; } condition RIGHT_PAREN statement_no_new_scope {
        context->symbolTable.pop();
        $$ = context->intermediate.addLoop(ELoopWhile, 0, $4, 0, $6, @1);
        --context->mLoopNestingLevel;
    }
    | DO { ++context->mLoopNestingLevel; } statement_with_scope WHILE LEFT_PAREN expression RIGHT_PAREN SEMICOLON {
        if (context->boolErrorCheck(@8, $6))
            context->recover();

        $$ = context->intermediate.addLoop(ELoopDoWhile, 0, $6, 0, $3, @4);
        --context->mLoopNestingLevel;
    }
    | FOR LEFT_PAREN { context->symbolTable.push(); ++context->mLoopNestingLevel; } for_init_statement for_rest_statement RIGHT_PAREN statement_no_new_scope {
        context->symbolTable.pop();
        $$ = context->intermediate.addLoop(ELoopFor, $4, reinterpret_cast<TIntermTyped*>($5.node1), reinterpret_cast<TIntermTyped*>($5.node2), $7, @1);
        --context->mLoopNestingLevel;
    }
    ;

for_init_statement
    : expression_statement {
        $$ = $1;
    }
    | declaration_statement {
        $$ = $1;
    }
    ;

conditionopt
    : condition {
        $$ = $1;
    }
    | /* May be null */ {
        $$ = 0;
    }
    ;

for_rest_statement
    : conditionopt SEMICOLON {
        $$.node1 = $1;
        $$.node2 = 0;
    }
    | conditionopt SEMICOLON expression  {
        $$.node1 = $1;
        $$.node2 = $3;
    }
    ;

jump_statement
    : CONTINUE SEMICOLON {
        $$ = context->addBranch(EOpContinue, @1);
    }
    | BREAK SEMICOLON {
        $$ = context->addBranch(EOpBreak, @1);
    }
    | RETURN SEMICOLON {
        $$ = context->addBranch(EOpReturn, @1);
    }
    | RETURN expression SEMICOLON {
        $$ = context->addBranch(EOpReturn, $2, @1);
    }
    | DISCARD SEMICOLON {
        FRAG_ONLY("discard", @1);
        $$ = context->addBranch(EOpKill, @1);
    }
    ;

// Grammar Note:  No 'goto'.  Gotos are not supported.

translation_unit
    : external_declaration {
        $$ = $1;
        context->treeRoot = $$;
    }
    | translation_unit external_declaration {
        $$ = context->intermediate.growAggregate($1, $2, @$);
        context->treeRoot = $$;
    }
    ;

external_declaration
    : function_definition {
        $$ = $1;
    }
    | declaration {
        $$ = $1;
    }
    ;

function_definition
    : function_prototype {
        TFunction* function = $1.function;
        
        const TSymbol *builtIn = context->symbolTable.findBuiltIn(function->getMangledName(), context->shaderVersion);
        
        if (builtIn)
        {
            context->error(@1, "built-in functions cannot be redefined", function->getName().c_str());
            context->recover();
        }
        
        TFunction* prevDec = static_cast<TFunction*>(context->symbolTable.find(function->getMangledName(), context->shaderVersion));
        //
        // Note:  'prevDec' could be 'function' if this is the first time we've seen function
        // as it would have just been put in the symbol table.  Otherwise, we're looking up
        // an earlier occurance.
        //
        if (prevDec->isDefined()) {
            //
            // Then this function already has a body.
            //
            context->error(@1, "function already has a body", function->getName().c_str());
            context->recover();
        }
        prevDec->setDefined();
        //
        // Overload the unique ID of the definition to be the same unique ID as the declaration.
        // Eventually we will probably want to have only a single definition and just swap the
        // arguments to be the definition's arguments.
        //
        function->setUniqueId(prevDec->getUniqueId());

        //
        // Raise error message if main function takes any parameters or return anything other than void
        //
        if (function->getName() == "main") {
            if (function->getParamCount() > 0) {
                context->error(@1, "function cannot take any parameter(s)", function->getName().c_str());
                context->recover();
            }
            if (function->getReturnType().getBasicType() != EbtVoid) {
                context->error(@1, "", function->getReturnType().getBasicString(), "main function cannot return a value");
                context->recover();
            }
        }

        //
        // Remember the return type for later checking for RETURN statements.
        //
        context->currentFunctionType = &(prevDec->getReturnType());
        context->mFunctionReturnsValue = false;

        //
        // Insert parameters into the symbol table.
        // If the parameter has no name, it's not an error, just don't insert it
        // (could be used for unused args).
        //
        // Also, accumulate the list of parameters into the HIL, so lower level code
        // knows where to find parameters.
        //
        TIntermAggregate* paramNodes = new TIntermAggregate;
        for (size_t i = 0; i < function->getParamCount(); i++) {
            const TParameter& param = function->getParam(i);
            if (param.name != 0) {
                TVariable *variable = new TVariable(param.name, *param.type);
                //
                // Insert the parameters with name in the symbol table.
                //
                if (! context->symbolTable.declare(variable)) {
                    context->error(@1, "redefinition", variable->getName().c_str());
                    context->recover();
                    delete variable;
                }

                //
                // Add the parameter to the HIL
                //
                paramNodes = context->intermediate.growAggregate(
                                               paramNodes,
                                               context->intermediate.addSymbol(variable->getUniqueId(),
                                                                       variable->getName(),
                                                                       variable->getType(), @1),
                                               @1);
            } else {
                paramNodes = context->intermediate.growAggregate(paramNodes, context->intermediate.addSymbol(0, "", *param.type, @1), @1);
            }
        }
        context->intermediate.setAggregateOperator(paramNodes, EOpParameters, @1);
        $1.intermAggregate = paramNodes;
        context->mLoopNestingLevel = 0;
    }
    compound_statement_no_new_scope {
        //?? Check that all paths return a value if return type != void ?
        //   May be best done as post process phase on intermediate code
        if (context->currentFunctionType->getBasicType() != EbtVoid && ! context->mFunctionReturnsValue) {
            context->error(@1, "function does not return a value:", "", $1.function->getName().c_str());
            context->recover();
        }
        
        $$ = context->intermediate.growAggregate($1.intermAggregate, $3, @$);
        context->intermediate.setAggregateOperator($$, EOpFunction, @1);
        $$->getAsAggregate()->setName($1.function->getMangledName().c_str());
        $$->getAsAggregate()->setType($1.function->getReturnType());
        $$->getAsAggregate()->setFunctionId($1.function->getUniqueId());

        // store the pragma information for debug and optimize and other vendor specific
        // information. This information can be queried from the parse tree
        $$->getAsAggregate()->setOptimize(context->pragma().optimize);
        $$->getAsAggregate()->setDebug(context->pragma().debug);

        context->symbolTable.pop();
    }
    ;

%%

int glslang_parse(TParseContext* context) {
    return yyparse(context, context->scanner);
}
