/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef QCHATICON_H
#define QCHATICON_H

#include <QIcon>
#include <QMap>

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class QChatIcon
{
  private:
    static QMap<QString, QIcon>   m_icons;
    static QMap<QString, QString> m_iconPaths;

  private:
    static void drawPixmap(QPixmap*, const QString & icon_name, const QSize&);

  public:
    QChatIcon();
    ~QChatIcon();

    static void initIcons();
    static const QIcon   & icon(const QString &);
    static const QString & iconPath(const QString &);
    static QPixmap* newPixmap(const QString &, int = -1, int = -1);
    static QPixmap  pixmap   (const QString &, int = -1, int = -1);
};

#endif
