/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "protocolversion3.h"

const char* ProtocolVersion3::m_programId = "QChat4Linux&Others"; // :)

ProtocolVersion3::ProtocolVersion3()
 : AbstractProtocol()
{
}

ProtocolVersion3::~ProtocolVersion3()
{
}

QString ProtocolVersion3::compName(const char * buf, uint sz)
{
  if(sz < protocolLen() || sz < protocolLen() + compNameLen(buf))
    return QString();
  return QString::fromUtf8(buf + protocolLen(), compNameLen(buf));
}

QString ProtocolVersion3::userName(const char * buf, uint sz)
{
  if(sz < protocolLen() || sz < protocolLen() + compNameLen(buf) + userNameLen(buf))
    return QString();
  return QString::fromUtf8(buf + protocolLen() + compNameLen(buf), userNameLen(buf));
}

QString ProtocolVersion3::message(const char * buf, uint sz)
{
  if(sz < protocolLen() || sz < protocolLen() + compNameLen(buf) + userNameLen(buf) + messageLen(buf))
    return QString();
  return QString::fromUtf8(buf + protocolLen() + compNameLen(buf) + userNameLen(buf), messageLen(buf));
}

QByteArray ProtocolVersion3::parametrs(const char * buf, uint sz)
{
  if(sz < protocolLen() || sz < protocolLen() + compNameLen(buf) + userNameLen(buf) + messageLen(buf) + parametrsLen(buf))
    return QByteArray();
  return QByteArray(buf + protocolLen() + compNameLen(buf) + userNameLen(buf) + messageLen(buf), parametrsLen(buf));
}
