# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AdvancedFilter(_serialization.Model):
    """This is the base type that represents an advanced filter. To configure an advanced filter, do
    not directly instantiate an object of this class. Instead, instantiate an object of a derived
    class such as BoolEqualsAdvancedFilter, NumberInAdvancedFilter, StringEqualsAdvancedFilter etc.
    depending on the type of the key based on which you want to filter.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BoolEqualsAdvancedFilter, IsNotNullAdvancedFilter, IsNullOrUndefinedAdvancedFilter,
    NumberGreaterThanAdvancedFilter, NumberGreaterThanOrEqualsAdvancedFilter,
    NumberInAdvancedFilter, NumberInRangeAdvancedFilter, NumberLessThanAdvancedFilter,
    NumberLessThanOrEqualsAdvancedFilter, NumberNotInAdvancedFilter,
    NumberNotInRangeAdvancedFilter, StringBeginsWithAdvancedFilter, StringContainsAdvancedFilter,
    StringEndsWithAdvancedFilter, StringInAdvancedFilter, StringNotBeginsWithAdvancedFilter,
    StringNotContainsAdvancedFilter, StringNotEndsWithAdvancedFilter, StringNotInAdvancedFilter

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
    }

    _subtype_map = {
        "operator_type": {
            "BoolEquals": "BoolEqualsAdvancedFilter",
            "IsNotNull": "IsNotNullAdvancedFilter",
            "IsNullOrUndefined": "IsNullOrUndefinedAdvancedFilter",
            "NumberGreaterThan": "NumberGreaterThanAdvancedFilter",
            "NumberGreaterThanOrEquals": "NumberGreaterThanOrEqualsAdvancedFilter",
            "NumberIn": "NumberInAdvancedFilter",
            "NumberInRange": "NumberInRangeAdvancedFilter",
            "NumberLessThan": "NumberLessThanAdvancedFilter",
            "NumberLessThanOrEquals": "NumberLessThanOrEqualsAdvancedFilter",
            "NumberNotIn": "NumberNotInAdvancedFilter",
            "NumberNotInRange": "NumberNotInRangeAdvancedFilter",
            "StringBeginsWith": "StringBeginsWithAdvancedFilter",
            "StringContains": "StringContainsAdvancedFilter",
            "StringEndsWith": "StringEndsWithAdvancedFilter",
            "StringIn": "StringInAdvancedFilter",
            "StringNotBeginsWith": "StringNotBeginsWithAdvancedFilter",
            "StringNotContains": "StringNotContainsAdvancedFilter",
            "StringNotEndsWith": "StringNotEndsWithAdvancedFilter",
            "StringNotIn": "StringNotInAdvancedFilter",
        }
    }

    def __init__(self, *, key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        """
        super().__init__(**kwargs)
        self.operator_type: Optional[str] = None
        self.key = key


class EventSubscriptionDestination(_serialization.Model):
    """Information about the destination for an event subscription.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureFunctionEventSubscriptionDestination, EventHubEventSubscriptionDestination,
    HybridConnectionEventSubscriptionDestination, MonitorAlertEventSubscriptionDestination,
    NamespaceTopicEventSubscriptionDestination, ServiceBusQueueEventSubscriptionDestination,
    ServiceBusTopicEventSubscriptionDestination, StorageQueueEventSubscriptionDestination,
    WebHookEventSubscriptionDestination

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: Type of the endpoint for the event subscription destination. Required.
     Known values are: "WebHook", "EventHub", "StorageQueue", "HybridConnection", "ServiceBusQueue",
     "ServiceBusTopic", "AzureFunction", "MonitorAlert", and "NamespaceTopic".
    :vartype endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    """

    _validation = {
        "endpoint_type": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
    }

    _subtype_map = {
        "endpoint_type": {
            "AzureFunction": "AzureFunctionEventSubscriptionDestination",
            "EventHub": "EventHubEventSubscriptionDestination",
            "HybridConnection": "HybridConnectionEventSubscriptionDestination",
            "MonitorAlert": "MonitorAlertEventSubscriptionDestination",
            "NamespaceTopic": "NamespaceTopicEventSubscriptionDestination",
            "ServiceBusQueue": "ServiceBusQueueEventSubscriptionDestination",
            "ServiceBusTopic": "ServiceBusTopicEventSubscriptionDestination",
            "StorageQueue": "StorageQueueEventSubscriptionDestination",
            "WebHook": "WebHookEventSubscriptionDestination",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.endpoint_type: Optional[str] = None


class AzureFunctionEventSubscriptionDestination(EventSubscriptionDestination):  # pylint: disable=name-too-long
    """Information about the azure function destination for an event subscription.

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: Type of the endpoint for the event subscription destination. Required.
     Known values are: "WebHook", "EventHub", "StorageQueue", "HybridConnection", "ServiceBusQueue",
     "ServiceBusTopic", "AzureFunction", "MonitorAlert", and "NamespaceTopic".
    :vartype endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :ivar resource_id: The Azure Resource Id that represents the endpoint of the Azure Function
     destination of an event subscription.
    :vartype resource_id: str
    :ivar max_events_per_batch: Maximum number of events per batch.
    :vartype max_events_per_batch: int
    :ivar preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
    :vartype preferred_batch_size_in_kilobytes: int
    :ivar delivery_attribute_mappings: Delivery attribute details.
    :vartype delivery_attribute_mappings:
     list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        "endpoint_type": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "max_events_per_batch": {"key": "properties.maxEventsPerBatch", "type": "int"},
        "preferred_batch_size_in_kilobytes": {"key": "properties.preferredBatchSizeInKilobytes", "type": "int"},
        "delivery_attribute_mappings": {
            "key": "properties.deliveryAttributeMappings",
            "type": "[DeliveryAttributeMapping]",
        },
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        max_events_per_batch: int = 1,
        preferred_batch_size_in_kilobytes: int = 64,
        delivery_attribute_mappings: Optional[List["_models.DeliveryAttributeMapping"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The Azure Resource Id that represents the endpoint of the Azure Function
         destination of an event subscription.
        :paramtype resource_id: str
        :keyword max_events_per_batch: Maximum number of events per batch.
        :paramtype max_events_per_batch: int
        :keyword preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
        :paramtype preferred_batch_size_in_kilobytes: int
        :keyword delivery_attribute_mappings: Delivery attribute details.
        :paramtype delivery_attribute_mappings:
         list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
        """
        super().__init__(**kwargs)
        self.endpoint_type: str = "AzureFunction"
        self.resource_id = resource_id
        self.max_events_per_batch = max_events_per_batch
        self.preferred_batch_size_in_kilobytes = preferred_batch_size_in_kilobytes
        self.delivery_attribute_mappings = delivery_attribute_mappings


class BoolEqualsAdvancedFilter(AdvancedFilter):
    """BoolEquals Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar value: The boolean filter value.
    :vartype value: bool
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "bool"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword value: The boolean filter value.
        :paramtype value: bool
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "BoolEquals"
        self.value = value


class Filter(_serialization.Model):
    """This is the base type that represents a filter. To configure a filter, do not directly
    instantiate an object of this class. Instead, instantiate
    an object of a derived class such as BoolEqualsFilter, NumberInFilter etc depending on the type
    of the key based on
    which you want to filter.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BoolEqualsFilter, IsNotNullFilter, IsNullOrUndefinedFilter, NumberGreaterThanFilter,
    NumberGreaterThanOrEqualsFilter, NumberInFilter, NumberInRangeFilter, NumberLessThanFilter,
    NumberLessThanOrEqualsFilter, NumberNotInFilter, NumberNotInRangeFilter,
    StringBeginsWithFilter, StringContainsFilter, StringEndsWithFilter, StringInFilter,
    StringNotBeginsWithFilter, StringNotContainsFilter, StringNotEndsWithFilter, StringNotInFilter

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
    }

    _subtype_map = {
        "operator_type": {
            "BoolEquals": "BoolEqualsFilter",
            "IsNotNull": "IsNotNullFilter",
            "IsNullOrUndefined": "IsNullOrUndefinedFilter",
            "NumberGreaterThan": "NumberGreaterThanFilter",
            "NumberGreaterThanOrEquals": "NumberGreaterThanOrEqualsFilter",
            "NumberIn": "NumberInFilter",
            "NumberInRange": "NumberInRangeFilter",
            "NumberLessThan": "NumberLessThanFilter",
            "NumberLessThanOrEquals": "NumberLessThanOrEqualsFilter",
            "NumberNotIn": "NumberNotInFilter",
            "NumberNotInRange": "NumberNotInRangeFilter",
            "StringBeginsWith": "StringBeginsWithFilter",
            "StringContains": "StringContainsFilter",
            "StringEndsWith": "StringEndsWithFilter",
            "StringIn": "StringInFilter",
            "StringNotBeginsWith": "StringNotBeginsWithFilter",
            "StringNotContains": "StringNotContainsFilter",
            "StringNotEndsWith": "StringNotEndsWithFilter",
            "StringNotIn": "StringNotInFilter",
        }
    }

    def __init__(self, *, key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        """
        super().__init__(**kwargs)
        self.operator_type: Optional[str] = None
        self.key = key


class BoolEqualsFilter(Filter):
    """BoolEquals Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar value: The boolean filter value.
    :vartype value: bool
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "bool"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword value: The boolean filter value.
        :paramtype value: bool
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "BoolEquals"
        self.value = value


class Resource(_serialization.Model):
    """Definition of a Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class CaCertificate(Resource):
    """The CA Certificate resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar description: Description for the CA Certificate resource.
    :vartype description: str
    :ivar encoded_certificate: Base64 encoded PEM (Privacy Enhanced Mail) format certificate data.
    :vartype encoded_certificate: str
    :ivar issue_time_in_utc: Certificate issue time in UTC. This is a read-only field.
    :vartype issue_time_in_utc: ~datetime.datetime
    :ivar expiry_time_in_utc: Certificate expiry time in UTC. This is a read-only field.
    :vartype expiry_time_in_utc: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the CA Certificate resource. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.CaCertificateProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "issue_time_in_utc": {"readonly": True},
        "expiry_time_in_utc": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "encoded_certificate": {"key": "properties.encodedCertificate", "type": "str"},
        "issue_time_in_utc": {"key": "properties.issueTimeInUtc", "type": "iso-8601"},
        "expiry_time_in_utc": {"key": "properties.expiryTimeInUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self, *, description: Optional[str] = None, encoded_certificate: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword description: Description for the CA Certificate resource.
        :paramtype description: str
        :keyword encoded_certificate: Base64 encoded PEM (Privacy Enhanced Mail) format certificate
         data.
        :paramtype encoded_certificate: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.description = description
        self.encoded_certificate = encoded_certificate
        self.issue_time_in_utc = None
        self.expiry_time_in_utc = None
        self.provisioning_state = None


class CaCertificatesListResult(_serialization.Model):
    """Result of the List CA Certificate operation.

    :ivar value: A collection of CA Certificate.
    :vartype value: list[~azure.mgmt.eventgrid.models.CaCertificate]
    :ivar next_link: A link for the next page of CA Certificate.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CaCertificate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.CaCertificate"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of CA Certificate.
        :paramtype value: list[~azure.mgmt.eventgrid.models.CaCertificate]
        :keyword next_link: A link for the next page of CA Certificate.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Channel(Resource):
    """Channel info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar channel_type: The type of the event channel which represents the direction flow of
     events. "PartnerTopic"
    :vartype channel_type: str or ~azure.mgmt.eventgrid.models.ChannelType
    :ivar partner_topic_info: This property should be populated when channelType is PartnerTopic
     and represents information about the partner topic resource corresponding to the channel.
    :vartype partner_topic_info: ~azure.mgmt.eventgrid.models.PartnerTopicInfo
    :ivar message_for_activation: Context or helpful message that can be used during the approval
     process by the subscriber.
    :vartype message_for_activation: str
    :ivar provisioning_state: Provisioning state of the channel. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Canceled", "Failed", and
     "IdleDueToMirroredPartnerTopicDeletion".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.ChannelProvisioningState
    :ivar readiness_state: The readiness state of the corresponding partner topic. Known values
     are: "NeverActivated" and "Activated".
    :vartype readiness_state: str or ~azure.mgmt.eventgrid.models.ReadinessState
    :ivar expiration_time_if_not_activated_utc: Expiration time of the channel. If this timer
     expires while the corresponding partner topic is never activated,
     the channel and corresponding partner topic are deleted.
    :vartype expiration_time_if_not_activated_utc: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "channel_type": {"key": "properties.channelType", "type": "str"},
        "partner_topic_info": {"key": "properties.partnerTopicInfo", "type": "PartnerTopicInfo"},
        "message_for_activation": {"key": "properties.messageForActivation", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "readiness_state": {"key": "properties.readinessState", "type": "str"},
        "expiration_time_if_not_activated_utc": {
            "key": "properties.expirationTimeIfNotActivatedUtc",
            "type": "iso-8601",
        },
    }

    def __init__(
        self,
        *,
        channel_type: Optional[Union[str, "_models.ChannelType"]] = None,
        partner_topic_info: Optional["_models.PartnerTopicInfo"] = None,
        message_for_activation: Optional[str] = None,
        provisioning_state: Optional[Union[str, "_models.ChannelProvisioningState"]] = None,
        readiness_state: Optional[Union[str, "_models.ReadinessState"]] = None,
        expiration_time_if_not_activated_utc: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword channel_type: The type of the event channel which represents the direction flow of
         events. "PartnerTopic"
        :paramtype channel_type: str or ~azure.mgmt.eventgrid.models.ChannelType
        :keyword partner_topic_info: This property should be populated when channelType is PartnerTopic
         and represents information about the partner topic resource corresponding to the channel.
        :paramtype partner_topic_info: ~azure.mgmt.eventgrid.models.PartnerTopicInfo
        :keyword message_for_activation: Context or helpful message that can be used during the
         approval process by the subscriber.
        :paramtype message_for_activation: str
        :keyword provisioning_state: Provisioning state of the channel. Known values are: "Creating",
         "Updating", "Deleting", "Succeeded", "Canceled", "Failed", and
         "IdleDueToMirroredPartnerTopicDeletion".
        :paramtype provisioning_state: str or ~azure.mgmt.eventgrid.models.ChannelProvisioningState
        :keyword readiness_state: The readiness state of the corresponding partner topic. Known values
         are: "NeverActivated" and "Activated".
        :paramtype readiness_state: str or ~azure.mgmt.eventgrid.models.ReadinessState
        :keyword expiration_time_if_not_activated_utc: Expiration time of the channel. If this timer
         expires while the corresponding partner topic is never activated,
         the channel and corresponding partner topic are deleted.
        :paramtype expiration_time_if_not_activated_utc: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.channel_type = channel_type
        self.partner_topic_info = partner_topic_info
        self.message_for_activation = message_for_activation
        self.provisioning_state = provisioning_state
        self.readiness_state = readiness_state
        self.expiration_time_if_not_activated_utc = expiration_time_if_not_activated_utc


class ChannelsListResult(_serialization.Model):
    """Result of the List Channels operation.

    :ivar value: A collection of Channels.
    :vartype value: list[~azure.mgmt.eventgrid.models.Channel]
    :ivar next_link: A link for the next page of channels.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Channel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Channel"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of Channels.
        :paramtype value: list[~azure.mgmt.eventgrid.models.Channel]
        :keyword next_link: A link for the next page of channels.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ChannelUpdateParameters(_serialization.Model):
    """Properties of the Channel update.

    :ivar expiration_time_if_not_activated_utc: Expiration time of the channel. If this timer
     expires while the corresponding partner topic or partner destination is never activated,
     the channel and corresponding partner topic or partner destination are deleted.
    :vartype expiration_time_if_not_activated_utc: ~datetime.datetime
    :ivar partner_topic_info: Partner topic properties which can be updated if the channel is of
     type PartnerTopic.
    :vartype partner_topic_info: ~azure.mgmt.eventgrid.models.PartnerUpdateTopicInfo
    """

    _attribute_map = {
        "expiration_time_if_not_activated_utc": {
            "key": "properties.expirationTimeIfNotActivatedUtc",
            "type": "iso-8601",
        },
        "partner_topic_info": {"key": "properties.partnerTopicInfo", "type": "PartnerUpdateTopicInfo"},
    }

    def __init__(
        self,
        *,
        expiration_time_if_not_activated_utc: Optional[datetime.datetime] = None,
        partner_topic_info: Optional["_models.PartnerUpdateTopicInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword expiration_time_if_not_activated_utc: Expiration time of the channel. If this timer
         expires while the corresponding partner topic or partner destination is never activated,
         the channel and corresponding partner topic or partner destination are deleted.
        :paramtype expiration_time_if_not_activated_utc: ~datetime.datetime
        :keyword partner_topic_info: Partner topic properties which can be updated if the channel is of
         type PartnerTopic.
        :paramtype partner_topic_info: ~azure.mgmt.eventgrid.models.PartnerUpdateTopicInfo
        """
        super().__init__(**kwargs)
        self.expiration_time_if_not_activated_utc = expiration_time_if_not_activated_utc
        self.partner_topic_info = partner_topic_info


class Client(Resource):
    """The Client resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar description: Description for the Client resource.
    :vartype description: str
    :ivar authentication_name: The name presented by the client for authentication. The default
     value is the name of the resource.
    :vartype authentication_name: str
    :ivar client_certificate_authentication: The client certificate authentication information.
    :vartype client_certificate_authentication:
     ~azure.mgmt.eventgrid.models.ClientCertificateAuthentication
    :ivar state: Indicates if the client is enabled or not. Default value is Enabled. Known values
     are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.eventgrid.models.ClientState
    :ivar attributes: Attributes for the client. Supported values are int, bool, string, string[].
     Example:
     "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }.
    :vartype attributes: dict[str, any]
    :ivar provisioning_state: Provisioning state of the Client resource. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.ClientProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "authentication_name": {"key": "properties.authenticationName", "type": "str"},
        "client_certificate_authentication": {
            "key": "properties.clientCertificateAuthentication",
            "type": "ClientCertificateAuthentication",
        },
        "state": {"key": "properties.state", "type": "str"},
        "attributes": {"key": "properties.attributes", "type": "{object}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        authentication_name: Optional[str] = None,
        client_certificate_authentication: Optional["_models.ClientCertificateAuthentication"] = None,
        state: Union[str, "_models.ClientState"] = "Enabled",
        attributes: Optional[Dict[str, Any]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description for the Client resource.
        :paramtype description: str
        :keyword authentication_name: The name presented by the client for authentication. The default
         value is the name of the resource.
        :paramtype authentication_name: str
        :keyword client_certificate_authentication: The client certificate authentication information.
        :paramtype client_certificate_authentication:
         ~azure.mgmt.eventgrid.models.ClientCertificateAuthentication
        :keyword state: Indicates if the client is enabled or not. Default value is Enabled. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.eventgrid.models.ClientState
        :keyword attributes: Attributes for the client. Supported values are int, bool, string,
         string[].
         Example:
         "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }.
        :paramtype attributes: dict[str, any]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.description = description
        self.authentication_name = authentication_name
        self.client_certificate_authentication = client_certificate_authentication
        self.state = state
        self.attributes = attributes
        self.provisioning_state = None


class ClientCertificateAuthentication(_serialization.Model):
    """The certificate authentication properties for the client.

    :ivar validation_scheme: The validation scheme used to authenticate the client. Default value
     is SubjectMatchesAuthenticationName. Known values are: "SubjectMatchesAuthenticationName",
     "DnsMatchesAuthenticationName", "UriMatchesAuthenticationName", "IpMatchesAuthenticationName",
     "EmailMatchesAuthenticationName", and "ThumbprintMatch".
    :vartype validation_scheme: str or
     ~azure.mgmt.eventgrid.models.ClientCertificateValidationScheme
    :ivar allowed_thumbprints: The list of thumbprints that are allowed during client
     authentication. This property is required only if the validationScheme is 'ThumbprintMatch'.
    :vartype allowed_thumbprints: list[str]
    """

    _attribute_map = {
        "validation_scheme": {"key": "validationScheme", "type": "str"},
        "allowed_thumbprints": {"key": "allowedThumbprints", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        validation_scheme: Optional[Union[str, "_models.ClientCertificateValidationScheme"]] = None,
        allowed_thumbprints: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword validation_scheme: The validation scheme used to authenticate the client. Default
         value is SubjectMatchesAuthenticationName. Known values are:
         "SubjectMatchesAuthenticationName", "DnsMatchesAuthenticationName",
         "UriMatchesAuthenticationName", "IpMatchesAuthenticationName",
         "EmailMatchesAuthenticationName", and "ThumbprintMatch".
        :paramtype validation_scheme: str or
         ~azure.mgmt.eventgrid.models.ClientCertificateValidationScheme
        :keyword allowed_thumbprints: The list of thumbprints that are allowed during client
         authentication. This property is required only if the validationScheme is 'ThumbprintMatch'.
        :paramtype allowed_thumbprints: list[str]
        """
        super().__init__(**kwargs)
        self.validation_scheme = validation_scheme
        self.allowed_thumbprints = allowed_thumbprints


class ClientGroup(Resource):
    """The Client group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar description: Description for the Client Group resource.
    :vartype description: str
    :ivar query: The grouping query for the clients.
     Example : attributes.keyName IN ['a', 'b', 'c'].
    :vartype query: str
    :ivar provisioning_state: Provisioning state of the ClientGroup resource. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.ClientGroupProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "query": {"key": "properties.query", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, query: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: Description for the Client Group resource.
        :paramtype description: str
        :keyword query: The grouping query for the clients.
         Example : attributes.keyName IN ['a', 'b', 'c'].
        :paramtype query: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.description = description
        self.query = query
        self.provisioning_state = None


class ClientGroupsListResult(_serialization.Model):
    """Result of the List Client Group operation.

    :ivar value: A collection of Client Group.
    :vartype value: list[~azure.mgmt.eventgrid.models.ClientGroup]
    :ivar next_link: A link for the next page of Client Group.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ClientGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ClientGroup"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of Client Group.
        :paramtype value: list[~azure.mgmt.eventgrid.models.ClientGroup]
        :keyword next_link: A link for the next page of Client Group.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ClientsListResult(_serialization.Model):
    """Result of the List Client operation.

    :ivar value: A collection of Client.
    :vartype value: list[~azure.mgmt.eventgrid.models.Client]
    :ivar next_link: A link for the next page of Client.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Client]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Client"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of Client.
        :paramtype value: list[~azure.mgmt.eventgrid.models.Client]
        :keyword next_link: A link for the next page of Client.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ConnectionState(_serialization.Model):
    """ConnectionState information.

    :ivar status: Status of the connection. Known values are: "Pending", "Approved", "Rejected",
     and "Disconnected".
    :vartype status: str or ~azure.mgmt.eventgrid.models.PersistedConnectionStatus
    :ivar description: Description of the connection state.
    :vartype description: str
    :ivar actions_required: Actions required (if any).
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PersistedConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the connection. Known values are: "Pending", "Approved", "Rejected",
         and "Disconnected".
        :paramtype status: str or ~azure.mgmt.eventgrid.models.PersistedConnectionStatus
        :keyword description: Description of the connection state.
        :paramtype description: str
        :keyword actions_required: Actions required (if any).
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class CustomDomainConfiguration(_serialization.Model):
    """A custom domain configuration that allows users to publish to their own domain name.

    All required parameters must be populated in order to send to server.

    :ivar fully_qualified_domain_name: Fully Qualified Domain Name (FQDN) for the custom domain.
     Required.
    :vartype fully_qualified_domain_name: str
    :ivar validation_state: Validation state for the custom domain. This is a read only property
     and is initially set to 'Pending' and will be updated to 'Approved' by Event Grid only after
     ownership of the domain name has been successfully validated. Known values are: "Pending",
     "Approved", and "ErrorRetrievingDnsRecord".
    :vartype validation_state: str or ~azure.mgmt.eventgrid.models.CustomDomainValidationState
    :ivar identity: Identity info for accessing the certificate for the custom domain. This
     identity info must match an identity that has been set on the namespace.
    :vartype identity: ~azure.mgmt.eventgrid.models.CustomDomainIdentity
    :ivar certificate_url: The URL for the certificate that is used for publishing to the custom
     domain. We currently support certificates stored in Azure Key Vault only. While certificate URL
     can be either
     versioned URL of the following format
     https://{key-vault-name}.vault.azure.net/certificates/{certificate-name}/{version-id}, or
     unversioned URL of the following format (e.g.,
     https://contosovault.vault.azure.net/certificates/contosocert, we support unversioned
     certificate URL only (e.g., https://contosovault.vault.azure.net/certificates/contosocert).
    :vartype certificate_url: str
    :ivar expected_txt_record_name: Expected DNS TXT record name. Event Grid will check for a TXT
     record with this name in the DNS record set of the custom domain name to prove ownership over
     the domain.
     The values under this TXT record must contain the expected TXT record value.
    :vartype expected_txt_record_name: str
    :ivar expected_txt_record_value: Expected DNS TXT record value. Event Grid will check for a TXT
     record with this value in the DNS record set of the custom domain name to prove ownership over
     the domain.
    :vartype expected_txt_record_value: str
    """

    _validation = {
        "fully_qualified_domain_name": {"required": True},
    }

    _attribute_map = {
        "fully_qualified_domain_name": {"key": "fullyQualifiedDomainName", "type": "str"},
        "validation_state": {"key": "validationState", "type": "str"},
        "identity": {"key": "identity", "type": "CustomDomainIdentity"},
        "certificate_url": {"key": "certificateUrl", "type": "str"},
        "expected_txt_record_name": {"key": "expectedTxtRecordName", "type": "str"},
        "expected_txt_record_value": {"key": "expectedTxtRecordValue", "type": "str"},
    }

    def __init__(
        self,
        *,
        fully_qualified_domain_name: str,
        validation_state: Optional[Union[str, "_models.CustomDomainValidationState"]] = None,
        identity: Optional["_models.CustomDomainIdentity"] = None,
        certificate_url: Optional[str] = None,
        expected_txt_record_name: Optional[str] = None,
        expected_txt_record_value: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword fully_qualified_domain_name: Fully Qualified Domain Name (FQDN) for the custom domain.
         Required.
        :paramtype fully_qualified_domain_name: str
        :keyword validation_state: Validation state for the custom domain. This is a read only property
         and is initially set to 'Pending' and will be updated to 'Approved' by Event Grid only after
         ownership of the domain name has been successfully validated. Known values are: "Pending",
         "Approved", and "ErrorRetrievingDnsRecord".
        :paramtype validation_state: str or ~azure.mgmt.eventgrid.models.CustomDomainValidationState
        :keyword identity: Identity info for accessing the certificate for the custom domain. This
         identity info must match an identity that has been set on the namespace.
        :paramtype identity: ~azure.mgmt.eventgrid.models.CustomDomainIdentity
        :keyword certificate_url: The URL for the certificate that is used for publishing to the custom
         domain. We currently support certificates stored in Azure Key Vault only. While certificate URL
         can be either
         versioned URL of the following format
         https://{key-vault-name}.vault.azure.net/certificates/{certificate-name}/{version-id}, or
         unversioned URL of the following format (e.g.,
         https://contosovault.vault.azure.net/certificates/contosocert, we support unversioned
         certificate URL only (e.g., https://contosovault.vault.azure.net/certificates/contosocert).
        :paramtype certificate_url: str
        :keyword expected_txt_record_name: Expected DNS TXT record name. Event Grid will check for a
         TXT record with this name in the DNS record set of the custom domain name to prove ownership
         over the domain.
         The values under this TXT record must contain the expected TXT record value.
        :paramtype expected_txt_record_name: str
        :keyword expected_txt_record_value: Expected DNS TXT record value. Event Grid will check for a
         TXT record with this value in the DNS record set of the custom domain name to prove ownership
         over the domain.
        :paramtype expected_txt_record_value: str
        """
        super().__init__(**kwargs)
        self.fully_qualified_domain_name = fully_qualified_domain_name
        self.validation_state = validation_state
        self.identity = identity
        self.certificate_url = certificate_url
        self.expected_txt_record_name = expected_txt_record_name
        self.expected_txt_record_value = expected_txt_record_value


class CustomDomainIdentity(_serialization.Model):
    """The identity information for retrieving the certificate for the custom domain.

    :ivar type: The type of managed identity used. Can be either 'SystemAssigned' or
     'UserAssigned'. Known values are: "SystemAssigned" and "UserAssigned".
    :vartype type: str or ~azure.mgmt.eventgrid.models.CustomDomainIdentityType
    :ivar user_assigned_identity: The user identity associated with the resource.
    :vartype user_assigned_identity: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_assigned_identity": {"key": "userAssignedIdentity", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.CustomDomainIdentityType"]] = None,
        user_assigned_identity: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of managed identity used. Can be either 'SystemAssigned' or
         'UserAssigned'. Known values are: "SystemAssigned" and "UserAssigned".
        :paramtype type: str or ~azure.mgmt.eventgrid.models.CustomDomainIdentityType
        :keyword user_assigned_identity: The user identity associated with the resource.
        :paramtype user_assigned_identity: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.user_assigned_identity = user_assigned_identity


class CustomDomainOwnershipValidationResult(_serialization.Model):
    """Namespace custom domain ownership validation result.

    :ivar custom_domains_for_topics_configuration: List of custom domain configurations for the
     namespace under topics configuration.
    :vartype custom_domains_for_topics_configuration:
     list[~azure.mgmt.eventgrid.models.CustomDomainConfiguration]
    :ivar custom_domains_for_topic_spaces_configuration: List of custom domain configurations for
     the namespace under topic spaces configuration.
    :vartype custom_domains_for_topic_spaces_configuration:
     list[~azure.mgmt.eventgrid.models.CustomDomainConfiguration]
    """

    _attribute_map = {
        "custom_domains_for_topics_configuration": {
            "key": "customDomainsForTopicsConfiguration",
            "type": "[CustomDomainConfiguration]",
        },
        "custom_domains_for_topic_spaces_configuration": {
            "key": "customDomainsForTopicSpacesConfiguration",
            "type": "[CustomDomainConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        custom_domains_for_topics_configuration: Optional[List["_models.CustomDomainConfiguration"]] = None,
        custom_domains_for_topic_spaces_configuration: Optional[List["_models.CustomDomainConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword custom_domains_for_topics_configuration: List of custom domain configurations for the
         namespace under topics configuration.
        :paramtype custom_domains_for_topics_configuration:
         list[~azure.mgmt.eventgrid.models.CustomDomainConfiguration]
        :keyword custom_domains_for_topic_spaces_configuration: List of custom domain configurations
         for the namespace under topic spaces configuration.
        :paramtype custom_domains_for_topic_spaces_configuration:
         list[~azure.mgmt.eventgrid.models.CustomDomainConfiguration]
        """
        super().__init__(**kwargs)
        self.custom_domains_for_topics_configuration = custom_domains_for_topics_configuration
        self.custom_domains_for_topic_spaces_configuration = custom_domains_for_topic_spaces_configuration


class DeadLetterDestination(_serialization.Model):
    """Information about the dead letter destination for an event subscription. To configure a
    deadletter destination, do not directly instantiate an object of this class. Instead,
    instantiate an object of a derived class. Currently, StorageBlobDeadLetterDestination is the
    only class that derives from this class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    StorageBlobDeadLetterDestination

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: Type of the endpoint for the dead letter destination. Required.
     "StorageBlob"
    :vartype endpoint_type: str or ~azure.mgmt.eventgrid.models.DeadLetterEndPointType
    """

    _validation = {
        "endpoint_type": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
    }

    _subtype_map = {"endpoint_type": {"StorageBlob": "StorageBlobDeadLetterDestination"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.endpoint_type: Optional[str] = None


class DeadLetterWithResourceIdentity(_serialization.Model):
    """Information about the deadletter destination with resource identity.

    :ivar identity: The identity to use when dead-lettering events.
    :vartype identity: ~azure.mgmt.eventgrid.models.EventSubscriptionIdentity
    :ivar dead_letter_destination: Information about the destination where events have to be
     delivered for the event subscription.
     Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire
     the authentication tokens being used during dead-lettering.
    :vartype dead_letter_destination: ~azure.mgmt.eventgrid.models.DeadLetterDestination
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "EventSubscriptionIdentity"},
        "dead_letter_destination": {"key": "deadLetterDestination", "type": "DeadLetterDestination"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.EventSubscriptionIdentity"] = None,
        dead_letter_destination: Optional["_models.DeadLetterDestination"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity to use when dead-lettering events.
        :paramtype identity: ~azure.mgmt.eventgrid.models.EventSubscriptionIdentity
        :keyword dead_letter_destination: Information about the destination where events have to be
         delivered for the event subscription.
         Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire
         the authentication tokens being used during dead-lettering.
        :paramtype dead_letter_destination: ~azure.mgmt.eventgrid.models.DeadLetterDestination
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.dead_letter_destination = dead_letter_destination


class DeliveryAttributeListResult(_serialization.Model):
    """Result of the Get delivery attributes operation.

    :ivar value: A collection of DeliveryAttributeMapping.
    :vartype value: list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DeliveryAttributeMapping]"},
    }

    def __init__(self, *, value: Optional[List["_models.DeliveryAttributeMapping"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A collection of DeliveryAttributeMapping.
        :paramtype value: list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
        """
        super().__init__(**kwargs)
        self.value = value


class DeliveryAttributeMapping(_serialization.Model):
    """Delivery attribute mapping details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DynamicDeliveryAttributeMapping, StaticDeliveryAttributeMapping

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the delivery attribute or header.
    :vartype name: str
    :ivar type: Type of the delivery attribute or header name. Required. Known values are: "Static"
     and "Dynamic".
    :vartype type: str or ~azure.mgmt.eventgrid.models.DeliveryAttributeMappingType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"Dynamic": "DynamicDeliveryAttributeMapping", "Static": "StaticDeliveryAttributeMapping"}}

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the delivery attribute or header.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type: Optional[str] = None


class DeliveryConfiguration(_serialization.Model):
    """Properties of the delivery configuration information of the event subscription.

    :ivar delivery_mode: Delivery mode of the event subscription. Known values are: "Queue" and
     "Push".
    :vartype delivery_mode: str or ~azure.mgmt.eventgrid.models.DeliveryMode
    :ivar queue: This property should be populated when deliveryMode is queue and represents
     information about the queue subscription.
    :vartype queue: ~azure.mgmt.eventgrid.models.QueueInfo
    :ivar push: This property should be populated when deliveryMode is push and represents
     information about the push subscription.
    :vartype push: ~azure.mgmt.eventgrid.models.PushInfo
    """

    _attribute_map = {
        "delivery_mode": {"key": "deliveryMode", "type": "str"},
        "queue": {"key": "queue", "type": "QueueInfo"},
        "push": {"key": "push", "type": "PushInfo"},
    }

    def __init__(
        self,
        *,
        delivery_mode: Optional[Union[str, "_models.DeliveryMode"]] = None,
        queue: Optional["_models.QueueInfo"] = None,
        push: Optional["_models.PushInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword delivery_mode: Delivery mode of the event subscription. Known values are: "Queue" and
         "Push".
        :paramtype delivery_mode: str or ~azure.mgmt.eventgrid.models.DeliveryMode
        :keyword queue: This property should be populated when deliveryMode is queue and represents
         information about the queue subscription.
        :paramtype queue: ~azure.mgmt.eventgrid.models.QueueInfo
        :keyword push: This property should be populated when deliveryMode is push and represents
         information about the push subscription.
        :paramtype push: ~azure.mgmt.eventgrid.models.PushInfo
        """
        super().__init__(**kwargs)
        self.delivery_mode = delivery_mode
        self.queue = queue
        self.push = push


class DeliveryWithResourceIdentity(_serialization.Model):
    """Information about the delivery for an event subscription with resource identity.

    :ivar identity: The identity to use when delivering events.
    :vartype identity: ~azure.mgmt.eventgrid.models.EventSubscriptionIdentity
    :ivar destination: Information about the destination where events have to be delivered for the
     event subscription.
     Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire
     the authentication tokens being used during delivery.
    :vartype destination: ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "EventSubscriptionIdentity"},
        "destination": {"key": "destination", "type": "EventSubscriptionDestination"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.EventSubscriptionIdentity"] = None,
        destination: Optional["_models.EventSubscriptionDestination"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity to use when delivering events.
        :paramtype identity: ~azure.mgmt.eventgrid.models.EventSubscriptionIdentity
        :keyword destination: Information about the destination where events have to be delivered for
         the event subscription.
         Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire
         the authentication tokens being used during delivery.
        :paramtype destination: ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.destination = destination


class TrackedResource(Resource):
    """Definition of a Tracked Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar location: Location of the resource. Required.
    :vartype location: str
    :ivar tags: Tags of the resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Location of the resource. Required.
        :paramtype location: str
        :keyword tags: Tags of the resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags


class Domain(TrackedResource):
    """EventGrid Domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar location: Location of the resource. Required.
    :vartype location: str
    :ivar tags: Tags of the resource.
    :vartype tags: dict[str, str]
    :ivar identity: Identity information for the Event Grid Domain resource.
    :vartype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :ivar provisioning_state: Provisioning state of the Event Grid Domain Resource. Known values
     are: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.DomainProvisioningState
    :ivar minimum_tls_version_allowed: Minimum TLS version of the publisher allowed to publish to
     this domain. Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
    :ivar endpoint: Endpoint for the Event Grid Domain Resource which is used for publishing the
     events.
    :vartype endpoint: str
    :ivar input_schema: This determines the format that Event Grid should expect for incoming
     events published to the Event Grid Domain Resource. Known values are: "EventGridSchema",
     "CustomEventSchema", and "CloudEventSchemaV1_0".
    :vartype input_schema: str or ~azure.mgmt.eventgrid.models.InputSchema
    :ivar event_type_info: Event Type Information for the domain. This information is provided by
     the publisher and can be used by the
     subscriber to view different types of events that are published.
    :vartype event_type_info: ~azure.mgmt.eventgrid.models.EventTypeInfo
    :ivar input_schema_mapping: Information about the InputSchemaMapping which specified the info
     about mapping event payload.
    :vartype input_schema_mapping: ~azure.mgmt.eventgrid.models.InputSchemaMapping
    :ivar metric_resource_id: Metric resource id for the Event Grid Domain Resource.
    :vartype metric_resource_id: str
    :ivar public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules"
     />`. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :ivar inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :vartype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    :ivar disable_local_auth: This boolean is used to enable or disable local auth. Default value
     is false. When the property is set to true, only AAD token will be used to authenticate if user
     is allowed to publish to the domain.
    :vartype disable_local_auth: bool
    :ivar auto_create_topic_with_first_subscription: This Boolean is used to specify the creation
     mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain
     resource.
     In this context, creation of domain topic can be auto-managed (when true) or self-managed
     (when false). The default value for this property is true.
     When this property is null or set to true, Event Grid is responsible of automatically creating
     the domain topic when the first event subscription is
     created at the scope of the domain topic. If this property is set to false, then creating the
     first event subscription will require creating a domain topic
     by the user. The self-management mode can be used if the user wants full control of when the
     domain topic is created, while auto-managed mode provides the
     flexibility to perform less operations and manage fewer resources by the user. Also, note that
     in auto-managed creation mode, user is allowed to create the
     domain topic on demand if needed.
    :vartype auto_create_topic_with_first_subscription: bool
    :ivar auto_delete_topic_with_last_subscription: This Boolean is used to specify the deletion
     mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain
     resource.
     In this context, deletion of domain topic can be auto-managed (when true) or self-managed
     (when false). The default value for this property is true.
     When this property is set to true, Event Grid is responsible of automatically deleting the
     domain topic when the last event subscription at the scope
     of the domain topic is deleted. If this property is set to false, then the user needs to
     manually delete the domain topic when it is no longer needed
     (e.g., when last event subscription is deleted and the resource needs to be cleaned up). The
     self-management mode can be used if the user wants full
     control of when the domain topic needs to be deleted, while auto-managed mode provides the
     flexibility to perform less operations and manage fewer
     resources by the user.
    :vartype auto_delete_topic_with_last_subscription: bool
    :ivar data_residency_boundary: Data Residency Boundary of the resource. Known values are:
     "WithinGeopair" and "WithinRegion".
    :vartype data_residency_boundary: str or ~azure.mgmt.eventgrid.models.DataResidencyBoundary
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "endpoint": {"readonly": True},
        "metric_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "IdentityInfo"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "minimum_tls_version_allowed": {"key": "properties.minimumTlsVersionAllowed", "type": "str"},
        "endpoint": {"key": "properties.endpoint", "type": "str"},
        "input_schema": {"key": "properties.inputSchema", "type": "str"},
        "event_type_info": {"key": "properties.eventTypeInfo", "type": "EventTypeInfo"},
        "input_schema_mapping": {"key": "properties.inputSchemaMapping", "type": "InputSchemaMapping"},
        "metric_resource_id": {"key": "properties.metricResourceId", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "inbound_ip_rules": {"key": "properties.inboundIpRules", "type": "[InboundIpRule]"},
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "auto_create_topic_with_first_subscription": {
            "key": "properties.autoCreateTopicWithFirstSubscription",
            "type": "bool",
        },
        "auto_delete_topic_with_last_subscription": {
            "key": "properties.autoDeleteTopicWithLastSubscription",
            "type": "bool",
        },
        "data_residency_boundary": {"key": "properties.dataResidencyBoundary", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.IdentityInfo"] = None,
        minimum_tls_version_allowed: Optional[Union[str, "_models.TlsVersion"]] = None,
        input_schema: Optional[Union[str, "_models.InputSchema"]] = None,
        event_type_info: Optional["_models.EventTypeInfo"] = None,
        input_schema_mapping: Optional["_models.InputSchemaMapping"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["_models.InboundIpRule"]] = None,
        disable_local_auth: bool = False,
        auto_create_topic_with_first_subscription: bool = True,
        auto_delete_topic_with_last_subscription: bool = True,
        data_residency_boundary: Optional[Union[str, "_models.DataResidencyBoundary"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Location of the resource. Required.
        :paramtype location: str
        :keyword tags: Tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword identity: Identity information for the Event Grid Domain resource.
        :paramtype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
        :keyword minimum_tls_version_allowed: Minimum TLS version of the publisher allowed to publish
         to this domain. Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
        :keyword input_schema: This determines the format that Event Grid should expect for incoming
         events published to the Event Grid Domain Resource. Known values are: "EventGridSchema",
         "CustomEventSchema", and "CloudEventSchemaV1_0".
        :paramtype input_schema: str or ~azure.mgmt.eventgrid.models.InputSchema
        :keyword event_type_info: Event Type Information for the domain. This information is provided
         by the publisher and can be used by the
         subscriber to view different types of events that are published.
        :paramtype event_type_info: ~azure.mgmt.eventgrid.models.EventTypeInfo
        :keyword input_schema_mapping: Information about the InputSchemaMapping which specified the
         info about mapping event payload.
        :paramtype input_schema_mapping: ~azure.mgmt.eventgrid.models.InputSchemaMapping
        :keyword public_network_access: This determines if traffic is allowed over public network. By
         default it is enabled.
         You can further restrict to specific IPs by configuring :code:`<seealso
         cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules"
         />`. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
        :keyword inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of
         all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
        :paramtype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
        :keyword disable_local_auth: This boolean is used to enable or disable local auth. Default
         value is false. When the property is set to true, only AAD token will be used to authenticate
         if user is allowed to publish to the domain.
        :paramtype disable_local_auth: bool
        :keyword auto_create_topic_with_first_subscription: This Boolean is used to specify the
         creation mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid
         Domain resource.
         In this context, creation of domain topic can be auto-managed (when true) or self-managed
         (when false). The default value for this property is true.
         When this property is null or set to true, Event Grid is responsible of automatically creating
         the domain topic when the first event subscription is
         created at the scope of the domain topic. If this property is set to false, then creating the
         first event subscription will require creating a domain topic
         by the user. The self-management mode can be used if the user wants full control of when the
         domain topic is created, while auto-managed mode provides the
         flexibility to perform less operations and manage fewer resources by the user. Also, note that
         in auto-managed creation mode, user is allowed to create the
         domain topic on demand if needed.
        :paramtype auto_create_topic_with_first_subscription: bool
        :keyword auto_delete_topic_with_last_subscription: This Boolean is used to specify the deletion
         mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain
         resource.
         In this context, deletion of domain topic can be auto-managed (when true) or self-managed
         (when false). The default value for this property is true.
         When this property is set to true, Event Grid is responsible of automatically deleting the
         domain topic when the last event subscription at the scope
         of the domain topic is deleted. If this property is set to false, then the user needs to
         manually delete the domain topic when it is no longer needed
         (e.g., when last event subscription is deleted and the resource needs to be cleaned up). The
         self-management mode can be used if the user wants full
         control of when the domain topic needs to be deleted, while auto-managed mode provides the
         flexibility to perform less operations and manage fewer
         resources by the user.
        :paramtype auto_delete_topic_with_last_subscription: bool
        :keyword data_residency_boundary: Data Residency Boundary of the resource. Known values are:
         "WithinGeopair" and "WithinRegion".
        :paramtype data_residency_boundary: str or ~azure.mgmt.eventgrid.models.DataResidencyBoundary
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.system_data = None
        self.private_endpoint_connections = None
        self.provisioning_state = None
        self.minimum_tls_version_allowed = minimum_tls_version_allowed
        self.endpoint = None
        self.input_schema = input_schema
        self.event_type_info = event_type_info
        self.input_schema_mapping = input_schema_mapping
        self.metric_resource_id = None
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules
        self.disable_local_auth = disable_local_auth
        self.auto_create_topic_with_first_subscription = auto_create_topic_with_first_subscription
        self.auto_delete_topic_with_last_subscription = auto_delete_topic_with_last_subscription
        self.data_residency_boundary = data_residency_boundary


class DomainRegenerateKeyRequest(_serialization.Model):
    """Domain regenerate share access key request.

    All required parameters must be populated in order to send to server.

    :ivar key_name: Key name to regenerate key1 or key2. Required.
    :vartype key_name: str
    """

    _validation = {
        "key_name": {"required": True},
    }

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
    }

    def __init__(self, *, key_name: str, **kwargs: Any) -> None:
        """
        :keyword key_name: Key name to regenerate key1 or key2. Required.
        :paramtype key_name: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name


class DomainSharedAccessKeys(_serialization.Model):
    """Shared access keys of the Domain.

    :ivar key1: Shared access key1 for the domain.
    :vartype key1: str
    :ivar key2: Shared access key2 for the domain.
    :vartype key2: str
    """

    _attribute_map = {
        "key1": {"key": "key1", "type": "str"},
        "key2": {"key": "key2", "type": "str"},
    }

    def __init__(self, *, key1: Optional[str] = None, key2: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key1: Shared access key1 for the domain.
        :paramtype key1: str
        :keyword key2: Shared access key2 for the domain.
        :paramtype key2: str
        """
        super().__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class DomainsListResult(_serialization.Model):
    """Result of the List Domains operation.

    :ivar value: A collection of Domains.
    :vartype value: list[~azure.mgmt.eventgrid.models.Domain]
    :ivar next_link: A link for the next page of domains.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Domain]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Domain"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of Domains.
        :paramtype value: list[~azure.mgmt.eventgrid.models.Domain]
        :keyword next_link: A link for the next page of domains.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DomainTopic(Resource):
    """Domain Topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar provisioning_state: Provisioning state of the domain topic. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.DomainTopicProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.system_data = None
        self.provisioning_state = None


class DomainTopicsListResult(_serialization.Model):
    """Result of the List Domain Topics operation.

    :ivar value: A collection of Domain Topics.
    :vartype value: list[~azure.mgmt.eventgrid.models.DomainTopic]
    :ivar next_link: A link for the next page of domain topics.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DomainTopic]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.DomainTopic"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of Domain Topics.
        :paramtype value: list[~azure.mgmt.eventgrid.models.DomainTopic]
        :keyword next_link: A link for the next page of domain topics.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DomainUpdateParameters(_serialization.Model):
    """Properties of the Domain update.

    :ivar tags: Tags of the domains resource.
    :vartype tags: dict[str, str]
    :ivar identity: Identity information for the resource.
    :vartype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :ivar public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainUpdateParameterProperties.InboundIpRules"
     />`. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :ivar inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :vartype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    :ivar minimum_tls_version_allowed: Minimum TLS version of the publisher allowed to publish to
     this domain. Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
    :ivar disable_local_auth: This boolean is used to enable or disable local auth. Default value
     is false. When the property is set to true, only AAD token will be used to authenticate if user
     is allowed to publish to the domain.
    :vartype disable_local_auth: bool
    :ivar auto_create_topic_with_first_subscription: This Boolean is used to specify the creation
     mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain
     resource.
     In this context, creation of domain topic can be auto-managed (when true) or self-managed
     (when false). The default value for this property is true.
     When this property is null or set to true, Event Grid is responsible of automatically creating
     the domain topic when the first event subscription is
     created at the scope of the domain topic. If this property is set to false, then creating the
     first event subscription will require creating a domain topic
     by the user. The self-management mode can be used if the user wants full control of when the
     domain topic is created, while auto-managed mode provides the
     flexibility to perform less operations and manage fewer resources by the user. Also, note that
     in auto-managed creation mode, user is allowed to create the
     domain topic on demand if needed.
    :vartype auto_create_topic_with_first_subscription: bool
    :ivar auto_delete_topic_with_last_subscription: This Boolean is used to specify the deletion
     mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain
     resource.
     In this context, deletion of domain topic can be auto-managed (when true) or self-managed
     (when false). The default value for this property is true.
     When this property is set to true, Event Grid is responsible of automatically deleting the
     domain topic when the last event subscription at the scope
     of the domain topic is deleted. If this property is set to false, then the user needs to
     manually delete the domain topic when it is no longer needed
     (e.g., when last event subscription is deleted and the resource needs to be cleaned up). The
     self-management mode can be used if the user wants full
     control of when the domain topic needs to be deleted, while auto-managed mode provides the
     flexibility to perform less operations and manage fewer
     resources by the user.
    :vartype auto_delete_topic_with_last_subscription: bool
    :ivar data_residency_boundary: The data residency boundary for the domain. Known values are:
     "WithinGeopair" and "WithinRegion".
    :vartype data_residency_boundary: str or ~azure.mgmt.eventgrid.models.DataResidencyBoundary
    :ivar event_type_info: The eventTypeInfo for the domain.
    :vartype event_type_info: ~azure.mgmt.eventgrid.models.EventTypeInfo
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "IdentityInfo"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "inbound_ip_rules": {"key": "properties.inboundIpRules", "type": "[InboundIpRule]"},
        "minimum_tls_version_allowed": {"key": "properties.minimumTlsVersionAllowed", "type": "str"},
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "auto_create_topic_with_first_subscription": {
            "key": "properties.autoCreateTopicWithFirstSubscription",
            "type": "bool",
        },
        "auto_delete_topic_with_last_subscription": {
            "key": "properties.autoDeleteTopicWithLastSubscription",
            "type": "bool",
        },
        "data_residency_boundary": {"key": "properties.dataResidencyBoundary", "type": "str"},
        "event_type_info": {"key": "properties.eventTypeInfo", "type": "EventTypeInfo"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.IdentityInfo"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["_models.InboundIpRule"]] = None,
        minimum_tls_version_allowed: Optional[Union[str, "_models.TlsVersion"]] = None,
        disable_local_auth: Optional[bool] = None,
        auto_create_topic_with_first_subscription: Optional[bool] = None,
        auto_delete_topic_with_last_subscription: Optional[bool] = None,
        data_residency_boundary: Optional[Union[str, "_models.DataResidencyBoundary"]] = None,
        event_type_info: Optional["_models.EventTypeInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Tags of the domains resource.
        :paramtype tags: dict[str, str]
        :keyword identity: Identity information for the resource.
        :paramtype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
        :keyword public_network_access: This determines if traffic is allowed over public network. By
         default it is enabled.
         You can further restrict to specific IPs by configuring :code:`<seealso
         cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainUpdateParameterProperties.InboundIpRules"  # pylint: disable=line-too-long
         />`. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
        :keyword inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of
         all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
        :paramtype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
        :keyword minimum_tls_version_allowed: Minimum TLS version of the publisher allowed to publish
         to this domain. Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
        :keyword disable_local_auth: This boolean is used to enable or disable local auth. Default
         value is false. When the property is set to true, only AAD token will be used to authenticate
         if user is allowed to publish to the domain.
        :paramtype disable_local_auth: bool
        :keyword auto_create_topic_with_first_subscription: This Boolean is used to specify the
         creation mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid
         Domain resource.
         In this context, creation of domain topic can be auto-managed (when true) or self-managed
         (when false). The default value for this property is true.
         When this property is null or set to true, Event Grid is responsible of automatically creating
         the domain topic when the first event subscription is
         created at the scope of the domain topic. If this property is set to false, then creating the
         first event subscription will require creating a domain topic
         by the user. The self-management mode can be used if the user wants full control of when the
         domain topic is created, while auto-managed mode provides the
         flexibility to perform less operations and manage fewer resources by the user. Also, note that
         in auto-managed creation mode, user is allowed to create the
         domain topic on demand if needed.
        :paramtype auto_create_topic_with_first_subscription: bool
        :keyword auto_delete_topic_with_last_subscription: This Boolean is used to specify the deletion
         mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain
         resource.
         In this context, deletion of domain topic can be auto-managed (when true) or self-managed
         (when false). The default value for this property is true.
         When this property is set to true, Event Grid is responsible of automatically deleting the
         domain topic when the last event subscription at the scope
         of the domain topic is deleted. If this property is set to false, then the user needs to
         manually delete the domain topic when it is no longer needed
         (e.g., when last event subscription is deleted and the resource needs to be cleaned up). The
         self-management mode can be used if the user wants full
         control of when the domain topic needs to be deleted, while auto-managed mode provides the
         flexibility to perform less operations and manage fewer
         resources by the user.
        :paramtype auto_delete_topic_with_last_subscription: bool
        :keyword data_residency_boundary: The data residency boundary for the domain. Known values are:
         "WithinGeopair" and "WithinRegion".
        :paramtype data_residency_boundary: str or ~azure.mgmt.eventgrid.models.DataResidencyBoundary
        :keyword event_type_info: The eventTypeInfo for the domain.
        :paramtype event_type_info: ~azure.mgmt.eventgrid.models.EventTypeInfo
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules
        self.minimum_tls_version_allowed = minimum_tls_version_allowed
        self.disable_local_auth = disable_local_auth
        self.auto_create_topic_with_first_subscription = auto_create_topic_with_first_subscription
        self.auto_delete_topic_with_last_subscription = auto_delete_topic_with_last_subscription
        self.data_residency_boundary = data_residency_boundary
        self.event_type_info = event_type_info


class DynamicDeliveryAttributeMapping(DeliveryAttributeMapping):
    """Dynamic delivery attribute mapping details.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the delivery attribute or header.
    :vartype name: str
    :ivar type: Type of the delivery attribute or header name. Required. Known values are: "Static"
     and "Dynamic".
    :vartype type: str or ~azure.mgmt.eventgrid.models.DeliveryAttributeMappingType
    :ivar source_field: JSON path in the event which contains attribute value.
    :vartype source_field: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "source_field": {"key": "properties.sourceField", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, source_field: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the delivery attribute or header.
        :paramtype name: str
        :keyword source_field: JSON path in the event which contains attribute value.
        :paramtype source_field: str
        """
        super().__init__(name=name, **kwargs)
        self.type: str = "Dynamic"
        self.source_field = source_field


class DynamicRoutingEnrichment(_serialization.Model):
    """DynamicRoutingEnrichment.

    :ivar key: Dynamic routing enrichment key.
    :vartype key: str
    :ivar value: Dynamic routing enrichment value.
    :vartype value: str
    """

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: Dynamic routing enrichment key.
        :paramtype key: str
        :keyword value: Dynamic routing enrichment value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.eventgrid.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.eventgrid.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.eventgrid.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.eventgrid.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class EventHubEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the event hub destination for an event subscription.

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: Type of the endpoint for the event subscription destination. Required.
     Known values are: "WebHook", "EventHub", "StorageQueue", "HybridConnection", "ServiceBusQueue",
     "ServiceBusTopic", "AzureFunction", "MonitorAlert", and "NamespaceTopic".
    :vartype endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :ivar resource_id: The Azure Resource Id that represents the endpoint of an Event Hub
     destination of an event subscription.
    :vartype resource_id: str
    :ivar delivery_attribute_mappings: Delivery attribute details.
    :vartype delivery_attribute_mappings:
     list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        "endpoint_type": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "delivery_attribute_mappings": {
            "key": "properties.deliveryAttributeMappings",
            "type": "[DeliveryAttributeMapping]",
        },
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        delivery_attribute_mappings: Optional[List["_models.DeliveryAttributeMapping"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The Azure Resource Id that represents the endpoint of an Event Hub
         destination of an event subscription.
        :paramtype resource_id: str
        :keyword delivery_attribute_mappings: Delivery attribute details.
        :paramtype delivery_attribute_mappings:
         list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
        """
        super().__init__(**kwargs)
        self.endpoint_type: str = "EventHub"
        self.resource_id = resource_id
        self.delivery_attribute_mappings = delivery_attribute_mappings


class EventSubscription(Resource):
    """Event Subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar topic: Name of the topic of the event subscription.
    :vartype topic: str
    :ivar provisioning_state: Provisioning state of the event subscription. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed", and
     "AwaitingManualAction".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.EventSubscriptionProvisioningState
    :ivar destination: Information about the destination where events have to be delivered for the
     event subscription.
     Uses Azure Event Grid's identity to acquire the authentication tokens being used during
     delivery / dead-lettering.
    :vartype destination: ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    :ivar delivery_with_resource_identity: Information about the destination where events have to
     be delivered for the event subscription.
     Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire
     the authentication tokens being used during delivery / dead-lettering.
    :vartype delivery_with_resource_identity:
     ~azure.mgmt.eventgrid.models.DeliveryWithResourceIdentity
    :ivar filter: Information about the filter for the event subscription.
    :vartype filter: ~azure.mgmt.eventgrid.models.EventSubscriptionFilter
    :ivar labels: List of user defined labels.
    :vartype labels: list[str]
    :ivar expiration_time_utc: Expiration time of the event subscription.
    :vartype expiration_time_utc: ~datetime.datetime
    :ivar event_delivery_schema: The event delivery schema for the event subscription. Known values
     are: "EventGridSchema", "CustomInputSchema", and "CloudEventSchemaV1_0".
    :vartype event_delivery_schema: str or ~azure.mgmt.eventgrid.models.EventDeliverySchema
    :ivar retry_policy: The retry policy for events. This can be used to configure maximum number
     of delivery attempts and time to live for events.
    :vartype retry_policy: ~azure.mgmt.eventgrid.models.RetryPolicy
    :ivar dead_letter_destination: The dead letter destination of the event subscription. Any event
     that cannot be delivered to its' destination is sent to the dead letter destination.
     Uses Azure Event Grid's identity to acquire the authentication tokens being used during
     delivery / dead-lettering.
    :vartype dead_letter_destination: ~azure.mgmt.eventgrid.models.DeadLetterDestination
    :ivar dead_letter_with_resource_identity: The dead letter destination of the event
     subscription. Any event that cannot be delivered to its' destination is sent to the dead letter
     destination.
     Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire
     the authentication tokens being used during delivery / dead-lettering.
    :vartype dead_letter_with_resource_identity:
     ~azure.mgmt.eventgrid.models.DeadLetterWithResourceIdentity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "topic": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "topic": {"key": "properties.topic", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "destination": {"key": "properties.destination", "type": "EventSubscriptionDestination"},
        "delivery_with_resource_identity": {
            "key": "properties.deliveryWithResourceIdentity",
            "type": "DeliveryWithResourceIdentity",
        },
        "filter": {"key": "properties.filter", "type": "EventSubscriptionFilter"},
        "labels": {"key": "properties.labels", "type": "[str]"},
        "expiration_time_utc": {"key": "properties.expirationTimeUtc", "type": "iso-8601"},
        "event_delivery_schema": {"key": "properties.eventDeliverySchema", "type": "str"},
        "retry_policy": {"key": "properties.retryPolicy", "type": "RetryPolicy"},
        "dead_letter_destination": {"key": "properties.deadLetterDestination", "type": "DeadLetterDestination"},
        "dead_letter_with_resource_identity": {
            "key": "properties.deadLetterWithResourceIdentity",
            "type": "DeadLetterWithResourceIdentity",
        },
    }

    def __init__(
        self,
        *,
        destination: Optional["_models.EventSubscriptionDestination"] = None,
        delivery_with_resource_identity: Optional["_models.DeliveryWithResourceIdentity"] = None,
        filter: Optional["_models.EventSubscriptionFilter"] = None,  # pylint: disable=redefined-builtin
        labels: Optional[List[str]] = None,
        expiration_time_utc: Optional[datetime.datetime] = None,
        event_delivery_schema: Optional[Union[str, "_models.EventDeliverySchema"]] = None,
        retry_policy: Optional["_models.RetryPolicy"] = None,
        dead_letter_destination: Optional["_models.DeadLetterDestination"] = None,
        dead_letter_with_resource_identity: Optional["_models.DeadLetterWithResourceIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword destination: Information about the destination where events have to be delivered for
         the event subscription.
         Uses Azure Event Grid's identity to acquire the authentication tokens being used during
         delivery / dead-lettering.
        :paramtype destination: ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
        :keyword delivery_with_resource_identity: Information about the destination where events have
         to be delivered for the event subscription.
         Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire
         the authentication tokens being used during delivery / dead-lettering.
        :paramtype delivery_with_resource_identity:
         ~azure.mgmt.eventgrid.models.DeliveryWithResourceIdentity
        :keyword filter: Information about the filter for the event subscription.
        :paramtype filter: ~azure.mgmt.eventgrid.models.EventSubscriptionFilter
        :keyword labels: List of user defined labels.
        :paramtype labels: list[str]
        :keyword expiration_time_utc: Expiration time of the event subscription.
        :paramtype expiration_time_utc: ~datetime.datetime
        :keyword event_delivery_schema: The event delivery schema for the event subscription. Known
         values are: "EventGridSchema", "CustomInputSchema", and "CloudEventSchemaV1_0".
        :paramtype event_delivery_schema: str or ~azure.mgmt.eventgrid.models.EventDeliverySchema
        :keyword retry_policy: The retry policy for events. This can be used to configure maximum
         number of delivery attempts and time to live for events.
        :paramtype retry_policy: ~azure.mgmt.eventgrid.models.RetryPolicy
        :keyword dead_letter_destination: The dead letter destination of the event subscription. Any
         event that cannot be delivered to its' destination is sent to the dead letter destination.
         Uses Azure Event Grid's identity to acquire the authentication tokens being used during
         delivery / dead-lettering.
        :paramtype dead_letter_destination: ~azure.mgmt.eventgrid.models.DeadLetterDestination
        :keyword dead_letter_with_resource_identity: The dead letter destination of the event
         subscription. Any event that cannot be delivered to its' destination is sent to the dead letter
         destination.
         Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire
         the authentication tokens being used during delivery / dead-lettering.
        :paramtype dead_letter_with_resource_identity:
         ~azure.mgmt.eventgrid.models.DeadLetterWithResourceIdentity
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.topic = None
        self.provisioning_state = None
        self.destination = destination
        self.delivery_with_resource_identity = delivery_with_resource_identity
        self.filter = filter
        self.labels = labels
        self.expiration_time_utc = expiration_time_utc
        self.event_delivery_schema = event_delivery_schema
        self.retry_policy = retry_policy
        self.dead_letter_destination = dead_letter_destination
        self.dead_letter_with_resource_identity = dead_letter_with_resource_identity


class EventSubscriptionFilter(_serialization.Model):
    """Filter for the Event Subscription.

    :ivar subject_begins_with: An optional string to filter events for an event subscription based
     on a resource path prefix.
     The format of this depends on the publisher of the events.
     Wildcard characters are not supported in this path.
    :vartype subject_begins_with: str
    :ivar subject_ends_with: An optional string to filter events for an event subscription based on
     a resource path suffix.
     Wildcard characters are not supported in this path.
    :vartype subject_ends_with: str
    :ivar included_event_types: A list of applicable event types that need to be part of the event
     subscription. If it is desired to subscribe to all default event types, set the
     IncludedEventTypes to null.
    :vartype included_event_types: list[str]
    :ivar is_subject_case_sensitive: Specifies if the SubjectBeginsWith and SubjectEndsWith
     properties of the filter
     should be compared in a case sensitive manner.
    :vartype is_subject_case_sensitive: bool
    :ivar enable_advanced_filtering_on_arrays: Allows advanced filters to be evaluated against an
     array of values instead of expecting a singular value.
    :vartype enable_advanced_filtering_on_arrays: bool
    :ivar advanced_filters: An array of advanced filters that are used for filtering event
     subscriptions.
    :vartype advanced_filters: list[~azure.mgmt.eventgrid.models.AdvancedFilter]
    """

    _attribute_map = {
        "subject_begins_with": {"key": "subjectBeginsWith", "type": "str"},
        "subject_ends_with": {"key": "subjectEndsWith", "type": "str"},
        "included_event_types": {"key": "includedEventTypes", "type": "[str]"},
        "is_subject_case_sensitive": {"key": "isSubjectCaseSensitive", "type": "bool"},
        "enable_advanced_filtering_on_arrays": {"key": "enableAdvancedFilteringOnArrays", "type": "bool"},
        "advanced_filters": {"key": "advancedFilters", "type": "[AdvancedFilter]"},
    }

    def __init__(
        self,
        *,
        subject_begins_with: Optional[str] = None,
        subject_ends_with: Optional[str] = None,
        included_event_types: Optional[List[str]] = None,
        is_subject_case_sensitive: bool = False,
        enable_advanced_filtering_on_arrays: Optional[bool] = None,
        advanced_filters: Optional[List["_models.AdvancedFilter"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subject_begins_with: An optional string to filter events for an event subscription
         based on a resource path prefix.
         The format of this depends on the publisher of the events.
         Wildcard characters are not supported in this path.
        :paramtype subject_begins_with: str
        :keyword subject_ends_with: An optional string to filter events for an event subscription based
         on a resource path suffix.
         Wildcard characters are not supported in this path.
        :paramtype subject_ends_with: str
        :keyword included_event_types: A list of applicable event types that need to be part of the
         event subscription. If it is desired to subscribe to all default event types, set the
         IncludedEventTypes to null.
        :paramtype included_event_types: list[str]
        :keyword is_subject_case_sensitive: Specifies if the SubjectBeginsWith and SubjectEndsWith
         properties of the filter
         should be compared in a case sensitive manner.
        :paramtype is_subject_case_sensitive: bool
        :keyword enable_advanced_filtering_on_arrays: Allows advanced filters to be evaluated against
         an array of values instead of expecting a singular value.
        :paramtype enable_advanced_filtering_on_arrays: bool
        :keyword advanced_filters: An array of advanced filters that are used for filtering event
         subscriptions.
        :paramtype advanced_filters: list[~azure.mgmt.eventgrid.models.AdvancedFilter]
        """
        super().__init__(**kwargs)
        self.subject_begins_with = subject_begins_with
        self.subject_ends_with = subject_ends_with
        self.included_event_types = included_event_types
        self.is_subject_case_sensitive = is_subject_case_sensitive
        self.enable_advanced_filtering_on_arrays = enable_advanced_filtering_on_arrays
        self.advanced_filters = advanced_filters


class EventSubscriptionFullUrl(_serialization.Model):
    """Full endpoint URL of an event subscription.

    :ivar endpoint_url: The URL that represents the endpoint of the destination of an event
     subscription.
    :vartype endpoint_url: str
    """

    _attribute_map = {
        "endpoint_url": {"key": "endpointUrl", "type": "str"},
    }

    def __init__(self, *, endpoint_url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword endpoint_url: The URL that represents the endpoint of the destination of an event
         subscription.
        :paramtype endpoint_url: str
        """
        super().__init__(**kwargs)
        self.endpoint_url = endpoint_url


class EventSubscriptionIdentity(_serialization.Model):
    """The identity information with the event subscription.

    :ivar type: The type of managed identity used. Can be either 'SystemAssigned' or
     'UserAssigned'. Known values are: "SystemAssigned" and "UserAssigned".
    :vartype type: str or ~azure.mgmt.eventgrid.models.EventSubscriptionIdentityType
    :ivar user_assigned_identity: The user identity associated with the resource.
    :vartype user_assigned_identity: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_assigned_identity": {"key": "userAssignedIdentity", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.EventSubscriptionIdentityType"]] = None,
        user_assigned_identity: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of managed identity used. Can be either 'SystemAssigned' or
         'UserAssigned'. Known values are: "SystemAssigned" and "UserAssigned".
        :paramtype type: str or ~azure.mgmt.eventgrid.models.EventSubscriptionIdentityType
        :keyword user_assigned_identity: The user identity associated with the resource.
        :paramtype user_assigned_identity: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.user_assigned_identity = user_assigned_identity


class EventSubscriptionsListResult(_serialization.Model):
    """Result of the List EventSubscriptions operation.

    :ivar value: A collection of EventSubscriptions.
    :vartype value: list[~azure.mgmt.eventgrid.models.EventSubscription]
    :ivar next_link: A link for the next page of event subscriptions.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EventSubscription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.EventSubscription"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of EventSubscriptions.
        :paramtype value: list[~azure.mgmt.eventgrid.models.EventSubscription]
        :keyword next_link: A link for the next page of event subscriptions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EventSubscriptionUpdateParameters(_serialization.Model):
    """Properties of the Event Subscription update.

    :ivar destination: Information about the destination where events have to be delivered for the
     event subscription.
     Uses Azure Event Grid's identity to acquire the authentication tokens being used during
     delivery / dead-lettering.
    :vartype destination: ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    :ivar delivery_with_resource_identity: Information about the destination where events have to
     be delivered for the event subscription.
     Uses the managed identity setup on the parent resource (topic / domain) to acquire the
     authentication tokens being used during delivery / dead-lettering.
    :vartype delivery_with_resource_identity:
     ~azure.mgmt.eventgrid.models.DeliveryWithResourceIdentity
    :ivar filter: Information about the filter for the event subscription.
    :vartype filter: ~azure.mgmt.eventgrid.models.EventSubscriptionFilter
    :ivar labels: List of user defined labels.
    :vartype labels: list[str]
    :ivar expiration_time_utc: Information about the expiration time for the event subscription.
    :vartype expiration_time_utc: ~datetime.datetime
    :ivar event_delivery_schema: The event delivery schema for the event subscription. Known values
     are: "EventGridSchema", "CustomInputSchema", and "CloudEventSchemaV1_0".
    :vartype event_delivery_schema: str or ~azure.mgmt.eventgrid.models.EventDeliverySchema
    :ivar retry_policy: The retry policy for events. This can be used to configure maximum number
     of delivery attempts and time to live for events.
    :vartype retry_policy: ~azure.mgmt.eventgrid.models.RetryPolicy
    :ivar dead_letter_destination: The dead letter destination of the event subscription. Any event
     that cannot be delivered to its' destination is sent to the dead letter destination.
     Uses Azure Event Grid's identity to acquire the authentication tokens being used during
     delivery / dead-lettering.
    :vartype dead_letter_destination: ~azure.mgmt.eventgrid.models.DeadLetterDestination
    :ivar dead_letter_with_resource_identity: The dead letter destination of the event
     subscription. Any event that cannot be delivered to its' destination is sent to the dead letter
     destination.
     Uses the managed identity setup on the parent resource (topic / domain) to acquire the
     authentication tokens being used during delivery / dead-lettering.
    :vartype dead_letter_with_resource_identity:
     ~azure.mgmt.eventgrid.models.DeadLetterWithResourceIdentity
    """

    _attribute_map = {
        "destination": {"key": "destination", "type": "EventSubscriptionDestination"},
        "delivery_with_resource_identity": {
            "key": "deliveryWithResourceIdentity",
            "type": "DeliveryWithResourceIdentity",
        },
        "filter": {"key": "filter", "type": "EventSubscriptionFilter"},
        "labels": {"key": "labels", "type": "[str]"},
        "expiration_time_utc": {"key": "expirationTimeUtc", "type": "iso-8601"},
        "event_delivery_schema": {"key": "eventDeliverySchema", "type": "str"},
        "retry_policy": {"key": "retryPolicy", "type": "RetryPolicy"},
        "dead_letter_destination": {"key": "deadLetterDestination", "type": "DeadLetterDestination"},
        "dead_letter_with_resource_identity": {
            "key": "deadLetterWithResourceIdentity",
            "type": "DeadLetterWithResourceIdentity",
        },
    }

    def __init__(
        self,
        *,
        destination: Optional["_models.EventSubscriptionDestination"] = None,
        delivery_with_resource_identity: Optional["_models.DeliveryWithResourceIdentity"] = None,
        filter: Optional["_models.EventSubscriptionFilter"] = None,  # pylint: disable=redefined-builtin
        labels: Optional[List[str]] = None,
        expiration_time_utc: Optional[datetime.datetime] = None,
        event_delivery_schema: Optional[Union[str, "_models.EventDeliverySchema"]] = None,
        retry_policy: Optional["_models.RetryPolicy"] = None,
        dead_letter_destination: Optional["_models.DeadLetterDestination"] = None,
        dead_letter_with_resource_identity: Optional["_models.DeadLetterWithResourceIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword destination: Information about the destination where events have to be delivered for
         the event subscription.
         Uses Azure Event Grid's identity to acquire the authentication tokens being used during
         delivery / dead-lettering.
        :paramtype destination: ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
        :keyword delivery_with_resource_identity: Information about the destination where events have
         to be delivered for the event subscription.
         Uses the managed identity setup on the parent resource (topic / domain) to acquire the
         authentication tokens being used during delivery / dead-lettering.
        :paramtype delivery_with_resource_identity:
         ~azure.mgmt.eventgrid.models.DeliveryWithResourceIdentity
        :keyword filter: Information about the filter for the event subscription.
        :paramtype filter: ~azure.mgmt.eventgrid.models.EventSubscriptionFilter
        :keyword labels: List of user defined labels.
        :paramtype labels: list[str]
        :keyword expiration_time_utc: Information about the expiration time for the event subscription.
        :paramtype expiration_time_utc: ~datetime.datetime
        :keyword event_delivery_schema: The event delivery schema for the event subscription. Known
         values are: "EventGridSchema", "CustomInputSchema", and "CloudEventSchemaV1_0".
        :paramtype event_delivery_schema: str or ~azure.mgmt.eventgrid.models.EventDeliverySchema
        :keyword retry_policy: The retry policy for events. This can be used to configure maximum
         number of delivery attempts and time to live for events.
        :paramtype retry_policy: ~azure.mgmt.eventgrid.models.RetryPolicy
        :keyword dead_letter_destination: The dead letter destination of the event subscription. Any
         event that cannot be delivered to its' destination is sent to the dead letter destination.
         Uses Azure Event Grid's identity to acquire the authentication tokens being used during
         delivery / dead-lettering.
        :paramtype dead_letter_destination: ~azure.mgmt.eventgrid.models.DeadLetterDestination
        :keyword dead_letter_with_resource_identity: The dead letter destination of the event
         subscription. Any event that cannot be delivered to its' destination is sent to the dead letter
         destination.
         Uses the managed identity setup on the parent resource (topic / domain) to acquire the
         authentication tokens being used during delivery / dead-lettering.
        :paramtype dead_letter_with_resource_identity:
         ~azure.mgmt.eventgrid.models.DeadLetterWithResourceIdentity
        """
        super().__init__(**kwargs)
        self.destination = destination
        self.delivery_with_resource_identity = delivery_with_resource_identity
        self.filter = filter
        self.labels = labels
        self.expiration_time_utc = expiration_time_utc
        self.event_delivery_schema = event_delivery_schema
        self.retry_policy = retry_policy
        self.dead_letter_destination = dead_letter_destination
        self.dead_letter_with_resource_identity = dead_letter_with_resource_identity


class EventType(Resource):
    """Event Type for a subject under a topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar display_name: Display name of the event type.
    :vartype display_name: str
    :ivar description: Description of the event type.
    :vartype description: str
    :ivar schema_url: URL of the schema for this event type.
    :vartype schema_url: str
    :ivar is_in_default_set: IsInDefaultSet flag of the event type.
    :vartype is_in_default_set: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "schema_url": {"key": "properties.schemaUrl", "type": "str"},
        "is_in_default_set": {"key": "properties.isInDefaultSet", "type": "bool"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        schema_url: Optional[str] = None,
        is_in_default_set: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Display name of the event type.
        :paramtype display_name: str
        :keyword description: Description of the event type.
        :paramtype description: str
        :keyword schema_url: URL of the schema for this event type.
        :paramtype schema_url: str
        :keyword is_in_default_set: IsInDefaultSet flag of the event type.
        :paramtype is_in_default_set: bool
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.schema_url = schema_url
        self.is_in_default_set = is_in_default_set


class EventTypeInfo(_serialization.Model):
    """The event type information for Channels.

    :ivar kind: The kind of event type used. "Inline"
    :vartype kind: str or ~azure.mgmt.eventgrid.models.EventDefinitionKind
    :ivar inline_event_types: A collection of inline event types for the resource. The inline event
     type keys are of type string which represents the name of the event.
     An example of a valid inline event name is "Contoso.OrderCreated".
     The inline event type values are of type InlineEventProperties and will contain additional
     information for every inline event type.
    :vartype inline_event_types: dict[str, ~azure.mgmt.eventgrid.models.InlineEventProperties]
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "inline_event_types": {"key": "inlineEventTypes", "type": "{InlineEventProperties}"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.EventDefinitionKind"]] = None,
        inline_event_types: Optional[Dict[str, "_models.InlineEventProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The kind of event type used. "Inline"
        :paramtype kind: str or ~azure.mgmt.eventgrid.models.EventDefinitionKind
        :keyword inline_event_types: A collection of inline event types for the resource. The inline
         event type keys are of type string which represents the name of the event.
         An example of a valid inline event name is "Contoso.OrderCreated".
         The inline event type values are of type InlineEventProperties and will contain additional
         information for every inline event type.
        :paramtype inline_event_types: dict[str, ~azure.mgmt.eventgrid.models.InlineEventProperties]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.inline_event_types = inline_event_types


class EventTypesListResult(_serialization.Model):
    """Result of the List Event Types operation.

    :ivar value: A collection of event types.
    :vartype value: list[~azure.mgmt.eventgrid.models.EventType]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EventType]"},
    }

    def __init__(self, *, value: Optional[List["_models.EventType"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A collection of event types.
        :paramtype value: list[~azure.mgmt.eventgrid.models.EventType]
        """
        super().__init__(**kwargs)
        self.value = value


class ExtensionTopic(Resource):
    """Event grid Extension Topic. This is used for getting Event Grid related metrics for Azure
    resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar description: Description of the extension topic.
    :vartype description: str
    :ivar system_topic: System topic resource id which is mapped to the source.
    :vartype system_topic: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "system_topic": {"key": "properties.systemTopic", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, system_topic: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: Description of the extension topic.
        :paramtype description: str
        :keyword system_topic: System topic resource id which is mapped to the source.
        :paramtype system_topic: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.description = description
        self.system_topic = system_topic


class FiltersConfiguration(_serialization.Model):
    """Filters configuration for the Event Subscription.

    :ivar included_event_types: A list of applicable event types that need to be part of the event
     subscription. If it is desired to subscribe to all default event types, set the
     IncludedEventTypes to null.
    :vartype included_event_types: list[str]
    :ivar filters: An array of filters that are used for filtering event subscriptions.
    :vartype filters: list[~azure.mgmt.eventgrid.models.Filter]
    """

    _attribute_map = {
        "included_event_types": {"key": "includedEventTypes", "type": "[str]"},
        "filters": {"key": "filters", "type": "[Filter]"},
    }

    def __init__(
        self,
        *,
        included_event_types: Optional[List[str]] = None,
        filters: Optional[List["_models.Filter"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword included_event_types: A list of applicable event types that need to be part of the
         event subscription. If it is desired to subscribe to all default event types, set the
         IncludedEventTypes to null.
        :paramtype included_event_types: list[str]
        :keyword filters: An array of filters that are used for filtering event subscriptions.
        :paramtype filters: list[~azure.mgmt.eventgrid.models.Filter]
        """
        super().__init__(**kwargs)
        self.included_event_types = included_event_types
        self.filters = filters


class HybridConnectionEventSubscriptionDestination(EventSubscriptionDestination):  # pylint: disable=name-too-long
    """Information about the HybridConnection destination for an event subscription.

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: Type of the endpoint for the event subscription destination. Required.
     Known values are: "WebHook", "EventHub", "StorageQueue", "HybridConnection", "ServiceBusQueue",
     "ServiceBusTopic", "AzureFunction", "MonitorAlert", and "NamespaceTopic".
    :vartype endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :ivar resource_id: The Azure Resource ID of an hybrid connection that is the destination of an
     event subscription.
    :vartype resource_id: str
    :ivar delivery_attribute_mappings: Delivery attribute details.
    :vartype delivery_attribute_mappings:
     list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        "endpoint_type": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "delivery_attribute_mappings": {
            "key": "properties.deliveryAttributeMappings",
            "type": "[DeliveryAttributeMapping]",
        },
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        delivery_attribute_mappings: Optional[List["_models.DeliveryAttributeMapping"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The Azure Resource ID of an hybrid connection that is the destination of
         an event subscription.
        :paramtype resource_id: str
        :keyword delivery_attribute_mappings: Delivery attribute details.
        :paramtype delivery_attribute_mappings:
         list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
        """
        super().__init__(**kwargs)
        self.endpoint_type: str = "HybridConnection"
        self.resource_id = resource_id
        self.delivery_attribute_mappings = delivery_attribute_mappings


class IdentityInfo(_serialization.Model):
    """The identity information for the resource.

    :ivar type: The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes
     both an implicitly created identity and a set of user-assigned identities. The type 'None' will
     remove any identity. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.eventgrid.models.IdentityType
    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource ids in the form:
    '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
     This property is currently not used and reserved for future usage.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.eventgrid.models.UserIdentityProperties]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserIdentityProperties}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.IdentityType"]] = None,
        principal_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserIdentityProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of managed identity used. The type 'SystemAssigned, UserAssigned'
         includes both an implicitly created identity and a set of user-assigned identities. The type
         'None' will remove any identity. Known values are: "None", "SystemAssigned", "UserAssigned",
         and "SystemAssigned, UserAssigned".
        :paramtype type: str or ~azure.mgmt.eventgrid.models.IdentityType
        :keyword principal_id: The principal ID of resource identity.
        :paramtype principal_id: str
        :keyword tenant_id: The tenant ID of resource.
        :paramtype tenant_id: str
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity dictionary key references will be ARM resource ids in the form:
        '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
         This property is currently not used and reserved for future usage.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.eventgrid.models.UserIdentityProperties]
        """
        super().__init__(**kwargs)
        self.type = type
        self.principal_id = principal_id
        self.tenant_id = tenant_id
        self.user_assigned_identities = user_assigned_identities


class InboundIpRule(_serialization.Model):
    """InboundIpRule.

    :ivar ip_mask: IP Address in CIDR notation e.g., 10.0.0.0/8.
    :vartype ip_mask: str
    :ivar action: Action to perform based on the match or no match of the IpMask. "Allow"
    :vartype action: str or ~azure.mgmt.eventgrid.models.IpActionType
    """

    _attribute_map = {
        "ip_mask": {"key": "ipMask", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_mask: Optional[str] = None,
        action: Optional[Union[str, "_models.IpActionType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_mask: IP Address in CIDR notation e.g., 10.0.0.0/8.
        :paramtype ip_mask: str
        :keyword action: Action to perform based on the match or no match of the IpMask. "Allow"
        :paramtype action: str or ~azure.mgmt.eventgrid.models.IpActionType
        """
        super().__init__(**kwargs)
        self.ip_mask = ip_mask
        self.action = action


class InlineEventProperties(_serialization.Model):
    """Additional information about every inline event.

    :ivar description: The description for the inline event.
    :vartype description: str
    :ivar display_name: The displayName for the inline event.
    :vartype display_name: str
    :ivar documentation_url: The documentationUrl for the inline event.
    :vartype documentation_url: str
    :ivar data_schema_url: The dataSchemaUrl for the inline event.
    :vartype data_schema_url: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "documentation_url": {"key": "documentationUrl", "type": "str"},
        "data_schema_url": {"key": "dataSchemaUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        documentation_url: Optional[str] = None,
        data_schema_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The description for the inline event.
        :paramtype description: str
        :keyword display_name: The displayName for the inline event.
        :paramtype display_name: str
        :keyword documentation_url: The documentationUrl for the inline event.
        :paramtype documentation_url: str
        :keyword data_schema_url: The dataSchemaUrl for the inline event.
        :paramtype data_schema_url: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.display_name = display_name
        self.documentation_url = documentation_url
        self.data_schema_url = data_schema_url


class InputSchemaMapping(_serialization.Model):
    """By default, Event Grid expects events to be in the Event Grid event schema. Specifying an input
    schema mapping enables publishing to Event Grid using a custom input schema. Currently, the
    only supported type of InputSchemaMapping is 'JsonInputSchemaMapping'.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    JsonInputSchemaMapping

    All required parameters must be populated in order to send to server.

    :ivar input_schema_mapping_type: Type of the custom mapping. Required. "Json"
    :vartype input_schema_mapping_type: str or ~azure.mgmt.eventgrid.models.InputSchemaMappingType
    """

    _validation = {
        "input_schema_mapping_type": {"required": True},
    }

    _attribute_map = {
        "input_schema_mapping_type": {"key": "inputSchemaMappingType", "type": "str"},
    }

    _subtype_map = {"input_schema_mapping_type": {"Json": "JsonInputSchemaMapping"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.input_schema_mapping_type: Optional[str] = None


class IsNotNullAdvancedFilter(AdvancedFilter):
    """IsNotNull Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "IsNotNull"


class IsNotNullFilter(Filter):
    """IsNotNull Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "IsNotNull"


class IsNullOrUndefinedAdvancedFilter(AdvancedFilter):
    """IsNullOrUndefined Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "IsNullOrUndefined"


class IsNullOrUndefinedFilter(Filter):
    """IsNullOrUndefined Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "IsNullOrUndefined"


class JsonField(_serialization.Model):
    """This is used to express the source of an input schema mapping for a single target field in the
    Event Grid Event schema. This is currently used in the mappings for the 'id', 'topic' and
    'eventtime' properties. This represents a field in the input event schema.

    :ivar source_field: Name of a field in the input event schema that's to be used as the source
     of a mapping.
    :vartype source_field: str
    """

    _attribute_map = {
        "source_field": {"key": "sourceField", "type": "str"},
    }

    def __init__(self, *, source_field: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword source_field: Name of a field in the input event schema that's to be used as the
         source of a mapping.
        :paramtype source_field: str
        """
        super().__init__(**kwargs)
        self.source_field = source_field


class JsonFieldWithDefault(_serialization.Model):
    """This is used to express the source of an input schema mapping for a single target field
    in the Event Grid Event schema. This is currently used in the mappings for the 'subject',
    'eventtype' and 'dataversion' properties. This represents a field in the input event schema
    along with a default value to be used, and at least one of these two properties should be
    provided.

    :ivar source_field: Name of a field in the input event schema that's to be used as the source
     of a mapping.
    :vartype source_field: str
    :ivar default_value: The default value to be used for mapping when a SourceField is not
     provided or if there's no property with the specified name in the published JSON event payload.
    :vartype default_value: str
    """

    _attribute_map = {
        "source_field": {"key": "sourceField", "type": "str"},
        "default_value": {"key": "defaultValue", "type": "str"},
    }

    def __init__(
        self, *, source_field: Optional[str] = None, default_value: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword source_field: Name of a field in the input event schema that's to be used as the
         source of a mapping.
        :paramtype source_field: str
        :keyword default_value: The default value to be used for mapping when a SourceField is not
         provided or if there's no property with the specified name in the published JSON event payload.
        :paramtype default_value: str
        """
        super().__init__(**kwargs)
        self.source_field = source_field
        self.default_value = default_value


class JsonInputSchemaMapping(InputSchemaMapping):
    """This enables publishing to Event Grid using a custom input schema. This can be used to map
    properties from a custom input JSON schema to the Event Grid event schema.

    All required parameters must be populated in order to send to server.

    :ivar input_schema_mapping_type: Type of the custom mapping. Required. "Json"
    :vartype input_schema_mapping_type: str or ~azure.mgmt.eventgrid.models.InputSchemaMappingType
    :ivar id: The mapping information for the Id property of the Event Grid Event.
    :vartype id: ~azure.mgmt.eventgrid.models.JsonField
    :ivar topic: The mapping information for the Topic property of the Event Grid Event.
    :vartype topic: ~azure.mgmt.eventgrid.models.JsonField
    :ivar event_time: The mapping information for the EventTime property of the Event Grid Event.
    :vartype event_time: ~azure.mgmt.eventgrid.models.JsonField
    :ivar event_type: The mapping information for the EventType property of the Event Grid Event.
    :vartype event_type: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    :ivar subject: The mapping information for the Subject property of the Event Grid Event.
    :vartype subject: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    :ivar data_version: The mapping information for the DataVersion property of the Event Grid
     Event.
    :vartype data_version: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    """

    _validation = {
        "input_schema_mapping_type": {"required": True},
    }

    _attribute_map = {
        "input_schema_mapping_type": {"key": "inputSchemaMappingType", "type": "str"},
        "id": {"key": "properties.id", "type": "JsonField"},
        "topic": {"key": "properties.topic", "type": "JsonField"},
        "event_time": {"key": "properties.eventTime", "type": "JsonField"},
        "event_type": {"key": "properties.eventType", "type": "JsonFieldWithDefault"},
        "subject": {"key": "properties.subject", "type": "JsonFieldWithDefault"},
        "data_version": {"key": "properties.dataVersion", "type": "JsonFieldWithDefault"},
    }

    def __init__(
        self,
        *,
        id: Optional["_models.JsonField"] = None,  # pylint: disable=redefined-builtin
        topic: Optional["_models.JsonField"] = None,
        event_time: Optional["_models.JsonField"] = None,
        event_type: Optional["_models.JsonFieldWithDefault"] = None,
        subject: Optional["_models.JsonFieldWithDefault"] = None,
        data_version: Optional["_models.JsonFieldWithDefault"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The mapping information for the Id property of the Event Grid Event.
        :paramtype id: ~azure.mgmt.eventgrid.models.JsonField
        :keyword topic: The mapping information for the Topic property of the Event Grid Event.
        :paramtype topic: ~azure.mgmt.eventgrid.models.JsonField
        :keyword event_time: The mapping information for the EventTime property of the Event Grid
         Event.
        :paramtype event_time: ~azure.mgmt.eventgrid.models.JsonField
        :keyword event_type: The mapping information for the EventType property of the Event Grid
         Event.
        :paramtype event_type: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
        :keyword subject: The mapping information for the Subject property of the Event Grid Event.
        :paramtype subject: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
        :keyword data_version: The mapping information for the DataVersion property of the Event Grid
         Event.
        :paramtype data_version: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
        """
        super().__init__(**kwargs)
        self.input_schema_mapping_type: str = "Json"
        self.id = id
        self.topic = topic
        self.event_time = event_time
        self.event_type = event_type
        self.subject = subject
        self.data_version = data_version


class MonitorAlertEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the Monitor Alert destination for an event subscription.

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: Type of the endpoint for the event subscription destination. Required.
     Known values are: "WebHook", "EventHub", "StorageQueue", "HybridConnection", "ServiceBusQueue",
     "ServiceBusTopic", "AzureFunction", "MonitorAlert", and "NamespaceTopic".
    :vartype endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :ivar severity: The severity that will be attached to every Alert fired through this event
     subscription.
     This field must be provided. Known values are: "Sev0", "Sev1", "Sev2", "Sev3", and "Sev4".
    :vartype severity: str or ~azure.mgmt.eventgrid.models.MonitorAlertSeverity
    :ivar description: The description that will be attached to every Alert fired through this
     event subscription.
    :vartype description: str
    :ivar action_groups: The list of ARM Ids of Action Groups that will be triggered on every Alert
     fired through this event subscription.
     Each resource ARM Id should follow this pattern:
     /subscriptions/{AzureSubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Insights/actionGroups/{ActionGroupName}.  # pylint: disable=line-too-long
    :vartype action_groups: list[str]
    """

    _validation = {
        "endpoint_type": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "severity": {"key": "properties.severity", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "action_groups": {"key": "properties.actionGroups", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        severity: Optional[Union[str, "_models.MonitorAlertSeverity"]] = None,
        description: Optional[str] = None,
        action_groups: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword severity: The severity that will be attached to every Alert fired through this event
         subscription.
         This field must be provided. Known values are: "Sev0", "Sev1", "Sev2", "Sev3", and "Sev4".
        :paramtype severity: str or ~azure.mgmt.eventgrid.models.MonitorAlertSeverity
        :keyword description: The description that will be attached to every Alert fired through this
         event subscription.
        :paramtype description: str
        :keyword action_groups: The list of ARM Ids of Action Groups that will be triggered on every
         Alert fired through this event subscription.
         Each resource ARM Id should follow this pattern:
         /subscriptions/{AzureSubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Insights/actionGroups/{ActionGroupName}.  # pylint: disable=line-too-long
        :paramtype action_groups: list[str]
        """
        super().__init__(**kwargs)
        self.endpoint_type: str = "MonitorAlert"
        self.severity = severity
        self.description = description
        self.action_groups = action_groups


class Namespace(TrackedResource):
    """Namespace resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar location: Location of the resource. Required.
    :vartype location: str
    :ivar tags: Tags of the resource.
    :vartype tags: dict[str, str]
    :ivar sku: Represents available Sku pricing tiers.
    :vartype sku: ~azure.mgmt.eventgrid.models.NamespaceSku
    :ivar identity: Identity information for the Namespace resource.
    :vartype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :ivar provisioning_state: Provisioning state of the namespace resource. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed", "Deleted",
     "DeleteFailed", "CreateFailed", and "UpdatedFailed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.NamespaceProvisioningState
    :ivar topics_configuration: Topics configuration information for the namespace resource.
    :vartype topics_configuration: ~azure.mgmt.eventgrid.models.TopicsConfiguration
    :ivar topic_spaces_configuration: Topic spaces configuration information for the namespace
     resource.
    :vartype topic_spaces_configuration: ~azure.mgmt.eventgrid.models.TopicSpacesConfiguration
    :ivar is_zone_redundant: This is an optional property and it allows the user to specify if the
     namespace resource supports zone-redundancy capability or not. If this
     property is not specified explicitly by the user, its default value depends on the following
     conditions:
         a. For Availability Zones enabled regions - The default property value would be true.
         b. For non-Availability Zones enabled regions - The default property value would be false.
     Once specified, this property cannot be updated.
    :vartype is_zone_redundant: bool
    :ivar public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules"
     />`. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :ivar inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :vartype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    :ivar minimum_tls_version_allowed: Minimum TLS version of the publisher allowed to publish to
     this namespace. Only TLS version 1.2 is supported. Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "NamespaceSku"},
        "identity": {"key": "identity", "type": "IdentityInfo"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "topics_configuration": {"key": "properties.topicsConfiguration", "type": "TopicsConfiguration"},
        "topic_spaces_configuration": {
            "key": "properties.topicSpacesConfiguration",
            "type": "TopicSpacesConfiguration",
        },
        "is_zone_redundant": {"key": "properties.isZoneRedundant", "type": "bool"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "inbound_ip_rules": {"key": "properties.inboundIpRules", "type": "[InboundIpRule]"},
        "minimum_tls_version_allowed": {"key": "properties.minimumTlsVersionAllowed", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.NamespaceSku"] = None,
        identity: Optional["_models.IdentityInfo"] = None,
        private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = None,
        topics_configuration: Optional["_models.TopicsConfiguration"] = None,
        topic_spaces_configuration: Optional["_models.TopicSpacesConfiguration"] = None,
        is_zone_redundant: Optional[bool] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["_models.InboundIpRule"]] = None,
        minimum_tls_version_allowed: Optional[Union[str, "_models.TlsVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Location of the resource. Required.
        :paramtype location: str
        :keyword tags: Tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword sku: Represents available Sku pricing tiers.
        :paramtype sku: ~azure.mgmt.eventgrid.models.NamespaceSku
        :keyword identity: Identity information for the Namespace resource.
        :paramtype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
        :keyword private_endpoint_connections: List of private endpoint connections.
        :paramtype private_endpoint_connections:
         list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
        :keyword topics_configuration: Topics configuration information for the namespace resource.
        :paramtype topics_configuration: ~azure.mgmt.eventgrid.models.TopicsConfiguration
        :keyword topic_spaces_configuration: Topic spaces configuration information for the namespace
         resource.
        :paramtype topic_spaces_configuration: ~azure.mgmt.eventgrid.models.TopicSpacesConfiguration
        :keyword is_zone_redundant: This is an optional property and it allows the user to specify if
         the namespace resource supports zone-redundancy capability or not. If this
         property is not specified explicitly by the user, its default value depends on the following
         conditions:
             a. For Availability Zones enabled regions - The default property value would be true.
             b. For non-Availability Zones enabled regions - The default property value would be false.
         Once specified, this property cannot be updated.
        :paramtype is_zone_redundant: bool
        :keyword public_network_access: This determines if traffic is allowed over public network. By
         default it is enabled.
         You can further restrict to specific IPs by configuring :code:`<seealso
         cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules"
         />`. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
        :keyword inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of
         all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
        :paramtype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
        :keyword minimum_tls_version_allowed: Minimum TLS version of the publisher allowed to publish
         to this namespace. Only TLS version 1.2 is supported. Known values are: "1.0", "1.1", and
         "1.2".
        :paramtype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.identity = identity
        self.system_data = None
        self.private_endpoint_connections = private_endpoint_connections
        self.provisioning_state = None
        self.topics_configuration = topics_configuration
        self.topic_spaces_configuration = topic_spaces_configuration
        self.is_zone_redundant = is_zone_redundant
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules
        self.minimum_tls_version_allowed = minimum_tls_version_allowed


class NamespaceRegenerateKeyRequest(_serialization.Model):
    """Namespace regenerate share access key request.

    All required parameters must be populated in order to send to server.

    :ivar key_name: Key name to regenerate key1 or key2. Required.
    :vartype key_name: str
    """

    _validation = {
        "key_name": {"required": True},
    }

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
    }

    def __init__(self, *, key_name: str, **kwargs: Any) -> None:
        """
        :keyword key_name: Key name to regenerate key1 or key2. Required.
        :paramtype key_name: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name


class NamespaceSharedAccessKeys(_serialization.Model):
    """Shared access keys of the Namespace.

    :ivar key1: Shared access key1 for the namespace.
    :vartype key1: str
    :ivar key2: Shared access key2 for the namespace.
    :vartype key2: str
    """

    _attribute_map = {
        "key1": {"key": "key1", "type": "str"},
        "key2": {"key": "key2", "type": "str"},
    }

    def __init__(self, *, key1: Optional[str] = None, key2: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key1: Shared access key1 for the namespace.
        :paramtype key1: str
        :keyword key2: Shared access key2 for the namespace.
        :paramtype key2: str
        """
        super().__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class NamespaceSku(_serialization.Model):
    """Represents available Sku pricing tiers.

    :ivar name: The name of the SKU. "Standard"
    :vartype name: str or ~azure.mgmt.eventgrid.models.SkuName
    :ivar capacity: Specifies the number of Throughput Units that defines the capacity for the
     namespace. The property default value is
     1 which signifies 1 Throughput Unit = 1MB/s ingress and 2MB/s egress per namespace. Min
     capacity is 1 and
     max allowed capacity is 20.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[Union[str, "_models.SkuName"]] = None, capacity: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the SKU. "Standard"
        :paramtype name: str or ~azure.mgmt.eventgrid.models.SkuName
        :keyword capacity: Specifies the number of Throughput Units that defines the capacity for the
         namespace. The property default value is
         1 which signifies 1 Throughput Unit = 1MB/s ingress and 2MB/s egress per namespace. Min
         capacity is 1 and
         max allowed capacity is 20.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.capacity = capacity


class NamespacesListResult(_serialization.Model):
    """Result of the List Namespaces operation.

    :ivar value: A collection of namespaces.
    :vartype value: list[~azure.mgmt.eventgrid.models.Namespace]
    :ivar next_link: A link for the next page of namespaces.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Namespace]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Namespace"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of namespaces.
        :paramtype value: list[~azure.mgmt.eventgrid.models.Namespace]
        :keyword next_link: A link for the next page of namespaces.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NamespaceTopic(Resource):
    """Namespace topic details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar provisioning_state: Provisioning state of the namespace topic. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed", "Deleted",
     "DeleteFailed", "CreateFailed", and "UpdatedFailed".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.NamespaceTopicProvisioningState
    :ivar publisher_type: Publisher type of the namespace topic. "Custom"
    :vartype publisher_type: str or ~azure.mgmt.eventgrid.models.PublisherType
    :ivar input_schema: This determines the format that is expected for incoming events published
     to the topic. "CloudEventSchemaV1_0"
    :vartype input_schema: str or ~azure.mgmt.eventgrid.models.EventInputSchema
    :ivar event_retention_in_days: Event retention for the namespace topic expressed in days. The
     property default value is 1 day.
     Min event retention duration value is 1 day and max event retention duration value is 1 day.
    :vartype event_retention_in_days: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "publisher_type": {"key": "properties.publisherType", "type": "str"},
        "input_schema": {"key": "properties.inputSchema", "type": "str"},
        "event_retention_in_days": {"key": "properties.eventRetentionInDays", "type": "int"},
    }

    def __init__(
        self,
        *,
        publisher_type: Optional[Union[str, "_models.PublisherType"]] = None,
        input_schema: Union[str, "_models.EventInputSchema"] = "CloudEventSchemaV1_0",
        event_retention_in_days: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher_type: Publisher type of the namespace topic. "Custom"
        :paramtype publisher_type: str or ~azure.mgmt.eventgrid.models.PublisherType
        :keyword input_schema: This determines the format that is expected for incoming events
         published to the topic. "CloudEventSchemaV1_0"
        :paramtype input_schema: str or ~azure.mgmt.eventgrid.models.EventInputSchema
        :keyword event_retention_in_days: Event retention for the namespace topic expressed in days.
         The property default value is 1 day.
         Min event retention duration value is 1 day and max event retention duration value is 1 day.
        :paramtype event_retention_in_days: int
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.publisher_type = publisher_type
        self.input_schema = input_schema
        self.event_retention_in_days = event_retention_in_days


class NamespaceTopicEventSubscriptionDestination(EventSubscriptionDestination):  # pylint: disable=name-too-long
    """Information about the Namespace Topic destination for an event subscription.

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: Type of the endpoint for the event subscription destination. Required.
     Known values are: "WebHook", "EventHub", "StorageQueue", "HybridConnection", "ServiceBusQueue",
     "ServiceBusTopic", "AzureFunction", "MonitorAlert", and "NamespaceTopic".
    :vartype endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :ivar resource_id: The Azure resource Id that represents the endpoint of the Event Grid
     Namespace Topic destination of an event subscription.
     This field is required and the Namespace Topic resource listed must already exist.
     The resource ARM Id should follow this pattern:
     /subscriptions/{AzureSubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.EventGrid/namespaces/{NamespaceName}/topics/{TopicName}.  # pylint: disable=line-too-long
    :vartype resource_id: str
    """

    _validation = {
        "endpoint_type": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
    }

    def __init__(self, *, resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource_id: The Azure resource Id that represents the endpoint of the Event Grid
         Namespace Topic destination of an event subscription.
         This field is required and the Namespace Topic resource listed must already exist.
         The resource ARM Id should follow this pattern:
         /subscriptions/{AzureSubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.EventGrid/namespaces/{NamespaceName}/topics/{TopicName}.  # pylint: disable=line-too-long
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.endpoint_type: str = "NamespaceTopic"
        self.resource_id = resource_id


class NamespaceTopicsListResult(_serialization.Model):
    """Result of the List namespace topics operation.

    :ivar value: A collection of namespace topics.
    :vartype value: list[~azure.mgmt.eventgrid.models.NamespaceTopic]
    :ivar next_link: A link for the next page of namespace topics.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NamespaceTopic]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NamespaceTopic"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of namespace topics.
        :paramtype value: list[~azure.mgmt.eventgrid.models.NamespaceTopic]
        :keyword next_link: A link for the next page of namespace topics.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NamespaceTopicUpdateParameters(_serialization.Model):
    """Properties of the namespace topic update.

    :ivar event_retention_in_days: Event retention for the namespace topic expressed in days. The
     property default value is 1 day.
     Min event retention duration value is 1 day and max event retention duration value is 1 day.
    :vartype event_retention_in_days: int
    """

    _attribute_map = {
        "event_retention_in_days": {"key": "properties.eventRetentionInDays", "type": "int"},
    }

    def __init__(self, *, event_retention_in_days: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword event_retention_in_days: Event retention for the namespace topic expressed in days.
         The property default value is 1 day.
         Min event retention duration value is 1 day and max event retention duration value is 1 day.
        :paramtype event_retention_in_days: int
        """
        super().__init__(**kwargs)
        self.event_retention_in_days = event_retention_in_days


class NamespaceUpdateParameters(_serialization.Model):
    """Properties to update namespace.

    :ivar tags: Tags of the namespace resource.
    :vartype tags: dict[str, str]
    :ivar identity: Namespace resource identity information.
    :vartype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :ivar sku: Represents available Sku pricing tiers.
    :vartype sku: ~azure.mgmt.eventgrid.models.NamespaceSku
    :ivar topic_spaces_configuration: Topic spaces configuration properties that can be updated.
    :vartype topic_spaces_configuration:
     ~azure.mgmt.eventgrid.models.UpdateTopicSpacesConfigurationInfo
    :ivar topics_configuration: Topics configuration properties that can be updated.
    :vartype topics_configuration: ~azure.mgmt.eventgrid.models.UpdateTopicsConfigurationInfo
    :ivar public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceUpdateParameterProperties.InboundIpRules"  # pylint: disable=line-too-long
     />`. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :ivar inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :vartype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "IdentityInfo"},
        "sku": {"key": "sku", "type": "NamespaceSku"},
        "topic_spaces_configuration": {
            "key": "properties.topicSpacesConfiguration",
            "type": "UpdateTopicSpacesConfigurationInfo",
        },
        "topics_configuration": {"key": "properties.topicsConfiguration", "type": "UpdateTopicsConfigurationInfo"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "inbound_ip_rules": {"key": "properties.inboundIpRules", "type": "[InboundIpRule]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.IdentityInfo"] = None,
        sku: Optional["_models.NamespaceSku"] = None,
        topic_spaces_configuration: Optional["_models.UpdateTopicSpacesConfigurationInfo"] = None,
        topics_configuration: Optional["_models.UpdateTopicsConfigurationInfo"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["_models.InboundIpRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Tags of the namespace resource.
        :paramtype tags: dict[str, str]
        :keyword identity: Namespace resource identity information.
        :paramtype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
        :keyword sku: Represents available Sku pricing tiers.
        :paramtype sku: ~azure.mgmt.eventgrid.models.NamespaceSku
        :keyword topic_spaces_configuration: Topic spaces configuration properties that can be updated.
        :paramtype topic_spaces_configuration:
         ~azure.mgmt.eventgrid.models.UpdateTopicSpacesConfigurationInfo
        :keyword topics_configuration: Topics configuration properties that can be updated.
        :paramtype topics_configuration: ~azure.mgmt.eventgrid.models.UpdateTopicsConfigurationInfo
        :keyword public_network_access: This determines if traffic is allowed over public network. By
         default it is enabled.
         You can further restrict to specific IPs by configuring :code:`<seealso
         cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceUpdateParameterProperties.InboundIpRules"  # pylint: disable=line-too-long
         />`. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
        :keyword inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of
         all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
        :paramtype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.sku = sku
        self.topic_spaces_configuration = topic_spaces_configuration
        self.topics_configuration = topics_configuration
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules


class NumberGreaterThanAdvancedFilter(AdvancedFilter):
    """NumberGreaterThan Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar value: The filter value.
    :vartype value: float
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword value: The filter value.
        :paramtype value: float
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberGreaterThan"
        self.value = value


class NumberGreaterThanFilter(Filter):
    """NumberGreaterThan Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar value: The filter value.
    :vartype value: float
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword value: The filter value.
        :paramtype value: float
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberGreaterThan"
        self.value = value


class NumberGreaterThanOrEqualsAdvancedFilter(AdvancedFilter):
    """NumberGreaterThanOrEquals Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar value: The filter value.
    :vartype value: float
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword value: The filter value.
        :paramtype value: float
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberGreaterThanOrEquals"
        self.value = value


class NumberGreaterThanOrEqualsFilter(Filter):
    """NumberGreaterThanOrEquals Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar value: The filter value.
    :vartype value: float
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword value: The filter value.
        :paramtype value: float
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberGreaterThanOrEquals"
        self.value = value


class NumberInAdvancedFilter(AdvancedFilter):
    """NumberIn Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[float]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[float]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[float]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[float]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberIn"
        self.values = values


class NumberInFilter(Filter):
    """NumberIn Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[float]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[float]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[float]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[float]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberIn"
        self.values = values


class NumberInRangeAdvancedFilter(AdvancedFilter):
    """NumberInRange Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[list[float]]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[[float]]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[List[float]]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[list[float]]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberInRange"
        self.values = values


class NumberInRangeFilter(Filter):
    """NumberInRange Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[list[float]]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[[float]]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[List[float]]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[list[float]]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberInRange"
        self.values = values


class NumberLessThanAdvancedFilter(AdvancedFilter):
    """NumberLessThan Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar value: The filter value.
    :vartype value: float
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword value: The filter value.
        :paramtype value: float
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberLessThan"
        self.value = value


class NumberLessThanFilter(Filter):
    """NumberLessThan Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar value: The filter value.
    :vartype value: float
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword value: The filter value.
        :paramtype value: float
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberLessThan"
        self.value = value


class NumberLessThanOrEqualsAdvancedFilter(AdvancedFilter):
    """NumberLessThanOrEquals Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar value: The filter value.
    :vartype value: float
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword value: The filter value.
        :paramtype value: float
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberLessThanOrEquals"
        self.value = value


class NumberLessThanOrEqualsFilter(Filter):
    """NumberLessThanOrEquals Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar value: The filter value.
    :vartype value: float
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword value: The filter value.
        :paramtype value: float
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberLessThanOrEquals"
        self.value = value


class NumberNotInAdvancedFilter(AdvancedFilter):
    """NumberNotIn Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[float]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[float]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[float]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[float]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberNotIn"
        self.values = values


class NumberNotInFilter(Filter):
    """NumberNotIn Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[float]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[float]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[float]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[float]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberNotIn"
        self.values = values


class NumberNotInRangeAdvancedFilter(AdvancedFilter):
    """NumberNotInRange Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[list[float]]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[[float]]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[List[float]]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[list[float]]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberNotInRange"
        self.values = values


class NumberNotInRangeFilter(Filter):
    """NumberNotInRange Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[list[float]]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[[float]]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[List[float]]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[list[float]]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "NumberNotInRange"
        self.values = values


class Operation(_serialization.Model):
    """Represents an operation returned by the GetOperations request.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar display: Display name of the operation.
    :vartype display: ~azure.mgmt.eventgrid.models.OperationInfo
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar is_data_action: This Boolean is used to determine if the operation is a data plane action
     or not.
    :vartype is_data_action: bool
    :ivar properties: Properties of the operation.
    :vartype properties: JSON
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationInfo"},
        "origin": {"key": "origin", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationInfo"] = None,
        origin: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        properties: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword display: Display name of the operation.
        :paramtype display: ~azure.mgmt.eventgrid.models.OperationInfo
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        :keyword is_data_action: This Boolean is used to determine if the operation is a data plane
         action or not.
        :paramtype is_data_action: bool
        :keyword properties: Properties of the operation.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.is_data_action = is_data_action
        self.properties = properties


class OperationInfo(_serialization.Model):
    """Information about an operation.

    :ivar provider: Name of the provider.
    :vartype provider: str
    :ivar resource: Name of the resource type.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Name of the provider.
        :paramtype provider: str
        :keyword resource: Name of the resource type.
        :paramtype resource: str
        :keyword operation: Name of the operation.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationsListResult(_serialization.Model):
    """Result of the List Operations operation.

    :ivar value: A collection of operations.
    :vartype value: list[~azure.mgmt.eventgrid.models.Operation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A collection of operations.
        :paramtype value: list[~azure.mgmt.eventgrid.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value


class Partner(_serialization.Model):
    """Information about the partner.

    :ivar partner_registration_immutable_id: The immutableId of the corresponding partner
     registration.
    :vartype partner_registration_immutable_id: str
    :ivar partner_name: The partner name.
    :vartype partner_name: str
    :ivar authorization_expiration_time_in_utc: Expiration time of the partner authorization. If
     this timer expires, any request from this partner to create, update or delete resources in
     subscriber's
     context will fail. If specified, the allowed values are between 1 to the value of
     defaultMaximumExpirationTimeInDays specified in PartnerConfiguration.
     If not specified, the default value will be the value of defaultMaximumExpirationTimeInDays
     specified in PartnerConfiguration or 7 if this value is not specified.
    :vartype authorization_expiration_time_in_utc: ~datetime.datetime
    """

    _attribute_map = {
        "partner_registration_immutable_id": {"key": "partnerRegistrationImmutableId", "type": "str"},
        "partner_name": {"key": "partnerName", "type": "str"},
        "authorization_expiration_time_in_utc": {"key": "authorizationExpirationTimeInUtc", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        partner_registration_immutable_id: Optional[str] = None,
        partner_name: Optional[str] = None,
        authorization_expiration_time_in_utc: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword partner_registration_immutable_id: The immutableId of the corresponding partner
         registration.
        :paramtype partner_registration_immutable_id: str
        :keyword partner_name: The partner name.
        :paramtype partner_name: str
        :keyword authorization_expiration_time_in_utc: Expiration time of the partner authorization. If
         this timer expires, any request from this partner to create, update or delete resources in
         subscriber's
         context will fail. If specified, the allowed values are between 1 to the value of
         defaultMaximumExpirationTimeInDays specified in PartnerConfiguration.
         If not specified, the default value will be the value of defaultMaximumExpirationTimeInDays
         specified in PartnerConfiguration or 7 if this value is not specified.
        :paramtype authorization_expiration_time_in_utc: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.partner_registration_immutable_id = partner_registration_immutable_id
        self.partner_name = partner_name
        self.authorization_expiration_time_in_utc = authorization_expiration_time_in_utc


class PartnerAuthorization(_serialization.Model):
    """The partner authorization details.

    :ivar default_maximum_expiration_time_in_days: Time used to validate the authorization
     expiration time for each authorized partner. If DefaultMaximumExpirationTimeInDays is
     not specified, the default is 7 days. Otherwise, allowed values are between 1 and 365 days.
    :vartype default_maximum_expiration_time_in_days: int
    :ivar authorized_partners_list: The list of authorized partners.
    :vartype authorized_partners_list: list[~azure.mgmt.eventgrid.models.Partner]
    """

    _attribute_map = {
        "default_maximum_expiration_time_in_days": {"key": "defaultMaximumExpirationTimeInDays", "type": "int"},
        "authorized_partners_list": {"key": "authorizedPartnersList", "type": "[Partner]"},
    }

    def __init__(
        self,
        *,
        default_maximum_expiration_time_in_days: Optional[int] = None,
        authorized_partners_list: Optional[List["_models.Partner"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword default_maximum_expiration_time_in_days: Time used to validate the authorization
         expiration time for each authorized partner. If DefaultMaximumExpirationTimeInDays is
         not specified, the default is 7 days. Otherwise, allowed values are between 1 and 365 days.
        :paramtype default_maximum_expiration_time_in_days: int
        :keyword authorized_partners_list: The list of authorized partners.
        :paramtype authorized_partners_list: list[~azure.mgmt.eventgrid.models.Partner]
        """
        super().__init__(**kwargs)
        self.default_maximum_expiration_time_in_days = default_maximum_expiration_time_in_days
        self.authorized_partners_list = authorized_partners_list


class PartnerConfiguration(Resource):
    """Partner configuration information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar location: Location of the resource.
    :vartype location: str
    :ivar tags: Tags of the resource.
    :vartype tags: dict[str, str]
    :ivar partner_authorization: The details of authorized partners.
    :vartype partner_authorization: ~azure.mgmt.eventgrid.models.PartnerAuthorization
    :ivar provisioning_state: Provisioning state of the partner configuration. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.PartnerConfigurationProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "partner_authorization": {"key": "properties.partnerAuthorization", "type": "PartnerAuthorization"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        partner_authorization: Optional["_models.PartnerAuthorization"] = None,
        provisioning_state: Optional[Union[str, "_models.PartnerConfigurationProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Location of the resource.
        :paramtype location: str
        :keyword tags: Tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword partner_authorization: The details of authorized partners.
        :paramtype partner_authorization: ~azure.mgmt.eventgrid.models.PartnerAuthorization
        :keyword provisioning_state: Provisioning state of the partner configuration. Known values are:
         "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
        :paramtype provisioning_state: str or
         ~azure.mgmt.eventgrid.models.PartnerConfigurationProvisioningState
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.location = location
        self.tags = tags
        self.partner_authorization = partner_authorization
        self.provisioning_state = provisioning_state


class PartnerConfigurationsListResult(_serialization.Model):
    """Result of the List partner configurations operation.

    :ivar value: A collection of partner configurations.
    :vartype value: list[~azure.mgmt.eventgrid.models.PartnerConfiguration]
    :ivar next_link: A link for the next page of partner configurations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PartnerConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PartnerConfiguration"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of partner configurations.
        :paramtype value: list[~azure.mgmt.eventgrid.models.PartnerConfiguration]
        :keyword next_link: A link for the next page of partner configurations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PartnerConfigurationUpdateParameters(_serialization.Model):
    """Properties of the partner configuration update.

    :ivar tags: Tags of the partner configuration resource.
    :vartype tags: dict[str, str]
    :ivar default_maximum_expiration_time_in_days: The default time used to validate the maximum
     expiration time for each authorized partners in days. Allowed values ar between 1 and 365 days.
    :vartype default_maximum_expiration_time_in_days: int
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "default_maximum_expiration_time_in_days": {
            "key": "properties.defaultMaximumExpirationTimeInDays",
            "type": "int",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        default_maximum_expiration_time_in_days: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Tags of the partner configuration resource.
        :paramtype tags: dict[str, str]
        :keyword default_maximum_expiration_time_in_days: The default time used to validate the maximum
         expiration time for each authorized partners in days. Allowed values ar between 1 and 365 days.
        :paramtype default_maximum_expiration_time_in_days: int
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.default_maximum_expiration_time_in_days = default_maximum_expiration_time_in_days


class PartnerDetails(_serialization.Model):
    """Information about the partner.

    :ivar description: This is short description about the partner. The length of this description
     should not exceed 256 characters.
    :vartype description: str
    :ivar long_description: Long description for the partner's scenarios and integration.Length of
     this description should not exceed 2048 characters.
    :vartype long_description: str
    :ivar setup_uri: URI of the partner website that can be used by Azure customers to setup Event
     Grid
     integration on an event source.
    :vartype setup_uri: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "long_description": {"key": "longDescription", "type": "str"},
        "setup_uri": {"key": "setupUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        long_description: Optional[str] = None,
        setup_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: This is short description about the partner. The length of this
         description should not exceed 256 characters.
        :paramtype description: str
        :keyword long_description: Long description for the partner's scenarios and integration.Length
         of this description should not exceed 2048 characters.
        :paramtype long_description: str
        :keyword setup_uri: URI of the partner website that can be used by Azure customers to setup
         Event Grid
         integration on an event source.
        :paramtype setup_uri: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.long_description = long_description
        self.setup_uri = setup_uri


class PartnerNamespace(TrackedResource):
    """EventGrid Partner Namespace.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar location: Location of the resource. Required.
    :vartype location: str
    :ivar tags: Tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :ivar provisioning_state: Provisioning state of the partner namespace. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.PartnerNamespaceProvisioningState
    :ivar partner_registration_fully_qualified_id: The fully qualified ARM Id of the partner
     registration that should be associated with this partner namespace. This takes the following
     format:
    /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}.  # pylint: disable=line-too-long
    :vartype partner_registration_fully_qualified_id: str
    :ivar minimum_tls_version_allowed: Minimum TLS version of the publisher allowed to publish to
     this partner namespace. Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
    :ivar endpoint: Endpoint for the partner namespace.
    :vartype endpoint: str
    :ivar public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PartnerNamespaceProperties.InboundIpRules"
     />`. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :ivar inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :vartype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    :ivar disable_local_auth: This boolean is used to enable or disable local auth. Default value
     is false. When the property is set to true, only AAD token will be used to authenticate if user
     is allowed to publish to the partner namespace.
    :vartype disable_local_auth: bool
    :ivar partner_topic_routing_mode: This determines if events published to this partner namespace
     should use the source attribute in the event payload
     or use the channel name in the header when matching to the partner topic. If none is
     specified, source attribute routing will be used to match the partner topic. Known values are:
     "SourceEventAttribute" and "ChannelNameHeader".
    :vartype partner_topic_routing_mode: str or
     ~azure.mgmt.eventgrid.models.PartnerTopicRoutingMode
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "endpoint": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "partner_registration_fully_qualified_id": {
            "key": "properties.partnerRegistrationFullyQualifiedId",
            "type": "str",
        },
        "minimum_tls_version_allowed": {"key": "properties.minimumTlsVersionAllowed", "type": "str"},
        "endpoint": {"key": "properties.endpoint", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "inbound_ip_rules": {"key": "properties.inboundIpRules", "type": "[InboundIpRule]"},
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "partner_topic_routing_mode": {"key": "properties.partnerTopicRoutingMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        partner_registration_fully_qualified_id: Optional[str] = None,
        minimum_tls_version_allowed: Optional[Union[str, "_models.TlsVersion"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["_models.InboundIpRule"]] = None,
        disable_local_auth: bool = False,
        partner_topic_routing_mode: Union[str, "_models.PartnerTopicRoutingMode"] = "SourceEventAttribute",
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Location of the resource. Required.
        :paramtype location: str
        :keyword tags: Tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword partner_registration_fully_qualified_id: The fully qualified ARM Id of the partner
         registration that should be associated with this partner namespace. This takes the following
         format:
        /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}.  # pylint: disable=line-too-long
        :paramtype partner_registration_fully_qualified_id: str
        :keyword minimum_tls_version_allowed: Minimum TLS version of the publisher allowed to publish
         to this partner namespace. Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
        :keyword public_network_access: This determines if traffic is allowed over public network. By
         default it is enabled.
         You can further restrict to specific IPs by configuring :code:`<seealso
         cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PartnerNamespaceProperties.InboundIpRules"
         />`. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
        :keyword inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of
         all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
        :paramtype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
        :keyword disable_local_auth: This boolean is used to enable or disable local auth. Default
         value is false. When the property is set to true, only AAD token will be used to authenticate
         if user is allowed to publish to the partner namespace.
        :paramtype disable_local_auth: bool
        :keyword partner_topic_routing_mode: This determines if events published to this partner
         namespace should use the source attribute in the event payload
         or use the channel name in the header when matching to the partner topic. If none is
         specified, source attribute routing will be used to match the partner topic. Known values are:
         "SourceEventAttribute" and "ChannelNameHeader".
        :paramtype partner_topic_routing_mode: str or
         ~azure.mgmt.eventgrid.models.PartnerTopicRoutingMode
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.system_data = None
        self.private_endpoint_connections = None
        self.provisioning_state = None
        self.partner_registration_fully_qualified_id = partner_registration_fully_qualified_id
        self.minimum_tls_version_allowed = minimum_tls_version_allowed
        self.endpoint = None
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules
        self.disable_local_auth = disable_local_auth
        self.partner_topic_routing_mode = partner_topic_routing_mode


class PartnerNamespaceRegenerateKeyRequest(_serialization.Model):
    """PartnerNamespace regenerate shared access key request.

    All required parameters must be populated in order to send to server.

    :ivar key_name: Key name to regenerate (key1 or key2). Required.
    :vartype key_name: str
    """

    _validation = {
        "key_name": {"required": True},
    }

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
    }

    def __init__(self, *, key_name: str, **kwargs: Any) -> None:
        """
        :keyword key_name: Key name to regenerate (key1 or key2). Required.
        :paramtype key_name: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name


class PartnerNamespaceSharedAccessKeys(_serialization.Model):
    """Shared access keys of the partner namespace.

    :ivar key1: Shared access key1 for the partner namespace.
    :vartype key1: str
    :ivar key2: Shared access key2 for the partner namespace.
    :vartype key2: str
    """

    _attribute_map = {
        "key1": {"key": "key1", "type": "str"},
        "key2": {"key": "key2", "type": "str"},
    }

    def __init__(self, *, key1: Optional[str] = None, key2: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key1: Shared access key1 for the partner namespace.
        :paramtype key1: str
        :keyword key2: Shared access key2 for the partner namespace.
        :paramtype key2: str
        """
        super().__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class PartnerNamespacesListResult(_serialization.Model):
    """Result of the List Partner Namespaces operation.

    :ivar value: A collection of partner namespaces.
    :vartype value: list[~azure.mgmt.eventgrid.models.PartnerNamespace]
    :ivar next_link: A link for the next page of partner namespaces.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PartnerNamespace]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PartnerNamespace"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of partner namespaces.
        :paramtype value: list[~azure.mgmt.eventgrid.models.PartnerNamespace]
        :keyword next_link: A link for the next page of partner namespaces.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PartnerNamespaceUpdateParameters(_serialization.Model):
    """Properties of the Partner Namespace update.

    :ivar tags: Tags of the Partner Namespace.
    :vartype tags: dict[str, str]
    :ivar public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PartnerNamespaceUpdateParameterProperties.InboundIpRules"  # pylint: disable=line-too-long
     />`. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :ivar inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :vartype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    :ivar minimum_tls_version_allowed: Minimum TLS version of the publisher allowed to publish to
     this domain. Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
    :ivar disable_local_auth: This boolean is used to enable or disable local auth. Default value
     is false. When the property is set to true, only AAD token will be used to authenticate if user
     is allowed to publish to the partner namespace.
    :vartype disable_local_auth: bool
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "inbound_ip_rules": {"key": "properties.inboundIpRules", "type": "[InboundIpRule]"},
        "minimum_tls_version_allowed": {"key": "properties.minimumTlsVersionAllowed", "type": "str"},
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["_models.InboundIpRule"]] = None,
        minimum_tls_version_allowed: Optional[Union[str, "_models.TlsVersion"]] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Tags of the Partner Namespace.
        :paramtype tags: dict[str, str]
        :keyword public_network_access: This determines if traffic is allowed over public network. By
         default it is enabled.
         You can further restrict to specific IPs by configuring :code:`<seealso
         cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PartnerNamespaceUpdateParameterProperties.InboundIpRules"  # pylint: disable=line-too-long
         />`. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
        :keyword inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of
         all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
        :paramtype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
        :keyword minimum_tls_version_allowed: Minimum TLS version of the publisher allowed to publish
         to this domain. Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
        :keyword disable_local_auth: This boolean is used to enable or disable local auth. Default
         value is false. When the property is set to true, only AAD token will be used to authenticate
         if user is allowed to publish to the partner namespace.
        :paramtype disable_local_auth: bool
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules
        self.minimum_tls_version_allowed = minimum_tls_version_allowed
        self.disable_local_auth = disable_local_auth


class PartnerRegistration(TrackedResource):
    """Information about a partner registration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar location: Location of the resource. Required.
    :vartype location: str
    :ivar tags: Tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar provisioning_state: Provisioning state of the partner registration. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.PartnerRegistrationProvisioningState
    :ivar partner_registration_immutable_id: The immutableId of the corresponding partner
     registration.
     Note: This property is marked for deprecation and is not supported in any future GA API
     version.
    :vartype partner_registration_immutable_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "partner_registration_immutable_id": {"key": "properties.partnerRegistrationImmutableId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        partner_registration_immutable_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Location of the resource. Required.
        :paramtype location: str
        :keyword tags: Tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword partner_registration_immutable_id: The immutableId of the corresponding partner
         registration.
         Note: This property is marked for deprecation and is not supported in any future GA API
         version.
        :paramtype partner_registration_immutable_id: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.partner_registration_immutable_id = partner_registration_immutable_id


class PartnerRegistrationsListResult(_serialization.Model):
    """Result of the List Partner Registrations operation.

    :ivar value: A collection of partner registrations.
    :vartype value: list[~azure.mgmt.eventgrid.models.PartnerRegistration]
    :ivar next_link: A link for the next page of partner registrations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PartnerRegistration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PartnerRegistration"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of partner registrations.
        :paramtype value: list[~azure.mgmt.eventgrid.models.PartnerRegistration]
        :keyword next_link: A link for the next page of partner registrations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PartnerRegistrationUpdateParameters(_serialization.Model):
    """Properties of the Partner Registration update.

    :ivar tags: Tags of the partner registration resource.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Tags of the partner registration resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class PartnerTopic(TrackedResource):
    """Event Grid Partner Topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar location: Location of the resource. Required.
    :vartype location: str
    :ivar tags: Tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar identity: Identity information for the Partner Topic resource.
    :vartype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :ivar partner_registration_immutable_id: The immutableId of the corresponding partner
     registration.
    :vartype partner_registration_immutable_id: str
    :ivar source: Source associated with this partner topic. This represents a unique partner
     resource.
    :vartype source: str
    :ivar event_type_info: Event Type information from the corresponding event channel.
    :vartype event_type_info: ~azure.mgmt.eventgrid.models.EventTypeInfo
    :ivar expiration_time_if_not_activated_utc: Expiration time of the partner topic. If this timer
     expires while the partner topic is still never activated,
     the partner topic and corresponding event channel are deleted.
    :vartype expiration_time_if_not_activated_utc: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the partner topic. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed", and
     "IdleDueToMirroredChannelResourceDeletion".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.PartnerTopicProvisioningState
    :ivar activation_state: Activation state of the partner topic. Known values are:
     "NeverActivated", "Activated", and "Deactivated".
    :vartype activation_state: str or ~azure.mgmt.eventgrid.models.PartnerTopicActivationState
    :ivar partner_topic_friendly_description: Friendly description about the topic. This can be set
     by the publisher/partner to show custom description for the customer partner topic.
     This will be helpful to remove any ambiguity of the origin of creation of the partner topic
     for the customer.
    :vartype partner_topic_friendly_description: str
    :ivar message_for_activation: Context or helpful message that can be used during the approval
     process by the subscriber.
    :vartype message_for_activation: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "identity": {"key": "identity", "type": "IdentityInfo"},
        "partner_registration_immutable_id": {"key": "properties.partnerRegistrationImmutableId", "type": "str"},
        "source": {"key": "properties.source", "type": "str"},
        "event_type_info": {"key": "properties.eventTypeInfo", "type": "EventTypeInfo"},
        "expiration_time_if_not_activated_utc": {
            "key": "properties.expirationTimeIfNotActivatedUtc",
            "type": "iso-8601",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "activation_state": {"key": "properties.activationState", "type": "str"},
        "partner_topic_friendly_description": {"key": "properties.partnerTopicFriendlyDescription", "type": "str"},
        "message_for_activation": {"key": "properties.messageForActivation", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.IdentityInfo"] = None,
        partner_registration_immutable_id: Optional[str] = None,
        source: Optional[str] = None,
        event_type_info: Optional["_models.EventTypeInfo"] = None,
        expiration_time_if_not_activated_utc: Optional[datetime.datetime] = None,
        activation_state: Optional[Union[str, "_models.PartnerTopicActivationState"]] = None,
        partner_topic_friendly_description: Optional[str] = None,
        message_for_activation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Location of the resource. Required.
        :paramtype location: str
        :keyword tags: Tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword identity: Identity information for the Partner Topic resource.
        :paramtype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
        :keyword partner_registration_immutable_id: The immutableId of the corresponding partner
         registration.
        :paramtype partner_registration_immutable_id: str
        :keyword source: Source associated with this partner topic. This represents a unique partner
         resource.
        :paramtype source: str
        :keyword event_type_info: Event Type information from the corresponding event channel.
        :paramtype event_type_info: ~azure.mgmt.eventgrid.models.EventTypeInfo
        :keyword expiration_time_if_not_activated_utc: Expiration time of the partner topic. If this
         timer expires while the partner topic is still never activated,
         the partner topic and corresponding event channel are deleted.
        :paramtype expiration_time_if_not_activated_utc: ~datetime.datetime
        :keyword activation_state: Activation state of the partner topic. Known values are:
         "NeverActivated", "Activated", and "Deactivated".
        :paramtype activation_state: str or ~azure.mgmt.eventgrid.models.PartnerTopicActivationState
        :keyword partner_topic_friendly_description: Friendly description about the topic. This can be
         set by the publisher/partner to show custom description for the customer partner topic.
         This will be helpful to remove any ambiguity of the origin of creation of the partner topic
         for the customer.
        :paramtype partner_topic_friendly_description: str
        :keyword message_for_activation: Context or helpful message that can be used during the
         approval process by the subscriber.
        :paramtype message_for_activation: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.system_data = None
        self.identity = identity
        self.partner_registration_immutable_id = partner_registration_immutable_id
        self.source = source
        self.event_type_info = event_type_info
        self.expiration_time_if_not_activated_utc = expiration_time_if_not_activated_utc
        self.provisioning_state = None
        self.activation_state = activation_state
        self.partner_topic_friendly_description = partner_topic_friendly_description
        self.message_for_activation = message_for_activation


class PartnerTopicInfo(_serialization.Model):
    """Properties of the corresponding partner topic of a Channel.

    :ivar azure_subscription_id: Azure subscription ID of the subscriber. The partner topic
     associated with the channel will be
     created under this Azure subscription.
    :vartype azure_subscription_id: str
    :ivar resource_group_name: Azure Resource Group of the subscriber. The partner topic associated
     with the channel will be
     created under this resource group.
    :vartype resource_group_name: str
    :ivar name: Name of the partner topic associated with the channel.
    :vartype name: str
    :ivar event_type_info: Event Type Information for the partner topic. This information is
     provided by the publisher and can be used by the
     subscriber to view different types of events that are published.
    :vartype event_type_info: ~azure.mgmt.eventgrid.models.EventTypeInfo
    :ivar source: The source information is provided by the publisher to determine the scope or
     context from which the events
     are originating. This information can be used by the subscriber during the approval process of
     the
     created partner topic.
    :vartype source: str
    """

    _attribute_map = {
        "azure_subscription_id": {"key": "azureSubscriptionId", "type": "str"},
        "resource_group_name": {"key": "resourceGroupName", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "event_type_info": {"key": "eventTypeInfo", "type": "EventTypeInfo"},
        "source": {"key": "source", "type": "str"},
    }

    def __init__(
        self,
        *,
        azure_subscription_id: Optional[str] = None,
        resource_group_name: Optional[str] = None,
        name: Optional[str] = None,
        event_type_info: Optional["_models.EventTypeInfo"] = None,
        source: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword azure_subscription_id: Azure subscription ID of the subscriber. The partner topic
         associated with the channel will be
         created under this Azure subscription.
        :paramtype azure_subscription_id: str
        :keyword resource_group_name: Azure Resource Group of the subscriber. The partner topic
         associated with the channel will be
         created under this resource group.
        :paramtype resource_group_name: str
        :keyword name: Name of the partner topic associated with the channel.
        :paramtype name: str
        :keyword event_type_info: Event Type Information for the partner topic. This information is
         provided by the publisher and can be used by the
         subscriber to view different types of events that are published.
        :paramtype event_type_info: ~azure.mgmt.eventgrid.models.EventTypeInfo
        :keyword source: The source information is provided by the publisher to determine the scope or
         context from which the events
         are originating. This information can be used by the subscriber during the approval process of
         the
         created partner topic.
        :paramtype source: str
        """
        super().__init__(**kwargs)
        self.azure_subscription_id = azure_subscription_id
        self.resource_group_name = resource_group_name
        self.name = name
        self.event_type_info = event_type_info
        self.source = source


class PartnerTopicsListResult(_serialization.Model):
    """Result of the List Partner Topics operation.

    :ivar value: A collection of partner topics.
    :vartype value: list[~azure.mgmt.eventgrid.models.PartnerTopic]
    :ivar next_link: A link for the next page of partner topics.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PartnerTopic]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PartnerTopic"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of partner topics.
        :paramtype value: list[~azure.mgmt.eventgrid.models.PartnerTopic]
        :keyword next_link: A link for the next page of partner topics.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PartnerTopicUpdateParameters(_serialization.Model):
    """Properties of the Partner Topic update.

    :ivar tags: Tags of the Partner Topic resource.
    :vartype tags: dict[str, str]
    :ivar identity: Identity information for the Partner Topic resource.
    :vartype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "IdentityInfo"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, identity: Optional["_models.IdentityInfo"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Tags of the Partner Topic resource.
        :paramtype tags: dict[str, str]
        :keyword identity: Identity information for the Partner Topic resource.
        :paramtype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity


class PartnerUpdateTopicInfo(_serialization.Model):
    """Update properties for the corresponding partner topic of a channel.

    :ivar event_type_info: Event type info for the partner topic.
    :vartype event_type_info: ~azure.mgmt.eventgrid.models.EventTypeInfo
    """

    _attribute_map = {
        "event_type_info": {"key": "eventTypeInfo", "type": "EventTypeInfo"},
    }

    def __init__(self, *, event_type_info: Optional["_models.EventTypeInfo"] = None, **kwargs: Any) -> None:
        """
        :keyword event_type_info: Event type info for the partner topic.
        :paramtype event_type_info: ~azure.mgmt.eventgrid.models.EventTypeInfo
        """
        super().__init__(**kwargs)
        self.event_type_info = event_type_info


class PermissionBinding(Resource):
    """The Permission binding resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar description: Description for the Permission Binding resource.
    :vartype description: str
    :ivar topic_space_name: The name of the Topic Space resource that the permission is bound to.
     The Topic space needs to be a resource under the same namespace the permission binding is a
     part of.
    :vartype topic_space_name: str
    :ivar permission: The allowed permission. Known values are: "Publisher" and "Subscriber".
    :vartype permission: str or ~azure.mgmt.eventgrid.models.PermissionType
    :ivar client_group_name: The name of the client group resource that the permission is bound to.
     The client group needs to be a resource under the same namespace the permission binding is a
     part of.
    :vartype client_group_name: str
    :ivar provisioning_state: Provisioning state of the PermissionBinding resource. Known values
     are: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed", and "Deleted".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.PermissionBindingProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "topic_space_name": {"key": "properties.topicSpaceName", "type": "str"},
        "permission": {"key": "properties.permission", "type": "str"},
        "client_group_name": {"key": "properties.clientGroupName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        topic_space_name: Optional[str] = None,
        permission: Optional[Union[str, "_models.PermissionType"]] = None,
        client_group_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description for the Permission Binding resource.
        :paramtype description: str
        :keyword topic_space_name: The name of the Topic Space resource that the permission is bound
         to.
         The Topic space needs to be a resource under the same namespace the permission binding is a
         part of.
        :paramtype topic_space_name: str
        :keyword permission: The allowed permission. Known values are: "Publisher" and "Subscriber".
        :paramtype permission: str or ~azure.mgmt.eventgrid.models.PermissionType
        :keyword client_group_name: The name of the client group resource that the permission is bound
         to.
         The client group needs to be a resource under the same namespace the permission binding is a
         part of.
        :paramtype client_group_name: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.description = description
        self.topic_space_name = topic_space_name
        self.permission = permission
        self.client_group_name = client_group_name
        self.provisioning_state = None


class PermissionBindingsListResult(_serialization.Model):
    """Result of the List Permission Binding operation.

    :ivar value: A collection of Permission Binding.
    :vartype value: list[~azure.mgmt.eventgrid.models.PermissionBinding]
    :ivar next_link: A link for the next page of Permission Binding.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PermissionBinding]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PermissionBinding"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of Permission Binding.
        :paramtype value: list[~azure.mgmt.eventgrid.models.PermissionBinding]
        :keyword next_link: A link for the next page of Permission Binding.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateEndpoint(_serialization.Model):
    """PrivateEndpoint information.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The ARM identifier for Private Endpoint.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(Resource):
    """PrivateEndpointConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar private_endpoint: The Private Endpoint resource for this Connection.
    :vartype private_endpoint: ~azure.mgmt.eventgrid.models.PrivateEndpoint
    :ivar group_ids: GroupIds from the private link service resource.
    :vartype group_ids: list[str]
    :ivar private_link_service_connection_state: Details about the state of the connection.
    :vartype private_link_service_connection_state: ~azure.mgmt.eventgrid.models.ConnectionState
    :ivar provisioning_state: Provisioning state of the Private Endpoint Connection. Known values
     are: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.ResourceProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "group_ids": {"key": "properties.groupIds", "type": "[str]"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "ConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        group_ids: Optional[List[str]] = None,
        private_link_service_connection_state: Optional["_models.ConnectionState"] = None,
        provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The Private Endpoint resource for this Connection.
        :paramtype private_endpoint: ~azure.mgmt.eventgrid.models.PrivateEndpoint
        :keyword group_ids: GroupIds from the private link service resource.
        :paramtype group_ids: list[str]
        :keyword private_link_service_connection_state: Details about the state of the connection.
        :paramtype private_link_service_connection_state: ~azure.mgmt.eventgrid.models.ConnectionState
        :keyword provisioning_state: Provisioning state of the Private Endpoint Connection. Known
         values are: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
        :paramtype provisioning_state: str or ~azure.mgmt.eventgrid.models.ResourceProvisioningState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.group_ids = group_ids
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionListResult(_serialization.Model):
    """Result of the list of all private endpoint connections operation.

    :ivar value: A collection of private endpoint connection resources.
    :vartype value: list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :ivar next_link: A link for the next page of private endpoint connection resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of private endpoint connection resources.
        :paramtype value: list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
        :keyword next_link: A link for the next page of private endpoint connection resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResource(_serialization.Model):
    """Information of the private link resource.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar group_id:
    :vartype group_id: str
    :ivar display_name:
    :vartype display_name: str
    :ivar required_members:
    :vartype required_members: list[str]
    :ivar required_zone_names:
    :vartype required_zone_names: list[str]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        group_id: Optional[str] = None,
        display_name: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified identifier of the resource.
        :paramtype id: str
        :keyword name: Name of the resource.
        :paramtype name: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword group_id:
        :paramtype group_id: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword required_members:
        :paramtype required_members: list[str]
        :keyword required_zone_names:
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.group_id = group_id
        self.display_name = display_name
        self.required_members = required_members
        self.required_zone_names = required_zone_names


class PrivateLinkResourcesListResult(_serialization.Model):
    """Result of the List private link resources operation.

    :ivar value: A collection of private link resources.
    :vartype value: list[~azure.mgmt.eventgrid.models.PrivateLinkResource]
    :ivar next_link: A link for the next page of private link resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of private link resources.
        :paramtype value: list[~azure.mgmt.eventgrid.models.PrivateLinkResource]
        :keyword next_link: A link for the next page of private link resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PushInfo(_serialization.Model):
    """Properties of the destination info for event subscription supporting push.

    :ivar max_delivery_count: The maximum delivery count of the events.
    :vartype max_delivery_count: int
    :ivar event_time_to_live: Time span duration in ISO 8601 format that determines how long
     messages are available to the subscription from the time the message was published.
     This duration value is expressed using the following format: \\'P(n)Y(n)M(n)DT(n)H(n)M(n)S\\',
     where:

     .. code-block::

        - (n) is replaced by the value of each time element that follows the (n).
        - P is the duration (or Period) designator and is always placed at the beginning of the
     duration.
        - Y is the year designator, and it follows the value for the number of years.
        - M is the month designator, and it follows the value for the number of months.
        - W is the week designator, and it follows the value for the number of weeks.
        - D is the day designator, and it follows the value for the number of days.
        - T is the time designator, and it precedes the time components.
        - H is the hour designator, and it follows the value for the number of hours.
        - M is the minute designator, and it follows the value for the number of minutes.
        - S is the second designator, and it follows the value for the number of seconds.

     This duration value cannot be set greater than the topic’s EventRetentionInDays. It is is an
     optional field where its minimum value is 1 minute, and its maximum is determined
     by topic’s EventRetentionInDays value. The followings are examples of valid values:

     .. code-block::

        - \\'P0DT23H12M\\' or \\'PT23H12M\\': for duration of 23 hours and 12 minutes.
        - \\'P1D\\' or \\'P1DT0H0M0S\\': for duration of 1 day.
    :vartype event_time_to_live: str
    :ivar dead_letter_destination_with_resource_identity: The dead letter destination of the event
     subscription. Any event that cannot be delivered to its' destination is sent to the dead letter
     destination.
     Uses the managed identity setup on the parent resource (namely, namespace) to acquire the
     authentication tokens being used during dead-lettering.
    :vartype dead_letter_destination_with_resource_identity:
     ~azure.mgmt.eventgrid.models.DeadLetterWithResourceIdentity
    :ivar delivery_with_resource_identity: Information about the destination where events have to
     be delivered for the event subscription.
     Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire
     the authentication tokens being used during delivery.
    :vartype delivery_with_resource_identity:
     ~azure.mgmt.eventgrid.models.DeliveryWithResourceIdentity
    :ivar destination: Information about the destination where events have to be delivered for the
     event subscription.
     Uses Azure Event Grid's identity to acquire the authentication tokens being used during
     delivery.
    :vartype destination: ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    """

    _attribute_map = {
        "max_delivery_count": {"key": "maxDeliveryCount", "type": "int"},
        "event_time_to_live": {"key": "eventTimeToLive", "type": "str"},
        "dead_letter_destination_with_resource_identity": {
            "key": "deadLetterDestinationWithResourceIdentity",
            "type": "DeadLetterWithResourceIdentity",
        },
        "delivery_with_resource_identity": {
            "key": "deliveryWithResourceIdentity",
            "type": "DeliveryWithResourceIdentity",
        },
        "destination": {"key": "destination", "type": "EventSubscriptionDestination"},
    }

    def __init__(
        self,
        *,
        max_delivery_count: Optional[int] = None,
        event_time_to_live: Optional[str] = None,
        dead_letter_destination_with_resource_identity: Optional["_models.DeadLetterWithResourceIdentity"] = None,
        delivery_with_resource_identity: Optional["_models.DeliveryWithResourceIdentity"] = None,
        destination: Optional["_models.EventSubscriptionDestination"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_delivery_count: The maximum delivery count of the events.
        :paramtype max_delivery_count: int
        :keyword event_time_to_live: Time span duration in ISO 8601 format that determines how long
         messages are available to the subscription from the time the message was published.
         This duration value is expressed using the following format: \\'P(n)Y(n)M(n)DT(n)H(n)M(n)S\\',
         where:

         .. code-block::

            - (n) is replaced by the value of each time element that follows the (n).
            - P is the duration (or Period) designator and is always placed at the beginning of the
         duration.
            - Y is the year designator, and it follows the value for the number of years.
            - M is the month designator, and it follows the value for the number of months.
            - W is the week designator, and it follows the value for the number of weeks.
            - D is the day designator, and it follows the value for the number of days.
            - T is the time designator, and it precedes the time components.
            - H is the hour designator, and it follows the value for the number of hours.
            - M is the minute designator, and it follows the value for the number of minutes.
            - S is the second designator, and it follows the value for the number of seconds.

         This duration value cannot be set greater than the topic’s EventRetentionInDays. It is is an
         optional field where its minimum value is 1 minute, and its maximum is determined
         by topic’s EventRetentionInDays value. The followings are examples of valid values:

         .. code-block::

            - \\'P0DT23H12M\\' or \\'PT23H12M\\': for duration of 23 hours and 12 minutes.
            - \\'P1D\\' or \\'P1DT0H0M0S\\': for duration of 1 day.
        :paramtype event_time_to_live: str
        :keyword dead_letter_destination_with_resource_identity: The dead letter destination of the
         event subscription. Any event that cannot be delivered to its' destination is sent to the dead
         letter destination.
         Uses the managed identity setup on the parent resource (namely, namespace) to acquire the
         authentication tokens being used during dead-lettering.
        :paramtype dead_letter_destination_with_resource_identity:
         ~azure.mgmt.eventgrid.models.DeadLetterWithResourceIdentity
        :keyword delivery_with_resource_identity: Information about the destination where events have
         to be delivered for the event subscription.
         Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire
         the authentication tokens being used during delivery.
        :paramtype delivery_with_resource_identity:
         ~azure.mgmt.eventgrid.models.DeliveryWithResourceIdentity
        :keyword destination: Information about the destination where events have to be delivered for
         the event subscription.
         Uses Azure Event Grid's identity to acquire the authentication tokens being used during
         delivery.
        :paramtype destination: ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
        """
        super().__init__(**kwargs)
        self.max_delivery_count = max_delivery_count
        self.event_time_to_live = event_time_to_live
        self.dead_letter_destination_with_resource_identity = dead_letter_destination_with_resource_identity
        self.delivery_with_resource_identity = delivery_with_resource_identity
        self.destination = destination


class QueueInfo(_serialization.Model):
    """Properties of the Queue info for event subscription.

    :ivar receive_lock_duration_in_seconds: Maximum period in seconds in which once the message is
     in received (by the client) state and waiting to be accepted, released or rejected.
     If this time elapsed after a message has been received by the client and not transitioned into
     accepted (not processed), released or rejected,
     the message is available for redelivery. This is an optional field, where default is 60
     seconds, minimum is 60 seconds and maximum is 300 seconds.
    :vartype receive_lock_duration_in_seconds: int
    :ivar max_delivery_count: The maximum delivery count of the events.
    :vartype max_delivery_count: int
    :ivar dead_letter_destination_with_resource_identity: The dead letter destination of the event
     subscription. Any event that cannot be delivered to its' destination is sent to the dead letter
     destination.
     Uses the managed identity setup on the parent resource (namely, topic) to acquire the
     authentication tokens being used during delivery / dead-lettering.
    :vartype dead_letter_destination_with_resource_identity:
     ~azure.mgmt.eventgrid.models.DeadLetterWithResourceIdentity
    :ivar event_time_to_live: Time span duration in ISO 8601 format that determines how long
     messages are available to the subscription from the time the message was published.
     This duration value is expressed using the following format: \\'P(n)Y(n)M(n)DT(n)H(n)M(n)S\\',
     where:

     .. code-block::

        - (n) is replaced by the value of each time element that follows the (n).
        - P is the duration (or Period) designator and is always placed at the beginning of the
     duration.
        - Y is the year designator, and it follows the value for the number of years.
        - M is the month designator, and it follows the value for the number of months.
        - W is the week designator, and it follows the value for the number of weeks.
        - D is the day designator, and it follows the value for the number of days.
        - T is the time designator, and it precedes the time components.
        - H is the hour designator, and it follows the value for the number of hours.
        - M is the minute designator, and it follows the value for the number of minutes.
        - S is the second designator, and it follows the value for the number of seconds.

     This duration value cannot be set greater than the topic’s EventRetentionInDays. It is is an
     optional field where its minimum value is 1 minute, and its maximum is determined
     by topic’s EventRetentionInDays value. The followings are examples of valid values:

     .. code-block::

        - \\'P0DT23H12M\\' or \\'PT23H12M\\': for duration of 23 hours and 12 minutes.
        - \\'P1D\\' or \\'P1DT0H0M0S\\': for duration of 1 day.
    :vartype event_time_to_live: ~datetime.timedelta
    """

    _attribute_map = {
        "receive_lock_duration_in_seconds": {"key": "receiveLockDurationInSeconds", "type": "int"},
        "max_delivery_count": {"key": "maxDeliveryCount", "type": "int"},
        "dead_letter_destination_with_resource_identity": {
            "key": "deadLetterDestinationWithResourceIdentity",
            "type": "DeadLetterWithResourceIdentity",
        },
        "event_time_to_live": {"key": "eventTimeToLive", "type": "duration"},
    }

    def __init__(
        self,
        *,
        receive_lock_duration_in_seconds: Optional[int] = None,
        max_delivery_count: Optional[int] = None,
        dead_letter_destination_with_resource_identity: Optional["_models.DeadLetterWithResourceIdentity"] = None,
        event_time_to_live: Optional[datetime.timedelta] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword receive_lock_duration_in_seconds: Maximum period in seconds in which once the message
         is in received (by the client) state and waiting to be accepted, released or rejected.
         If this time elapsed after a message has been received by the client and not transitioned into
         accepted (not processed), released or rejected,
         the message is available for redelivery. This is an optional field, where default is 60
         seconds, minimum is 60 seconds and maximum is 300 seconds.
        :paramtype receive_lock_duration_in_seconds: int
        :keyword max_delivery_count: The maximum delivery count of the events.
        :paramtype max_delivery_count: int
        :keyword dead_letter_destination_with_resource_identity: The dead letter destination of the
         event subscription. Any event that cannot be delivered to its' destination is sent to the dead
         letter destination.
         Uses the managed identity setup on the parent resource (namely, topic) to acquire the
         authentication tokens being used during delivery / dead-lettering.
        :paramtype dead_letter_destination_with_resource_identity:
         ~azure.mgmt.eventgrid.models.DeadLetterWithResourceIdentity
        :keyword event_time_to_live: Time span duration in ISO 8601 format that determines how long
         messages are available to the subscription from the time the message was published.
         This duration value is expressed using the following format: \\'P(n)Y(n)M(n)DT(n)H(n)M(n)S\\',
         where:

         .. code-block::

            - (n) is replaced by the value of each time element that follows the (n).
            - P is the duration (or Period) designator and is always placed at the beginning of the
         duration.
            - Y is the year designator, and it follows the value for the number of years.
            - M is the month designator, and it follows the value for the number of months.
            - W is the week designator, and it follows the value for the number of weeks.
            - D is the day designator, and it follows the value for the number of days.
            - T is the time designator, and it precedes the time components.
            - H is the hour designator, and it follows the value for the number of hours.
            - M is the minute designator, and it follows the value for the number of minutes.
            - S is the second designator, and it follows the value for the number of seconds.

         This duration value cannot be set greater than the topic’s EventRetentionInDays. It is is an
         optional field where its minimum value is 1 minute, and its maximum is determined
         by topic’s EventRetentionInDays value. The followings are examples of valid values:

         .. code-block::

            - \\'P0DT23H12M\\' or \\'PT23H12M\\': for duration of 23 hours and 12 minutes.
            - \\'P1D\\' or \\'P1DT0H0M0S\\': for duration of 1 day.
        :paramtype event_time_to_live: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.receive_lock_duration_in_seconds = receive_lock_duration_in_seconds
        self.max_delivery_count = max_delivery_count
        self.dead_letter_destination_with_resource_identity = dead_letter_destination_with_resource_identity
        self.event_time_to_live = event_time_to_live


class RetryPolicy(_serialization.Model):
    """Information about the retry policy for an event subscription.

    :ivar max_delivery_attempts: Maximum number of delivery retry attempts for events.
    :vartype max_delivery_attempts: int
    :ivar event_time_to_live_in_minutes: Time To Live (in minutes) for events.
    :vartype event_time_to_live_in_minutes: int
    """

    _attribute_map = {
        "max_delivery_attempts": {"key": "maxDeliveryAttempts", "type": "int"},
        "event_time_to_live_in_minutes": {"key": "eventTimeToLiveInMinutes", "type": "int"},
    }

    def __init__(
        self, *, max_delivery_attempts: int = 30, event_time_to_live_in_minutes: int = 1440, **kwargs: Any
    ) -> None:
        """
        :keyword max_delivery_attempts: Maximum number of delivery retry attempts for events.
        :paramtype max_delivery_attempts: int
        :keyword event_time_to_live_in_minutes: Time To Live (in minutes) for events.
        :paramtype event_time_to_live_in_minutes: int
        """
        super().__init__(**kwargs)
        self.max_delivery_attempts = max_delivery_attempts
        self.event_time_to_live_in_minutes = event_time_to_live_in_minutes


class RoutingEnrichments(_serialization.Model):
    """RoutingEnrichments.

    :ivar static:
    :vartype static: list[~azure.mgmt.eventgrid.models.StaticRoutingEnrichment]
    :ivar dynamic:
    :vartype dynamic: list[~azure.mgmt.eventgrid.models.DynamicRoutingEnrichment]
    """

    _attribute_map = {
        "static": {"key": "static", "type": "[StaticRoutingEnrichment]"},
        "dynamic": {"key": "dynamic", "type": "[DynamicRoutingEnrichment]"},
    }

    def __init__(
        self,
        *,
        static: Optional[List["_models.StaticRoutingEnrichment"]] = None,
        dynamic: Optional[List["_models.DynamicRoutingEnrichment"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword static:
        :paramtype static: list[~azure.mgmt.eventgrid.models.StaticRoutingEnrichment]
        :keyword dynamic:
        :paramtype dynamic: list[~azure.mgmt.eventgrid.models.DynamicRoutingEnrichment]
        """
        super().__init__(**kwargs)
        self.static = static
        self.dynamic = dynamic


class RoutingIdentityInfo(_serialization.Model):
    """Routing identity info for topic spaces configuration.

    :ivar type: Routing identity type for topic spaces configuration. Known values are: "None",
     "SystemAssigned", and "UserAssigned".
    :vartype type: str or ~azure.mgmt.eventgrid.models.RoutingIdentityType
    :ivar user_assigned_identity:
    :vartype user_assigned_identity: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_assigned_identity": {"key": "userAssignedIdentity", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.RoutingIdentityType"]] = None,
        user_assigned_identity: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Routing identity type for topic spaces configuration. Known values are: "None",
         "SystemAssigned", and "UserAssigned".
        :paramtype type: str or ~azure.mgmt.eventgrid.models.RoutingIdentityType
        :keyword user_assigned_identity:
        :paramtype user_assigned_identity: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.user_assigned_identity = user_assigned_identity


class ServiceBusQueueEventSubscriptionDestination(EventSubscriptionDestination):  # pylint: disable=name-too-long
    """Information about the service bus destination for an event subscription.

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: Type of the endpoint for the event subscription destination. Required.
     Known values are: "WebHook", "EventHub", "StorageQueue", "HybridConnection", "ServiceBusQueue",
     "ServiceBusTopic", "AzureFunction", "MonitorAlert", and "NamespaceTopic".
    :vartype endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :ivar resource_id: The Azure Resource Id that represents the endpoint of the Service Bus
     destination of an event subscription.
    :vartype resource_id: str
    :ivar delivery_attribute_mappings: Delivery attribute details.
    :vartype delivery_attribute_mappings:
     list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        "endpoint_type": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "delivery_attribute_mappings": {
            "key": "properties.deliveryAttributeMappings",
            "type": "[DeliveryAttributeMapping]",
        },
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        delivery_attribute_mappings: Optional[List["_models.DeliveryAttributeMapping"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The Azure Resource Id that represents the endpoint of the Service Bus
         destination of an event subscription.
        :paramtype resource_id: str
        :keyword delivery_attribute_mappings: Delivery attribute details.
        :paramtype delivery_attribute_mappings:
         list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
        """
        super().__init__(**kwargs)
        self.endpoint_type: str = "ServiceBusQueue"
        self.resource_id = resource_id
        self.delivery_attribute_mappings = delivery_attribute_mappings


class ServiceBusTopicEventSubscriptionDestination(EventSubscriptionDestination):  # pylint: disable=name-too-long
    """Information about the service bus topic destination for an event subscription.

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: Type of the endpoint for the event subscription destination. Required.
     Known values are: "WebHook", "EventHub", "StorageQueue", "HybridConnection", "ServiceBusQueue",
     "ServiceBusTopic", "AzureFunction", "MonitorAlert", and "NamespaceTopic".
    :vartype endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :ivar resource_id: The Azure Resource Id that represents the endpoint of the Service Bus Topic
     destination of an event subscription.
    :vartype resource_id: str
    :ivar delivery_attribute_mappings: Delivery attribute details.
    :vartype delivery_attribute_mappings:
     list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        "endpoint_type": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "delivery_attribute_mappings": {
            "key": "properties.deliveryAttributeMappings",
            "type": "[DeliveryAttributeMapping]",
        },
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        delivery_attribute_mappings: Optional[List["_models.DeliveryAttributeMapping"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The Azure Resource Id that represents the endpoint of the Service Bus
         Topic destination of an event subscription.
        :paramtype resource_id: str
        :keyword delivery_attribute_mappings: Delivery attribute details.
        :paramtype delivery_attribute_mappings:
         list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
        """
        super().__init__(**kwargs)
        self.endpoint_type: str = "ServiceBusTopic"
        self.resource_id = resource_id
        self.delivery_attribute_mappings = delivery_attribute_mappings


class StaticDeliveryAttributeMapping(DeliveryAttributeMapping):
    """Static delivery attribute mapping details.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the delivery attribute or header.
    :vartype name: str
    :ivar type: Type of the delivery attribute or header name. Required. Known values are: "Static"
     and "Dynamic".
    :vartype type: str or ~azure.mgmt.eventgrid.models.DeliveryAttributeMappingType
    :ivar value: Value of the delivery attribute.
    :vartype value: str
    :ivar is_secret: Boolean flag to tell if the attribute contains sensitive information .
    :vartype is_secret: bool
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "value": {"key": "properties.value", "type": "str"},
        "is_secret": {"key": "properties.isSecret", "type": "bool"},
    }

    def __init__(
        self, *, name: Optional[str] = None, value: Optional[str] = None, is_secret: bool = False, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the delivery attribute or header.
        :paramtype name: str
        :keyword value: Value of the delivery attribute.
        :paramtype value: str
        :keyword is_secret: Boolean flag to tell if the attribute contains sensitive information .
        :paramtype is_secret: bool
        """
        super().__init__(name=name, **kwargs)
        self.type: str = "Static"
        self.value = value
        self.is_secret = is_secret


class StaticRoutingEnrichment(_serialization.Model):
    """Static routing enrichment details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    StaticStringRoutingEnrichment

    All required parameters must be populated in order to send to server.

    :ivar key: Static routing enrichment key.
    :vartype key: str
    :ivar value_type: Static routing enrichment value type. For e.g. this property value can be
     'String'. Required. "String"
    :vartype value_type: str or ~azure.mgmt.eventgrid.models.StaticRoutingEnrichmentType
    """

    _validation = {
        "value_type": {"required": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
    }

    _subtype_map = {"value_type": {"String": "StaticStringRoutingEnrichment"}}

    def __init__(self, *, key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: Static routing enrichment key.
        :paramtype key: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value_type: Optional[str] = None


class StaticStringRoutingEnrichment(StaticRoutingEnrichment):
    """StaticStringRoutingEnrichment.

    All required parameters must be populated in order to send to server.

    :ivar key: Static routing enrichment key.
    :vartype key: str
    :ivar value_type: Static routing enrichment value type. For e.g. this property value can be
     'String'. Required. "String"
    :vartype value_type: str or ~azure.mgmt.eventgrid.models.StaticRoutingEnrichmentType
    :ivar value: String type routing enrichment value.
    :vartype value: str
    """

    _validation = {
        "value_type": {"required": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: Static routing enrichment key.
        :paramtype key: str
        :keyword value: String type routing enrichment value.
        :paramtype value: str
        """
        super().__init__(key=key, **kwargs)
        self.value_type: str = "String"
        self.value = value


class StorageBlobDeadLetterDestination(DeadLetterDestination):
    """Information about the storage blob based dead letter destination.

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: Type of the endpoint for the dead letter destination. Required.
     "StorageBlob"
    :vartype endpoint_type: str or ~azure.mgmt.eventgrid.models.DeadLetterEndPointType
    :ivar resource_id: The Azure Resource ID of the storage account that is the destination of the
     deadletter events.
    :vartype resource_id: str
    :ivar blob_container_name: The name of the Storage blob container that is the destination of
     the deadletter events.
    :vartype blob_container_name: str
    """

    _validation = {
        "endpoint_type": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "blob_container_name": {"key": "properties.blobContainerName", "type": "str"},
    }

    def __init__(
        self, *, resource_id: Optional[str] = None, blob_container_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The Azure Resource ID of the storage account that is the destination of
         the deadletter events.
        :paramtype resource_id: str
        :keyword blob_container_name: The name of the Storage blob container that is the destination of
         the deadletter events.
        :paramtype blob_container_name: str
        """
        super().__init__(**kwargs)
        self.endpoint_type: str = "StorageBlob"
        self.resource_id = resource_id
        self.blob_container_name = blob_container_name


class StorageQueueEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the storage queue destination for an event subscription.

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: Type of the endpoint for the event subscription destination. Required.
     Known values are: "WebHook", "EventHub", "StorageQueue", "HybridConnection", "ServiceBusQueue",
     "ServiceBusTopic", "AzureFunction", "MonitorAlert", and "NamespaceTopic".
    :vartype endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :ivar resource_id: The Azure Resource ID of the storage account that contains the queue that is
     the destination of an event subscription.
    :vartype resource_id: str
    :ivar queue_name: The name of the Storage queue under a storage account that is the destination
     of an event subscription.
    :vartype queue_name: str
    :ivar queue_message_time_to_live_in_seconds: Storage queue message time to live in seconds.
     This value cannot be zero or negative with the exception of using -1 to indicate that the Time
     To Live of the message is Infinite.
    :vartype queue_message_time_to_live_in_seconds: int
    """

    _validation = {
        "endpoint_type": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "queue_name": {"key": "properties.queueName", "type": "str"},
        "queue_message_time_to_live_in_seconds": {"key": "properties.queueMessageTimeToLiveInSeconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        queue_name: Optional[str] = None,
        queue_message_time_to_live_in_seconds: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The Azure Resource ID of the storage account that contains the queue that
         is the destination of an event subscription.
        :paramtype resource_id: str
        :keyword queue_name: The name of the Storage queue under a storage account that is the
         destination of an event subscription.
        :paramtype queue_name: str
        :keyword queue_message_time_to_live_in_seconds: Storage queue message time to live in seconds.
         This value cannot be zero or negative with the exception of using -1 to indicate that the Time
         To Live of the message is Infinite.
        :paramtype queue_message_time_to_live_in_seconds: int
        """
        super().__init__(**kwargs)
        self.endpoint_type: str = "StorageQueue"
        self.resource_id = resource_id
        self.queue_name = queue_name
        self.queue_message_time_to_live_in_seconds = queue_message_time_to_live_in_seconds


class StringBeginsWithAdvancedFilter(AdvancedFilter):
    """StringBeginsWith Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringBeginsWith"
        self.values = values


class StringBeginsWithFilter(Filter):
    """StringBeginsWith Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringBeginsWith"
        self.values = values


class StringContainsAdvancedFilter(AdvancedFilter):
    """StringContains Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringContains"
        self.values = values


class StringContainsFilter(Filter):
    """StringContains Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringContains"
        self.values = values


class StringEndsWithAdvancedFilter(AdvancedFilter):
    """StringEndsWith Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringEndsWith"
        self.values = values


class StringEndsWithFilter(Filter):
    """StringEndsWith Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringEndsWith"
        self.values = values


class StringInAdvancedFilter(AdvancedFilter):
    """StringIn Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringIn"
        self.values = values


class StringInFilter(Filter):
    """StringIn Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringIn"
        self.values = values


class StringNotBeginsWithAdvancedFilter(AdvancedFilter):
    """StringNotBeginsWith Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringNotBeginsWith"
        self.values = values


class StringNotBeginsWithFilter(Filter):
    """StringNotBeginsWith Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringNotBeginsWith"
        self.values = values


class StringNotContainsAdvancedFilter(AdvancedFilter):
    """StringNotContains Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringNotContains"
        self.values = values


class StringNotContainsFilter(Filter):
    """StringNotContains Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringNotContains"
        self.values = values


class StringNotEndsWithAdvancedFilter(AdvancedFilter):
    """StringNotEndsWith Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringNotEndsWith"
        self.values = values


class StringNotEndsWithFilter(Filter):
    """StringNotEndsWith Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringNotEndsWith"
        self.values = values


class StringNotInAdvancedFilter(AdvancedFilter):
    """StringNotIn Advanced Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringNotIn"
        self.values = values


class StringNotInFilter(Filter):
    """StringNotIn Filter.

    All required parameters must be populated in order to send to server.

    :ivar operator_type: The operator type used for filtering, e.g., NumberIn, StringContains,
     BoolEquals and others. Required. Known values are: "NumberIn", "NumberNotIn", "NumberLessThan",
     "NumberGreaterThan", "NumberLessThanOrEquals", "NumberGreaterThanOrEquals", "BoolEquals",
     "StringIn", "StringNotIn", "StringBeginsWith", "StringEndsWith", "StringContains",
     "NumberInRange", "NumberNotInRange", "StringNotBeginsWith", "StringNotEndsWith",
     "StringNotContains", "IsNullOrUndefined", and "IsNotNull".
    :vartype operator_type: str or ~azure.mgmt.eventgrid.models.FilterOperatorType
    :ivar key: The field/property in the event based on which you want to filter.
    :vartype key: str
    :ivar values: The set of filter values.
    :vartype values: list[str]
    """

    _validation = {
        "operator_type": {"required": True},
    }

    _attribute_map = {
        "operator_type": {"key": "operatorType", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: Optional[str] = None, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword key: The field/property in the event based on which you want to filter.
        :paramtype key: str
        :keyword values: The set of filter values.
        :paramtype values: list[str]
        """
        super().__init__(key=key, **kwargs)
        self.operator_type: str = "StringNotIn"
        self.values = values


class Subscription(Resource):
    """Event Subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar provisioning_state: Provisioning state of the event subscription. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed", "AwaitingManualAction",
     "Deleted", "DeleteFailed", "CreateFailed", and "UpdatedFailed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.SubscriptionProvisioningState
    :ivar delivery_configuration: Information about the delivery configuration of the event
     subscription.
    :vartype delivery_configuration: ~azure.mgmt.eventgrid.models.DeliveryConfiguration
    :ivar event_delivery_schema: The event delivery schema for the event subscription.
     "CloudEventSchemaV1_0"
    :vartype event_delivery_schema: str or ~azure.mgmt.eventgrid.models.DeliverySchema
    :ivar filters_configuration: Information about the filter for the event subscription.
    :vartype filters_configuration: ~azure.mgmt.eventgrid.models.FiltersConfiguration
    :ivar expiration_time_utc: Expiration time of the event subscription.
    :vartype expiration_time_utc: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "delivery_configuration": {"key": "properties.deliveryConfiguration", "type": "DeliveryConfiguration"},
        "event_delivery_schema": {"key": "properties.eventDeliverySchema", "type": "str"},
        "filters_configuration": {"key": "properties.filtersConfiguration", "type": "FiltersConfiguration"},
        "expiration_time_utc": {"key": "properties.expirationTimeUtc", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        delivery_configuration: Optional["_models.DeliveryConfiguration"] = None,
        event_delivery_schema: Optional[Union[str, "_models.DeliverySchema"]] = None,
        filters_configuration: Optional["_models.FiltersConfiguration"] = None,
        expiration_time_utc: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword delivery_configuration: Information about the delivery configuration of the event
         subscription.
        :paramtype delivery_configuration: ~azure.mgmt.eventgrid.models.DeliveryConfiguration
        :keyword event_delivery_schema: The event delivery schema for the event subscription.
         "CloudEventSchemaV1_0"
        :paramtype event_delivery_schema: str or ~azure.mgmt.eventgrid.models.DeliverySchema
        :keyword filters_configuration: Information about the filter for the event subscription.
        :paramtype filters_configuration: ~azure.mgmt.eventgrid.models.FiltersConfiguration
        :keyword expiration_time_utc: Expiration time of the event subscription.
        :paramtype expiration_time_utc: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.delivery_configuration = delivery_configuration
        self.event_delivery_schema = event_delivery_schema
        self.filters_configuration = filters_configuration
        self.expiration_time_utc = expiration_time_utc


class SubscriptionFullUrl(_serialization.Model):
    """Full endpoint URL of an event subscription.

    :ivar endpoint_url: The URL that represents the endpoint of the destination of an event
     subscription.
    :vartype endpoint_url: str
    """

    _attribute_map = {
        "endpoint_url": {"key": "endpointUrl", "type": "str"},
    }

    def __init__(self, *, endpoint_url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword endpoint_url: The URL that represents the endpoint of the destination of an event
         subscription.
        :paramtype endpoint_url: str
        """
        super().__init__(**kwargs)
        self.endpoint_url = endpoint_url


class SubscriptionsListResult(_serialization.Model):
    """Result of the List event subscriptions operation.

    :ivar value: A collection of Subscriptions.
    :vartype value: list[~azure.mgmt.eventgrid.models.Subscription]
    :ivar next_link: A link for the next page of event subscriptions.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Subscription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Subscription"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of Subscriptions.
        :paramtype value: list[~azure.mgmt.eventgrid.models.Subscription]
        :keyword next_link: A link for the next page of event subscriptions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SubscriptionUpdateParameters(_serialization.Model):
    """Properties of the Event Subscription update.

    :ivar delivery_configuration: Information about the delivery configuration of the event
     subscription.
    :vartype delivery_configuration: ~azure.mgmt.eventgrid.models.DeliveryConfiguration
    :ivar event_delivery_schema: The event delivery schema for the event subscription.
     "CloudEventSchemaV1_0"
    :vartype event_delivery_schema: str or ~azure.mgmt.eventgrid.models.DeliverySchema
    :ivar filters_configuration: Information about the filter for the event subscription.
    :vartype filters_configuration: ~azure.mgmt.eventgrid.models.FiltersConfiguration
    :ivar expiration_time_utc: Expiration time of the event subscription.
    :vartype expiration_time_utc: ~datetime.datetime
    """

    _attribute_map = {
        "delivery_configuration": {"key": "properties.deliveryConfiguration", "type": "DeliveryConfiguration"},
        "event_delivery_schema": {"key": "properties.eventDeliverySchema", "type": "str"},
        "filters_configuration": {"key": "properties.filtersConfiguration", "type": "FiltersConfiguration"},
        "expiration_time_utc": {"key": "properties.expirationTimeUtc", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        delivery_configuration: Optional["_models.DeliveryConfiguration"] = None,
        event_delivery_schema: Optional[Union[str, "_models.DeliverySchema"]] = None,
        filters_configuration: Optional["_models.FiltersConfiguration"] = None,
        expiration_time_utc: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword delivery_configuration: Information about the delivery configuration of the event
         subscription.
        :paramtype delivery_configuration: ~azure.mgmt.eventgrid.models.DeliveryConfiguration
        :keyword event_delivery_schema: The event delivery schema for the event subscription.
         "CloudEventSchemaV1_0"
        :paramtype event_delivery_schema: str or ~azure.mgmt.eventgrid.models.DeliverySchema
        :keyword filters_configuration: Information about the filter for the event subscription.
        :paramtype filters_configuration: ~azure.mgmt.eventgrid.models.FiltersConfiguration
        :keyword expiration_time_utc: Expiration time of the event subscription.
        :paramtype expiration_time_utc: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.delivery_configuration = delivery_configuration
        self.event_delivery_schema = event_delivery_schema
        self.filters_configuration = filters_configuration
        self.expiration_time_utc = expiration_time_utc


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.eventgrid.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.eventgrid.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.eventgrid.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.eventgrid.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class SystemTopic(TrackedResource):
    """EventGrid System Topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar location: Location of the resource. Required.
    :vartype location: str
    :ivar tags: Tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar identity: Identity information for the resource.
    :vartype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :ivar provisioning_state: Provisioning state of the system topic. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.ResourceProvisioningState
    :ivar source: Source for the system topic.
    :vartype source: str
    :ivar topic_type: TopicType for the system topic.
    :vartype topic_type: str
    :ivar metric_resource_id: Metric resource id for the system topic.
    :vartype metric_resource_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "metric_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "identity": {"key": "identity", "type": "IdentityInfo"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "source": {"key": "properties.source", "type": "str"},
        "topic_type": {"key": "properties.topicType", "type": "str"},
        "metric_resource_id": {"key": "properties.metricResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.IdentityInfo"] = None,
        source: Optional[str] = None,
        topic_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Location of the resource. Required.
        :paramtype location: str
        :keyword tags: Tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword identity: Identity information for the resource.
        :paramtype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
        :keyword source: Source for the system topic.
        :paramtype source: str
        :keyword topic_type: TopicType for the system topic.
        :paramtype topic_type: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.system_data = None
        self.identity = identity
        self.provisioning_state = None
        self.source = source
        self.topic_type = topic_type
        self.metric_resource_id = None


class SystemTopicsListResult(_serialization.Model):
    """Result of the List System topics operation.

    :ivar value: A collection of system Topics.
    :vartype value: list[~azure.mgmt.eventgrid.models.SystemTopic]
    :ivar next_link: A link for the next page of topics.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SystemTopic]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.SystemTopic"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of system Topics.
        :paramtype value: list[~azure.mgmt.eventgrid.models.SystemTopic]
        :keyword next_link: A link for the next page of topics.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SystemTopicUpdateParameters(_serialization.Model):
    """Properties of the System Topic update.

    :ivar tags: Tags of the system topic.
    :vartype tags: dict[str, str]
    :ivar identity: Resource identity information.
    :vartype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "IdentityInfo"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, identity: Optional["_models.IdentityInfo"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Tags of the system topic.
        :paramtype tags: dict[str, str]
        :keyword identity: Resource identity information.
        :paramtype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity


class Topic(TrackedResource):
    """EventGrid Topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar location: Location of the resource. Required.
    :vartype location: str
    :ivar tags: Tags of the resource.
    :vartype tags: dict[str, str]
    :ivar identity: Identity information for the resource.
    :vartype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :ivar provisioning_state: Provisioning state of the topic. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.TopicProvisioningState
    :ivar endpoint: Endpoint for the topic.
    :vartype endpoint: str
    :ivar event_type_info: Event Type Information for the user topic. This information is provided
     by the publisher and can be used by the
     subscriber to view different types of events that are published.
    :vartype event_type_info: ~azure.mgmt.eventgrid.models.EventTypeInfo
    :ivar minimum_tls_version_allowed: Minimum TLS version of the publisher allowed to publish to
     this topic. Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
    :ivar input_schema: This determines the format that Event Grid should expect for incoming
     events published to the topic. Known values are: "EventGridSchema", "CustomEventSchema", and
     "CloudEventSchemaV1_0".
    :vartype input_schema: str or ~azure.mgmt.eventgrid.models.InputSchema
    :ivar input_schema_mapping: This enables publishing using custom event schemas. An
     InputSchemaMapping can be specified to map various properties of a source schema to various
     required properties of the EventGridEvent schema.
    :vartype input_schema_mapping: ~azure.mgmt.eventgrid.models.InputSchemaMapping
    :ivar metric_resource_id: Metric resource id for the topic.
    :vartype metric_resource_id: str
    :ivar public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules"
     />`. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :ivar inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :vartype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    :ivar disable_local_auth: This boolean is used to enable or disable local auth. Default value
     is false. When the property is set to true, only AAD token will be used to authenticate if user
     is allowed to publish to the topic.
    :vartype disable_local_auth: bool
    :ivar data_residency_boundary: Data Residency Boundary of the resource. Known values are:
     "WithinGeopair" and "WithinRegion".
    :vartype data_residency_boundary: str or ~azure.mgmt.eventgrid.models.DataResidencyBoundary
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "endpoint": {"readonly": True},
        "metric_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "IdentityInfo"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "endpoint": {"key": "properties.endpoint", "type": "str"},
        "event_type_info": {"key": "properties.eventTypeInfo", "type": "EventTypeInfo"},
        "minimum_tls_version_allowed": {"key": "properties.minimumTlsVersionAllowed", "type": "str"},
        "input_schema": {"key": "properties.inputSchema", "type": "str"},
        "input_schema_mapping": {"key": "properties.inputSchemaMapping", "type": "InputSchemaMapping"},
        "metric_resource_id": {"key": "properties.metricResourceId", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "inbound_ip_rules": {"key": "properties.inboundIpRules", "type": "[InboundIpRule]"},
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "data_residency_boundary": {"key": "properties.dataResidencyBoundary", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.IdentityInfo"] = None,
        event_type_info: Optional["_models.EventTypeInfo"] = None,
        minimum_tls_version_allowed: Optional[Union[str, "_models.TlsVersion"]] = None,
        input_schema: Optional[Union[str, "_models.InputSchema"]] = None,
        input_schema_mapping: Optional["_models.InputSchemaMapping"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["_models.InboundIpRule"]] = None,
        disable_local_auth: bool = False,
        data_residency_boundary: Optional[Union[str, "_models.DataResidencyBoundary"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Location of the resource. Required.
        :paramtype location: str
        :keyword tags: Tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword identity: Identity information for the resource.
        :paramtype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
        :keyword event_type_info: Event Type Information for the user topic. This information is
         provided by the publisher and can be used by the
         subscriber to view different types of events that are published.
        :paramtype event_type_info: ~azure.mgmt.eventgrid.models.EventTypeInfo
        :keyword minimum_tls_version_allowed: Minimum TLS version of the publisher allowed to publish
         to this topic. Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
        :keyword input_schema: This determines the format that Event Grid should expect for incoming
         events published to the topic. Known values are: "EventGridSchema", "CustomEventSchema", and
         "CloudEventSchemaV1_0".
        :paramtype input_schema: str or ~azure.mgmt.eventgrid.models.InputSchema
        :keyword input_schema_mapping: This enables publishing using custom event schemas. An
         InputSchemaMapping can be specified to map various properties of a source schema to various
         required properties of the EventGridEvent schema.
        :paramtype input_schema_mapping: ~azure.mgmt.eventgrid.models.InputSchemaMapping
        :keyword public_network_access: This determines if traffic is allowed over public network. By
         default it is enabled.
         You can further restrict to specific IPs by configuring :code:`<seealso
         cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules"
         />`. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
        :keyword inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of
         all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
        :paramtype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
        :keyword disable_local_auth: This boolean is used to enable or disable local auth. Default
         value is false. When the property is set to true, only AAD token will be used to authenticate
         if user is allowed to publish to the topic.
        :paramtype disable_local_auth: bool
        :keyword data_residency_boundary: Data Residency Boundary of the resource. Known values are:
         "WithinGeopair" and "WithinRegion".
        :paramtype data_residency_boundary: str or ~azure.mgmt.eventgrid.models.DataResidencyBoundary
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.system_data = None
        self.private_endpoint_connections = None
        self.provisioning_state = None
        self.endpoint = None
        self.event_type_info = event_type_info
        self.minimum_tls_version_allowed = minimum_tls_version_allowed
        self.input_schema = input_schema
        self.input_schema_mapping = input_schema_mapping
        self.metric_resource_id = None
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules
        self.disable_local_auth = disable_local_auth
        self.data_residency_boundary = data_residency_boundary


class TopicRegenerateKeyRequest(_serialization.Model):
    """Topic regenerate share access key request.

    All required parameters must be populated in order to send to server.

    :ivar key_name: Key name to regenerate key1 or key2. Required.
    :vartype key_name: str
    """

    _validation = {
        "key_name": {"required": True},
    }

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
    }

    def __init__(self, *, key_name: str, **kwargs: Any) -> None:
        """
        :keyword key_name: Key name to regenerate key1 or key2. Required.
        :paramtype key_name: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name


class TopicsConfiguration(_serialization.Model):
    """Properties of the Topics Configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hostname: The hostname for the topics configuration. This is a read-only property.
    :vartype hostname: str
    :ivar custom_domains: List of custom domain configurations for the namespace.
    :vartype custom_domains: list[~azure.mgmt.eventgrid.models.CustomDomainConfiguration]
    """

    _validation = {
        "hostname": {"readonly": True},
    }

    _attribute_map = {
        "hostname": {"key": "hostname", "type": "str"},
        "custom_domains": {"key": "customDomains", "type": "[CustomDomainConfiguration]"},
    }

    def __init__(
        self, *, custom_domains: Optional[List["_models.CustomDomainConfiguration"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword custom_domains: List of custom domain configurations for the namespace.
        :paramtype custom_domains: list[~azure.mgmt.eventgrid.models.CustomDomainConfiguration]
        """
        super().__init__(**kwargs)
        self.hostname = None
        self.custom_domains = custom_domains


class TopicSharedAccessKeys(_serialization.Model):
    """Shared access keys of the Topic.

    :ivar key1: Shared access key1 for the topic.
    :vartype key1: str
    :ivar key2: Shared access key2 for the topic.
    :vartype key2: str
    """

    _attribute_map = {
        "key1": {"key": "key1", "type": "str"},
        "key2": {"key": "key2", "type": "str"},
    }

    def __init__(self, *, key1: Optional[str] = None, key2: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key1: Shared access key1 for the topic.
        :paramtype key1: str
        :keyword key2: Shared access key2 for the topic.
        :paramtype key2: str
        """
        super().__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class TopicsListResult(_serialization.Model):
    """Result of the List Topics operation.

    :ivar value: A collection of Topics.
    :vartype value: list[~azure.mgmt.eventgrid.models.Topic]
    :ivar next_link: A link for the next page of topics.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Topic]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Topic"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of Topics.
        :paramtype value: list[~azure.mgmt.eventgrid.models.Topic]
        :keyword next_link: A link for the next page of topics.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TopicSpace(Resource):
    """The Topic space resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar description: Description for the Topic Space resource.
    :vartype description: str
    :ivar topic_templates: The topic filters in the topic space.
     Example: "topicTemplates": [
                   "devices/foo/bar",
                   "devices/topic1/+",
                   "devices/${principal.name}/${principal.attributes.keyName}" ].
    :vartype topic_templates: list[str]
    :ivar provisioning_state: Provisioning state of the TopicSpace resource. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.TopicSpaceProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "topic_templates": {"key": "properties.topicTemplates", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self, *, description: Optional[str] = None, topic_templates: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword description: Description for the Topic Space resource.
        :paramtype description: str
        :keyword topic_templates: The topic filters in the topic space.
         Example: "topicTemplates": [
                       "devices/foo/bar",
                       "devices/topic1/+",
                       "devices/${principal.name}/${principal.attributes.keyName}" ].
        :paramtype topic_templates: list[str]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.description = description
        self.topic_templates = topic_templates
        self.provisioning_state = None


class TopicSpacesConfiguration(_serialization.Model):
    """Properties of the Topic Spaces Configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar state: Indicate if Topic Spaces Configuration is enabled for the namespace. Default is
     Disabled. Known values are: "Disabled" and "Enabled".
    :vartype state: str or ~azure.mgmt.eventgrid.models.TopicSpacesConfigurationState
    :ivar route_topic_resource_id: Fully qualified Azure Resource Id for the Event Grid Topic to
     which events will be routed to from TopicSpaces under a namespace.
     This property should be in the following format
     '/subscriptions/{subId}/resourcegroups/{resourceGroupName}/providers/microsoft.EventGrid/topics/{topicName}'.
     This topic should reside in the same region where namespace is located.
    :vartype route_topic_resource_id: str
    :ivar hostname: The endpoint for the topic spaces configuration. This is a read-only property.
    :vartype hostname: str
    :ivar routing_enrichments: Routing enrichments for topic spaces configuration.
    :vartype routing_enrichments: ~azure.mgmt.eventgrid.models.RoutingEnrichments
    :ivar maximum_session_expiry_in_hours: The maximum session expiry in hours. The property
     default value is 1 hour.
     Min allowed value is 1 hour and max allowed value is 8 hours.
    :vartype maximum_session_expiry_in_hours: int
    :ivar maximum_client_sessions_per_authentication_name: The maximum number of sessions per
     authentication name. The property default value is 1.
     Min allowed value is 1 and max allowed value is 100.
    :vartype maximum_client_sessions_per_authentication_name: int
    :ivar routing_identity_info: Routing identity info for topic spaces configuration.
    :vartype routing_identity_info: ~azure.mgmt.eventgrid.models.RoutingIdentityInfo
    :ivar custom_domains: List of custom domain configurations for the namespace.
    :vartype custom_domains: list[~azure.mgmt.eventgrid.models.CustomDomainConfiguration]
    """

    _validation = {
        "hostname": {"readonly": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "route_topic_resource_id": {"key": "routeTopicResourceId", "type": "str"},
        "hostname": {"key": "hostname", "type": "str"},
        "routing_enrichments": {"key": "routingEnrichments", "type": "RoutingEnrichments"},
        "maximum_session_expiry_in_hours": {"key": "maximumSessionExpiryInHours", "type": "int"},
        "maximum_client_sessions_per_authentication_name": {
            "key": "maximumClientSessionsPerAuthenticationName",
            "type": "int",
        },
        "routing_identity_info": {"key": "routingIdentityInfo", "type": "RoutingIdentityInfo"},
        "custom_domains": {"key": "customDomains", "type": "[CustomDomainConfiguration]"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.TopicSpacesConfigurationState"]] = None,
        route_topic_resource_id: Optional[str] = None,
        routing_enrichments: Optional["_models.RoutingEnrichments"] = None,
        maximum_session_expiry_in_hours: Optional[int] = None,
        maximum_client_sessions_per_authentication_name: Optional[int] = None,
        routing_identity_info: Optional["_models.RoutingIdentityInfo"] = None,
        custom_domains: Optional[List["_models.CustomDomainConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: Indicate if Topic Spaces Configuration is enabled for the namespace. Default is
         Disabled. Known values are: "Disabled" and "Enabled".
        :paramtype state: str or ~azure.mgmt.eventgrid.models.TopicSpacesConfigurationState
        :keyword route_topic_resource_id: Fully qualified Azure Resource Id for the Event Grid Topic to
         which events will be routed to from TopicSpaces under a namespace.
         This property should be in the following format
         '/subscriptions/{subId}/resourcegroups/{resourceGroupName}/providers/microsoft.EventGrid/topics/{topicName}'.
         This topic should reside in the same region where namespace is located.
        :paramtype route_topic_resource_id: str
        :keyword routing_enrichments: Routing enrichments for topic spaces configuration.
        :paramtype routing_enrichments: ~azure.mgmt.eventgrid.models.RoutingEnrichments
        :keyword maximum_session_expiry_in_hours: The maximum session expiry in hours. The property
         default value is 1 hour.
         Min allowed value is 1 hour and max allowed value is 8 hours.
        :paramtype maximum_session_expiry_in_hours: int
        :keyword maximum_client_sessions_per_authentication_name: The maximum number of sessions per
         authentication name. The property default value is 1.
         Min allowed value is 1 and max allowed value is 100.
        :paramtype maximum_client_sessions_per_authentication_name: int
        :keyword routing_identity_info: Routing identity info for topic spaces configuration.
        :paramtype routing_identity_info: ~azure.mgmt.eventgrid.models.RoutingIdentityInfo
        :keyword custom_domains: List of custom domain configurations for the namespace.
        :paramtype custom_domains: list[~azure.mgmt.eventgrid.models.CustomDomainConfiguration]
        """
        super().__init__(**kwargs)
        self.state = state
        self.route_topic_resource_id = route_topic_resource_id
        self.hostname = None
        self.routing_enrichments = routing_enrichments
        self.maximum_session_expiry_in_hours = maximum_session_expiry_in_hours
        self.maximum_client_sessions_per_authentication_name = maximum_client_sessions_per_authentication_name
        self.routing_identity_info = routing_identity_info
        self.custom_domains = custom_domains


class TopicSpacesListResult(_serialization.Model):
    """Result of the List Topic Space operation.

    :ivar value: A collection of Topic Space.
    :vartype value: list[~azure.mgmt.eventgrid.models.TopicSpace]
    :ivar next_link: A link for the next page of Topic Space.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[TopicSpace]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.TopicSpace"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of Topic Space.
        :paramtype value: list[~azure.mgmt.eventgrid.models.TopicSpace]
        :keyword next_link: A link for the next page of Topic Space.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TopicTypeAdditionalEnforcedPermission(_serialization.Model):
    """TopicTypeAdditionalEnforcedPermission.

    :ivar permission_name:
    :vartype permission_name: str
    :ivar is_data_action:
    :vartype is_data_action: bool
    """

    _attribute_map = {
        "permission_name": {"key": "permissionName", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
    }

    def __init__(
        self, *, permission_name: Optional[str] = None, is_data_action: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword permission_name:
        :paramtype permission_name: str
        :keyword is_data_action:
        :paramtype is_data_action: bool
        """
        super().__init__(**kwargs)
        self.permission_name = permission_name
        self.is_data_action = is_data_action


class TopicTypeInfo(Resource):
    """Properties of a topic type info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar provider: Namespace of the provider of the topic type.
    :vartype provider: str
    :ivar display_name: Display Name for the topic type.
    :vartype display_name: str
    :ivar description: Description of the topic type.
    :vartype description: str
    :ivar resource_region_type: Region type of the resource. Known values are: "RegionalResource"
     and "GlobalResource".
    :vartype resource_region_type: str or ~azure.mgmt.eventgrid.models.ResourceRegionType
    :ivar provisioning_state: Provisioning state of the topic type. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.TopicTypeProvisioningState
    :ivar supported_locations: List of locations supported by this topic type.
    :vartype supported_locations: list[str]
    :ivar source_resource_format: Source resource format.
    :vartype source_resource_format: str
    :ivar supported_scopes_for_source: Supported source scopes.
    :vartype supported_scopes_for_source: list[str or
     ~azure.mgmt.eventgrid.models.TopicTypeSourceScope]
    :ivar are_regional_and_global_sources_supported: Flag to indicate that a topic type can support
     both regional or global system topics.
    :vartype are_regional_and_global_sources_supported: bool
    :ivar additional_enforced_permissions: Permissions which are enforced for creating and updating
     system topics of this this topic type.
    :vartype additional_enforced_permissions:
     list[~azure.mgmt.eventgrid.models.TopicTypeAdditionalEnforcedPermission]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provider": {"key": "properties.provider", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "resource_region_type": {"key": "properties.resourceRegionType", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "supported_locations": {"key": "properties.supportedLocations", "type": "[str]"},
        "source_resource_format": {"key": "properties.sourceResourceFormat", "type": "str"},
        "supported_scopes_for_source": {"key": "properties.supportedScopesForSource", "type": "[str]"},
        "are_regional_and_global_sources_supported": {
            "key": "properties.areRegionalAndGlobalSourcesSupported",
            "type": "bool",
        },
        "additional_enforced_permissions": {
            "key": "properties.additionalEnforcedPermissions",
            "type": "[TopicTypeAdditionalEnforcedPermission]",
        },
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        resource_region_type: Optional[Union[str, "_models.ResourceRegionType"]] = None,
        provisioning_state: Optional[Union[str, "_models.TopicTypeProvisioningState"]] = None,
        supported_locations: Optional[List[str]] = None,
        source_resource_format: Optional[str] = None,
        supported_scopes_for_source: Optional[List[Union[str, "_models.TopicTypeSourceScope"]]] = None,
        are_regional_and_global_sources_supported: Optional[bool] = None,
        additional_enforced_permissions: Optional[List["_models.TopicTypeAdditionalEnforcedPermission"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Namespace of the provider of the topic type.
        :paramtype provider: str
        :keyword display_name: Display Name for the topic type.
        :paramtype display_name: str
        :keyword description: Description of the topic type.
        :paramtype description: str
        :keyword resource_region_type: Region type of the resource. Known values are:
         "RegionalResource" and "GlobalResource".
        :paramtype resource_region_type: str or ~azure.mgmt.eventgrid.models.ResourceRegionType
        :keyword provisioning_state: Provisioning state of the topic type. Known values are:
         "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
        :paramtype provisioning_state: str or ~azure.mgmt.eventgrid.models.TopicTypeProvisioningState
        :keyword supported_locations: List of locations supported by this topic type.
        :paramtype supported_locations: list[str]
        :keyword source_resource_format: Source resource format.
        :paramtype source_resource_format: str
        :keyword supported_scopes_for_source: Supported source scopes.
        :paramtype supported_scopes_for_source: list[str or
         ~azure.mgmt.eventgrid.models.TopicTypeSourceScope]
        :keyword are_regional_and_global_sources_supported: Flag to indicate that a topic type can
         support both regional or global system topics.
        :paramtype are_regional_and_global_sources_supported: bool
        :keyword additional_enforced_permissions: Permissions which are enforced for creating and
         updating system topics of this this topic type.
        :paramtype additional_enforced_permissions:
         list[~azure.mgmt.eventgrid.models.TopicTypeAdditionalEnforcedPermission]
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.display_name = display_name
        self.description = description
        self.resource_region_type = resource_region_type
        self.provisioning_state = provisioning_state
        self.supported_locations = supported_locations
        self.source_resource_format = source_resource_format
        self.supported_scopes_for_source = supported_scopes_for_source
        self.are_regional_and_global_sources_supported = are_regional_and_global_sources_supported
        self.additional_enforced_permissions = additional_enforced_permissions


class TopicTypesListResult(_serialization.Model):
    """Result of the List Topic Types operation.

    :ivar value: A collection of topic types.
    :vartype value: list[~azure.mgmt.eventgrid.models.TopicTypeInfo]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[TopicTypeInfo]"},
    }

    def __init__(self, *, value: Optional[List["_models.TopicTypeInfo"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A collection of topic types.
        :paramtype value: list[~azure.mgmt.eventgrid.models.TopicTypeInfo]
        """
        super().__init__(**kwargs)
        self.value = value


class TopicUpdateParameters(_serialization.Model):
    """Properties of the Topic update.

    :ivar tags: Tags of the Topic resource.
    :vartype tags: dict[str, str]
    :ivar identity: Topic resource identity information.
    :vartype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :ivar public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicUpdateParameterProperties.InboundIpRules"
     />`. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :ivar inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :vartype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    :ivar minimum_tls_version_allowed: Minimum TLS version of the publisher allowed to publish to
     this domain. Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
    :ivar disable_local_auth: This boolean is used to enable or disable local auth. Default value
     is false. When the property is set to true, only AAD token will be used to authenticate if user
     is allowed to publish to the topic.
    :vartype disable_local_auth: bool
    :ivar data_residency_boundary: The data residency boundary for the topic. Known values are:
     "WithinGeopair" and "WithinRegion".
    :vartype data_residency_boundary: str or ~azure.mgmt.eventgrid.models.DataResidencyBoundary
    :ivar event_type_info: The eventTypeInfo for the topic.
    :vartype event_type_info: ~azure.mgmt.eventgrid.models.EventTypeInfo
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "IdentityInfo"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "inbound_ip_rules": {"key": "properties.inboundIpRules", "type": "[InboundIpRule]"},
        "minimum_tls_version_allowed": {"key": "properties.minimumTlsVersionAllowed", "type": "str"},
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "data_residency_boundary": {"key": "properties.dataResidencyBoundary", "type": "str"},
        "event_type_info": {"key": "properties.eventTypeInfo", "type": "EventTypeInfo"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.IdentityInfo"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["_models.InboundIpRule"]] = None,
        minimum_tls_version_allowed: Optional[Union[str, "_models.TlsVersion"]] = None,
        disable_local_auth: Optional[bool] = None,
        data_residency_boundary: Optional[Union[str, "_models.DataResidencyBoundary"]] = None,
        event_type_info: Optional["_models.EventTypeInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Tags of the Topic resource.
        :paramtype tags: dict[str, str]
        :keyword identity: Topic resource identity information.
        :paramtype identity: ~azure.mgmt.eventgrid.models.IdentityInfo
        :keyword public_network_access: This determines if traffic is allowed over public network. By
         default it is enabled.
         You can further restrict to specific IPs by configuring :code:`<seealso
         cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicUpdateParameterProperties.InboundIpRules"
         />`. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
        :keyword inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of
         all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
        :paramtype inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
        :keyword minimum_tls_version_allowed: Minimum TLS version of the publisher allowed to publish
         to this domain. Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
        :keyword disable_local_auth: This boolean is used to enable or disable local auth. Default
         value is false. When the property is set to true, only AAD token will be used to authenticate
         if user is allowed to publish to the topic.
        :paramtype disable_local_auth: bool
        :keyword data_residency_boundary: The data residency boundary for the topic. Known values are:
         "WithinGeopair" and "WithinRegion".
        :paramtype data_residency_boundary: str or ~azure.mgmt.eventgrid.models.DataResidencyBoundary
        :keyword event_type_info: The eventTypeInfo for the topic.
        :paramtype event_type_info: ~azure.mgmt.eventgrid.models.EventTypeInfo
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules
        self.minimum_tls_version_allowed = minimum_tls_version_allowed
        self.disable_local_auth = disable_local_auth
        self.data_residency_boundary = data_residency_boundary
        self.event_type_info = event_type_info


class UpdateTopicsConfigurationInfo(_serialization.Model):
    """Properties of the topics configuration info of a namespace.

    :ivar custom_domains: Custom domain info for topics configuration.
    :vartype custom_domains: list[~azure.mgmt.eventgrid.models.CustomDomainConfiguration]
    """

    _attribute_map = {
        "custom_domains": {"key": "customDomains", "type": "[CustomDomainConfiguration]"},
    }

    def __init__(
        self, *, custom_domains: Optional[List["_models.CustomDomainConfiguration"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword custom_domains: Custom domain info for topics configuration.
        :paramtype custom_domains: list[~azure.mgmt.eventgrid.models.CustomDomainConfiguration]
        """
        super().__init__(**kwargs)
        self.custom_domains = custom_domains


class UpdateTopicSpacesConfigurationInfo(_serialization.Model):
    """Properties of the topic spaces configuration info of a namespace.

    :ivar state: Indicate if Topic Spaces Configuration is enabled for the namespace. Default is
     Disabled. Known values are: "Disabled" and "Enabled".
    :vartype state: str or ~azure.mgmt.eventgrid.models.TopicSpacesConfigurationState
    :ivar route_topic_resource_id: This property is used to specify custom topic to which events
     will be routed to from topic spaces configuration under namespace.
    :vartype route_topic_resource_id: str
    :ivar routing_enrichments: Routing enrichments for topic spaces configuration.
    :vartype routing_enrichments: ~azure.mgmt.eventgrid.models.RoutingEnrichments
    :ivar maximum_session_expiry_in_hours: The maximum session expiry in hours. The property
     default value is 1 hour.
     Min allowed value is 1 hour and max allowed value is 8 hours.
    :vartype maximum_session_expiry_in_hours: int
    :ivar maximum_client_sessions_per_authentication_name: The maximum number of sessions per
     authentication name. The property default value is 1.
     Min allowed value is 1 and max allowed value is 100.
    :vartype maximum_client_sessions_per_authentication_name: int
    :ivar routing_identity_info: Routing identity info for topic spaces configuration.
    :vartype routing_identity_info: ~azure.mgmt.eventgrid.models.RoutingIdentityInfo
    :ivar custom_domains: Custom domain info for topic spaces configuration.
    :vartype custom_domains: list[~azure.mgmt.eventgrid.models.CustomDomainConfiguration]
    """

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "route_topic_resource_id": {"key": "routeTopicResourceId", "type": "str"},
        "routing_enrichments": {"key": "routingEnrichments", "type": "RoutingEnrichments"},
        "maximum_session_expiry_in_hours": {"key": "maximumSessionExpiryInHours", "type": "int"},
        "maximum_client_sessions_per_authentication_name": {
            "key": "maximumClientSessionsPerAuthenticationName",
            "type": "int",
        },
        "routing_identity_info": {"key": "routingIdentityInfo", "type": "RoutingIdentityInfo"},
        "custom_domains": {"key": "customDomains", "type": "[CustomDomainConfiguration]"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.TopicSpacesConfigurationState"]] = None,
        route_topic_resource_id: Optional[str] = None,
        routing_enrichments: Optional["_models.RoutingEnrichments"] = None,
        maximum_session_expiry_in_hours: Optional[int] = None,
        maximum_client_sessions_per_authentication_name: Optional[int] = None,
        routing_identity_info: Optional["_models.RoutingIdentityInfo"] = None,
        custom_domains: Optional[List["_models.CustomDomainConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: Indicate if Topic Spaces Configuration is enabled for the namespace. Default is
         Disabled. Known values are: "Disabled" and "Enabled".
        :paramtype state: str or ~azure.mgmt.eventgrid.models.TopicSpacesConfigurationState
        :keyword route_topic_resource_id: This property is used to specify custom topic to which events
         will be routed to from topic spaces configuration under namespace.
        :paramtype route_topic_resource_id: str
        :keyword routing_enrichments: Routing enrichments for topic spaces configuration.
        :paramtype routing_enrichments: ~azure.mgmt.eventgrid.models.RoutingEnrichments
        :keyword maximum_session_expiry_in_hours: The maximum session expiry in hours. The property
         default value is 1 hour.
         Min allowed value is 1 hour and max allowed value is 8 hours.
        :paramtype maximum_session_expiry_in_hours: int
        :keyword maximum_client_sessions_per_authentication_name: The maximum number of sessions per
         authentication name. The property default value is 1.
         Min allowed value is 1 and max allowed value is 100.
        :paramtype maximum_client_sessions_per_authentication_name: int
        :keyword routing_identity_info: Routing identity info for topic spaces configuration.
        :paramtype routing_identity_info: ~azure.mgmt.eventgrid.models.RoutingIdentityInfo
        :keyword custom_domains: Custom domain info for topic spaces configuration.
        :paramtype custom_domains: list[~azure.mgmt.eventgrid.models.CustomDomainConfiguration]
        """
        super().__init__(**kwargs)
        self.state = state
        self.route_topic_resource_id = route_topic_resource_id
        self.routing_enrichments = routing_enrichments
        self.maximum_session_expiry_in_hours = maximum_session_expiry_in_hours
        self.maximum_client_sessions_per_authentication_name = maximum_client_sessions_per_authentication_name
        self.routing_identity_info = routing_identity_info
        self.custom_domains = custom_domains


class UserIdentityProperties(_serialization.Model):
    """The information about the user identity.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, *, principal_id: Optional[str] = None, client_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword principal_id: The principal id of user assigned identity.
        :paramtype principal_id: str
        :keyword client_id: The client id of user assigned identity.
        :paramtype client_id: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.client_id = client_id


class VerifiedPartner(Resource):
    """Verified partner information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar system_data: The system metadata relating to the Event Grid resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    :ivar partner_registration_immutable_id: ImmutableId of the corresponding partner registration.
    :vartype partner_registration_immutable_id: str
    :ivar organization_name: Official name of the Partner.
    :vartype organization_name: str
    :ivar partner_display_name: Display name of the verified partner.
    :vartype partner_display_name: str
    :ivar partner_topic_details: Details of the partner topic scenario.
    :vartype partner_topic_details: ~azure.mgmt.eventgrid.models.PartnerDetails
    :ivar provisioning_state: Provisioning state of the verified partner. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.VerifiedPartnerProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "partner_registration_immutable_id": {"key": "properties.partnerRegistrationImmutableId", "type": "str"},
        "organization_name": {"key": "properties.organizationName", "type": "str"},
        "partner_display_name": {"key": "properties.partnerDisplayName", "type": "str"},
        "partner_topic_details": {"key": "properties.partnerTopicDetails", "type": "PartnerDetails"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        partner_registration_immutable_id: Optional[str] = None,
        organization_name: Optional[str] = None,
        partner_display_name: Optional[str] = None,
        partner_topic_details: Optional["_models.PartnerDetails"] = None,
        provisioning_state: Optional[Union[str, "_models.VerifiedPartnerProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword partner_registration_immutable_id: ImmutableId of the corresponding partner
         registration.
        :paramtype partner_registration_immutable_id: str
        :keyword organization_name: Official name of the Partner.
        :paramtype organization_name: str
        :keyword partner_display_name: Display name of the verified partner.
        :paramtype partner_display_name: str
        :keyword partner_topic_details: Details of the partner topic scenario.
        :paramtype partner_topic_details: ~azure.mgmt.eventgrid.models.PartnerDetails
        :keyword provisioning_state: Provisioning state of the verified partner. Known values are:
         "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
        :paramtype provisioning_state: str or
         ~azure.mgmt.eventgrid.models.VerifiedPartnerProvisioningState
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.partner_registration_immutable_id = partner_registration_immutable_id
        self.organization_name = organization_name
        self.partner_display_name = partner_display_name
        self.partner_topic_details = partner_topic_details
        self.provisioning_state = provisioning_state


class VerifiedPartnersListResult(_serialization.Model):
    """Result of the List verified partners operation.

    :ivar value: A collection of verified partners.
    :vartype value: list[~azure.mgmt.eventgrid.models.VerifiedPartner]
    :ivar next_link: A link for the next page of verified partners if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VerifiedPartner]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VerifiedPartner"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of verified partners.
        :paramtype value: list[~azure.mgmt.eventgrid.models.VerifiedPartner]
        :keyword next_link: A link for the next page of verified partners if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WebHookEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the webhook destination for an event subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: Type of the endpoint for the event subscription destination. Required.
     Known values are: "WebHook", "EventHub", "StorageQueue", "HybridConnection", "ServiceBusQueue",
     "ServiceBusTopic", "AzureFunction", "MonitorAlert", and "NamespaceTopic".
    :vartype endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :ivar endpoint_url: The URL that represents the endpoint of the destination of an event
     subscription.
    :vartype endpoint_url: str
    :ivar endpoint_base_url: The base URL that represents the endpoint of the destination of an
     event subscription.
    :vartype endpoint_base_url: str
    :ivar max_events_per_batch: Maximum number of events per batch.
    :vartype max_events_per_batch: int
    :ivar preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
    :vartype preferred_batch_size_in_kilobytes: int
    :ivar azure_active_directory_tenant_id: The Azure Active Directory Tenant ID to get the access
     token that will be included as the bearer token in delivery requests.
    :vartype azure_active_directory_tenant_id: str
    :ivar azure_active_directory_application_id_or_uri: The Azure Active Directory Application ID
     or URI to get the access token that will be included as the bearer token in delivery requests.
    :vartype azure_active_directory_application_id_or_uri: str
    :ivar delivery_attribute_mappings: Delivery attribute details.
    :vartype delivery_attribute_mappings:
     list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    :ivar minimum_tls_version_allowed: Minimum TLS version that should be supported by webhook
     endpoint. Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
    """

    _validation = {
        "endpoint_type": {"required": True},
        "endpoint_base_url": {"readonly": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "endpoint_url": {"key": "properties.endpointUrl", "type": "str"},
        "endpoint_base_url": {"key": "properties.endpointBaseUrl", "type": "str"},
        "max_events_per_batch": {"key": "properties.maxEventsPerBatch", "type": "int"},
        "preferred_batch_size_in_kilobytes": {"key": "properties.preferredBatchSizeInKilobytes", "type": "int"},
        "azure_active_directory_tenant_id": {"key": "properties.azureActiveDirectoryTenantId", "type": "str"},
        "azure_active_directory_application_id_or_uri": {
            "key": "properties.azureActiveDirectoryApplicationIdOrUri",
            "type": "str",
        },
        "delivery_attribute_mappings": {
            "key": "properties.deliveryAttributeMappings",
            "type": "[DeliveryAttributeMapping]",
        },
        "minimum_tls_version_allowed": {"key": "properties.minimumTlsVersionAllowed", "type": "str"},
    }

    def __init__(
        self,
        *,
        endpoint_url: Optional[str] = None,
        max_events_per_batch: int = 1,
        preferred_batch_size_in_kilobytes: int = 64,
        azure_active_directory_tenant_id: Optional[str] = None,
        azure_active_directory_application_id_or_uri: Optional[str] = None,
        delivery_attribute_mappings: Optional[List["_models.DeliveryAttributeMapping"]] = None,
        minimum_tls_version_allowed: Optional[Union[str, "_models.TlsVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword endpoint_url: The URL that represents the endpoint of the destination of an event
         subscription.
        :paramtype endpoint_url: str
        :keyword max_events_per_batch: Maximum number of events per batch.
        :paramtype max_events_per_batch: int
        :keyword preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
        :paramtype preferred_batch_size_in_kilobytes: int
        :keyword azure_active_directory_tenant_id: The Azure Active Directory Tenant ID to get the
         access token that will be included as the bearer token in delivery requests.
        :paramtype azure_active_directory_tenant_id: str
        :keyword azure_active_directory_application_id_or_uri: The Azure Active Directory Application
         ID or URI to get the access token that will be included as the bearer token in delivery
         requests.
        :paramtype azure_active_directory_application_id_or_uri: str
        :keyword delivery_attribute_mappings: Delivery attribute details.
        :paramtype delivery_attribute_mappings:
         list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
        :keyword minimum_tls_version_allowed: Minimum TLS version that should be supported by webhook
         endpoint. Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version_allowed: str or ~azure.mgmt.eventgrid.models.TlsVersion
        """
        super().__init__(**kwargs)
        self.endpoint_type: str = "WebHook"
        self.endpoint_url = endpoint_url
        self.endpoint_base_url = None
        self.max_events_per_batch = max_events_per_batch
        self.preferred_batch_size_in_kilobytes = preferred_batch_size_in_kilobytes
        self.azure_active_directory_tenant_id = azure_active_directory_tenant_id
        self.azure_active_directory_application_id_or_uri = azure_active_directory_application_id_or_uri
        self.delivery_attribute_mappings = delivery_attribute_mappings
        self.minimum_tls_version_allowed = minimum_tls_version_allowed
