# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, Generic, List, Optional, TypeVar, Union
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling

from ... import models

T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class SearchOperations:
    """SearchOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.maps.search.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    async def list_polygons(
        self,
        geometry_ids: List[str],
        format: Union[str, "models.JsonFormat"] = "json",
        **kwargs
    ) -> "models.PolygonResult":
        """**Get Polygon**

        **Applies to**\ : S1 pricing tier.

        The Get Polygon service allows you to request the geometry data such as a city or country
        outline for a set of entities, previously retrieved from an Online Search request in GeoJSON
        format. The geometry ID is returned in the sourceGeometry object under "geometry" and "id" in
        either a Search Address or Search Fuzzy call.

        Please note that any geometry ID retrieved from an Online Search endpoint has a limited
        lifetime. The client  should not store geometry IDs in persistent storage for later referral,
        as the stability of these identifiers is  not guaranteed for a long period of time. It is
        expected that a request to the Polygon method is made within a  few minutes of the request to
        the Online Search method that provided the ID. The service allows for batch  requests up to 20
        identifiers.

        :param geometry_ids: Comma separated list of geometry UUIDs, previously retrieved from an
         Online Search request.
        :type geometry_ids: list[str]
        :param format: Desired format of the response. Only ``json`` format is supported.
        :type format: str or ~azure.maps.search.models.JsonFormat
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PolygonResult, or the result of cls(response)
        :rtype: ~azure.maps.search.models.PolygonResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.PolygonResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/json"

        # Construct URL
        url = self.list_polygons.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['geometries'] = self._serialize.query("geometry_ids", geometry_ids, '[str]', div=',')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('PolygonResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    list_polygons.metadata = {'url': '/search/polygon/{format}'}  # type: ignore

    async def fuzzy_search(
        self,
        query: str,
        format: Union[str, "models.ResponseFormat"] = "json",
        is_type_ahead: Optional[bool] = None,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        category_filter: Optional[List[int]] = None,
        country_filter: Optional[List[str]] = None,
        lat: Optional[float] = None,
        lon: Optional[float] = None,
        radius_in_meters: Optional[int] = None,
        top_left: Optional[str] = None,
        btm_right: Optional[str] = None,
        language: Optional[str] = None,
        extended_postal_codes_for: Optional[List[Union[str, "models.SearchIndexes"]]] = None,
        min_fuzzy_level: Optional[int] = None,
        max_fuzzy_level: Optional[int] = None,
        index_filter: Optional[List[Union[str, "models.SearchIndexes"]]] = None,
        brand_filter: Optional[List[str]] = None,
        electric_vehicle_connector_filter: Optional[List[Union[str, "models.ElectricVehicleConnector"]]] = None,
        entity_type: Optional[Union[str, "models.GeographicEntityType"]] = None,
        localized_map_view: Optional[Union[str, "models.LocalizedMapView"]] = None,
        operating_hours: Optional[Union[str, "models.OperatingHoursRange"]] = None,
        **kwargs
    ) -> "models.SearchAddressResult":
        """**Free Form Search**

        **Applies to**\ : S0 and S1 pricing tiers.

        The basic default API is Free Form Search which handles the most fuzzy of inputs handling any
        combination of address or POI tokens. This search API is the canonical 'single line search'.
        The Free Form Search API is a seamless combination of POI search and geocoding. The API can
        also be weighted with a contextual position (lat./lon. pair), or fully constrained by a
        coordinate and radius, or it can be executed more generally without any geo biasing anchor
        point.:code:`<br>`:code:`<br>`We strongly advise you to use the 'countrySet' parameter to
        specify only the countries for which your application needs coverage, as the default behavior
        will be to search the entire world, potentially returning unnecessary
        results.:code:`<br>`:code:`<br>` E.g.: ``countrySet``\ =US,FR :code:`<br>`:code:`<br>`Please
        see `Search Coverage <https://docs.microsoft.com/azure/location-based-services/geocoding-
        coverage>`_ for a complete list of all the supported countries.:code:`<br>`:code:`<br>`Most
        Search queries default to ``maxFuzzyLevel``\ =2 to gain performance and also reduce unusual
        results. This new default can be overridden as needed per request by passing in the query param
        ``maxFuzzyLevel``\ =3 or 4.

        :param query: The applicable query string (e.g., "seattle", "pizza"). Can *also* be specified
         as a comma separated string composed by latitude followed by longitude (e.g., "47.641268,
         -122.125679"). Must be properly URL encoded.
        :type query: str
        :param format: Desired format of the response. Value can be either *json* or *xml*.
        :type format: str or ~azure.maps.search.models.ResponseFormat
        :param is_type_ahead: Boolean. If the typeahead flag is set, the query will be interpreted as a
         partial input and the search will enter predictive mode.
        :type is_type_ahead: bool
        :param top: Maximum number of responses that will be returned. Default: 10, minimum: 1 and
         maximum: 100.
        :type top: int
        :param skip: Starting offset of the returned results within the full result set. Default: 0,
         minimum: 0 and maximum: 1900.
        :type skip: int
        :param category_filter: A comma-separated list of category set IDs which could be used to
         restrict the result to specific Points of Interest categories. ID order does not matter. When
         multiple category identifiers are provided, only POIs that belong to (at least) one of the
         categories from the provided list will be returned. The list of supported categories can be
         discovered using  `POI Categories API <https://aka.ms/AzureMapsPOICategoryTree>`_. Usage
         examples:


         *
           **categorySet=7315**\  (Search Points of Interest from category Restaurant)

         *
           **categorySet=7315025,7315017**\  (Search Points of Interest of category either Italian or
         French Restaurant).
        :type category_filter: list[int]
        :param country_filter: Comma separated string of country codes, e.g. FR,ES. This will limit the
         search to the specified countries.
        :type country_filter: list[str]
        :param lat: Latitude where results should be biased. E.g. 37.337.
        :type lat: float
        :param lon: Longitude where results should be biased. E.g. -121.89.
        :type lon: float
        :param radius_in_meters: The radius in meters to for the results to be constrained to the
         defined area.
        :type radius_in_meters: int
        :param top_left: Top left position of the bounding box. E.g. 37.553,-122.453.
        :type top_left: str
        :param btm_right: Bottom right position of the bounding box. E.g. 37.553,-122.453.
        :type btm_right: str
        :param language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages <https://docs.microsoft.com/azure/azure-maps/supported-
         languages>`_ for details.
        :type language: str
        :param extended_postal_codes_for: Indexes for which extended postal codes should be included in
         the results.

         Available indexes are:

          **Addr** = Address ranges

          **Geo** = Geographies

          **PAD** = Point Addresses

          **POI** = Points of Interest

          **Str** = Streets

          **XStr** = Cross Streets (intersections)

         Value should be a comma separated list of index types (in any order) or **None** for no
         indexes.

         By default extended postal codes are included for all indexes except Geo. Extended postal code
         lists for geographies can be quite long so they have to be explicitly requested when needed.

         Usage examples:

          extendedPostalCodesFor=POI

          extendedPostalCodesFor=PAD,Addr,POI

          extendedPostalCodesFor=None

         Extended postal code is returned as an **extendedPostalCode** property of an address.
         Availability is region-dependent.
        :type extended_postal_codes_for: list[str or ~azure.maps.search.models.SearchIndexes]
        :param min_fuzzy_level: Minimum fuzziness level to be used. Default: 1, minimum: 1 and maximum:
         4


         *
           Level 1 has no spell checking.

         *
           Level 2 uses normal n-gram spell checking. For example, query "restrant" can be matched to
         "restaurant."

         *
           Level 3 uses sound-like spell checking, and shingle spell checking. Sound-like spell
         checking is for "rstrnt" to "restaurant" matching. Shingle spell checking is for "mountainview"
         to "mountain view" matching.

         *
           Level 4 doesn’t add any more spell checking functions.

         The search engine will start looking for a match on the level defined by minFuzzyLevel, and
         will stop searching at the level specified by maxFuzzyLevel.
        :type min_fuzzy_level: int
        :param max_fuzzy_level: Maximum fuzziness level to be used. Default: 2, minimum: 1 and maximum:
         4


         *
           Level 1 has no spell checking.

         *
           Level 2 uses normal n-gram spell checking. For example, query "restrant" can be matched to
         "restaurant."

         *
           Level 3 uses sound-like spell checking, and shingle spell checking. Sound-like spell
         checking is for "rstrnt" to "restaurant" matching. Shingle spell checking is for "mountainview"
         to "mountain view" matching.

         *
           Level 4 doesn’t add any more spell checking functions.

         The search engine will start looking for a match on the level defined by minFuzzyLevel, and
         will stop searching at the level specified by maxFuzzyLevel.
        :type max_fuzzy_level: int
        :param index_filter: A comma separated list of indexes which should be utilized for the search.
         Item order does not matter. Available indexes are: Addr = Address range interpolation, Geo =
         Geographies, PAD = Point Addresses, POI = Points of interest, Str = Streets, Xstr = Cross
         Streets (intersections).
        :type index_filter: list[str or ~azure.maps.search.models.SearchIndexes]
        :param brand_filter: A comma-separated list of brand names which could be used to restrict the
         result to specific brands. Item order does not matter. When multiple brands are provided, only
         results that belong to (at least) one of the provided list will be returned. Brands that
         contain a "," in their name should be put into quotes.

         Usage examples:

          brandSet=Foo

          brandSet=Foo,Bar

          brandSet="A,B,C Comma",Bar.
        :type brand_filter: list[str]
        :param electric_vehicle_connector_filter: A comma-separated list of connector types which could
         be used to restrict the result to Electric Vehicle Station supporting specific connector types.
         Item order does not matter. When multiple connector types are provided, only results that
         belong to (at least) one of the provided list will be returned.

         Available connector types are:


         * ``StandardHouseholdCountrySpecific`` - These are the standard household connectors for a
         certain region. They are all AC single phase and the standard Voltage and standard Amperage.
         See also: `Plug & socket types - World Standards
         <https://www.worldstandards.eu/electricity/plugs-and-sockets>`_.
         * ``IEC62196Type1`` - Type 1 connector as defined in the IEC 62196-2 standard. Also called
         Yazaki after the original manufacturer or SAE J1772 after the standard that first published it.
         Mostly used in combination with 120V single phase or up to 240V single phase infrastructure.
         * ``IEC62196Type1CCS`` - Type 1 based combo connector as defined in the IEC 62196-3 standard.
         The connector is based on the Type 1 connector – as defined in the IEC 62196-2 standard – with
         two additional direct current (DC) contacts to allow DC fast charging.
         * ``IEC62196Type2CableAttached`` - Type 2 connector as defined in the IEC 62196-2 standard.
         Provided as a cable and plug attached to the charging point.
         * ``IEC62196Type2Outlet`` - Type 2 connector as defined in the IEC 62196-2 standard. Provided
         as a socket set into the charging point.
         * ``IEC62196Type2CCS`` - Type 2 based combo connector as defined in the IEC 62196-3 standard.
         The connector is based on the Type 2 connector – as defined in the IEC 62196-2 standard – with
         two additional direct current (DC) contacts to allow DC fast charging.
         * ``IEC62196Type3`` - Type 3 connector as defined in the IEC 62196-2 standard. Also called
         Scame after the original manufacturer. Mostly used in combination with up to 240V single phase
         or up to 420V three phase infrastructure.
         * ``Chademo`` - CHAdeMO connector named after an association formed by the Tokyo Electric
         Power Company and industrial partners. Because of this is is also known as the TEPCO's
         connector. It supports fast DC charging.
         * ``IEC60309AC1PhaseBlue`` - Industrial Blue connector is a connector defined in the IEC 60309
         standard. It is sometime referred to as by some combination of the standard, the color and the
         fact that is a single phase connector. The connector usually has the "P+N+E, 6h" configuration.
         * ``IEC60309DCWhite`` - Industrial White connector is a DC connector defined in the IEC 60309
         standard.
         * ``Tesla`` - The Tesla connector is the regionally specific Tesla Supercharger connector.
         I.e. it refers to either Tesla's proprietary connector, sometimes referred to as Tesla Port
         mostly limited to North America or the modified Type 2 (DC over Type 2) in Europe.

         Usage examples:

          connectorSet=IEC62196Type2CableAttached
          connectorSet=IEC62196Type2Outlet,IEC62196Type2CableAttached.
        :type electric_vehicle_connector_filter: list[str or ~azure.maps.search.models.ElectricVehicleConnector]
        :param entity_type: Specifies the level of filtering performed on geographies. Narrows the
         search for specified geography entity types, e.g. return only municipality. The resulting
         response will contain the geography ID as well as the entity type matched. If you provide more
         than one entity as a comma separated list, endpoint will return the 'smallest entity
         available'. Returned Geometry ID can be used to get the geometry of that geography via `Get
         Search Polygon <https://docs.microsoft.com/rest/api/maps/search/getsearchpolygon>`_ API. The
         following parameters are ignored when entityType is set:


         * heading
         * number
         * returnRoadUse
         * returnSpeedLimit
         * roadUse
         * returnMatchType.
        :type entity_type: str or ~azure.maps.search.models.GeographicEntityType
        :param localized_map_view: The View parameter (also called the "user region" parameter) allows
         you to show the correct maps for a certain country/region for geopolitically disputed regions.
         Different countries have different views of such regions, and the View parameter allows your
         application to comply with the view required by the country your application will be serving.
         By default, the View parameter is set to “Unified” even if you haven’t defined it in  the
         request. It is your responsibility to determine the location of your users, and then set the
         View parameter correctly for that location. Alternatively, you have the option to set
         ‘View=Auto’, which will return the map data based on the IP  address of the request. The View
         parameter in Azure Maps must be used in compliance with applicable laws, including those
         regarding mapping, of the country where maps, images and other data and third party content
         that you are authorized to  access via Azure Maps is made available. Example: view=IN.

         Please refer to `Supported Views <https://aka.ms/AzureMapsLocalizationViews>`_ for details and
         to see the available Views.
        :type localized_map_view: str or ~azure.maps.search.models.LocalizedMapView
        :param operating_hours: Hours of operation for a POI (Points of Interest). The availability of
         hours of operation will vary based on the data available. If not passed, then no opening hours
         information will be returned.
         Supported value: nextSevenDays.
        :type operating_hours: str or ~azure.maps.search.models.OperatingHoursRange
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SearchAddressResult, or the result of cls(response)
        :rtype: ~azure.maps.search.models.SearchAddressResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.SearchAddressResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/json"

        # Construct URL
        url = self.fuzzy_search.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['query'] = self._serialize.query("query", query, 'str')
        if is_type_ahead is not None:
            query_parameters['typeahead'] = self._serialize.query("is_type_ahead", is_type_ahead, 'bool')
        if top is not None:
            query_parameters['limit'] = self._serialize.query("top", top, 'int', maximum=100, minimum=1)
        if skip is not None:
            query_parameters['ofs'] = self._serialize.query("skip", skip, 'int', maximum=1900, minimum=0)
        if category_filter is not None:
            query_parameters['categorySet'] = self._serialize.query("category_filter", category_filter, '[int]', div=',')
        if country_filter is not None:
            query_parameters['countrySet'] = self._serialize.query("country_filter", country_filter, '[str]', div=',')
        if lat is not None:
            query_parameters['lat'] = self._serialize.query("lat", lat, 'float')
        if lon is not None:
            query_parameters['lon'] = self._serialize.query("lon", lon, 'float')
        if radius_in_meters is not None:
            query_parameters['radius'] = self._serialize.query("radius_in_meters", radius_in_meters, 'int')
        if top_left is not None:
            query_parameters['topLeft'] = self._serialize.query("top_left", top_left, 'str')
        if btm_right is not None:
            query_parameters['btmRight'] = self._serialize.query("btm_right", btm_right, 'str')
        if language is not None:
            query_parameters['language'] = self._serialize.query("language", language, 'str')
        if extended_postal_codes_for is not None:
            query_parameters['extendedPostalCodesFor'] = self._serialize.query("extended_postal_codes_for", extended_postal_codes_for, '[str]', div=',')
        if min_fuzzy_level is not None:
            query_parameters['minFuzzyLevel'] = self._serialize.query("min_fuzzy_level", min_fuzzy_level, 'int', maximum=4, minimum=1)
        if max_fuzzy_level is not None:
            query_parameters['maxFuzzyLevel'] = self._serialize.query("max_fuzzy_level", max_fuzzy_level, 'int', maximum=4, minimum=1)
        if index_filter is not None:
            query_parameters['idxSet'] = self._serialize.query("index_filter", index_filter, '[str]', div=',')
        if brand_filter is not None:
            query_parameters['brandSet'] = self._serialize.query("brand_filter", brand_filter, '[str]', div=',')
        if electric_vehicle_connector_filter is not None:
            query_parameters['connectorSet'] = self._serialize.query("electric_vehicle_connector_filter", electric_vehicle_connector_filter, '[str]', div=',')
        if entity_type is not None:
            query_parameters['entityType'] = self._serialize.query("entity_type", entity_type, 'str')
        if localized_map_view is not None:
            query_parameters['view'] = self._serialize.query("localized_map_view", localized_map_view, 'str')
        if operating_hours is not None:
            query_parameters['openingHours'] = self._serialize.query("operating_hours", operating_hours, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('SearchAddressResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    fuzzy_search.metadata = {'url': '/search/fuzzy/{format}'}  # type: ignore

    async def search_point_of_interest(
        self,
        query: str,
        format: Union[str, "models.ResponseFormat"] = "json",
        is_type_ahead: Optional[bool] = None,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        category_filter: Optional[List[int]] = None,
        country_filter: Optional[List[str]] = None,
        lat: Optional[float] = None,
        lon: Optional[float] = None,
        radius_in_meters: Optional[int] = None,
        top_left: Optional[str] = None,
        btm_right: Optional[str] = None,
        language: Optional[str] = None,
        extended_postal_codes_for: Optional[List[Union[str, "models.PointOfInterestExtendedPostalCodes"]]] = None,
        brand_filter: Optional[List[str]] = None,
        electric_vehicle_connector_filter: Optional[List[Union[str, "models.ElectricVehicleConnector"]]] = None,
        localized_map_view: Optional[Union[str, "models.LocalizedMapView"]] = None,
        operating_hours: Optional[Union[str, "models.OperatingHoursRange"]] = None,
        **kwargs
    ) -> "models.SearchAddressResult":
        """**Get POI by Name**

        **Applies to**\ : S0 and S1 pricing tiers.

        Points of Interest (POI) Search allows you to request POI results by name.  Search supports
        additional query parameters such as language and filtering results by area of interest driven
        by country or bounding box.  Endpoint will return only POI results matching the query string.
        Response includes POI details such as address, coordinate location and category.

        :param query: The POI name to search for (e.g., "statue of liberty", "starbucks"), must be
         properly URL encoded.
        :type query: str
        :param format: Desired format of the response. Value can be either *json* or *xml*.
        :type format: str or ~azure.maps.search.models.ResponseFormat
        :param is_type_ahead: Boolean. If the typeahead flag is set, the query will be interpreted as a
         partial input and the search will enter predictive mode.
        :type is_type_ahead: bool
        :param top: Maximum number of responses that will be returned. Default: 10, minimum: 1 and
         maximum: 100.
        :type top: int
        :param skip: Starting offset of the returned results within the full result set. Default: 0,
         minimum: 0 and maximum: 1900.
        :type skip: int
        :param category_filter: A comma-separated list of category set IDs which could be used to
         restrict the result to specific Points of Interest categories. ID order does not matter. When
         multiple category identifiers are provided, only POIs that belong to (at least) one of the
         categories from the provided list will be returned. The list of supported categories can be
         discovered using  `POI Categories API <https://aka.ms/AzureMapsPOICategoryTree>`_. Usage
         examples:


         *
           **categorySet=7315**\  (Search Points of Interest from category Restaurant)

         *
           **categorySet=7315025,7315017**\  (Search Points of Interest of category either Italian or
         French Restaurant).
        :type category_filter: list[int]
        :param country_filter: Comma separated string of country codes, e.g. FR,ES. This will limit the
         search to the specified countries.
        :type country_filter: list[str]
        :param lat: Latitude where results should be biased. E.g. 37.337.
        :type lat: float
        :param lon: Longitude where results should be biased. E.g. -121.89.
        :type lon: float
        :param radius_in_meters: The radius in meters to for the results to be constrained to the
         defined area.
        :type radius_in_meters: int
        :param top_left: Top left position of the bounding box. E.g. 37.553,-122.453.
        :type top_left: str
        :param btm_right: Bottom right position of the bounding box. E.g. 37.553,-122.453.
        :type btm_right: str
        :param language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages <https://docs.microsoft.com/azure/azure-maps/supported-
         languages>`_ for details.
        :type language: str
        :param extended_postal_codes_for: Indexes for which extended postal codes should be included in
         the results.

         Available indexes are:

          **POI** = Points of Interest

         Value should be **POI** or **None** to disable extended postal codes.

         By default extended postal codes are included.

         Usage examples:

          extendedPostalCodesFor=POI

          extendedPostalCodesFor=None

         Extended postal code is returned as an **extendedPostalCode** property of an address.
         Availability is region-dependent.
        :type extended_postal_codes_for: list[str or ~azure.maps.search.models.PointOfInterestExtendedPostalCodes]
        :param brand_filter: A comma-separated list of brand names which could be used to restrict the
         result to specific brands. Item order does not matter. When multiple brands are provided, only
         results that belong to (at least) one of the provided list will be returned. Brands that
         contain a "," in their name should be put into quotes.

         Usage examples:

          brandSet=Foo

          brandSet=Foo,Bar

          brandSet="A,B,C Comma",Bar.
        :type brand_filter: list[str]
        :param electric_vehicle_connector_filter: A comma-separated list of connector types which could
         be used to restrict the result to Electric Vehicle Station supporting specific connector types.
         Item order does not matter. When multiple connector types are provided, only results that
         belong to (at least) one of the provided list will be returned.

         Available connector types are:


         * ``StandardHouseholdCountrySpecific`` - These are the standard household connectors for a
         certain region. They are all AC single phase and the standard Voltage and standard Amperage.
         See also: `Plug & socket types - World Standards
         <https://www.worldstandards.eu/electricity/plugs-and-sockets>`_.
         * ``IEC62196Type1`` - Type 1 connector as defined in the IEC 62196-2 standard. Also called
         Yazaki after the original manufacturer or SAE J1772 after the standard that first published it.
         Mostly used in combination with 120V single phase or up to 240V single phase infrastructure.
         * ``IEC62196Type1CCS`` - Type 1 based combo connector as defined in the IEC 62196-3 standard.
         The connector is based on the Type 1 connector – as defined in the IEC 62196-2 standard – with
         two additional direct current (DC) contacts to allow DC fast charging.
         * ``IEC62196Type2CableAttached`` - Type 2 connector as defined in the IEC 62196-2 standard.
         Provided as a cable and plug attached to the charging point.
         * ``IEC62196Type2Outlet`` - Type 2 connector as defined in the IEC 62196-2 standard. Provided
         as a socket set into the charging point.
         * ``IEC62196Type2CCS`` - Type 2 based combo connector as defined in the IEC 62196-3 standard.
         The connector is based on the Type 2 connector – as defined in the IEC 62196-2 standard – with
         two additional direct current (DC) contacts to allow DC fast charging.
         * ``IEC62196Type3`` - Type 3 connector as defined in the IEC 62196-2 standard. Also called
         Scame after the original manufacturer. Mostly used in combination with up to 240V single phase
         or up to 420V three phase infrastructure.
         * ``Chademo`` - CHAdeMO connector named after an association formed by the Tokyo Electric
         Power Company and industrial partners. Because of this is is also known as the TEPCO's
         connector. It supports fast DC charging.
         * ``IEC60309AC1PhaseBlue`` - Industrial Blue connector is a connector defined in the IEC 60309
         standard. It is sometime referred to as by some combination of the standard, the color and the
         fact that is a single phase connector. The connector usually has the "P+N+E, 6h" configuration.
         * ``IEC60309DCWhite`` - Industrial White connector is a DC connector defined in the IEC 60309
         standard.
         * ``Tesla`` - The Tesla connector is the regionally specific Tesla Supercharger connector.
         I.e. it refers to either Tesla's proprietary connector, sometimes referred to as Tesla Port
         mostly limited to North America or the modified Type 2 (DC over Type 2) in Europe.

         Usage examples:

          connectorSet=IEC62196Type2CableAttached
          connectorSet=IEC62196Type2Outlet,IEC62196Type2CableAttached.
        :type electric_vehicle_connector_filter: list[str or ~azure.maps.search.models.ElectricVehicleConnector]
        :param localized_map_view: The View parameter (also called the "user region" parameter) allows
         you to show the correct maps for a certain country/region for geopolitically disputed regions.
         Different countries have different views of such regions, and the View parameter allows your
         application to comply with the view required by the country your application will be serving.
         By default, the View parameter is set to “Unified” even if you haven’t defined it in  the
         request. It is your responsibility to determine the location of your users, and then set the
         View parameter correctly for that location. Alternatively, you have the option to set
         ‘View=Auto’, which will return the map data based on the IP  address of the request. The View
         parameter in Azure Maps must be used in compliance with applicable laws, including those
         regarding mapping, of the country where maps, images and other data and third party content
         that you are authorized to  access via Azure Maps is made available. Example: view=IN.

         Please refer to `Supported Views <https://aka.ms/AzureMapsLocalizationViews>`_ for details and
         to see the available Views.
        :type localized_map_view: str or ~azure.maps.search.models.LocalizedMapView
        :param operating_hours: Hours of operation for a POI (Points of Interest). The availability of
         hours of operation will vary based on the data available. If not passed, then no opening hours
         information will be returned.
         Supported value: nextSevenDays.
        :type operating_hours: str or ~azure.maps.search.models.OperatingHoursRange
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SearchAddressResult, or the result of cls(response)
        :rtype: ~azure.maps.search.models.SearchAddressResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.SearchAddressResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/json"

        # Construct URL
        url = self.search_point_of_interest.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['query'] = self._serialize.query("query", query, 'str')
        if is_type_ahead is not None:
            query_parameters['typeahead'] = self._serialize.query("is_type_ahead", is_type_ahead, 'bool')
        if top is not None:
            query_parameters['limit'] = self._serialize.query("top", top, 'int', maximum=100, minimum=1)
        if skip is not None:
            query_parameters['ofs'] = self._serialize.query("skip", skip, 'int', maximum=1900, minimum=0)
        if category_filter is not None:
            query_parameters['categorySet'] = self._serialize.query("category_filter", category_filter, '[int]', div=',')
        if country_filter is not None:
            query_parameters['countrySet'] = self._serialize.query("country_filter", country_filter, '[str]', div=',')
        if lat is not None:
            query_parameters['lat'] = self._serialize.query("lat", lat, 'float')
        if lon is not None:
            query_parameters['lon'] = self._serialize.query("lon", lon, 'float')
        if radius_in_meters is not None:
            query_parameters['radius'] = self._serialize.query("radius_in_meters", radius_in_meters, 'int')
        if top_left is not None:
            query_parameters['topLeft'] = self._serialize.query("top_left", top_left, 'str')
        if btm_right is not None:
            query_parameters['btmRight'] = self._serialize.query("btm_right", btm_right, 'str')
        if language is not None:
            query_parameters['language'] = self._serialize.query("language", language, 'str')
        if extended_postal_codes_for is not None:
            query_parameters['extendedPostalCodesFor'] = self._serialize.query("extended_postal_codes_for", extended_postal_codes_for, '[str]', div=',')
        if brand_filter is not None:
            query_parameters['brandSet'] = self._serialize.query("brand_filter", brand_filter, '[str]', div=',')
        if electric_vehicle_connector_filter is not None:
            query_parameters['connectorSet'] = self._serialize.query("electric_vehicle_connector_filter", electric_vehicle_connector_filter, '[str]', div=',')
        if localized_map_view is not None:
            query_parameters['view'] = self._serialize.query("localized_map_view", localized_map_view, 'str')
        if operating_hours is not None:
            query_parameters['openingHours'] = self._serialize.query("operating_hours", operating_hours, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('SearchAddressResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    search_point_of_interest.metadata = {'url': '/search/poi/{format}'}  # type: ignore

    async def search_nearby_point_of_interest(
        self,
        lat: float,
        lon: float,
        format: Union[str, "models.ResponseFormat"] = "json",
        top: Optional[int] = None,
        skip: Optional[int] = None,
        category_filter: Optional[List[int]] = None,
        country_filter: Optional[List[str]] = None,
        radius_in_meters: Optional[int] = None,
        language: Optional[str] = None,
        extended_postal_codes_for: Optional[List[Union[str, "models.SearchIndexes"]]] = None,
        brand_filter: Optional[List[str]] = None,
        electric_vehicle_connector_filter: Optional[List[Union[str, "models.ElectricVehicleConnector"]]] = None,
        localized_map_view: Optional[Union[str, "models.LocalizedMapView"]] = None,
        **kwargs
    ) -> "models.SearchAddressResult":
        """**Nearby Search**

        **Applies to**\ : S0 and S1 pricing tiers.

        If you have a use case for only retrieving POI results around a specific location, the nearby
        search method may be the right choice. This endpoint will only return POI results, and does not
        take in a search query parameter.

        :param lat: Latitude where results should be biased. E.g. 37.337.
        :type lat: float
        :param lon: Longitude where results should be biased. E.g. -121.89.
        :type lon: float
        :param format: Desired format of the response. Value can be either *json* or *xml*.
        :type format: str or ~azure.maps.search.models.ResponseFormat
        :param top: Maximum number of responses that will be returned. Default: 10, minimum: 1 and
         maximum: 100.
        :type top: int
        :param skip: Starting offset of the returned results within the full result set. Default: 0,
         minimum: 0 and maximum: 1900.
        :type skip: int
        :param category_filter: A comma-separated list of category set IDs which could be used to
         restrict the result to specific Points of Interest categories. ID order does not matter. When
         multiple category identifiers are provided, only POIs that belong to (at least) one of the
         categories from the provided list will be returned. The list of supported categories can be
         discovered using  `POI Categories API <https://aka.ms/AzureMapsPOICategoryTree>`_. Usage
         examples:


         *
           **categorySet=7315**\  (Search Points of Interest from category Restaurant)

         *
           **categorySet=7315025,7315017**\  (Search Points of Interest of category either Italian or
         French Restaurant).
        :type category_filter: list[int]
        :param country_filter: Comma separated string of country codes, e.g. FR,ES. This will limit the
         search to the specified countries.
        :type country_filter: list[str]
        :param radius_in_meters: The radius in meters to for the results to be constrained to the
         defined area, Min value is 1, Max Value is 50000.
        :type radius_in_meters: int
        :param language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages <https://docs.microsoft.com/azure/azure-maps/supported-
         languages>`_ for details.
        :type language: str
        :param extended_postal_codes_for: Indexes for which extended postal codes should be included in
         the results.

         Available indexes are:

          **Addr** = Address ranges

          **Geo** = Geographies

          **PAD** = Point Addresses

          **POI** = Points of Interest

          **Str** = Streets

          **XStr** = Cross Streets (intersections)

         Value should be a comma separated list of index types (in any order) or **None** for no
         indexes.

         By default extended postal codes are included for all indexes except Geo. Extended postal code
         lists for geographies can be quite long so they have to be explicitly requested when needed.

         Usage examples:

          extendedPostalCodesFor=POI

          extendedPostalCodesFor=PAD,Addr,POI

          extendedPostalCodesFor=None

         Extended postal code is returned as an **extendedPostalCode** property of an address.
         Availability is region-dependent.
        :type extended_postal_codes_for: list[str or ~azure.maps.search.models.SearchIndexes]
        :param brand_filter: A comma-separated list of brand names which could be used to restrict the
         result to specific brands. Item order does not matter. When multiple brands are provided, only
         results that belong to (at least) one of the provided list will be returned. Brands that
         contain a "," in their name should be put into quotes.

         Usage examples:

          brandSet=Foo

          brandSet=Foo,Bar

          brandSet="A,B,C Comma",Bar.
        :type brand_filter: list[str]
        :param electric_vehicle_connector_filter: A comma-separated list of connector types which could
         be used to restrict the result to Electric Vehicle Station supporting specific connector types.
         Item order does not matter. When multiple connector types are provided, only results that
         belong to (at least) one of the provided list will be returned.

         Available connector types are:


         * ``StandardHouseholdCountrySpecific`` - These are the standard household connectors for a
         certain region. They are all AC single phase and the standard Voltage and standard Amperage.
         See also: `Plug & socket types - World Standards
         <https://www.worldstandards.eu/electricity/plugs-and-sockets>`_.
         * ``IEC62196Type1`` - Type 1 connector as defined in the IEC 62196-2 standard. Also called
         Yazaki after the original manufacturer or SAE J1772 after the standard that first published it.
         Mostly used in combination with 120V single phase or up to 240V single phase infrastructure.
         * ``IEC62196Type1CCS`` - Type 1 based combo connector as defined in the IEC 62196-3 standard.
         The connector is based on the Type 1 connector – as defined in the IEC 62196-2 standard – with
         two additional direct current (DC) contacts to allow DC fast charging.
         * ``IEC62196Type2CableAttached`` - Type 2 connector as defined in the IEC 62196-2 standard.
         Provided as a cable and plug attached to the charging point.
         * ``IEC62196Type2Outlet`` - Type 2 connector as defined in the IEC 62196-2 standard. Provided
         as a socket set into the charging point.
         * ``IEC62196Type2CCS`` - Type 2 based combo connector as defined in the IEC 62196-3 standard.
         The connector is based on the Type 2 connector – as defined in the IEC 62196-2 standard – with
         two additional direct current (DC) contacts to allow DC fast charging.
         * ``IEC62196Type3`` - Type 3 connector as defined in the IEC 62196-2 standard. Also called
         Scame after the original manufacturer. Mostly used in combination with up to 240V single phase
         or up to 420V three phase infrastructure.
         * ``Chademo`` - CHAdeMO connector named after an association formed by the Tokyo Electric
         Power Company and industrial partners. Because of this is is also known as the TEPCO's
         connector. It supports fast DC charging.
         * ``IEC60309AC1PhaseBlue`` - Industrial Blue connector is a connector defined in the IEC 60309
         standard. It is sometime referred to as by some combination of the standard, the color and the
         fact that is a single phase connector. The connector usually has the "P+N+E, 6h" configuration.
         * ``IEC60309DCWhite`` - Industrial White connector is a DC connector defined in the IEC 60309
         standard.
         * ``Tesla`` - The Tesla connector is the regionally specific Tesla Supercharger connector.
         I.e. it refers to either Tesla's proprietary connector, sometimes referred to as Tesla Port
         mostly limited to North America or the modified Type 2 (DC over Type 2) in Europe.

         Usage examples:

          connectorSet=IEC62196Type2CableAttached
          connectorSet=IEC62196Type2Outlet,IEC62196Type2CableAttached.
        :type electric_vehicle_connector_filter: list[str or ~azure.maps.search.models.ElectricVehicleConnector]
        :param localized_map_view: The View parameter (also called the "user region" parameter) allows
         you to show the correct maps for a certain country/region for geopolitically disputed regions.
         Different countries have different views of such regions, and the View parameter allows your
         application to comply with the view required by the country your application will be serving.
         By default, the View parameter is set to “Unified” even if you haven’t defined it in  the
         request. It is your responsibility to determine the location of your users, and then set the
         View parameter correctly for that location. Alternatively, you have the option to set
         ‘View=Auto’, which will return the map data based on the IP  address of the request. The View
         parameter in Azure Maps must be used in compliance with applicable laws, including those
         regarding mapping, of the country where maps, images and other data and third party content
         that you are authorized to  access via Azure Maps is made available. Example: view=IN.

         Please refer to `Supported Views <https://aka.ms/AzureMapsLocalizationViews>`_ for details and
         to see the available Views.
        :type localized_map_view: str or ~azure.maps.search.models.LocalizedMapView
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SearchAddressResult, or the result of cls(response)
        :rtype: ~azure.maps.search.models.SearchAddressResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.SearchAddressResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/json"

        # Construct URL
        url = self.search_nearby_point_of_interest.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['lat'] = self._serialize.query("lat", lat, 'float')
        query_parameters['lon'] = self._serialize.query("lon", lon, 'float')
        if top is not None:
            query_parameters['limit'] = self._serialize.query("top", top, 'int', maximum=100, minimum=1)
        if skip is not None:
            query_parameters['ofs'] = self._serialize.query("skip", skip, 'int', maximum=1900, minimum=0)
        if category_filter is not None:
            query_parameters['categorySet'] = self._serialize.query("category_filter", category_filter, '[int]', div=',')
        if country_filter is not None:
            query_parameters['countrySet'] = self._serialize.query("country_filter", country_filter, '[str]', div=',')
        if radius_in_meters is not None:
            query_parameters['radius'] = self._serialize.query("radius_in_meters", radius_in_meters, 'int')
        if language is not None:
            query_parameters['language'] = self._serialize.query("language", language, 'str')
        if extended_postal_codes_for is not None:
            query_parameters['extendedPostalCodesFor'] = self._serialize.query("extended_postal_codes_for", extended_postal_codes_for, '[str]', div=',')
        if brand_filter is not None:
            query_parameters['brandSet'] = self._serialize.query("brand_filter", brand_filter, '[str]', div=',')
        if electric_vehicle_connector_filter is not None:
            query_parameters['connectorSet'] = self._serialize.query("electric_vehicle_connector_filter", electric_vehicle_connector_filter, '[str]', div=',')
        if localized_map_view is not None:
            query_parameters['view'] = self._serialize.query("localized_map_view", localized_map_view, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('SearchAddressResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    search_nearby_point_of_interest.metadata = {'url': '/search/nearby/{format}'}  # type: ignore

    async def search_point_of_interest_category(
        self,
        query: str,
        format: Union[str, "models.ResponseFormat"] = "json",
        is_type_ahead: Optional[bool] = None,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        category_filter: Optional[List[int]] = None,
        country_filter: Optional[List[str]] = None,
        lat: Optional[float] = None,
        lon: Optional[float] = None,
        radius_in_meters: Optional[int] = None,
        top_left: Optional[str] = None,
        btm_right: Optional[str] = None,
        language: Optional[str] = None,
        extended_postal_codes_for: Optional[List[Union[str, "models.SearchIndexes"]]] = None,
        brand_filter: Optional[List[str]] = None,
        electric_vehicle_connector_filter: Optional[List[Union[str, "models.ElectricVehicleConnector"]]] = None,
        localized_map_view: Optional[Union[str, "models.LocalizedMapView"]] = None,
        operating_hours: Optional[Union[str, "models.OperatingHoursRange"]] = None,
        **kwargs
    ) -> "models.SearchAddressResult":
        """**Get POI by Category**

        **Applies to**\ : S0 and S1 pricing tiers.

        Points of Interest (POI) Category Search allows you to request POI results from given category.
        Search allows to query POIs from one category at a time.  Endpoint will only return POI results
        which are categorized as specified.  Response includes POI details such as address, coordinate
        location and classification.

        :param query: The POI category to search for (e.g., "AIRPORT", "RESTAURANT"), must be properly
         URL encoded. Supported main categories can be requested by calling `Get Search POI Category
         Tree API <https://aka.ms/AzureMapsPOICategoryTree>`_. List of available categories can also be
         found `here <https://docs.microsoft.com/azure/azure-maps/supported-search-categories>`_. We
         recommend to use POI Search Category Tree API to request the supported categories.
        :type query: str
        :param format: Desired format of the response. Value can be either *json* or *xml*.
        :type format: str or ~azure.maps.search.models.ResponseFormat
        :param is_type_ahead: Boolean. If the typeahead flag is set, the query will be interpreted as a
         partial input and the search will enter predictive mode.
        :type is_type_ahead: bool
        :param top: Maximum number of responses that will be returned. Default: 10, minimum: 1 and
         maximum: 100.
        :type top: int
        :param skip: Starting offset of the returned results within the full result set. Default: 0,
         minimum: 0 and maximum: 1900.
        :type skip: int
        :param category_filter: A comma-separated list of category set IDs which could be used to
         restrict the result to specific Points of Interest categories. ID order does not matter. When
         multiple category identifiers are provided, only POIs that belong to (at least) one of the
         categories from the provided list will be returned. The list of supported categories can be
         discovered using  `POI Categories API <https://aka.ms/AzureMapsPOICategoryTree>`_. Usage
         examples:


         *
           **categorySet=7315**\  (Search Points of Interest from category Restaurant)

         *
           **categorySet=7315025,7315017**\  (Search Points of Interest of category either Italian or
         French Restaurant).
        :type category_filter: list[int]
        :param country_filter: Comma separated string of country codes, e.g. FR,ES. This will limit the
         search to the specified countries.
        :type country_filter: list[str]
        :param lat: Latitude where results should be biased. E.g. 37.337.
        :type lat: float
        :param lon: Longitude where results should be biased. E.g. -121.89.
        :type lon: float
        :param radius_in_meters: The radius in meters to for the results to be constrained to the
         defined area.
        :type radius_in_meters: int
        :param top_left: Top left position of the bounding box. E.g. 37.553,-122.453.
        :type top_left: str
        :param btm_right: Bottom right position of the bounding box. E.g. 37.553,-122.453.
        :type btm_right: str
        :param language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages <https://docs.microsoft.com/azure/azure-maps/supported-
         languages>`_ for details.
        :type language: str
        :param extended_postal_codes_for: Indexes for which extended postal codes should be included in
         the results.

         Available indexes are:

          **Addr** = Address ranges

          **Geo** = Geographies

          **PAD** = Point Addresses

          **POI** = Points of Interest

          **Str** = Streets

          **XStr** = Cross Streets (intersections)

         Value should be a comma separated list of index types (in any order) or **None** for no
         indexes.

         By default extended postal codes are included for all indexes except Geo. Extended postal code
         lists for geographies can be quite long so they have to be explicitly requested when needed.

         Usage examples:

          extendedPostalCodesFor=POI

          extendedPostalCodesFor=PAD,Addr,POI

          extendedPostalCodesFor=None

         Extended postal code is returned as an **extendedPostalCode** property of an address.
         Availability is region-dependent.
        :type extended_postal_codes_for: list[str or ~azure.maps.search.models.SearchIndexes]
        :param brand_filter: A comma-separated list of brand names which could be used to restrict the
         result to specific brands. Item order does not matter. When multiple brands are provided, only
         results that belong to (at least) one of the provided list will be returned. Brands that
         contain a "," in their name should be put into quotes.

         Usage examples:

          brandSet=Foo

          brandSet=Foo,Bar

          brandSet="A,B,C Comma",Bar.
        :type brand_filter: list[str]
        :param electric_vehicle_connector_filter: A comma-separated list of connector types which could
         be used to restrict the result to Electric Vehicle Station supporting specific connector types.
         Item order does not matter. When multiple connector types are provided, only results that
         belong to (at least) one of the provided list will be returned.

         Available connector types are:


         * ``StandardHouseholdCountrySpecific`` - These are the standard household connectors for a
         certain region. They are all AC single phase and the standard Voltage and standard Amperage.
         See also: `Plug & socket types - World Standards
         <https://www.worldstandards.eu/electricity/plugs-and-sockets>`_.
         * ``IEC62196Type1`` - Type 1 connector as defined in the IEC 62196-2 standard. Also called
         Yazaki after the original manufacturer or SAE J1772 after the standard that first published it.
         Mostly used in combination with 120V single phase or up to 240V single phase infrastructure.
         * ``IEC62196Type1CCS`` - Type 1 based combo connector as defined in the IEC 62196-3 standard.
         The connector is based on the Type 1 connector – as defined in the IEC 62196-2 standard – with
         two additional direct current (DC) contacts to allow DC fast charging.
         * ``IEC62196Type2CableAttached`` - Type 2 connector as defined in the IEC 62196-2 standard.
         Provided as a cable and plug attached to the charging point.
         * ``IEC62196Type2Outlet`` - Type 2 connector as defined in the IEC 62196-2 standard. Provided
         as a socket set into the charging point.
         * ``IEC62196Type2CCS`` - Type 2 based combo connector as defined in the IEC 62196-3 standard.
         The connector is based on the Type 2 connector – as defined in the IEC 62196-2 standard – with
         two additional direct current (DC) contacts to allow DC fast charging.
         * ``IEC62196Type3`` - Type 3 connector as defined in the IEC 62196-2 standard. Also called
         Scame after the original manufacturer. Mostly used in combination with up to 240V single phase
         or up to 420V three phase infrastructure.
         * ``Chademo`` - CHAdeMO connector named after an association formed by the Tokyo Electric
         Power Company and industrial partners. Because of this is is also known as the TEPCO's
         connector. It supports fast DC charging.
         * ``IEC60309AC1PhaseBlue`` - Industrial Blue connector is a connector defined in the IEC 60309
         standard. It is sometime referred to as by some combination of the standard, the color and the
         fact that is a single phase connector. The connector usually has the "P+N+E, 6h" configuration.
         * ``IEC60309DCWhite`` - Industrial White connector is a DC connector defined in the IEC 60309
         standard.
         * ``Tesla`` - The Tesla connector is the regionally specific Tesla Supercharger connector.
         I.e. it refers to either Tesla's proprietary connector, sometimes referred to as Tesla Port
         mostly limited to North America or the modified Type 2 (DC over Type 2) in Europe.

         Usage examples:

          connectorSet=IEC62196Type2CableAttached
          connectorSet=IEC62196Type2Outlet,IEC62196Type2CableAttached.
        :type electric_vehicle_connector_filter: list[str or ~azure.maps.search.models.ElectricVehicleConnector]
        :param localized_map_view: The View parameter (also called the "user region" parameter) allows
         you to show the correct maps for a certain country/region for geopolitically disputed regions.
         Different countries have different views of such regions, and the View parameter allows your
         application to comply with the view required by the country your application will be serving.
         By default, the View parameter is set to “Unified” even if you haven’t defined it in  the
         request. It is your responsibility to determine the location of your users, and then set the
         View parameter correctly for that location. Alternatively, you have the option to set
         ‘View=Auto’, which will return the map data based on the IP  address of the request. The View
         parameter in Azure Maps must be used in compliance with applicable laws, including those
         regarding mapping, of the country where maps, images and other data and third party content
         that you are authorized to  access via Azure Maps is made available. Example: view=IN.

         Please refer to `Supported Views <https://aka.ms/AzureMapsLocalizationViews>`_ for details and
         to see the available Views.
        :type localized_map_view: str or ~azure.maps.search.models.LocalizedMapView
        :param operating_hours: Hours of operation for a POI (Points of Interest). The availability of
         hours of operation will vary based on the data available. If not passed, then no opening hours
         information will be returned.
         Supported value: nextSevenDays.
        :type operating_hours: str or ~azure.maps.search.models.OperatingHoursRange
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SearchAddressResult, or the result of cls(response)
        :rtype: ~azure.maps.search.models.SearchAddressResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.SearchAddressResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/json"

        # Construct URL
        url = self.search_point_of_interest_category.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['query'] = self._serialize.query("query", query, 'str')
        if is_type_ahead is not None:
            query_parameters['typeahead'] = self._serialize.query("is_type_ahead", is_type_ahead, 'bool')
        if top is not None:
            query_parameters['limit'] = self._serialize.query("top", top, 'int', maximum=100, minimum=1)
        if skip is not None:
            query_parameters['ofs'] = self._serialize.query("skip", skip, 'int', maximum=1900, minimum=0)
        if category_filter is not None:
            query_parameters['categorySet'] = self._serialize.query("category_filter", category_filter, '[int]', div=',')
        if country_filter is not None:
            query_parameters['countrySet'] = self._serialize.query("country_filter", country_filter, '[str]', div=',')
        if lat is not None:
            query_parameters['lat'] = self._serialize.query("lat", lat, 'float')
        if lon is not None:
            query_parameters['lon'] = self._serialize.query("lon", lon, 'float')
        if radius_in_meters is not None:
            query_parameters['radius'] = self._serialize.query("radius_in_meters", radius_in_meters, 'int')
        if top_left is not None:
            query_parameters['topLeft'] = self._serialize.query("top_left", top_left, 'str')
        if btm_right is not None:
            query_parameters['btmRight'] = self._serialize.query("btm_right", btm_right, 'str')
        if language is not None:
            query_parameters['language'] = self._serialize.query("language", language, 'str')
        if extended_postal_codes_for is not None:
            query_parameters['extendedPostalCodesFor'] = self._serialize.query("extended_postal_codes_for", extended_postal_codes_for, '[str]', div=',')
        if brand_filter is not None:
            query_parameters['brandSet'] = self._serialize.query("brand_filter", brand_filter, '[str]', div=',')
        if electric_vehicle_connector_filter is not None:
            query_parameters['connectorSet'] = self._serialize.query("electric_vehicle_connector_filter", electric_vehicle_connector_filter, '[str]', div=',')
        if localized_map_view is not None:
            query_parameters['view'] = self._serialize.query("localized_map_view", localized_map_view, 'str')
        if operating_hours is not None:
            query_parameters['openingHours'] = self._serialize.query("operating_hours", operating_hours, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('SearchAddressResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    search_point_of_interest_category.metadata = {'url': '/search/poi/category/{format}'}  # type: ignore

    async def get_point_of_interest_category_tree(
        self,
        format: Union[str, "models.JsonFormat"] = "json",
        language: Optional[str] = None,
        **kwargs
    ) -> "models.PointOfInterestCategoryTreeResult":
        """**Get POI Category Tree**

        **Applies to**\ : S0 and S1 pricing tiers.

        POI Category API provides a full list of supported Points of Interest (POI) categories and
        subcategories together with their translations and synonyms. The returned content can be used
        to provide more meaningful results through other Search Service APIs, like `Get Search POI
        <https://docs.microsoft.com/rest/api/maps/search/getsearchpoi>`_.

        :param format: Desired format of the response. Only ``json`` format is supported.
        :type format: str or ~azure.maps.search.models.JsonFormat
        :param language: Language in which search results should be returned. Should be one of
         supported IETF language tags, except NGT and NGT-Latn. Language tag is case insensitive. When
         data in specified language is not available for a specific field, default language is used
         (English).

         Please refer to `Supported Languages <https://docs.microsoft.com/azure/azure-maps/supported-
         languages>`_ for details.
        :type language: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PointOfInterestCategoryTreeResult, or the result of cls(response)
        :rtype: ~azure.maps.search.models.PointOfInterestCategoryTreeResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.PointOfInterestCategoryTreeResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/json"

        # Construct URL
        url = self.get_point_of_interest_category_tree.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if language is not None:
            query_parameters['language'] = self._serialize.query("language", language, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('PointOfInterestCategoryTreeResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_point_of_interest_category_tree.metadata = {'url': '/search/poi/category/tree/{format}'}  # type: ignore

    async def search_address(
        self,
        query: str,
        format: Union[str, "models.ResponseFormat"] = "json",
        is_type_ahead: Optional[bool] = None,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        country_filter: Optional[List[str]] = None,
        lat: Optional[float] = None,
        lon: Optional[float] = None,
        radius_in_meters: Optional[int] = None,
        top_left: Optional[str] = None,
        btm_right: Optional[str] = None,
        language: Optional[str] = None,
        extended_postal_codes_for: Optional[List[Union[str, "models.SearchIndexes"]]] = None,
        entity_type: Optional[Union[str, "models.GeographicEntityType"]] = None,
        localized_map_view: Optional[Union[str, "models.LocalizedMapView"]] = None,
        **kwargs
    ) -> "models.SearchAddressResult":
        """**Address Geocoding**

        **Applies to**\ : S0 and S1 pricing tiers.

        In many cases, the complete search service might be too much, for instance if you are only
        interested in traditional geocoding. Search can also be accessed for address look up
        exclusively. The geocoding is performed by hitting the geocode endpoint with just the address
        or partial address in question. The geocoding search index will be queried for everything above
        the street level data. No POIs will be returned. Note that the geocoder is very tolerant of
        typos and incomplete addresses. It will also handle everything from exact street addresses or
        street or intersections as well as higher level geographies such as city centers, counties,
        states etc.

        :param query: The address to search for (e.g., "1 Microsoft way, Redmond, WA"), must be
         properly URL encoded.
        :type query: str
        :param format: Desired format of the response. Value can be either *json* or *xml*.
        :type format: str or ~azure.maps.search.models.ResponseFormat
        :param is_type_ahead: Boolean. If the typeahead flag is set, the query will be interpreted as a
         partial input and the search will enter predictive mode.
        :type is_type_ahead: bool
        :param top: Maximum number of responses that will be returned. Default: 10, minimum: 1 and
         maximum: 100.
        :type top: int
        :param skip: Starting offset of the returned results within the full result set. Default: 0,
         minimum: 0 and maximum: 1900.
        :type skip: int
        :param country_filter: Comma separated string of country codes, e.g. FR,ES. This will limit the
         search to the specified countries.
        :type country_filter: list[str]
        :param lat: Latitude where results should be biased. E.g. 37.337.
        :type lat: float
        :param lon: Longitude where results should be biased. E.g. -121.89.
        :type lon: float
        :param radius_in_meters: The radius in meters to for the results to be constrained to the
         defined area.
        :type radius_in_meters: int
        :param top_left: Top left position of the bounding box. E.g. 37.553,-122.453.
        :type top_left: str
        :param btm_right: Bottom right position of the bounding box. E.g. 37.553,-122.453.
        :type btm_right: str
        :param language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages <https://docs.microsoft.com/azure/azure-maps/supported-
         languages>`_ for details.
        :type language: str
        :param extended_postal_codes_for: Indexes for which extended postal codes should be included in
         the results.

         Available indexes are:

          **Addr** = Address ranges

          **Geo** = Geographies

          **PAD** = Point Addresses

          **POI** = Points of Interest

          **Str** = Streets

          **XStr** = Cross Streets (intersections)

         Value should be a comma separated list of index types (in any order) or **None** for no
         indexes.

         By default extended postal codes are included for all indexes except Geo. Extended postal code
         lists for geographies can be quite long so they have to be explicitly requested when needed.

         Usage examples:

          extendedPostalCodesFor=POI

          extendedPostalCodesFor=PAD,Addr,POI

          extendedPostalCodesFor=None

         Extended postal code is returned as an **extendedPostalCode** property of an address.
         Availability is region-dependent.
        :type extended_postal_codes_for: list[str or ~azure.maps.search.models.SearchIndexes]
        :param entity_type: Specifies the level of filtering performed on geographies. Narrows the
         search for specified geography entity types, e.g. return only municipality. The resulting
         response will contain the geography ID as well as the entity type matched. If you provide more
         than one entity as a comma separated list, endpoint will return the 'smallest entity
         available'. Returned Geometry ID can be used to get the geometry of that geography via `Get
         Search Polygon <https://docs.microsoft.com/rest/api/maps/search/getsearchpolygon>`_ API. The
         following parameters are ignored when entityType is set:


         * heading
         * number
         * returnRoadUse
         * returnSpeedLimit
         * roadUse
         * returnMatchType.
        :type entity_type: str or ~azure.maps.search.models.GeographicEntityType
        :param localized_map_view: The View parameter (also called the "user region" parameter) allows
         you to show the correct maps for a certain country/region for geopolitically disputed regions.
         Different countries have different views of such regions, and the View parameter allows your
         application to comply with the view required by the country your application will be serving.
         By default, the View parameter is set to “Unified” even if you haven’t defined it in  the
         request. It is your responsibility to determine the location of your users, and then set the
         View parameter correctly for that location. Alternatively, you have the option to set
         ‘View=Auto’, which will return the map data based on the IP  address of the request. The View
         parameter in Azure Maps must be used in compliance with applicable laws, including those
         regarding mapping, of the country where maps, images and other data and third party content
         that you are authorized to  access via Azure Maps is made available. Example: view=IN.

         Please refer to `Supported Views <https://aka.ms/AzureMapsLocalizationViews>`_ for details and
         to see the available Views.
        :type localized_map_view: str or ~azure.maps.search.models.LocalizedMapView
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SearchAddressResult, or the result of cls(response)
        :rtype: ~azure.maps.search.models.SearchAddressResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.SearchAddressResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/json"

        # Construct URL
        url = self.search_address.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['query'] = self._serialize.query("query", query, 'str')
        if is_type_ahead is not None:
            query_parameters['typeahead'] = self._serialize.query("is_type_ahead", is_type_ahead, 'bool')
        if top is not None:
            query_parameters['limit'] = self._serialize.query("top", top, 'int', maximum=100, minimum=1)
        if skip is not None:
            query_parameters['ofs'] = self._serialize.query("skip", skip, 'int', maximum=1900, minimum=0)
        if country_filter is not None:
            query_parameters['countrySet'] = self._serialize.query("country_filter", country_filter, '[str]', div=',')
        if lat is not None:
            query_parameters['lat'] = self._serialize.query("lat", lat, 'float')
        if lon is not None:
            query_parameters['lon'] = self._serialize.query("lon", lon, 'float')
        if radius_in_meters is not None:
            query_parameters['radius'] = self._serialize.query("radius_in_meters", radius_in_meters, 'int')
        if top_left is not None:
            query_parameters['topLeft'] = self._serialize.query("top_left", top_left, 'str')
        if btm_right is not None:
            query_parameters['btmRight'] = self._serialize.query("btm_right", btm_right, 'str')
        if language is not None:
            query_parameters['language'] = self._serialize.query("language", language, 'str')
        if extended_postal_codes_for is not None:
            query_parameters['extendedPostalCodesFor'] = self._serialize.query("extended_postal_codes_for", extended_postal_codes_for, '[str]', div=',')
        if entity_type is not None:
            query_parameters['entityType'] = self._serialize.query("entity_type", entity_type, 'str')
        if localized_map_view is not None:
            query_parameters['view'] = self._serialize.query("localized_map_view", localized_map_view, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('SearchAddressResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    search_address.metadata = {'url': '/search/address/{format}'}  # type: ignore

    async def reverse_search_address(
        self,
        query: List[float],
        format: Union[str, "models.ResponseFormat"] = "json",
        language: Optional[str] = None,
        include_speed_limit: Optional[bool] = None,
        heading: Optional[int] = None,
        radius_in_meters: Optional[int] = None,
        number: Optional[str] = None,
        include_road_use: Optional[bool] = None,
        road_use: Optional[List[Union[str, "models.RoadUseType"]]] = None,
        allow_freeform_newline: Optional[bool] = None,
        include_match_type: Optional[bool] = None,
        entity_type: Optional[Union[str, "models.GeographicEntityType"]] = None,
        localized_map_view: Optional[Union[str, "models.LocalizedMapView"]] = None,
        **kwargs
    ) -> "models.ReverseSearchAddressResult":
        """**Reverse Geocode to an Address**

        **Applies to**\ : S0 and S1 pricing tiers.

        There may be times when you need to translate a  coordinate (example: 37.786505, -122.3862)
        into a human understandable street address. Most often  this is needed in tracking applications
        where you  receive a GPS feed from the device or asset and  wish to know what address where the
        coordinate is  located. This endpoint will return address  information for a given coordinate.

        :param query: The applicable query specified as a comma separated string composed by latitude
         followed by longitude e.g. "47.641268,-122.125679".
        :type query: list[float]
        :param format: Desired format of the response. Value can be either *json* or *xml*.
        :type format: str or ~azure.maps.search.models.ResponseFormat
        :param language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages <https://docs.microsoft.com/azure/azure-maps/supported-
         languages>`_ for details.
        :type language: str
        :param include_speed_limit: Boolean. To enable return of the posted speed limit.
        :type include_speed_limit: bool
        :param heading: The directional heading of the vehicle in degrees, for travel along a segment
         of roadway. 0 is North, 90 is East and so on, values range from -360 to 360. The precision can
         include upto one decimal place.
        :type heading: int
        :param radius_in_meters: The radius in meters to for the results to be constrained to the
         defined area.
        :type radius_in_meters: int
        :param number: If a number is sent in along with the request, the response may include the side
         of the street (Left/Right) and also an offset position for that number.
        :type number: str
        :param include_road_use: Boolean. To enable return of the road use array for reverse geocodes
         at street level.
        :type include_road_use: bool
        :param road_use: To restrict reverse geocodes to a certain type of road use. The road use array
         for reverse geocodes can be one or more of LimitedAccess, Arterial, Terminal, Ramp, Rotary,
         LocalStreet.
        :type road_use: list[str or ~azure.maps.search.models.RoadUseType]
        :param allow_freeform_newline: Format of newlines in the formatted address.

         If true, the address will contain newlines.
         If false, newlines will be converted to commas.
        :type allow_freeform_newline: bool
        :param include_match_type: Include information on the type of match the geocoder achieved in
         the response.
        :type include_match_type: bool
        :param entity_type: Specifies the level of filtering performed on geographies. Narrows the
         search for specified geography entity types, e.g. return only municipality. The resulting
         response will contain the geography ID as well as the entity type matched. If you provide more
         than one entity as a comma separated list, endpoint will return the 'smallest entity
         available'. Returned Geometry ID can be used to get the geometry of that geography via `Get
         Search Polygon <https://docs.microsoft.com/rest/api/maps/search/getsearchpolygon>`_ API. The
         following parameters are ignored when entityType is set:


         * heading
         * number
         * returnRoadUse
         * returnSpeedLimit
         * roadUse
         * returnMatchType.
        :type entity_type: str or ~azure.maps.search.models.GeographicEntityType
        :param localized_map_view: The View parameter (also called the "user region" parameter) allows
         you to show the correct maps for a certain country/region for geopolitically disputed regions.
         Different countries have different views of such regions, and the View parameter allows your
         application to comply with the view required by the country your application will be serving.
         By default, the View parameter is set to “Unified” even if you haven’t defined it in  the
         request. It is your responsibility to determine the location of your users, and then set the
         View parameter correctly for that location. Alternatively, you have the option to set
         ‘View=Auto’, which will return the map data based on the IP  address of the request. The View
         parameter in Azure Maps must be used in compliance with applicable laws, including those
         regarding mapping, of the country where maps, images and other data and third party content
         that you are authorized to  access via Azure Maps is made available. Example: view=IN.

         Please refer to `Supported Views <https://aka.ms/AzureMapsLocalizationViews>`_ for details and
         to see the available Views.
        :type localized_map_view: str or ~azure.maps.search.models.LocalizedMapView
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ReverseSearchAddressResult, or the result of cls(response)
        :rtype: ~azure.maps.search.models.ReverseSearchAddressResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.ReverseSearchAddressResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/json"

        # Construct URL
        url = self.reverse_search_address.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['query'] = self._serialize.query("query", query, '[float]', div=',')
        if language is not None:
            query_parameters['language'] = self._serialize.query("language", language, 'str')
        if include_speed_limit is not None:
            query_parameters['returnSpeedLimit'] = self._serialize.query("include_speed_limit", include_speed_limit, 'bool')
        if heading is not None:
            query_parameters['heading'] = self._serialize.query("heading", heading, 'int', maximum=360, minimum=-360)
        if radius_in_meters is not None:
            query_parameters['radius'] = self._serialize.query("radius_in_meters", radius_in_meters, 'int')
        if number is not None:
            query_parameters['number'] = self._serialize.query("number", number, 'str')
        if include_road_use is not None:
            query_parameters['returnRoadUse'] = self._serialize.query("include_road_use", include_road_use, 'bool')
        if road_use is not None:
            query_parameters['roadUse'] = self._serialize.query("road_use", road_use, '[str]', div=',')
        if allow_freeform_newline is not None:
            query_parameters['allowFreeformNewline'] = self._serialize.query("allow_freeform_newline", allow_freeform_newline, 'bool')
        if include_match_type is not None:
            query_parameters['returnMatchType'] = self._serialize.query("include_match_type", include_match_type, 'bool')
        if entity_type is not None:
            query_parameters['entityType'] = self._serialize.query("entity_type", entity_type, 'str')
        if localized_map_view is not None:
            query_parameters['view'] = self._serialize.query("localized_map_view", localized_map_view, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('ReverseSearchAddressResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    reverse_search_address.metadata = {'url': '/search/address/reverse/{format}'}  # type: ignore

    async def reverse_search_cross_street_address(
        self,
        query: List[float],
        format: Union[str, "models.ResponseFormat"] = "json",
        top: Optional[int] = None,
        heading: Optional[int] = None,
        radius_in_meters: Optional[int] = None,
        language: Optional[str] = None,
        localized_map_view: Optional[Union[str, "models.LocalizedMapView"]] = None,
        **kwargs
    ) -> "models.ReverseSearchCrossStreetAddressResult":
        """**Reverse Geocode to a Cross Street**

        **Applies to**\ : S0 and S1 pricing tiers.

        There may be times when you need to translate a  coordinate (example: 37.786505, -122.3862)
        into a human understandable cross street. Most often this  is needed in tracking applications
        where you  receive a GPS feed from the device or asset and wish to know what address where the
        coordinate is  located.
        This endpoint will return cross street information  for a given coordinate.

        :param query: The applicable query specified as a comma separated string composed by latitude
         followed by longitude e.g. "47.641268,-122.125679".
        :type query: list[float]
        :param format: Desired format of the response. Value can be either *json* or *xml*.
        :type format: str or ~azure.maps.search.models.ResponseFormat
        :param top: Maximum number of responses that will be returned. Default: 10, minimum: 1 and
         maximum: 100.
        :type top: int
        :param heading: The directional heading of the vehicle in degrees, for travel along a segment
         of roadway. 0 is North, 90 is East and so on, values range from -360 to 360. The precision can
         include upto one decimal place.
        :type heading: int
        :param radius_in_meters: The radius in meters to for the results to be constrained to the
         defined area.
        :type radius_in_meters: int
        :param language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages <https://docs.microsoft.com/azure/azure-maps/supported-
         languages>`_ for details.
        :type language: str
        :param localized_map_view: The View parameter (also called the "user region" parameter) allows
         you to show the correct maps for a certain country/region for geopolitically disputed regions.
         Different countries have different views of such regions, and the View parameter allows your
         application to comply with the view required by the country your application will be serving.
         By default, the View parameter is set to “Unified” even if you haven’t defined it in  the
         request. It is your responsibility to determine the location of your users, and then set the
         View parameter correctly for that location. Alternatively, you have the option to set
         ‘View=Auto’, which will return the map data based on the IP  address of the request. The View
         parameter in Azure Maps must be used in compliance with applicable laws, including those
         regarding mapping, of the country where maps, images and other data and third party content
         that you are authorized to  access via Azure Maps is made available. Example: view=IN.

         Please refer to `Supported Views <https://aka.ms/AzureMapsLocalizationViews>`_ for details and
         to see the available Views.
        :type localized_map_view: str or ~azure.maps.search.models.LocalizedMapView
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ReverseSearchCrossStreetAddressResult, or the result of cls(response)
        :rtype: ~azure.maps.search.models.ReverseSearchCrossStreetAddressResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.ReverseSearchCrossStreetAddressResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/json"

        # Construct URL
        url = self.reverse_search_cross_street_address.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['query'] = self._serialize.query("query", query, '[float]', div=',')
        if top is not None:
            query_parameters['limit'] = self._serialize.query("top", top, 'int', maximum=100, minimum=1)
        if heading is not None:
            query_parameters['heading'] = self._serialize.query("heading", heading, 'int', maximum=360, minimum=-360)
        if radius_in_meters is not None:
            query_parameters['radius'] = self._serialize.query("radius_in_meters", radius_in_meters, 'int')
        if language is not None:
            query_parameters['language'] = self._serialize.query("language", language, 'str')
        if localized_map_view is not None:
            query_parameters['view'] = self._serialize.query("localized_map_view", localized_map_view, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('ReverseSearchCrossStreetAddressResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    reverse_search_cross_street_address.metadata = {'url': '/search/address/reverse/crossStreet/{format}'}  # type: ignore

    async def search_structured_address(
        self,
        format: Union[str, "models.ResponseFormat"] = "json",
        language: Optional[str] = None,
        country_code: str = "US",
        top: Optional[int] = None,
        skip: Optional[int] = None,
        street_number: Optional[str] = None,
        street_name: Optional[str] = None,
        cross_street: Optional[str] = None,
        municipality: Optional[str] = None,
        municipality_subdivision: Optional[str] = None,
        country_tertiary_subdivision: Optional[str] = None,
        country_secondary_subdivision: Optional[str] = None,
        country_subdivision: Optional[str] = None,
        postal_code: Optional[str] = None,
        extended_postal_codes_for: Optional[List[Union[str, "models.SearchIndexes"]]] = None,
        entity_type: Optional[Union[str, "models.GeographicEntityType"]] = None,
        localized_map_view: Optional[Union[str, "models.LocalizedMapView"]] = None,
        **kwargs
    ) -> "models.SearchAddressResult":
        """**Structured Address Geocoding**

        **Applies to**\ : S0 and S1 pricing tiers.

        Azure Address Geocoding can also be accessed for  structured address look up exclusively. The
        geocoding search index will be queried for everything above the  street level data. No POIs
        will be returned. Note that the geocoder is very tolerant of typos and incomplete  addresses.
        It will also handle everything from exact  street addresses or street or intersections as well
        as higher level geographies such as city centers,  counties, states etc.

        :param format: Desired format of the response. Value can be either *json* or *xml*.
        :type format: str or ~azure.maps.search.models.ResponseFormat
        :param language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages <https://docs.microsoft.com/azure/azure-maps/supported-
         languages>`_ for details.
        :type language: str
        :param country_code: The 2 or 3 letter `ISO3166-1 <https://www.iso.org/iso-3166-country-
         codes.html>`_ country code portion of an address. E.g. US.
        :type country_code: str
        :param top: Maximum number of responses that will be returned. Default: 10, minimum: 1 and
         maximum: 100.
        :type top: int
        :param skip: Starting offset of the returned results within the full result set. Default: 0,
         minimum: 0 and maximum: 1900.
        :type skip: int
        :param street_number: The street number portion of an address.
        :type street_number: str
        :param street_name: The street name portion of an address.
        :type street_name: str
        :param cross_street: The cross street name for the structured address.
        :type cross_street: str
        :param municipality: The municipality portion of an address.
        :type municipality: str
        :param municipality_subdivision: The municipality subdivision (sub/super city) for the
         structured address.
        :type municipality_subdivision: str
        :param country_tertiary_subdivision: The named area for the structured address.
        :type country_tertiary_subdivision: str
        :param country_secondary_subdivision: The county for the structured address.
        :type country_secondary_subdivision: str
        :param country_subdivision: The country subdivision portion of an address.
        :type country_subdivision: str
        :param postal_code: The postal code portion of an address.
        :type postal_code: str
        :param extended_postal_codes_for: Indexes for which extended postal codes should be included in
         the results.

         Available indexes are:

          **Addr** = Address ranges

          **Geo** = Geographies

          **PAD** = Point Addresses

          **POI** = Points of Interest

          **Str** = Streets

          **XStr** = Cross Streets (intersections)

         Value should be a comma separated list of index types (in any order) or **None** for no
         indexes.

         By default extended postal codes are included for all indexes except Geo. Extended postal code
         lists for geographies can be quite long so they have to be explicitly requested when needed.

         Usage examples:

          extendedPostalCodesFor=POI

          extendedPostalCodesFor=PAD,Addr,POI

          extendedPostalCodesFor=None

         Extended postal code is returned as an **extendedPostalCode** property of an address.
         Availability is region-dependent.
        :type extended_postal_codes_for: list[str or ~azure.maps.search.models.SearchIndexes]
        :param entity_type: Specifies the level of filtering performed on geographies. Narrows the
         search for specified geography entity types, e.g. return only municipality. The resulting
         response will contain the geography ID as well as the entity type matched. If you provide more
         than one entity as a comma separated list, endpoint will return the 'smallest entity
         available'. Returned Geometry ID can be used to get the geometry of that geography via `Get
         Search Polygon <https://docs.microsoft.com/rest/api/maps/search/getsearchpolygon>`_ API. The
         following parameters are ignored when entityType is set:


         * heading
         * number
         * returnRoadUse
         * returnSpeedLimit
         * roadUse
         * returnMatchType.
        :type entity_type: str or ~azure.maps.search.models.GeographicEntityType
        :param localized_map_view: The View parameter (also called the "user region" parameter) allows
         you to show the correct maps for a certain country/region for geopolitically disputed regions.
         Different countries have different views of such regions, and the View parameter allows your
         application to comply with the view required by the country your application will be serving.
         By default, the View parameter is set to “Unified” even if you haven’t defined it in  the
         request. It is your responsibility to determine the location of your users, and then set the
         View parameter correctly for that location. Alternatively, you have the option to set
         ‘View=Auto’, which will return the map data based on the IP  address of the request. The View
         parameter in Azure Maps must be used in compliance with applicable laws, including those
         regarding mapping, of the country where maps, images and other data and third party content
         that you are authorized to  access via Azure Maps is made available. Example: view=IN.

         Please refer to `Supported Views <https://aka.ms/AzureMapsLocalizationViews>`_ for details and
         to see the available Views.
        :type localized_map_view: str or ~azure.maps.search.models.LocalizedMapView
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SearchAddressResult, or the result of cls(response)
        :rtype: ~azure.maps.search.models.SearchAddressResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.SearchAddressResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/json"

        # Construct URL
        url = self.search_structured_address.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        if language is not None:
            query_parameters['language'] = self._serialize.query("language", language, 'str')
        query_parameters['countryCode'] = self._serialize.query("country_code", country_code, 'str')
        if top is not None:
            query_parameters['limit'] = self._serialize.query("top", top, 'int', maximum=100, minimum=1)
        if skip is not None:
            query_parameters['ofs'] = self._serialize.query("skip", skip, 'int', maximum=1900, minimum=0)
        if street_number is not None:
            query_parameters['streetNumber'] = self._serialize.query("street_number", street_number, 'str')
        if street_name is not None:
            query_parameters['streetName'] = self._serialize.query("street_name", street_name, 'str')
        if cross_street is not None:
            query_parameters['crossStreet'] = self._serialize.query("cross_street", cross_street, 'str')
        if municipality is not None:
            query_parameters['municipality'] = self._serialize.query("municipality", municipality, 'str')
        if municipality_subdivision is not None:
            query_parameters['municipalitySubdivision'] = self._serialize.query("municipality_subdivision", municipality_subdivision, 'str')
        if country_tertiary_subdivision is not None:
            query_parameters['countryTertiarySubdivision'] = self._serialize.query("country_tertiary_subdivision", country_tertiary_subdivision, 'str')
        if country_secondary_subdivision is not None:
            query_parameters['countrySecondarySubdivision'] = self._serialize.query("country_secondary_subdivision", country_secondary_subdivision, 'str')
        if country_subdivision is not None:
            query_parameters['countrySubdivision'] = self._serialize.query("country_subdivision", country_subdivision, 'str')
        if postal_code is not None:
            query_parameters['postalCode'] = self._serialize.query("postal_code", postal_code, 'str')
        if extended_postal_codes_for is not None:
            query_parameters['extendedPostalCodesFor'] = self._serialize.query("extended_postal_codes_for", extended_postal_codes_for, '[str]', div=',')
        if entity_type is not None:
            query_parameters['entityType'] = self._serialize.query("entity_type", entity_type, 'str')
        if localized_map_view is not None:
            query_parameters['view'] = self._serialize.query("localized_map_view", localized_map_view, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('SearchAddressResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    search_structured_address.metadata = {'url': '/search/address/structured/{format}'}  # type: ignore

    async def search_inside_geometry(
        self,
        query: str,
        geometry: "models.SearchInsideGeometryRequest",
        format: Union[str, "models.ResponseFormat"] = "json",
        top: Optional[int] = None,
        language: Optional[str] = None,
        category_filter: Optional[List[int]] = None,
        extended_postal_codes_for: Optional[List[Union[str, "models.SearchIndexes"]]] = None,
        index_filter: Optional[List[Union[str, "models.SearchIndexes"]]] = None,
        localized_map_view: Optional[Union[str, "models.LocalizedMapView"]] = None,
        operating_hours: Optional[Union[str, "models.OperatingHoursRange"]] = None,
        **kwargs
    ) -> "models.SearchAddressResult":
        """**Applies to**\ : S0 and S1 pricing tiers.

        The Search Geometry endpoint allows you to perform a free form search inside a single geometry
        or many of them. The search results that fall inside the geometry/geometries will be
        returned.:code:`<br>`:code:`<br>`To send the geometry you will use a ``POST`` request where the
        request body will contain the ``geometry`` object represented as a ``GeoJSON`` type and the
        ``Content-Type`` header will be set to ``application/json``. The geographical features to be
        searched can be modeled as Polygon and/or Circle geometries represented using any one of the
        following ``GeoJSON`` types::code:`<ul><li>**GeoJSON FeatureCollection** <br>The `geometry` can
        be represented as a `GeoJSON FeatureCollection` object. This is the recommended option if the
        geometry contains both Polygons and Circles. The `FeatureCollection` can contain a max of 50
        `GeoJSON Feature` objects. Each `Feature` object should represent either a Polygon or a Circle
        with the following conditions:<ul style="list-style-type:none"><li>A `Feature` object for the
        Polygon geometry can have a max of 50 coordinates and it's properties must be empty.</li><li>A
        `Feature` object for the Circle geometry is composed of a _center_ represented using a `GeoJSON
        Point` type and a _radius_ value (in meters) which must be specified in the object's properties
        along with the _subType_ property whose value should be 'Circle'.</li></ul>`:code:`<br>` Please
        see the Examples section below for a sample ``FeatureCollection``
        representation.:code:`<br>`:code:`<br>`</li>:code:`<li>**GeoJSON GeometryCollection**<br>The
        `geometry` can be represented as a `GeoJSON GeometryCollection` object. This is the recommended
        option if the geometry contains a list of Polygons only. The `GeometryCollection` can contain a
        max of 50 `GeoJSON Polygon` objects. Each `Polygon` object can have a max of 50 coordinates.
        Please see the Examples section below for a sample `GeometryCollection`
        representation.<br><br></li>`:code:`<li>**GeoJSON Polygon**<br>The `geometry` can be
        represented as a `GeoJSON Polygon` object. This is the recommended option if the geometry
        contains a single Polygon. The `Polygon` object can have a max of 50 coordinates. Please see
        the Examples section below for a sample `Polygon`
        representation.<br><br></li>`</ul>.:code:`<br>`:code:`<br>`.

        :param query: The POI name to search for (e.g., "statue of liberty", "starbucks", "pizza").
         Must be properly URL encoded.
        :type query: str
        :param geometry: This represents the geometry for one or more geographical features (parks,
         state boundary etc.) to search in and should be a GeoJSON compliant type. Please refer to `RFC
         7946 <https://tools.ietf.org/html/rfc7946>`_ for details.
        :type geometry: ~azure.maps.search.models.SearchInsideGeometryRequest
        :param format: Desired format of the response. Value can be either *json* or *xml*.
        :type format: str or ~azure.maps.search.models.ResponseFormat
        :param top: Maximum number of responses that will be returned. Default: 10, minimum: 1 and
         maximum: 100.
        :type top: int
        :param language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages <https://docs.microsoft.com/azure/azure-maps/supported-
         languages>`_ for details.
        :type language: str
        :param category_filter: A comma-separated list of category set IDs which could be used to
         restrict the result to specific Points of Interest categories. ID order does not matter. When
         multiple category identifiers are provided, only POIs that belong to (at least) one of the
         categories from the provided list will be returned. The list of supported categories can be
         discovered using  `POI Categories API <https://aka.ms/AzureMapsPOICategoryTree>`_. Usage
         examples:


         *
           **categorySet=7315**\  (Search Points of Interest from category Restaurant)

         *
           **categorySet=7315025,7315017**\  (Search Points of Interest of category either Italian or
         French Restaurant).
        :type category_filter: list[int]
        :param extended_postal_codes_for: Indexes for which extended postal codes should be included in
         the results.

         Available indexes are:

          **Addr** = Address ranges

          **Geo** = Geographies

          **PAD** = Point Addresses

          **POI** = Points of Interest

          **Str** = Streets

          **XStr** = Cross Streets (intersections)

         Value should be a comma separated list of index types (in any order) or **None** for no
         indexes.

         By default extended postal codes are included for all indexes except Geo. Extended postal code
         lists for geographies can be quite long so they have to be explicitly requested when needed.

         Usage examples:

          extendedPostalCodesFor=POI

          extendedPostalCodesFor=PAD,Addr,POI

          extendedPostalCodesFor=None

         Extended postal code is returned as an **extendedPostalCode** property of an address.
         Availability is region-dependent.
        :type extended_postal_codes_for: list[str or ~azure.maps.search.models.SearchIndexes]
        :param index_filter: A comma separated list of indexes which should be utilized for the search.
         Item order does not matter. Available indexes are: Addr = Address range interpolation, Geo =
         Geographies, PAD = Point Addresses, POI = Points of interest, Str = Streets, Xstr = Cross
         Streets (intersections).
        :type index_filter: list[str or ~azure.maps.search.models.SearchIndexes]
        :param localized_map_view: The View parameter (also called the "user region" parameter) allows
         you to show the correct maps for a certain country/region for geopolitically disputed regions.
         Different countries have different views of such regions, and the View parameter allows your
         application to comply with the view required by the country your application will be serving.
         By default, the View parameter is set to “Unified” even if you haven’t defined it in  the
         request. It is your responsibility to determine the location of your users, and then set the
         View parameter correctly for that location. Alternatively, you have the option to set
         ‘View=Auto’, which will return the map data based on the IP  address of the request. The View
         parameter in Azure Maps must be used in compliance with applicable laws, including those
         regarding mapping, of the country where maps, images and other data and third party content
         that you are authorized to  access via Azure Maps is made available. Example: view=IN.

         Please refer to `Supported Views <https://aka.ms/AzureMapsLocalizationViews>`_ for details and
         to see the available Views.
        :type localized_map_view: str or ~azure.maps.search.models.LocalizedMapView
        :param operating_hours: Hours of operation for a POI (Points of Interest). The availability of
         hours of operation will vary based on the data available. If not passed, then no opening hours
         information will be returned.
         Supported value: nextSevenDays.
        :type operating_hours: str or ~azure.maps.search.models.OperatingHoursRange
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SearchAddressResult, or the result of cls(response)
        :rtype: ~azure.maps.search.models.SearchAddressResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.SearchAddressResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.search_inside_geometry.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['query'] = self._serialize.query("query", query, 'str')
        if top is not None:
            query_parameters['limit'] = self._serialize.query("top", top, 'int', maximum=100, minimum=1)
        if language is not None:
            query_parameters['language'] = self._serialize.query("language", language, 'str')
        if category_filter is not None:
            query_parameters['categorySet'] = self._serialize.query("category_filter", category_filter, '[int]', div=',')
        if extended_postal_codes_for is not None:
            query_parameters['extendedPostalCodesFor'] = self._serialize.query("extended_postal_codes_for", extended_postal_codes_for, '[str]', div=',')
        if index_filter is not None:
            query_parameters['idxSet'] = self._serialize.query("index_filter", index_filter, '[str]', div=',')
        if localized_map_view is not None:
            query_parameters['view'] = self._serialize.query("localized_map_view", localized_map_view, 'str')
        if operating_hours is not None:
            query_parameters['openingHours'] = self._serialize.query("operating_hours", operating_hours, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(geometry, 'SearchInsideGeometryRequest')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('SearchAddressResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    search_inside_geometry.metadata = {'url': '/search/geometry/{format}'}  # type: ignore

    async def search_along_route(
        self,
        query: str,
        max_detour_time: int,
        route: "models.SearchAlongRouteRequest",
        format: Union[str, "models.ResponseFormat"] = "json",
        top: Optional[int] = None,
        brand_filter: Optional[List[str]] = None,
        category_filter: Optional[List[int]] = None,
        electric_vehicle_connector_filter: Optional[List[Union[str, "models.ElectricVehicleConnector"]]] = None,
        localized_map_view: Optional[Union[str, "models.LocalizedMapView"]] = None,
        operating_hours: Optional[Union[str, "models.OperatingHoursRange"]] = None,
        **kwargs
    ) -> "models.SearchAddressResult":
        """**Applies to**\ : S0 and S1 pricing tiers.

        The Search Along Route endpoint allows you to perform a fuzzy search for POIs along a specified
        route. This search is constrained by specifying the ``maxDetourTime`` limiting
        measure.:code:`<br>`:code:`<br>`To send the route-points you will use a ``POST`` request where
        the request body will contain the ``route`` object represented as a ``GeoJSON LineString`` type
        and the ``Content-Type`` header will be set to ``application/json``. Each route-point in
        ``route`` is represented as a ``GeoJSON Position`` type i.e. an array where the *longitude*
        value is followed by the *latitude* value and the *altitude* value is ignored. The ``route``
        should contain at least 2 route-points.:code:`<br>`:code:`<br>`It is possible that original
        route will be altered, some of it's points may be skipped. If the route that passes through the
        found point is faster than the original one, the ``detourTime`` value in the response is
        negative.

        :param query: The POI name to search for (e.g., "statue of liberty", "starbucks", "pizza").
         Must be properly URL encoded.
        :type query: str
        :param max_detour_time: Maximum detour time of the point of interest in seconds. Max value is
         3600 seconds.
        :type max_detour_time: int
        :param route: This represents the route to search along and should be a valid ``GeoJSON
         LineString`` type. Please refer to `RFC 7946
         <https://tools.ietf.org/html/rfc7946#section-3.1.4>`_ for details.
        :type route: ~azure.maps.search.models.SearchAlongRouteRequest
        :param format: Desired format of the response. Value can be either *json* or *xml*.
        :type format: str or ~azure.maps.search.models.ResponseFormat
        :param top: Maximum number of responses that will be returned. Default value is 10. Max value
         is 20.
        :type top: int
        :param brand_filter: A comma-separated list of brand names which could be used to restrict the
         result to specific brands. Item order does not matter. When multiple brands are provided, only
         results that belong to (at least) one of the provided list will be returned. Brands that
         contain a "," in their name should be put into quotes.

         Usage examples:

          brandSet=Foo

          brandSet=Foo,Bar

          brandSet="A,B,C Comma",Bar.
        :type brand_filter: list[str]
        :param category_filter: A comma-separated list of category set IDs which could be used to
         restrict the result to specific Points of Interest categories. ID order does not matter. When
         multiple category identifiers are provided, only POIs that belong to (at least) one of the
         categories from the provided list will be returned. The list of supported categories can be
         discovered using  `POI Categories API <https://aka.ms/AzureMapsPOICategoryTree>`_. Usage
         examples:


         *
           **categorySet=7315**\  (Search Points of Interest from category Restaurant)

         *
           **categorySet=7315025,7315017**\  (Search Points of Interest of category either Italian or
         French Restaurant).
        :type category_filter: list[int]
        :param electric_vehicle_connector_filter: A comma-separated list of connector types which could
         be used to restrict the result to Electric Vehicle Station supporting specific connector types.
         Item order does not matter. When multiple connector types are provided, only results that
         belong to (at least) one of the provided list will be returned.

         Available connector types are:


         * ``StandardHouseholdCountrySpecific`` - These are the standard household connectors for a
         certain region. They are all AC single phase and the standard Voltage and standard Amperage.
         See also: `Plug & socket types - World Standards
         <https://www.worldstandards.eu/electricity/plugs-and-sockets>`_.
         * ``IEC62196Type1`` - Type 1 connector as defined in the IEC 62196-2 standard. Also called
         Yazaki after the original manufacturer or SAE J1772 after the standard that first published it.
         Mostly used in combination with 120V single phase or up to 240V single phase infrastructure.
         * ``IEC62196Type1CCS`` - Type 1 based combo connector as defined in the IEC 62196-3 standard.
         The connector is based on the Type 1 connector – as defined in the IEC 62196-2 standard – with
         two additional direct current (DC) contacts to allow DC fast charging.
         * ``IEC62196Type2CableAttached`` - Type 2 connector as defined in the IEC 62196-2 standard.
         Provided as a cable and plug attached to the charging point.
         * ``IEC62196Type2Outlet`` - Type 2 connector as defined in the IEC 62196-2 standard. Provided
         as a socket set into the charging point.
         * ``IEC62196Type2CCS`` - Type 2 based combo connector as defined in the IEC 62196-3 standard.
         The connector is based on the Type 2 connector – as defined in the IEC 62196-2 standard – with
         two additional direct current (DC) contacts to allow DC fast charging.
         * ``IEC62196Type3`` - Type 3 connector as defined in the IEC 62196-2 standard. Also called
         Scame after the original manufacturer. Mostly used in combination with up to 240V single phase
         or up to 420V three phase infrastructure.
         * ``Chademo`` - CHAdeMO connector named after an association formed by the Tokyo Electric
         Power Company and industrial partners. Because of this is is also known as the TEPCO's
         connector. It supports fast DC charging.
         * ``IEC60309AC1PhaseBlue`` - Industrial Blue connector is a connector defined in the IEC 60309
         standard. It is sometime referred to as by some combination of the standard, the color and the
         fact that is a single phase connector. The connector usually has the "P+N+E, 6h" configuration.
         * ``IEC60309DCWhite`` - Industrial White connector is a DC connector defined in the IEC 60309
         standard.
         * ``Tesla`` - The Tesla connector is the regionally specific Tesla Supercharger connector.
         I.e. it refers to either Tesla's proprietary connector, sometimes referred to as Tesla Port
         mostly limited to North America or the modified Type 2 (DC over Type 2) in Europe.

         Usage examples:

          connectorSet=IEC62196Type2CableAttached
          connectorSet=IEC62196Type2Outlet,IEC62196Type2CableAttached.
        :type electric_vehicle_connector_filter: list[str or ~azure.maps.search.models.ElectricVehicleConnector]
        :param localized_map_view: The View parameter (also called the "user region" parameter) allows
         you to show the correct maps for a certain country/region for geopolitically disputed regions.
         Different countries have different views of such regions, and the View parameter allows your
         application to comply with the view required by the country your application will be serving.
         By default, the View parameter is set to “Unified” even if you haven’t defined it in  the
         request. It is your responsibility to determine the location of your users, and then set the
         View parameter correctly for that location. Alternatively, you have the option to set
         ‘View=Auto’, which will return the map data based on the IP  address of the request. The View
         parameter in Azure Maps must be used in compliance with applicable laws, including those
         regarding mapping, of the country where maps, images and other data and third party content
         that you are authorized to  access via Azure Maps is made available. Example: view=IN.

         Please refer to `Supported Views <https://aka.ms/AzureMapsLocalizationViews>`_ for details and
         to see the available Views.
        :type localized_map_view: str or ~azure.maps.search.models.LocalizedMapView
        :param operating_hours: Hours of operation for a POI (Points of Interest). The availability of
         hours of operation will vary based on the data available. If not passed, then no opening hours
         information will be returned.
         Supported value: nextSevenDays.
        :type operating_hours: str or ~azure.maps.search.models.OperatingHoursRange
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SearchAddressResult, or the result of cls(response)
        :rtype: ~azure.maps.search.models.SearchAddressResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.SearchAddressResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.search_along_route.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')
        query_parameters['query'] = self._serialize.query("query", query, 'str')
        query_parameters['maxDetourTime'] = self._serialize.query("max_detour_time", max_detour_time, 'int', maximum=3600)
        if top is not None:
            query_parameters['limit'] = self._serialize.query("top", top, 'int', maximum=20)
        if brand_filter is not None:
            query_parameters['brandSet'] = self._serialize.query("brand_filter", brand_filter, '[str]', div=',')
        if category_filter is not None:
            query_parameters['categorySet'] = self._serialize.query("category_filter", category_filter, '[int]', div=',')
        if electric_vehicle_connector_filter is not None:
            query_parameters['connectorSet'] = self._serialize.query("electric_vehicle_connector_filter", electric_vehicle_connector_filter, '[str]', div=',')
        if localized_map_view is not None:
            query_parameters['view'] = self._serialize.query("localized_map_view", localized_map_view, 'str')
        if operating_hours is not None:
            query_parameters['openingHours'] = self._serialize.query("operating_hours", operating_hours, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(route, 'SearchAlongRouteRequest')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('SearchAddressResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    search_along_route.metadata = {'url': '/search/alongRoute/{format}'}  # type: ignore

    async def fuzzy_search_batch_sync(
        self,
        batch_request: "models.BatchRequest",
        format: Union[str, "models.JsonFormat"] = "json",
        **kwargs
    ) -> "models.SearchAddressBatchResult":
        """**Search Fuzzy Batch API**

        **Applies to**\ : S1 pricing tier.

        The Search Address Batch API sends batches of queries to `Search Fuzzy API
        <https://docs.microsoft.com/rest/api/maps/search/getsearchfuzzy>`_ using just a single API
        call. You can call Search Address Fuzzy Batch API to run either asynchronously (async) or
        synchronously (sync). The async API allows caller to batch up to **10,000** queries and sync
        API up to **100** queries.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        .. code-block::

           POST https://atlas.microsoft.com/search/fuzzy/batch/sync/json?api-version=1.0&subscription-
        key={subscription-key}

        Submit Asynchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex search
        requests


        * It allows the retrieval of results in a separate call (multiple downloads are possible).
        * The asynchronous API is optimized for reliability and is not expected to run into a timeout.
        * The number of batch items is limited to **10,000** for this API.

        When you make a request by using async request, by default the service returns a 202 response
        code along a redirect URL in the Location field of the response header. This URL should be
        checked periodically until the response data or error information is available.
        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        Please note that asynchronous batch request is a long-running request. Here's a typical
        sequence of operations:


        #. Client sends a Search Address Batch ``POST`` request to Azure Maps
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request has been accepted.

              HTTP ``Error`` - There was an error processing your Batch request. This could either be a
        ``400 Bad Request`` or any other ``Error`` status code.


        #.
           If the batch request was accepted successfully, the ``Location`` header in the response
        contains the URL to download the results of the batch request.
            This status URI looks like following:

        .. code-block::

               GET https://atlas.microsoft.com/search/fuzzy/batch/{batch-id}?api-
        version=1.0&subscription-key={subscription-key}


        #. Client issues a ``GET`` request on the *download URL* obtained in Step 3 to download the
        batch results.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *search fuzzy* queries you will use a ``POST`` request where the request body will
        contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header will be set
        to ``application/json``. Here's a sample request body containing 5 *search fuzzy* queries:

        .. code-block:: json

           {
               "batchItems": [
                   {"query": "?query=atm&lat=47.639769&lon=-122.128362&radius=5000&limit=5"},
                   {"query": "?query=Statue Of Liberty&limit=2"},
                   {"query": "?query=Starbucks&lat=47.639769&lon=-122.128362&radius=5000"},
                   {"query": "?query=Space Needle"},
                   {"query": "?query=pizza&limit=10"}
               ]
           }

        A *search fuzzy* query in a batch is just a partial URL *without* the protocol, base URL, path,
        api-version and subscription-key. It can accept any of the supported *search fuzzy* `URI
        parameters <https://docs.microsoft.com/rest/api/maps/search/getsearchfuzzy#uri-parameters>`_.
        The string values in the *search fuzzy* query must be properly escaped (e.g. " character should
        be escaped with ) and it should also be properly URL-encoded.

        The async API allows caller to batch up to **10,000** queries and sync API up to **100**
        queries, and the batch should contain at least **1** query.

        Download Asynchronous Batch Results
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To download the async batch results you will issue a ``GET`` request to the batch download
        endpoint. This *download URL* can be obtained from the ``Location`` header of a successful
        ``POST`` batch request and looks like the following:

        .. code-block::

           https://atlas.microsoft.com/search/fuzzy/batch/{batch-id}?api-version=1.0&subscription-
        key={subscription-key}

        Here's the typical sequence of operations for downloading the batch results:


        #. Client sends a ``GET`` request using the *download URL*.
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request was accepted but is still being processed. Please
        try again in some time.

              HTTP ``200 OK`` - Batch request successfully processed. The response body contains all
        the batch results.


        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\ i.e.
        queries which were executed successfully. The batch response also includes a ``batchItems``
        array which contains a response for each and every query in the batch request. The
        ``batchItems`` will contain the results in the exact same order the original queries were sent
        in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        *
          `\ ``SearchAddressResponse``
        <https://docs.microsoft.com/rest/api/maps/search/getsearchfuzzy#SearchAddressResponse>`_ - If
        the query completed successfully.

        *
          ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
        this case.

        Here's a sample Batch Response with 2 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 2,
                   "totalRequests": 3
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "query": "atm"
                           },
                           "results": [
                               {
                                   "type": "POI",
                                   "poi": {
                                       "name": "ATM at Wells Fargo"
                                   },
                                   "address": {
                                       "country": "United States Of America",
                                       "freeformAddress": "3240 157th Ave NE, Redmond, WA 98052"
                                   }
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "query": "statue of liberty"
                           },
                           "results": [
                               {
                                   "type": "POI",
                                   "poi": {
                                       "name": "Statue of Liberty"
                                   },
                                   "address": {
                                       "country": "United States Of America",
                                       "freeformAddress": "New York, NY 10004"
                                   }
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message": "Bad request: one or more parameters were incorrectly
        specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }.

        :param batch_request: The list of search fuzzy queries/requests to process. The list can
         contain  a max of 10,000 queries and must contain at least 1 query.
        :type batch_request: ~azure.maps.search.models.BatchRequest
        :param format: Desired format of the response. Only ``json`` format is supported.
        :type format: str or ~azure.maps.search.models.JsonFormat
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SearchAddressBatchResult, or the result of cls(response)
        :rtype: ~azure.maps.search.models.SearchAddressBatchResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.SearchAddressBatchResult"]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            408: lambda response: HttpResponseError(response=response, model=self._deserialize(models.ErrorResponse, response)),
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.fuzzy_search_batch_sync.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(batch_request, 'BatchRequest')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('SearchAddressBatchResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    fuzzy_search_batch_sync.metadata = {'url': '/search/fuzzy/batch/sync/{format}'}  # type: ignore

    async def _fuzzy_search_batch_initial(
        self,
        batch_request: "models.BatchRequest",
        format: Union[str, "models.JsonFormat"] = "json",
        **kwargs
    ) -> Optional["models.SearchAddressBatchResult"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["models.SearchAddressBatchResult"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self._fuzzy_search_batch_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(batch_request, 'BatchRequest')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('SearchAddressBatchResult', pipeline_response)

        if response.status_code == 202:
            response_headers['Location']=self._deserialize('str', response.headers.get('Location'))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    _fuzzy_search_batch_initial.metadata = {'url': '/search/fuzzy/batch/{format}'}  # type: ignore

    async def begin_fuzzy_search_batch(
        self,
        batch_request: "models.BatchRequest",
        format: Union[str, "models.JsonFormat"] = "json",
        **kwargs
    ) -> AsyncLROPoller["models.SearchAddressBatchResult"]:
        """**Search Fuzzy Batch API**

        **Applies to**\ : S1 pricing tier.

        The Search Address Batch API sends batches of queries to `Search Fuzzy API
        <https://docs.microsoft.com/rest/api/maps/search/getsearchfuzzy>`_ using just a single API
        call. You can call Search Address Fuzzy Batch API to run either asynchronously (async) or
        synchronously (sync). The async API allows caller to batch up to **10,000** queries and sync
        API up to **100** queries.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        .. code-block::

           POST https://atlas.microsoft.com/search/fuzzy/batch/sync/json?api-version=1.0&subscription-
        key={subscription-key}

        Submit Asynchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex search
        requests


        * It allows the retrieval of results in a separate call (multiple downloads are possible).
        * The asynchronous API is optimized for reliability and is not expected to run into a timeout.
        * The number of batch items is limited to **10,000** for this API.

        When you make a request by using async request, by default the service returns a 202 response
        code along a redirect URL in the Location field of the response header. This URL should be
        checked periodically until the response data or error information is available.
        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        Please note that asynchronous batch request is a long-running request. Here's a typical
        sequence of operations:


        #. Client sends a Search Address Batch ``POST`` request to Azure Maps
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request has been accepted.

              HTTP ``Error`` - There was an error processing your Batch request. This could either be a
        ``400 Bad Request`` or any other ``Error`` status code.


        #.
           If the batch request was accepted successfully, the ``Location`` header in the response
        contains the URL to download the results of the batch request.
            This status URI looks like following:

        .. code-block::

               GET https://atlas.microsoft.com/search/fuzzy/batch/{batch-id}?api-
        version=1.0&subscription-key={subscription-key}


        #. Client issues a ``GET`` request on the *download URL* obtained in Step 3 to download the
        batch results.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *search fuzzy* queries you will use a ``POST`` request where the request body will
        contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header will be set
        to ``application/json``. Here's a sample request body containing 5 *search fuzzy* queries:

        .. code-block:: json

           {
               "batchItems": [
                   {"query": "?query=atm&lat=47.639769&lon=-122.128362&radius=5000&limit=5"},
                   {"query": "?query=Statue Of Liberty&limit=2"},
                   {"query": "?query=Starbucks&lat=47.639769&lon=-122.128362&radius=5000"},
                   {"query": "?query=Space Needle"},
                   {"query": "?query=pizza&limit=10"}
               ]
           }

        A *search fuzzy* query in a batch is just a partial URL *without* the protocol, base URL, path,
        api-version and subscription-key. It can accept any of the supported *search fuzzy* `URI
        parameters <https://docs.microsoft.com/rest/api/maps/search/getsearchfuzzy#uri-parameters>`_.
        The string values in the *search fuzzy* query must be properly escaped (e.g. " character should
        be escaped with ) and it should also be properly URL-encoded.

        The async API allows caller to batch up to **10,000** queries and sync API up to **100**
        queries, and the batch should contain at least **1** query.

        Download Asynchronous Batch Results
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To download the async batch results you will issue a ``GET`` request to the batch download
        endpoint. This *download URL* can be obtained from the ``Location`` header of a successful
        ``POST`` batch request and looks like the following:

        .. code-block::

           https://atlas.microsoft.com/search/fuzzy/batch/{batch-id}?api-version=1.0&subscription-
        key={subscription-key}

        Here's the typical sequence of operations for downloading the batch results:


        #. Client sends a ``GET`` request using the *download URL*.
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request was accepted but is still being processed. Please
        try again in some time.

              HTTP ``200 OK`` - Batch request successfully processed. The response body contains all
        the batch results.


        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\ i.e.
        queries which were executed successfully. The batch response also includes a ``batchItems``
        array which contains a response for each and every query in the batch request. The
        ``batchItems`` will contain the results in the exact same order the original queries were sent
        in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        *
          `\ ``SearchAddressResponse``
        <https://docs.microsoft.com/rest/api/maps/search/getsearchfuzzy#SearchAddressResponse>`_ - If
        the query completed successfully.

        *
          ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
        this case.

        Here's a sample Batch Response with 2 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 2,
                   "totalRequests": 3
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "query": "atm"
                           },
                           "results": [
                               {
                                   "type": "POI",
                                   "poi": {
                                       "name": "ATM at Wells Fargo"
                                   },
                                   "address": {
                                       "country": "United States Of America",
                                       "freeformAddress": "3240 157th Ave NE, Redmond, WA 98052"
                                   }
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "query": "statue of liberty"
                           },
                           "results": [
                               {
                                   "type": "POI",
                                   "poi": {
                                       "name": "Statue of Liberty"
                                   },
                                   "address": {
                                       "country": "United States Of America",
                                       "freeformAddress": "New York, NY 10004"
                                   }
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message": "Bad request: one or more parameters were incorrectly
        specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }.

        :param batch_request: The list of search fuzzy queries/requests to process. The list can
         contain a max of 10,000 queries and must contain at least 1 query.
        :type batch_request: ~azure.maps.search.models.BatchRequest
        :param format: Desired format of the response. Only ``json`` format is supported.
        :type format: str or ~azure.maps.search.models.JsonFormat
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: True for ARMPolling, False for no polling, or a
         polling object for personal polling strategy
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either SearchAddressBatchResult or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.maps.search.models.SearchAddressBatchResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', False)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["models.SearchAddressBatchResult"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._fuzzy_search_batch_initial(
                batch_request=batch_request,
                format=format,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize('SearchAddressBatchResult', pipeline_response)

            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }

        if polling is True: polling_method = AsyncLROBasePolling(lro_delay, lro_options={'final-state-via': 'location'}, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_fuzzy_search_batch.metadata = {'url': '/search/fuzzy/batch/{format}'}  # type: ignore

    async def _get_fuzzy_search_batch_initial(
        self,
        batch_id: str,
        **kwargs
    ) -> Optional["models.SearchAddressBatchResult"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["models.SearchAddressBatchResult"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/json"

        # Construct URL
        url = self._get_fuzzy_search_batch_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("batch_id", batch_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('SearchAddressBatchResult', pipeline_response)

        if response.status_code == 202:
            response_headers['Location']=self._deserialize('str', response.headers.get('Location'))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    _get_fuzzy_search_batch_initial.metadata = {'url': '/search/fuzzy/batch/{format}'}  # type: ignore

    async def begin_get_fuzzy_search_batch(
        self,
        batch_id: str,
        **kwargs
    ) -> AsyncLROPoller["models.SearchAddressBatchResult"]:
        """**Search Fuzzy Batch API**

        **Applies to**\ : S1 pricing tier.

        The Search Address Batch API sends batches of queries to `Search Fuzzy API
        <https://docs.microsoft.com/rest/api/maps/search/getsearchfuzzy>`_ using just a single API
        call. You can call Search Address Fuzzy Batch API to run either asynchronously (async) or
        synchronously (sync). The async API allows caller to batch up to **10,000** queries and sync
        API up to **100** queries.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        .. code-block::

           POST https://atlas.microsoft.com/search/fuzzy/batch/sync/json?api-version=1.0&subscription-
        key={subscription-key}

        Submit Asynchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex search
        requests


        * It allows the retrieval of results in a separate call (multiple downloads are possible).
        * The asynchronous API is optimized for reliability and is not expected to run into a timeout.
        * The number of batch items is limited to **10,000** for this API.

        When you make a request by using async request, by default the service returns a 202 response
        code along a redirect URL in the Location field of the response header. This URL should be
        checked periodically until the response data or error information is available.
        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        Please note that asynchronous batch request is a long-running request. Here's a typical
        sequence of operations:


        #. Client sends a Search Address Batch ``POST`` request to Azure Maps
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request has been accepted.

              HTTP ``Error`` - There was an error processing your Batch request. This could either be a
        ``400 Bad Request`` or any other ``Error`` status code.


        #.
           If the batch request was accepted successfully, the ``Location`` header in the response
        contains the URL to download the results of the batch request.
            This status URI looks like following:

        .. code-block::

               GET https://atlas.microsoft.com/search/fuzzy/batch/{batch-id}?api-
        version=1.0&subscription-key={subscription-key}


        #. Client issues a ``GET`` request on the *download URL* obtained in Step 3 to download the
        batch results.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *search fuzzy* queries you will use a ``POST`` request where the request body will
        contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header will be set
        to ``application/json``. Here's a sample request body containing 5 *search fuzzy* queries:

        .. code-block:: json

           {
               "batchItems": [
                   {"query": "?query=atm&lat=47.639769&lon=-122.128362&radius=5000&limit=5"},
                   {"query": "?query=Statue Of Liberty&limit=2"},
                   {"query": "?query=Starbucks&lat=47.639769&lon=-122.128362&radius=5000"},
                   {"query": "?query=Space Needle"},
                   {"query": "?query=pizza&limit=10"}
               ]
           }

        A *search fuzzy* query in a batch is just a partial URL *without* the protocol, base URL, path,
        api-version and subscription-key. It can accept any of the supported *search fuzzy* `URI
        parameters <https://docs.microsoft.com/rest/api/maps/search/getsearchfuzzy#uri-parameters>`_.
        The string values in the *search fuzzy* query must be properly escaped (e.g. " character should
        be escaped with ) and it should also be properly URL-encoded.

        The async API allows caller to batch up to **10,000** queries and sync API up to **100**
        queries, and the batch should contain at least **1** query.

        Download Asynchronous Batch Results
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To download the async batch results you will issue a ``GET`` request to the batch download
        endpoint. This *download URL* can be obtained from the ``Location`` header of a successful
        ``POST`` batch request and looks like the following:

        .. code-block::

           https://atlas.microsoft.com/search/fuzzy/batch/{batch-id}?api-version=1.0&subscription-
        key={subscription-key}

        Here's the typical sequence of operations for downloading the batch results:


        #. Client sends a ``GET`` request using the *download URL*.
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request was accepted but is still being processed. Please
        try again in some time.

              HTTP ``200 OK`` - Batch request successfully processed. The response body contains all
        the batch results.


        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\ i.e.
        queries which were executed successfully. The batch response also includes a ``batchItems``
        array which contains a response for each and every query in the batch request. The
        ``batchItems`` will contain the results in the exact same order the original queries were sent
        in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        *
          `\ ``SearchAddressResponse``
        <https://docs.microsoft.com/rest/api/maps/search/getsearchfuzzy#SearchAddressResponse>`_ - If
        the query completed successfully.

        *
          ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
        this case.

        Here's a sample Batch Response with 2 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 2,
                   "totalRequests": 3
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "query": "atm"
                           },
                           "results": [
                               {
                                   "type": "POI",
                                   "poi": {
                                       "name": "ATM at Wells Fargo"
                                   },
                                   "address": {
                                       "country": "United States Of America",
                                       "freeformAddress": "3240 157th Ave NE, Redmond, WA 98052"
                                   }
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "query": "statue of liberty"
                           },
                           "results": [
                               {
                                   "type": "POI",
                                   "poi": {
                                       "name": "Statue of Liberty"
                                   },
                                   "address": {
                                       "country": "United States Of America",
                                       "freeformAddress": "New York, NY 10004"
                                   }
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message": "Bad request: one or more parameters were incorrectly
        specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }.

        :param batch_id: Batch id for querying the operation.
        :type batch_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: True for ARMPolling, False for no polling, or a
         polling object for personal polling strategy
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either SearchAddressBatchResult or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.maps.search.models.SearchAddressBatchResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', False)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["models.SearchAddressBatchResult"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._get_fuzzy_search_batch_initial(
                batch_id=batch_id,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize('SearchAddressBatchResult', pipeline_response)

            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            'format': self._serialize.url("batch_id", batch_id, 'str'),
        }

        if polling is True: polling_method = AsyncLROBasePolling(lro_delay, lro_options={'final-state-via': 'original-uri'}, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_get_fuzzy_search_batch.metadata = {'url': '/search/fuzzy/batch/{format}'}  # type: ignore

    async def search_address_batch_sync(
        self,
        batch_request: "models.BatchRequest",
        format: Union[str, "models.JsonFormat"] = "json",
        **kwargs
    ) -> "models.SearchAddressBatchResult":
        """**Search Address Batch API**

        **Applies to**\ : S1 pricing tier.

        The Search Address Batch API sends batches of queries to `Search Address API
        <https://docs.microsoft.com/rest/api/maps/search/getsearchaddress>`_ using just a single API
        call. You can call Search Address Batch API to run either asynchronously (async) or
        synchronously (sync). The async API allows caller to batch up to **10,000** queries and sync
        API up to **100** queries.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        .. code-block::

           POST https://atlas.microsoft.com/search/address/batch/sync/json?api-
        version=1.0&subscription-key={subscription-key}

        Submit Asynchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex search
        requests


        * It allows the retrieval of results in a separate call (multiple downloads are possible).
        * The asynchronous API is optimized for reliability and is not expected to run into a timeout.
        * The number of batch items is limited to **10,000** for this API.

        When you make a request by using async request, by default the service returns a 202 response
        code along a redirect URL in the Location field of the response header. This URL should be
        checked periodically until the response data or error information is available.
        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        Please note that asynchronous batch request is a long-running request. Here's a typical
        sequence of operations:


        #. Client sends a Search Address Batch ``POST`` request to Azure Maps
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request has been accepted.

              HTTP ``Error`` - There was an error processing your Batch request. This could either be a
        ``400 Bad Request`` or any other ``Error`` status code.


        #.
           If the batch request was accepted successfully, the ``Location`` header in the response
        contains the URL to download the results of the batch request.
            This status URI looks like following:

        .. code-block::

               GET https://atlas.microsoft.com/search/address/batch/{batch-id}?api-
        version=1.0&subscription-key={subscription-key}


        #. Client issues a ``GET`` request on the *download URL* obtained in Step 3 to download the
        batch results.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *search address* queries you will use a ``POST`` request where the request body
        will contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header will
        be set to ``application/json``. Here's a sample request body containing 5 *search address*
        queries:

        .. code-block:: json

           {
               "batchItems": [
                   {"query": "?query=400 Broad St, Seattle, WA 98109&limit=3"},
                   {"query": "?query=One, Microsoft Way, Redmond, WA 98052&limit=3"},
                   {"query": "?query=350 5th Ave, New York, NY 10118&limit=1"},
                   {"query": "?query=Pike Pl, Seattle, WA
        98101&lat=47.610970&lon=-122.342469&radius=1000"},
                   {"query": "?query=Champ de Mars, 5 Avenue Anatole France, 75007 Paris,
        France&limit=1"}
               ]
           }

        A *search address* query in a batch is just a partial URL *without* the protocol, base URL,
        path, api-version and subscription-key. It can accept any of the supported *search address*
        `URI parameters <https://docs.microsoft.com/rest/api/maps/search/getsearchaddress#uri-
        parameters>`_. The string values in the *search address* query must be properly escaped (e.g. "
        character should be escaped with ) and it should also be properly URL-encoded.

        The async API allows caller to batch up to **10,000** queries and sync API up to **100**
        queries, and the batch should contain at least **1** query.

        Download Asynchronous Batch Results
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To download the async batch results you will issue a ``GET`` request to the batch download
        endpoint. This *download URL* can be obtained from the ``Location`` header of a successful
        ``POST`` batch request and looks like the following:

        .. code-block::

           https://atlas.microsoft.com/search/address/batch/{batch-id}?api-version=1.0&subscription-
        key={subscription-key}

        Here's the typical sequence of operations for downloading the batch results:


        #. Client sends a ``GET`` request using the *download URL*.
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request was accepted but is still being processed. Please
        try again in some time.

              HTTP ``200 OK`` - Batch request successfully processed. The response body contains all
        the batch results.


        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\ i.e.
        queries which were executed successfully. The batch response also includes a ``batchItems``
        array which contains a response for each and every query in the batch request. The
        ``batchItems`` will contain the results in the exact same order the original queries were sent
        in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        *
          `\ ``SearchAddressResponse``
        <https://docs.microsoft.com/rest/api/maps/search/getsearchaddress#SearchAddressResponse>`_ - If
        the query completed successfully.

        *
          ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
        this case.

        Here's a sample Batch Response with 2 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 2,
                   "totalRequests": 3
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "query": "one microsoft way redmond wa 98052"
                           },
                           "results": [
                               {
                                   "position": {
                                       "lat": 47.63989,
                                       "lon": -122.12509
                                   }
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "query": "pike pl seattle wa 98101"
                           },
                           "results": [
                               {
                                   "position": {
                                       "lat": 47.60963,
                                       "lon": -122.34215
                                   }
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message": "Bad request: one or more parameters were incorrectly
        specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }.

        :param batch_request: The list of address geocoding queries/requests to process. The list can
         contain  a max of 10,000 queries and must contain at least 1 query.
        :type batch_request: ~azure.maps.search.models.BatchRequest
        :param format: Desired format of the response. Only ``json`` format is supported.
        :type format: str or ~azure.maps.search.models.JsonFormat
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SearchAddressBatchResult, or the result of cls(response)
        :rtype: ~azure.maps.search.models.SearchAddressBatchResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.SearchAddressBatchResult"]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            408: lambda response: HttpResponseError(response=response, model=self._deserialize(models.ErrorResponse, response)),
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.search_address_batch_sync.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(batch_request, 'BatchRequest')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('SearchAddressBatchResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    search_address_batch_sync.metadata = {'url': '/search/address/batch/sync/{format}'}  # type: ignore

    async def _search_address_batch_initial(
        self,
        batch_request: "models.BatchRequest",
        format: Union[str, "models.JsonFormat"] = "json",
        **kwargs
    ) -> Optional["models.SearchAddressBatchResult"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["models.SearchAddressBatchResult"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self._search_address_batch_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(batch_request, 'BatchRequest')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('SearchAddressBatchResult', pipeline_response)

        if response.status_code == 202:
            response_headers['Location']=self._deserialize('str', response.headers.get('Location'))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    _search_address_batch_initial.metadata = {'url': '/search/address/batch/{format}'}  # type: ignore

    async def begin_search_address_batch(
        self,
        batch_request: "models.BatchRequest",
        format: Union[str, "models.JsonFormat"] = "json",
        **kwargs
    ) -> AsyncLROPoller["models.SearchAddressBatchResult"]:
        """**Search Address Batch API**

        **Applies to**\ : S1 pricing tier.

        The Search Address Batch API sends batches of queries to `Search Address API
        <https://docs.microsoft.com/rest/api/maps/search/getsearchaddress>`_ using just a single API
        call. You can call Search Address Batch API to run either asynchronously (async) or
        synchronously (sync). The async API allows caller to batch up to **10,000** queries and sync
        API up to **100** queries.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        .. code-block::

           POST https://atlas.microsoft.com/search/address/batch/sync/json?api-
        version=1.0&subscription-key={subscription-key}

        Submit Asynchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex search
        requests


        * It allows the retrieval of results in a separate call (multiple downloads are possible).
        * The asynchronous API is optimized for reliability and is not expected to run into a timeout.
        * The number of batch items is limited to **10,000** for this API.

        When you make a request by using async request, by default the service returns a 202 response
        code along a redirect URL in the Location field of the response header. This URL should be
        checked periodically until the response data or error information is available.
        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        Please note that asynchronous batch request is a long-running request. Here's a typical
        sequence of operations:


        #. Client sends a Search Address Batch ``POST`` request to Azure Maps
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request has been accepted.

              HTTP ``Error`` - There was an error processing your Batch request. This could either be a
        ``400 Bad Request`` or any other ``Error`` status code.


        #.
           If the batch request was accepted successfully, the ``Location`` header in the response
        contains the URL to download the results of the batch request.
            This status URI looks like following:

        .. code-block::

               GET https://atlas.microsoft.com/search/address/batch/{batch-id}?api-
        version=1.0&subscription-key={subscription-key}


        #. Client issues a ``GET`` request on the *download URL* obtained in Step 3 to download the
        batch results.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *search address* queries you will use a ``POST`` request where the request body
        will contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header will
        be set to ``application/json``. Here's a sample request body containing 5 *search address*
        queries:

        .. code-block:: json

           {
               "batchItems": [
                   {"query": "?query=400 Broad St, Seattle, WA 98109&limit=3"},
                   {"query": "?query=One, Microsoft Way, Redmond, WA 98052&limit=3"},
                   {"query": "?query=350 5th Ave, New York, NY 10118&limit=1"},
                   {"query": "?query=Pike Pl, Seattle, WA
        98101&lat=47.610970&lon=-122.342469&radius=1000"},
                   {"query": "?query=Champ de Mars, 5 Avenue Anatole France, 75007 Paris,
        France&limit=1"}
               ]
           }

        A *search address* query in a batch is just a partial URL *without* the protocol, base URL,
        path, api-version and subscription-key. It can accept any of the supported *search address*
        `URI parameters <https://docs.microsoft.com/rest/api/maps/search/getsearchaddress#uri-
        parameters>`_. The string values in the *search address* query must be properly escaped (e.g. "
        character should be escaped with ) and it should also be properly URL-encoded.

        The async API allows caller to batch up to **10,000** queries and sync API up to **100**
        queries, and the batch should contain at least **1** query.

        Download Asynchronous Batch Results
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To download the async batch results you will issue a ``GET`` request to the batch download
        endpoint. This *download URL* can be obtained from the ``Location`` header of a successful
        ``POST`` batch request and looks like the following:

        .. code-block::

           https://atlas.microsoft.com/search/address/batch/{batch-id}?api-version=1.0&subscription-
        key={subscription-key}

        Here's the typical sequence of operations for downloading the batch results:


        #. Client sends a ``GET`` request using the *download URL*.
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request was accepted but is still being processed. Please
        try again in some time.

              HTTP ``200 OK`` - Batch request successfully processed. The response body contains all
        the batch results.


        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\ i.e.
        queries which were executed successfully. The batch response also includes a ``batchItems``
        array which contains a response for each and every query in the batch request. The
        ``batchItems`` will contain the results in the exact same order the original queries were sent
        in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        *
          `\ ``SearchAddressResponse``
        <https://docs.microsoft.com/rest/api/maps/search/getsearchaddress#SearchAddressResponse>`_ - If
        the query completed successfully.

        *
          ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
        this case.

        Here's a sample Batch Response with 2 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 2,
                   "totalRequests": 3
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "query": "one microsoft way redmond wa 98052"
                           },
                           "results": [
                               {
                                   "position": {
                                       "lat": 47.63989,
                                       "lon": -122.12509
                                   }
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "query": "pike pl seattle wa 98101"
                           },
                           "results": [
                               {
                                   "position": {
                                       "lat": 47.60963,
                                       "lon": -122.34215
                                   }
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message": "Bad request: one or more parameters were incorrectly
        specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }.

        :param batch_request: The list of address geocoding queries/requests to process. The list can
         contain  a max of 10,000 queries and must contain at least 1 query.
        :type batch_request: ~azure.maps.search.models.BatchRequest
        :param format: Desired format of the response. Only ``json`` format is supported.
        :type format: str or ~azure.maps.search.models.JsonFormat
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: True for ARMPolling, False for no polling, or a
         polling object for personal polling strategy
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either SearchAddressBatchResult or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.maps.search.models.SearchAddressBatchResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', False)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["models.SearchAddressBatchResult"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._search_address_batch_initial(
                batch_request=batch_request,
                format=format,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize('SearchAddressBatchResult', pipeline_response)

            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }

        if polling is True: polling_method = AsyncLROBasePolling(lro_delay, lro_options={'final-state-via': 'location'}, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_search_address_batch.metadata = {'url': '/search/address/batch/{format}'}  # type: ignore

    async def _get_search_address_batch_initial(
        self,
        batch_id: str,
        **kwargs
    ) -> Optional["models.SearchAddressBatchResult"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["models.SearchAddressBatchResult"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/json"

        # Construct URL
        url = self._get_search_address_batch_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("batch_id", batch_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('SearchAddressBatchResult', pipeline_response)

        if response.status_code == 202:
            response_headers['Location']=self._deserialize('str', response.headers.get('Location'))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    _get_search_address_batch_initial.metadata = {'url': '/search/address/batch/{format}'}  # type: ignore

    async def begin_get_search_address_batch(
        self,
        batch_id: str,
        **kwargs
    ) -> AsyncLROPoller["models.SearchAddressBatchResult"]:
        """**Search Address Batch API**

        **Applies to**\ : S1 pricing tier.

        The Search Address Batch API sends batches of queries to `Search Address API
        <https://docs.microsoft.com/rest/api/maps/search/getsearchaddress>`_ using just a single API
        call. You can call Search Address Batch API to run either asynchronously (async) or
        synchronously (sync). The async API allows caller to batch up to **10,000** queries and sync
        API up to **100** queries.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        .. code-block::

           POST https://atlas.microsoft.com/search/address/batch/sync/json?api-
        version=1.0&subscription-key={subscription-key}

        Submit Asynchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex search
        requests


        * It allows the retrieval of results in a separate call (multiple downloads are possible).
        * The asynchronous API is optimized for reliability and is not expected to run into a timeout.
        * The number of batch items is limited to **10,000** for this API.

        When you make a request by using async request, by default the service returns a 202 response
        code along a redirect URL in the Location field of the response header. This URL should be
        checked periodically until the response data or error information is available.
        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        Please note that asynchronous batch request is a long-running request. Here's a typical
        sequence of operations:


        #. Client sends a Search Address Batch ``POST`` request to Azure Maps
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request has been accepted.

              HTTP ``Error`` - There was an error processing your Batch request. This could either be a
        ``400 Bad Request`` or any other ``Error`` status code.


        #.
           If the batch request was accepted successfully, the ``Location`` header in the response
        contains the URL to download the results of the batch request.
            This status URI looks like following:

        .. code-block::

               GET https://atlas.microsoft.com/search/address/batch/{batch-id}?api-
        version=1.0&subscription-key={subscription-key}


        #. Client issues a ``GET`` request on the *download URL* obtained in Step 3 to download the
        batch results.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *search address* queries you will use a ``POST`` request where the request body
        will contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header will
        be set to ``application/json``. Here's a sample request body containing 5 *search address*
        queries:

        .. code-block:: json

           {
               "batchItems": [
                   {"query": "?query=400 Broad St, Seattle, WA 98109&limit=3"},
                   {"query": "?query=One, Microsoft Way, Redmond, WA 98052&limit=3"},
                   {"query": "?query=350 5th Ave, New York, NY 10118&limit=1"},
                   {"query": "?query=Pike Pl, Seattle, WA
        98101&lat=47.610970&lon=-122.342469&radius=1000"},
                   {"query": "?query=Champ de Mars, 5 Avenue Anatole France, 75007 Paris,
        France&limit=1"}
               ]
           }

        A *search address* query in a batch is just a partial URL *without* the protocol, base URL,
        path, api-version and subscription-key. It can accept any of the supported *search address*
        `URI parameters <https://docs.microsoft.com/rest/api/maps/search/getsearchaddress#uri-
        parameters>`_. The string values in the *search address* query must be properly escaped (e.g. "
        character should be escaped with ) and it should also be properly URL-encoded.

        The async API allows caller to batch up to **10,000** queries and sync API up to **100**
        queries, and the batch should contain at least **1** query.

        Download Asynchronous Batch Results
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To download the async batch results you will issue a ``GET`` request to the batch download
        endpoint. This *download URL* can be obtained from the ``Location`` header of a successful
        ``POST`` batch request and looks like the following:

        .. code-block::

           https://atlas.microsoft.com/search/address/batch/{batch-id}?api-version=1.0&subscription-
        key={subscription-key}

        Here's the typical sequence of operations for downloading the batch results:


        #. Client sends a ``GET`` request using the *download URL*.
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request was accepted but is still being processed. Please
        try again in some time.

              HTTP ``200 OK`` - Batch request successfully processed. The response body contains all
        the batch results.


        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\ i.e.
        queries which were executed successfully. The batch response also includes a ``batchItems``
        array which contains a response for each and every query in the batch request. The
        ``batchItems`` will contain the results in the exact same order the original queries were sent
        in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        *
          `\ ``SearchAddressResponse``
        <https://docs.microsoft.com/rest/api/maps/search/getsearchaddress#SearchAddressResponse>`_ - If
        the query completed successfully.

        *
          ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
        this case.

        Here's a sample Batch Response with 2 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 2,
                   "totalRequests": 3
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "query": "one microsoft way redmond wa 98052"
                           },
                           "results": [
                               {
                                   "position": {
                                       "lat": 47.63989,
                                       "lon": -122.12509
                                   }
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "query": "pike pl seattle wa 98101"
                           },
                           "results": [
                               {
                                   "position": {
                                       "lat": 47.60963,
                                       "lon": -122.34215
                                   }
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message": "Bad request: one or more parameters were incorrectly
        specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }.

        :param batch_id: Batch id for querying the operation.
        :type batch_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: True for ARMPolling, False for no polling, or a
         polling object for personal polling strategy
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either SearchAddressBatchResult or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.maps.search.models.SearchAddressBatchResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', False)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["models.SearchAddressBatchResult"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._get_search_address_batch_initial(
                batch_id=batch_id,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize('SearchAddressBatchResult', pipeline_response)

            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            'format': self._serialize.url("batch_id", batch_id, 'str'),
        }

        if polling is True: polling_method = AsyncLROBasePolling(lro_delay, lro_options={'final-state-via': 'original-uri'}, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_get_search_address_batch.metadata = {'url': '/search/address/batch/{format}'}  # type: ignore

    async def reverse_search_address_batch_sync(
        self,
        batch_request: "models.BatchRequest",
        format: Union[str, "models.JsonFormat"] = "json",
        **kwargs
    ) -> "models.ReverseSearchAddressBatchProcessResult":
        """**Search Address Reverse Batch API**

        **Applies to**\ : S1 pricing tier.

        The Search Address Batch API sends batches of queries to `Search Address Reverse API
        <https://docs.microsoft.com/rest/api/maps/search/getsearchaddressreverse>`_ using just a single
        API call. You can call Search Address Reverse Batch API to run either asynchronously (async) or
        synchronously (sync). The async API allows caller to batch up to **10,000** queries and sync
        API up to **100** queries.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        .. code-block::

           POST https://atlas.microsoft.com/search/address/reverse/batch/sync/json?api-
        version=1.0&subscription-key={subscription-key}

        Submit Asynchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex search
        requests


        * It allows the retrieval of results in a separate call (multiple downloads are possible).
        * The asynchronous API is optimized for reliability and is not expected to run into a timeout.
        * The number of batch items is limited to **10,000** for this API.

        When you make a request by using async request, by default the service returns a 202 response
        code along a redirect URL in the Location field of the response header. This URL should be
        checked periodically until the response data or error information is available.
        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        Please note that asynchronous batch request is a long-running request. Here's a typical
        sequence of operations:


        #. Client sends a Search Address Batch ``POST`` request to Azure Maps
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request has been accepted.

              HTTP ``Error`` - There was an error processing your Batch request. This could either be a
        ``400 Bad Request`` or any other ``Error`` status code.


        #.
           If the batch request was accepted successfully, the ``Location`` header in the response
        contains the URL to download the results of the batch request.
            This status URI looks like following:

        .. code-block::

               GET https://atlas.microsoft.com/search/address/reverse/batch/{batch-id}?api-
        version=1.0&subscription-key={subscription-key}


        #. Client issues a ``GET`` request on the *download URL* obtained in Step 3 to download the
        batch results.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *search address reverse* queries you will use a ``POST`` request where the request
        body will contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header
        will be set to ``application/json``. Here's a sample request body containing 5 *search address
        reverse* queries:

        .. code-block:: json

           {
               "batchItems": [
                   {"query": "?query=48.858561,2.294911"},
                   {"query": "?query=47.639765,-122.127896&radius=5000&limit=2"},
                   {"query": "?query=47.621028,-122.348170"},
                   {"query": "?query=43.722990,10.396695"},
                   {"query": "?query=40.750958,-73.982336"}
               ]
           }

        A *search address reverse* query in a batch is just a partial URL *without* the protocol, base
        URL, path, api-version and subscription-key. It can accept any of the supported *search address
        reverse* `URI parameters
        <https://docs.microsoft.com/rest/api/maps/search/getsearchaddressreverse#uri-parameters>`_. The
        string values in the *search address reverse* query must be properly escaped (e.g. " character
        should be escaped with ) and it should also be properly URL-encoded.

        The async API allows caller to batch up to **10,000** queries and sync API up to **100**
        queries, and the batch should contain at least **1** query.

        Download Asynchronous Batch Results
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To download the async batch results you will issue a ``GET`` request to the batch download
        endpoint. This *download URL* can be obtained from the ``Location`` header of a successful
        ``POST`` batch request and looks like the following:

        .. code-block::

           https://atlas.microsoft.com/search/address/reverse/batch/{batch-id}?api-
        version=1.0&subscription-key={subscription-key}

        Here's the typical sequence of operations for downloading the batch results:


        #. Client sends a ``GET`` request using the *download URL*.
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request was accepted but is still being processed. Please
        try again in some time.

              HTTP ``200 OK`` - Batch request successfully processed. The response body contains all
        the batch results.


        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\ i.e.
        queries which were executed successfully. The batch response also includes a ``batchItems``
        array which contains a response for each and every query in the batch request. The
        ``batchItems`` will contain the results in the exact same order the original queries were sent
        in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        *
          `\ ``SearchAddressReverseResponse``
        <https://docs.microsoft.com/rest/api/maps/search/getsearchaddressreverse#searchaddressreverseresponse>`_
        - If the query completed successfully.

        *
          ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
        this case.

        Here's a sample Batch Response with 2 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 2,
                   "totalRequests": 3
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "queryTime": 11
                           },
                           "addresses": [
                               {
                                   "address": {
                                       "country": "France",
                                       "freeformAddress": "Avenue Anatole France, 75007 Paris"
                                   },
                                   "position": "48.858490,2.294820"
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "queryTime": 1
                           },
                           "addresses": [
                               {
                                   "address": {
                                       "country": "United States of America",
                                       "freeformAddress": "157th Pl NE, Redmond WA 98052"
                                   },
                                   "position": "47.640470,-122.129430"
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message": "Bad request: one or more parameters were incorrectly
        specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }.

        :param batch_request: The list of reverse geocoding queries/requests to process. The list can
         contain  a max of 10,000 queries and must contain at least 1 query.
        :type batch_request: ~azure.maps.search.models.BatchRequest
        :param format: Desired format of the response. Only ``json`` format is supported.
        :type format: str or ~azure.maps.search.models.JsonFormat
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ReverseSearchAddressBatchProcessResult, or the result of cls(response)
        :rtype: ~azure.maps.search.models.ReverseSearchAddressBatchProcessResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.ReverseSearchAddressBatchProcessResult"]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            408: lambda response: HttpResponseError(response=response, model=self._deserialize(models.ErrorResponse, response)),
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.reverse_search_address_batch_sync.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(batch_request, 'BatchRequest')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('ReverseSearchAddressBatchProcessResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    reverse_search_address_batch_sync.metadata = {'url': '/search/address/reverse/batch/sync/{format}'}  # type: ignore

    async def _reverse_search_address_batch_initial(
        self,
        batch_request: "models.BatchRequest",
        format: Union[str, "models.JsonFormat"] = "json",
        **kwargs
    ) -> Optional["models.ReverseSearchAddressBatchProcessResult"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["models.ReverseSearchAddressBatchProcessResult"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self._reverse_search_address_batch_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(batch_request, 'BatchRequest')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('ReverseSearchAddressBatchProcessResult', pipeline_response)

        if response.status_code == 202:
            response_headers['Location']=self._deserialize('str', response.headers.get('Location'))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    _reverse_search_address_batch_initial.metadata = {'url': '/search/address/reverse/batch/{format}'}  # type: ignore

    async def begin_reverse_search_address_batch(
        self,
        batch_request: "models.BatchRequest",
        format: Union[str, "models.JsonFormat"] = "json",
        **kwargs
    ) -> AsyncLROPoller["models.ReverseSearchAddressBatchProcessResult"]:
        """**Search Address Reverse Batch API**

        **Applies to**\ : S1 pricing tier.

        The Search Address Batch API sends batches of queries to `Search Address Reverse API
        <https://docs.microsoft.com/rest/api/maps/search/getsearchaddressreverse>`_ using just a single
        API call. You can call Search Address Reverse Batch API to run either asynchronously (async) or
        synchronously (sync). The async API allows caller to batch up to **10,000** queries and sync
        API up to **100** queries.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        .. code-block::

           POST https://atlas.microsoft.com/search/address/reverse/batch/sync/json?api-
        version=1.0&subscription-key={subscription-key}

        Submit Asynchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex search
        requests


        * It allows the retrieval of results in a separate call (multiple downloads are possible).
        * The asynchronous API is optimized for reliability and is not expected to run into a timeout.
        * The number of batch items is limited to **10,000** for this API.

        When you make a request by using async request, by default the service returns a 202 response
        code along a redirect URL in the Location field of the response header. This URL should be
        checked periodically until the response data or error information is available.
        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        Please note that asynchronous batch request is a long-running request. Here's a typical
        sequence of operations:


        #. Client sends a Search Address Batch ``POST`` request to Azure Maps
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request has been accepted.

              HTTP ``Error`` - There was an error processing your Batch request. This could either be a
        ``400 Bad Request`` or any other ``Error`` status code.


        #.
           If the batch request was accepted successfully, the ``Location`` header in the response
        contains the URL to download the results of the batch request.
            This status URI looks like following:

        .. code-block::

               GET https://atlas.microsoft.com/search/address/reverse/batch/{batch-id}?api-
        version=1.0&subscription-key={subscription-key}


        #. Client issues a ``GET`` request on the *download URL* obtained in Step 3 to download the
        batch results.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *search address reverse* queries you will use a ``POST`` request where the request
        body will contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header
        will be set to ``application/json``. Here's a sample request body containing 5 *search address
        reverse* queries:

        .. code-block:: json

           {
               "batchItems": [
                   {"query": "?query=48.858561,2.294911"},
                   {"query": "?query=47.639765,-122.127896&radius=5000&limit=2"},
                   {"query": "?query=47.621028,-122.348170"},
                   {"query": "?query=43.722990,10.396695"},
                   {"query": "?query=40.750958,-73.982336"}
               ]
           }

        A *search address reverse* query in a batch is just a partial URL *without* the protocol, base
        URL, path, api-version and subscription-key. It can accept any of the supported *search address
        reverse* `URI parameters
        <https://docs.microsoft.com/rest/api/maps/search/getsearchaddressreverse#uri-parameters>`_. The
        string values in the *search address reverse* query must be properly escaped (e.g. " character
        should be escaped with ) and it should also be properly URL-encoded.

        The async API allows caller to batch up to **10,000** queries and sync API up to **100**
        queries, and the batch should contain at least **1** query.

        Download Asynchronous Batch Results
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To download the async batch results you will issue a ``GET`` request to the batch download
        endpoint. This *download URL* can be obtained from the ``Location`` header of a successful
        ``POST`` batch request and looks like the following:

        .. code-block::

           https://atlas.microsoft.com/search/address/reverse/batch/{batch-id}?api-
        version=1.0&subscription-key={subscription-key}

        Here's the typical sequence of operations for downloading the batch results:


        #. Client sends a ``GET`` request using the *download URL*.
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request was accepted but is still being processed. Please
        try again in some time.

              HTTP ``200 OK`` - Batch request successfully processed. The response body contains all
        the batch results.


        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\ i.e.
        queries which were executed successfully. The batch response also includes a ``batchItems``
        array which contains a response for each and every query in the batch request. The
        ``batchItems`` will contain the results in the exact same order the original queries were sent
        in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        *
          `\ ``SearchAddressReverseResponse``
        <https://docs.microsoft.com/rest/api/maps/search/getsearchaddressreverse#searchaddressreverseresponse>`_
        - If the query completed successfully.

        *
          ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
        this case.

        Here's a sample Batch Response with 2 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 2,
                   "totalRequests": 3
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "queryTime": 11
                           },
                           "addresses": [
                               {
                                   "address": {
                                       "country": "France",
                                       "freeformAddress": "Avenue Anatole France, 75007 Paris"
                                   },
                                   "position": "48.858490,2.294820"
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "queryTime": 1
                           },
                           "addresses": [
                               {
                                   "address": {
                                       "country": "United States of America",
                                       "freeformAddress": "157th Pl NE, Redmond WA 98052"
                                   },
                                   "position": "47.640470,-122.129430"
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message": "Bad request: one or more parameters were incorrectly
        specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }.

        :param batch_request: The list of reverse geocoding queries/requests to process. The list can
         contain  a max of 10,000 queries and must contain at least 1 query.
        :type batch_request: ~azure.maps.search.models.BatchRequest
        :param format: Desired format of the response. Only ``json`` format is supported.
        :type format: str or ~azure.maps.search.models.JsonFormat
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: True for ARMPolling, False for no polling, or a
         polling object for personal polling strategy
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either ReverseSearchAddressBatchProcessResult or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.maps.search.models.ReverseSearchAddressBatchProcessResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', False)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["models.ReverseSearchAddressBatchProcessResult"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._reverse_search_address_batch_initial(
                batch_request=batch_request,
                format=format,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize('ReverseSearchAddressBatchProcessResult', pipeline_response)

            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            'format': self._serialize.url("format", format, 'str'),
        }

        if polling is True: polling_method = AsyncLROBasePolling(lro_delay, lro_options={'final-state-via': 'location'}, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_reverse_search_address_batch.metadata = {'url': '/search/address/reverse/batch/{format}'}  # type: ignore

    async def _get_reverse_search_address_batch_initial(
        self,
        batch_id: str,
        **kwargs
    ) -> Optional["models.ReverseSearchAddressBatchProcessResult"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["models.ReverseSearchAddressBatchProcessResult"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "1.0"
        accept = "application/json"

        # Construct URL
        url = self._get_reverse_search_address_batch_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'format': self._serialize.url("batch_id", batch_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if self._config.client_id is not None:
            header_parameters['x-ms-client-id'] = self._serialize.header("self._config.client_id", self._config.client_id, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('ReverseSearchAddressBatchProcessResult', pipeline_response)

        if response.status_code == 202:
            response_headers['Location']=self._deserialize('str', response.headers.get('Location'))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    _get_reverse_search_address_batch_initial.metadata = {'url': '/search/address/reverse/batch/{format}'}  # type: ignore

    async def begin_get_reverse_search_address_batch(
        self,
        batch_id: str,
        **kwargs
    ) -> AsyncLROPoller["models.ReverseSearchAddressBatchProcessResult"]:
        """**Search Address Reverse Batch API**

        **Applies to**\ : S1 pricing tier.

        The Search Address Batch API sends batches of queries to `Search Address Reverse API
        <https://docs.microsoft.com/rest/api/maps/search/getsearchaddressreverse>`_ using just a single
        API call. You can call Search Address Reverse Batch API to run either asynchronously (async) or
        synchronously (sync). The async API allows caller to batch up to **10,000** queries and sync
        API up to **100** queries.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        .. code-block::

           POST https://atlas.microsoft.com/search/address/reverse/batch/sync/json?api-
        version=1.0&subscription-key={subscription-key}

        Submit Asynchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Asynchronous API is appropriate for processing big volumes of relatively complex search
        requests


        * It allows the retrieval of results in a separate call (multiple downloads are possible).
        * The asynchronous API is optimized for reliability and is not expected to run into a timeout.
        * The number of batch items is limited to **10,000** for this API.

        When you make a request by using async request, by default the service returns a 202 response
        code along a redirect URL in the Location field of the response header. This URL should be
        checked periodically until the response data or error information is available.
        The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response
        if used after the expiration period.

        Please note that asynchronous batch request is a long-running request. Here's a typical
        sequence of operations:


        #. Client sends a Search Address Batch ``POST`` request to Azure Maps
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request has been accepted.

              HTTP ``Error`` - There was an error processing your Batch request. This could either be a
        ``400 Bad Request`` or any other ``Error`` status code.


        #.
           If the batch request was accepted successfully, the ``Location`` header in the response
        contains the URL to download the results of the batch request.
            This status URI looks like following:

        .. code-block::

               GET https://atlas.microsoft.com/search/address/reverse/batch/{batch-id}?api-
        version=1.0&subscription-key={subscription-key}


        #. Client issues a ``GET`` request on the *download URL* obtained in Step 3 to download the
        batch results.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *search address reverse* queries you will use a ``POST`` request where the request
        body will contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header
        will be set to ``application/json``. Here's a sample request body containing 5 *search address
        reverse* queries:

        .. code-block:: json

           {
               "batchItems": [
                   {"query": "?query=48.858561,2.294911"},
                   {"query": "?query=47.639765,-122.127896&radius=5000&limit=2"},
                   {"query": "?query=47.621028,-122.348170"},
                   {"query": "?query=43.722990,10.396695"},
                   {"query": "?query=40.750958,-73.982336"}
               ]
           }

        A *search address reverse* query in a batch is just a partial URL *without* the protocol, base
        URL, path, api-version and subscription-key. It can accept any of the supported *search address
        reverse* `URI parameters
        <https://docs.microsoft.com/rest/api/maps/search/getsearchaddressreverse#uri-parameters>`_. The
        string values in the *search address reverse* query must be properly escaped (e.g. " character
        should be escaped with ) and it should also be properly URL-encoded.

        The async API allows caller to batch up to **10,000** queries and sync API up to **100**
        queries, and the batch should contain at least **1** query.

        Download Asynchronous Batch Results
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To download the async batch results you will issue a ``GET`` request to the batch download
        endpoint. This *download URL* can be obtained from the ``Location`` header of a successful
        ``POST`` batch request and looks like the following:

        .. code-block::

           https://atlas.microsoft.com/search/address/reverse/batch/{batch-id}?api-
        version=1.0&subscription-key={subscription-key}

        Here's the typical sequence of operations for downloading the batch results:


        #. Client sends a ``GET`` request using the *download URL*.
        #.
           The server will respond with one of the following:

           ..

              HTTP ``202 Accepted`` - Batch request was accepted but is still being processed. Please
        try again in some time.

              HTTP ``200 OK`` - Batch request successfully processed. The response body contains all
        the batch results.


        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The returned data content is similar for async and sync requests. When downloading the results
        of an async batch request, if the batch has finished processing, the response body contains the
        batch response. This batch response contains a ``summary`` component that indicates the
        ``totalRequests`` that were part of the original batch request and ``successfulRequests``\ i.e.
        queries which were executed successfully. The batch response also includes a ``batchItems``
        array which contains a response for each and every query in the batch request. The
        ``batchItems`` will contain the results in the exact same order the original queries were sent
        in the batch request. Each item in ``batchItems`` contains ``statusCode`` and ``response``
        fields. Each ``response`` in ``batchItems`` is of one of the following types:


        *
          `\ ``SearchAddressReverseResponse``
        <https://docs.microsoft.com/rest/api/maps/search/getsearchaddressreverse#searchaddressreverseresponse>`_
        - If the query completed successfully.

        *
          ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in
        this case.

        Here's a sample Batch Response with 2 *successful* and 1 *failed* result:

        .. code-block:: json

           {
               "summary": {
                   "successfulRequests": 2,
                   "totalRequests": 3
               },
               "batchItems": [
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "queryTime": 11
                           },
                           "addresses": [
                               {
                                   "address": {
                                       "country": "France",
                                       "freeformAddress": "Avenue Anatole France, 75007 Paris"
                                   },
                                   "position": "48.858490,2.294820"
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 200,
                       "response":
                       {
                           "summary": {
                               "queryTime": 1
                           },
                           "addresses": [
                               {
                                   "address": {
                                       "country": "United States of America",
                                       "freeformAddress": "157th Pl NE, Redmond WA 98052"
                                   },
                                   "position": "47.640470,-122.129430"
                               }
                           ]
                       }
                   },
                   {
                       "statusCode": 400,
                       "response":
                       {
                           "error":
                           {
                               "code": "400 BadRequest",
                               "message": "Bad request: one or more parameters were incorrectly
        specified or are mutually exclusive."
                           }
                       }
                   }
               ]
           }.

        :param batch_id: Batch id for querying the operation.
        :type batch_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: True for ARMPolling, False for no polling, or a
         polling object for personal polling strategy
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either ReverseSearchAddressBatchProcessResult or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.maps.search.models.ReverseSearchAddressBatchProcessResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', False)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["models.ReverseSearchAddressBatchProcessResult"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._get_reverse_search_address_batch_initial(
                batch_id=batch_id,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize('ReverseSearchAddressBatchProcessResult', pipeline_response)

            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            'format': self._serialize.url("batch_id", batch_id, 'str'),
        }

        if polling is True: polling_method = AsyncLROBasePolling(lro_delay, lro_options={'final-state-via': 'original-uri'}, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_get_reverse_search_address_batch.metadata = {'url': '/search/address/reverse/batch/{format}'}  # type: ignore
