# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AlertSeverity(with_metaclass(_CaseInsensitiveEnumMeta, float, Enum)):
    """Severity of the alert. Should be an integer between [0-4]. Value of 0 is severest
    """

    ZERO = 0
    ONE = 1
    TWO = 2
    THREE = 3
    FOUR = 4

class ConditionOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The criteria operator.
    """

    EQUALS = "Equals"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"

class DimensionOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Operator for dimension values
    """

    INCLUDE = "Include"
    EXCLUDE = "Exclude"

class TimeAggregation(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Aggregation type
    """

    COUNT = "Count"
    AVERAGE = "Average"
    MINIMUM = "Minimum"
    MAXIMUM = "Maximum"
    TOTAL = "Total"
