# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CheckNameAvailabilityInput(Model):
    """The request body for CheckNameAvailability API.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param name: The name of the resource. A name must be globally unique.
    :type name: str
    :ivar type: The type of the resource - mediaservices. Default value:
     "mediaservices" .
    :vartype type: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 24, 'min_length': 3, 'pattern': r'^[a-z0-9]{3,24}$'},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "mediaservices"

    def __init__(self, name):
        self.name = name
