sub packet_payload__binary2mixed($)
{
	my $binary = shift;

	my $output = "<pre>";

	while( $binary )
	{
		my $bin_line;
		if ( length( $binary ) <= 16 )
		{
			$bin_line = $binary;
			$binary = '';
		}
		else
		{
			$bin_line = substr( $binary, 0, 16 );
			$binary = substr( $binary, 16, length( $binary ) - 16 );
		}

		my $hex_line = '';
		my $ascii_line = '';
		for( my $i = 0; $i < length( $bin_line ) ; $i ++ )
		{
			my $char = substr( $bin_line, $i, 1 );
			$hex_line .= sprintf( "%02X " , ord( $char ) );
			if ( $i and ! ( ( $i + 1 ) % 4 ) ) { $hex_line .=' '; };

			if ( ( ord( $char ) < 32 ) or ( ord( $char ) > 127 ) ) { $char = '.'; };

			$ascii_line .= $char;
		}
		for( my $i = length( $bin_line ) ; $i < 16 ; $i ++ )
		{
			$hex_line .= '.. ';
			if ( $i and ! ( ( $i + 1 ) % 4 ) ) { $hex_line .=' '; };
		}

		$output .= "$hex_line | $ascii_line\n";
	}

	$output .= "</pre>";

	return $output;
}

sub packet_payload__ascii_only($)
{
	my $binary = shift;

	my $output = '';

	for( my $i = 0; $i < length( $binary ) ; $i ++ )
	{
		my $char = substr( $binary, $i, 1 );
		my $ord = ord( $char );

		if ( ( ( $ord >= 32 ) and ( $ord <= 127 ) ) or ( $char =~ m/\r|\n/ ) )
		{
			$output .= $char;
		}
		else
		{
			$output .= '.';
		}
	}

	$output =~ s/(.{80})/$1 <=\n/g;

	$output =~ s/</&lt;/;
	$output =~ s/>/&gt;/;

	$output = "<pre>$output</pre>";

	return $output;
}

sub AlertDetail_Transform_Add_data($$)
{
	my $meaning = shift;
	my $data = shift;

	if ( $meaning ne 'Payload Hexadecimal Dump' )
	{
		if ( $meaning ne 'Packet Payload' )
		{
			if ( ( $meaning eq 'Passive OS Fingerprint' ) and $conf{'ettercap_fp_db'} )
			{
				if ( -f $conf{'ettercap_fp_db'} )
				{
					$data = getosbyfingerprint( $data );
				}
				else
				{
					error( "ettercap OS fingerprint DB not found : $conf{'ettercap_fp_db'}" );
				}
			}
			else
			{
				if ( $meaning eq 'Ethernet header' )
				{
					$data = '<font size=1>'.Packet_Ethernet( $data, 'STD' ).'</font>';
				}
				else
				{
					$data =~ s/\n/<br>\n/g;
				}
			}
			AlertDetail_Display_Add_data( $meaning, $data );
		}
		else
		{
			AlertDetail_Display_Add_data( $meaning.' - Hexadecimal Dump', packet_payload__binary2mixed( $data ) );
			AlertDetail_Display_Add_data( $meaning.' - ASCII only Dump', packet_payload__ascii_only( $data ) );
		}
	}
	else
	{
		$data =~ s/</&lt;/g;
		$data =~ s/>/&gt;/g;

		my $Mixed = "<br>\n<pre>$data</pre>";

		my $ASCII = '';
		foreach my $Line ( split( /\n/, $data ) )
		{
			my $HEX = substr( $Line, 0, 50 );
			foreach my $Byte ( split( /\s+/, $HEX ) )
			{
				my $dec = hex( $Byte );
				my $char = chr( $dec );
				$char =~ s/\r//g;
				$char =~ s/\n/<br>/g;
				if ( $char and ( $char ne '<br>' ) and ( ( $dec < 32 ) or ( $dec > 127 ) ) )
				{
					$char = '.';
				}
				else
				{
					if ( $char ne '<br>' )
					{
						$char =~ s/</&lt;/g;
						$char =~ s/>/&gt;/g;
					}
				}
				$ASCII .= $char;
			}
		}

		my $NewASCII = '';
		foreach my $line ( split( /<br>/, $ASCII ) )
		{
			$line =~ s/(.{80})/$1<br>/g;
			$NewASCII .= $line.'<br>';
		}

		AlertDetail_Display_Add_data( 'Payload Hexadecimal Dump', $Mixed );
		AlertDetail_Display_Add_data( 'Payload ASCII only Dump', $NewASCII );
	}
}

sub AlertDetail_Display_Add_data($$)
{
	my $meaning = shift;
	my $data = shift;

	my @styles = ( 'even', 'odd' );
	my $skin = $styles[$cnt % 2];

	print "  <tr>";
	print "<td class=\"$skin\" width=25%><b>$meaning</b></td>";
	print "<td class=\"$skin\">$data</td>";
	print "</tr>\n";

	$cnt ++;
}

sub getosbyfingerprint($)
{
	my $OSfingerprint = shift;

	my $OSname = 'unknown OS fingerprint : '.$OSfingerprint;

	local *OS_FINGERPRINT_DB;
	undef $!;
	open( OS_FINGERPRINT_DB, $conf{'ettercap_fp_db'} );
	if ( $! and ( $! !~ m/Inappropriate ioctl for device/i ) )
	{
		error( "Error opening ettercap fingerprint DB : $!" );
		return $OSfingerprint;
	}
	my $found = 0;
	while( ! $found and ( my $Line = <OS_FINGERPRINT_DB> ) )
	{
		# 16D0:05B4:40:00:0:1:1:0:S:30:Mandrake 8.2
		if ( $Line =~ m/^$OSfingerprint:(.*)[\r|\n]+$/i )
		{
			$OSname = "$1 ($OSfingerprint)";
			$found = 1;
		}
	}
	close( OS_FINGERPRINT_DB );

	return $OSname
}

sub ExtURL($)
{
	my $URL = shift;

	return "<a target=\"_blank\" href=\"redirect.pl?url=".url_encode( $URL )."\">$URL</a>";
}

1;
