sub AlertList_otfFilt_Class_name()
{
	my @Results = get_Data( 'Alert/Classification', $AlertId, '' );

	my %Res = get_DataLine( \@Results, 1 );
	my $name = $Res{'name'};

	if ( $name )
	{
		if ( ! $cgi->param( 'timelimit' ) ) {$cgi->param( 'timelimit', '10Y' );};

		print "<a href=\"Filters".$conf{'extension'}.'?load=';
		print url_encode( 'defaults/eqClassification.name' );
		print '&amp;valA='.url_encode( $name );
		print '&amp;timelimit='.$cgi->param( 'timelimit' );
		print "\">".$name.'</a>';
	}
	else
	{
		print 'n/a';
	}
}

sub AlertList_otfFilt_Impa_sev($)
{
	my $Type = shift;

	my $Severity = get( 'Alert/Impact.severity' );

	if ( $Severity )
	{
		print "<a href=\"Filters".$conf{'extension'}.'?load='.url_encode( 'defaults/eqImpact.severity' );
		print '&amp;valA='.$Severity;
		print '&amp;timelimit='.$cgi->param( 'timelimit' );
		print "\" class=\"sev_".substr( $Severity, 0, 3 )."\">";
		if ( $Type eq 'Img' )
		{
			print "<img src=\"images/".$Severity.".gif\" border=\"0\" alt=\"\">";
		}
		else
		{
			print $Severity;
		}
		print "</a>";
	}
}

sub AlertList_otfFilt_Impa_completion()
{
	my $completion = get( 'Alert/Impact.completion' );

	if ( $completion )
	{
		print "<a href=\"Filters".$conf{'extension'}.'?load='.url_encode( 'defaults/eqImpact.completion' );
		print '&amp;valA='.$completion;
		print '&amp;timelimit='.$cgi->param( 'timelimit' );
		print "\">".$completion.'</a>';
	}
	else
	{
		print 'n/a';
	}
}

sub AlertList_otfFilt_Ana_model()
{
	my $model = get( 'Alert/Analyzer.model' );

	print "<a href=\"Filters".$conf{'extension'}.'?load='.url_encode( 'defaults/eqAnalyzer.model' );
	print '&amp;valA='.$model;
	print '&amp;timelimit='.$cgi->param( 'timelimit' );

	$model =~ s/^Log Monitoring Lackey$/LML/;

	print "\">".$model.'</a>';
}

sub AlertList_otfFilt_Ana_class()
{
	my $class = get( 'Alert/Analyzer.class' );

	print "<a href=\"Filters".$conf{'extension'}.'?load='.url_encode( 'defaults/eqAnalyzer.class' );
	print '&amp;valA='.$class;
	print '&amp;timelimit='.$cgi->param( 'timelimit' );

	$class =~ s/[Hh]ost\s+/H/;
	$class =~ s/[Nn]etwork\s+/N/;
	$class =~ s/[Bb]ased\s+//;
	$class =~ s/[Ii]ntrusion [Dd]etection [Ss]ystem/IDS/;

	print "\">".$class.'</a>';
}

sub AlertList_otfFilt_Serv_proto($)
{
	my $Type = shift;

	if ( $Type ne 'Source' ) {$Type = 'Target';};
	my $Protocol = get( 'Alert/'.lc( $Type ).'/Service.protocol' );
	if ( $Protocol and ( $Protocol ne '-' ) )
	{
		print "<a href=\"Filters".$conf{'extension'}.'?load='.url_encode( 'defaults/eqService.protocol' );
		print '&amp;valA='.$Protocol;
		print '&amp;timelimit='.$cgi->param( 'timelimit' );
		print "\">".$Protocol.'</a>';
	}
	else
	{
		print 'unknown';
	}
}

sub AlertList_Get_Addr_and_Port($$)
{
	my $Type = shift;
	my $ShowService = shift;

	if ( ! $cgi->param( 'timelimit' ) ) {$cgi->param( 'timelimit', '1D' );};

	if ( $Type ne 'Source' ) {$Type = 'Target';};

	my $Address = get( 'Alert/'.lc( $Type ).'/Node/Address.address' );
	if ( $Address )
	{
		print "<a href=\"Filters".$conf{'extension'}.'?load='.url_encode( 'defaults/eqAddress.address' );
		print '&amp;valA='.url_encode( $Address );
		print '&amp;timelimit='.$cgi->param( 'timelimit' );
		print "\">".$Address.'</a>';
	}
	else
	{
		print 'unknown';
	}

	my $Port = get( 'Alert/'.lc( $Type ).'/Service.port' );
	if ( $Port )
	{
		print "&nbsp;<a href=\"Filters".$conf{'extension'}.'?load='.url_encode( 'defaults/eqService.port' );
		print '&amp;valA='.$Port;
		print '&amp;timelimit='.$cgi->param( 'timelimit' );
		print "\">".$Port.'</a>';

		my $Proto = lc( get( 'Alert/'.lc( $Type ).'/Service.protocol' ) );
		my ( $name, $aliases, $port, $proto ) = getservbyport( $Port, $Proto );

		print "/<a href=\"Filters".$conf{'extension'}.'?load='.url_encode( 'defaults/eqService.protocol' );
		print '&amp;valA='.$Proto;
		print '&amp;timelimit='.$cgi->param( 'timelimit' );
		print "\">".$Proto.'</a>';

		if ( $name )
		{
			print "&nbsp;(".$name.')&nbsp;';
		}
	}
}

1;
