/*
 * Copyright © 2012 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/**
 * \file piglit-util-compressed-grays.h
 *
 * This file contains pre-compressed representations of uniform
 * grayscale images in various texture compression formats, for use in
 * testing compressed textures.
 */

/**
 * Bit pattern representing each possible 8-bit grayscale value using
 * ETC1 compression.
 *
 * These bit patterns may also be used for the GL_COMPRESSED_RGB8_ETC2
 * format, because it is a superset of ETC1.
 */
static const unsigned char piglit_etc1_grayscale_blocks[256][8] = {
	{ 0, 0, 0, 0, 255, 255, 0, 0 }, /* 0 */
	{ 34, 34, 34, 216, 255, 255, 0, 0 }, /* 1 */
	{ 0, 0, 0, 0, 0, 0, 0, 0 }, /* 2 */
	{ 8, 8, 8, 38, 255, 255, 0, 0 }, /* 3 */
	{ 17, 17, 17, 108, 255, 255, 0, 0 }, /* 4 */
	{ 0, 0, 0, 36, 0, 0, 0, 0 }, /* 5 */
	{ 8, 8, 8, 2, 255, 255, 0, 0 }, /* 6 */
	{ 16, 16, 16, 74, 255, 255, 0, 0 }, /* 7 */
	{ 0, 0, 0, 0, 0, 0, 255, 255 }, /* 8 */
	{ 0, 0, 0, 72, 0, 0, 0, 0 }, /* 9 */
	{ 34, 34, 34, 180, 255, 255, 0, 0 }, /* 10 */
	{ 16, 16, 16, 38, 255, 255, 0, 0 }, /* 11 */
	{ 17, 17, 17, 36, 255, 255, 0, 0 }, /* 12 */
	{ 0, 0, 0, 108, 0, 0, 0, 0 }, /* 13 */
	{ 16, 16, 16, 2, 255, 255, 0, 0 }, /* 14 */
	{ 17, 17, 17, 0, 255, 255, 0, 0 }, /* 15 */
	{ 34, 34, 34, 144, 255, 255, 0, 0 }, /* 16 */
	{ 0, 0, 0, 36, 0, 0, 255, 255 }, /* 17 */
	{ 0, 0, 0, 144, 0, 0, 0, 0 }, /* 18 */
	{ 17, 17, 17, 0, 0, 0, 0, 0 }, /* 19 */
	{ 32, 32, 32, 110, 255, 255, 0, 0 }, /* 20 */
	{ 34, 34, 34, 108, 255, 255, 0, 0 }, /* 21 */
	{ 17, 17, 17, 36, 0, 0, 0, 0 }, /* 22 */
	{ 40, 40, 40, 146, 255, 255, 0, 0 }, /* 23 */
	{ 0, 0, 0, 180, 0, 0, 0, 0 }, /* 24 */
	{ 17, 17, 17, 0, 0, 0, 255, 255 }, /* 25 */
	{ 17, 17, 17, 72, 0, 0, 0, 0 }, /* 26 */
	{ 51, 51, 51, 180, 255, 255, 0, 0 }, /* 27 */
	{ 32, 32, 32, 38, 255, 255, 0, 0 }, /* 28 */
	{ 0, 0, 0, 72, 0, 0, 255, 255 }, /* 29 */
	{ 17, 17, 17, 108, 0, 0, 0, 0 }, /* 30 */
	{ 32, 32, 32, 2, 255, 255, 0, 0 }, /* 31 */
	{ 34, 34, 34, 0, 255, 255, 0, 0 }, /* 32 */
	{ 0, 0, 0, 216, 0, 0, 0, 0 }, /* 33 */
	{ 17, 17, 17, 36, 0, 0, 255, 255 }, /* 34 */
	{ 17, 17, 17, 144, 0, 0, 0, 0 }, /* 35 */
	{ 34, 34, 34, 0, 0, 0, 0, 0 }, /* 36 */
	{ 8, 8, 8, 74, 0, 0, 255, 255 }, /* 37 */
	{ 51, 51, 51, 108, 255, 255, 0, 0 }, /* 38 */
	{ 34, 34, 34, 36, 0, 0, 0, 0 }, /* 39 */
	{ 16, 16, 16, 182, 0, 0, 0, 0 }, /* 40 */
	{ 17, 17, 17, 180, 0, 0, 0, 0 }, /* 41 */
	{ 0, 0, 0, 108, 0, 0, 255, 255 }, /* 42 */
	{ 34, 34, 34, 72, 0, 0, 0, 0 }, /* 43 */
	{ 68, 68, 68, 180, 255, 255, 0, 0 }, /* 44 */
	{ 16, 16, 16, 74, 0, 0, 255, 255 }, /* 45 */
	{ 17, 17, 17, 72, 0, 0, 255, 255 }, /* 46 */
	{ 0, 0, 0, 252, 0, 0, 0, 0 }, /* 47 */
	{ 24, 24, 24, 182, 0, 0, 0, 0 }, /* 48 */
	{ 51, 51, 51, 0, 255, 255, 0, 0 }, /* 49 */
	{ 17, 17, 17, 216, 0, 0, 0, 0 }, /* 50 */
	{ 34, 34, 34, 36, 0, 0, 255, 255 }, /* 51 */
	{ 34, 34, 34, 144, 0, 0, 0, 0 }, /* 52 */
	{ 51, 51, 51, 0, 0, 0, 0, 0 }, /* 53 */
	{ 40, 40, 40, 110, 0, 0, 0, 0 }, /* 54 */
	{ 68, 68, 68, 108, 255, 255, 0, 0 }, /* 55 */
	{ 51, 51, 51, 36, 0, 0, 0, 0 }, /* 56 */
	{ 24, 24, 24, 218, 0, 0, 0, 0 }, /* 57 */
	{ 34, 34, 34, 180, 0, 0, 0, 0 }, /* 58 */
	{ 17, 17, 17, 108, 0, 0, 255, 255 }, /* 59 */
	{ 0, 0, 0, 144, 0, 0, 255, 255 }, /* 60 */
	{ 85, 85, 85, 180, 255, 255, 0, 0 }, /* 61 */
	{ 32, 32, 32, 74, 0, 0, 255, 255 }, /* 62 */
	{ 34, 34, 34, 72, 0, 0, 255, 255 }, /* 63 */
	{ 17, 17, 17, 252, 0, 0, 0, 0 }, /* 64 */
	{ 40, 40, 40, 182, 0, 0, 0, 0 }, /* 65 */
	{ 68, 68, 68, 0, 255, 255, 0, 0 }, /* 66 */
	{ 34, 34, 34, 216, 0, 0, 0, 0 }, /* 67 */
	{ 51, 51, 51, 36, 0, 0, 255, 255 }, /* 68 */
	{ 51, 51, 51, 144, 0, 0, 0, 0 }, /* 69 */
	{ 68, 68, 68, 0, 0, 0, 0, 0 }, /* 70 */
	{ 24, 24, 24, 254, 0, 0, 0, 0 }, /* 71 */
	{ 85, 85, 85, 108, 255, 255, 0, 0 }, /* 72 */
	{ 68, 68, 68, 36, 0, 0, 0, 0 }, /* 73 */
	{ 40, 40, 40, 218, 0, 0, 0, 0 }, /* 74 */
	{ 51, 51, 51, 180, 0, 0, 0, 0 }, /* 75 */
	{ 34, 34, 34, 108, 0, 0, 255, 255 }, /* 76 */
	{ 17, 17, 17, 144, 0, 0, 255, 255 }, /* 77 */
	{ 102, 102, 102, 180, 255, 255, 0, 0 }, /* 78 */
	{ 64, 64, 64, 110, 0, 0, 0, 0 }, /* 79 */
	{ 0, 0, 0, 180, 0, 0, 255, 255 }, /* 80 */
	{ 34, 34, 34, 252, 0, 0, 0, 0 }, /* 81 */
	{ 48, 48, 48, 218, 0, 0, 0, 0 }, /* 82 */
	{ 85, 85, 85, 0, 255, 255, 0, 0 }, /* 83 */
	{ 51, 51, 51, 216, 0, 0, 0, 0 }, /* 84 */
	{ 68, 68, 68, 36, 0, 0, 255, 255 }, /* 85 */
	{ 68, 68, 68, 144, 0, 0, 0, 0 }, /* 86 */
	{ 85, 85, 85, 0, 0, 0, 0, 0 }, /* 87 */
	{ 8, 8, 8, 182, 0, 0, 255, 255 }, /* 88 */
	{ 102, 102, 102, 108, 255, 255, 0, 0 }, /* 89 */
	{ 85, 85, 85, 36, 0, 0, 0, 0 }, /* 90 */
	{ 48, 48, 48, 110, 0, 0, 255, 255 }, /* 91 */
	{ 68, 68, 68, 180, 0, 0, 0, 0 }, /* 92 */
	{ 51, 51, 51, 108, 0, 0, 255, 255 }, /* 93 */
	{ 34, 34, 34, 144, 0, 0, 255, 255 }, /* 94 */
	{ 119, 119, 119, 180, 255, 255, 0, 0 }, /* 95 */
	{ 16, 16, 16, 182, 0, 0, 255, 255 }, /* 96 */
	{ 17, 17, 17, 180, 0, 0, 255, 255 }, /* 97 */
	{ 51, 51, 51, 252, 0, 0, 0, 0 }, /* 98 */
	{ 56, 56, 56, 110, 0, 0, 255, 255 }, /* 99 */
	{ 102, 102, 102, 0, 255, 255, 0, 0 }, /* 100 */
	{ 68, 68, 68, 216, 0, 0, 0, 0 }, /* 101 */
	{ 85, 85, 85, 36, 0, 0, 255, 255 }, /* 102 */
	{ 85, 85, 85, 144, 0, 0, 0, 0 }, /* 103 */
	{ 102, 102, 102, 0, 0, 0, 0, 0 }, /* 104 */
	{ 104, 104, 104, 2, 255, 255, 0, 0 }, /* 105 */
	{ 0, 0, 0, 216, 0, 0, 255, 255 }, /* 106 */
	{ 102, 102, 102, 36, 0, 0, 0, 0 }, /* 107 */
	{ 64, 64, 64, 110, 0, 0, 255, 255 }, /* 108 */
	{ 85, 85, 85, 180, 0, 0, 0, 0 }, /* 109 */
	{ 68, 68, 68, 108, 0, 0, 255, 255 }, /* 110 */
	{ 51, 51, 51, 144, 0, 0, 255, 255 }, /* 111 */
	{ 136, 136, 136, 180, 255, 255, 0, 0 }, /* 112 */
	{ 32, 32, 32, 182, 0, 0, 255, 255 }, /* 113 */
	{ 34, 34, 34, 180, 0, 0, 255, 255 }, /* 114 */
	{ 68, 68, 68, 252, 0, 0, 0, 0 }, /* 115 */
	{ 72, 72, 72, 110, 0, 0, 255, 255 }, /* 116 */
	{ 119, 119, 119, 0, 255, 255, 0, 0 }, /* 117 */
	{ 85, 85, 85, 216, 0, 0, 0, 0 }, /* 118 */
	{ 102, 102, 102, 36, 0, 0, 255, 255 }, /* 119 */
	{ 102, 102, 102, 144, 0, 0, 0, 0 }, /* 120 */
	{ 119, 119, 119, 0, 0, 0, 0, 0 }, /* 121 */
	{ 16, 16, 16, 218, 0, 0, 255, 255 }, /* 122 */
	{ 17, 17, 17, 216, 0, 0, 255, 255 }, /* 123 */
	{ 119, 119, 119, 36, 0, 0, 0, 0 }, /* 124 */
	{ 104, 104, 104, 146, 0, 0, 0, 0 }, /* 125 */
	{ 102, 102, 102, 180, 0, 0, 0, 0 }, /* 126 */
	{ 85, 85, 85, 108, 0, 0, 255, 255 }, /* 127 */
	{ 68, 68, 68, 144, 0, 0, 255, 255 }, /* 128 */
	{ 153, 153, 153, 180, 255, 255, 0, 0 }, /* 129 */
	{ 24, 24, 24, 218, 0, 0, 255, 255 }, /* 130 */
	{ 51, 51, 51, 180, 0, 0, 255, 255 }, /* 131 */
	{ 85, 85, 85, 252, 0, 0, 0, 0 }, /* 132 */
	{ 112, 112, 112, 146, 0, 0, 0, 0 }, /* 133 */
	{ 136, 136, 136, 0, 255, 255, 0, 0 }, /* 134 */
	{ 102, 102, 102, 216, 0, 0, 0, 0 }, /* 135 */
	{ 119, 119, 119, 36, 0, 0, 255, 255 }, /* 136 */
	{ 119, 119, 119, 144, 0, 0, 0, 0 }, /* 137 */
	{ 136, 136, 136, 0, 0, 0, 0, 0 }, /* 138 */
	{ 32, 32, 32, 218, 0, 0, 255, 255 }, /* 139 */
	{ 34, 34, 34, 216, 0, 0, 255, 255 }, /* 140 */
	{ 136, 136, 136, 36, 0, 0, 0, 0 }, /* 141 */
	{ 80, 80, 80, 146, 0, 0, 255, 255 }, /* 142 */
	{ 119, 119, 119, 180, 0, 0, 0, 0 }, /* 143 */
	{ 102, 102, 102, 108, 0, 0, 255, 255 }, /* 144 */
	{ 85, 85, 85, 144, 0, 0, 255, 255 }, /* 145 */
	{ 170, 170, 170, 180, 255, 255, 0, 0 }, /* 146 */
	{ 40, 40, 40, 218, 0, 0, 255, 255 }, /* 147 */
	{ 68, 68, 68, 180, 0, 0, 255, 255 }, /* 148 */
	{ 102, 102, 102, 252, 0, 0, 0, 0 }, /* 149 */
	{ 88, 88, 88, 146, 0, 0, 255, 255 }, /* 150 */
	{ 153, 153, 153, 0, 255, 255, 0, 0 }, /* 151 */
	{ 119, 119, 119, 216, 0, 0, 0, 0 }, /* 152 */
	{ 136, 136, 136, 36, 0, 0, 255, 255 }, /* 153 */
	{ 136, 136, 136, 144, 0, 0, 0, 0 }, /* 154 */
	{ 153, 153, 153, 0, 0, 0, 0, 0 }, /* 155 */
	{ 120, 120, 120, 218, 0, 0, 0, 0 }, /* 156 */
	{ 51, 51, 51, 216, 0, 0, 255, 255 }, /* 157 */
	{ 153, 153, 153, 36, 0, 0, 0, 0 }, /* 158 */
	{ 96, 96, 96, 146, 0, 0, 255, 255 }, /* 159 */
	{ 136, 136, 136, 180, 0, 0, 0, 0 }, /* 160 */
	{ 119, 119, 119, 108, 0, 0, 255, 255 }, /* 161 */
	{ 102, 102, 102, 144, 0, 0, 255, 255 }, /* 162 */
	{ 187, 187, 187, 180, 255, 255, 0, 0 }, /* 163 */
	{ 136, 136, 136, 182, 0, 0, 0, 0 }, /* 164 */
	{ 85, 85, 85, 180, 0, 0, 255, 255 }, /* 165 */
	{ 119, 119, 119, 252, 0, 0, 0, 0 }, /* 166 */
	{ 104, 104, 104, 146, 0, 0, 255, 255 }, /* 167 */
	{ 170, 170, 170, 0, 255, 255, 0, 0 }, /* 168 */
	{ 136, 136, 136, 216, 0, 0, 0, 0 }, /* 169 */
	{ 153, 153, 153, 36, 0, 0, 255, 255 }, /* 170 */
	{ 153, 153, 153, 144, 0, 0, 0, 0 }, /* 171 */
	{ 170, 170, 170, 0, 0, 0, 0, 0 }, /* 172 */
	{ 136, 136, 136, 218, 0, 0, 0, 0 }, /* 173 */
	{ 68, 68, 68, 216, 0, 0, 255, 255 }, /* 174 */
	{ 170, 170, 170, 36, 0, 0, 0, 0 }, /* 175 */
	{ 176, 176, 176, 38, 255, 255, 0, 0 }, /* 176 */
	{ 153, 153, 153, 180, 0, 0, 0, 0 }, /* 177 */
	{ 136, 136, 136, 108, 0, 0, 255, 255 }, /* 178 */
	{ 119, 119, 119, 144, 0, 0, 255, 255 }, /* 179 */
	{ 204, 204, 204, 180, 255, 255, 0, 0 }, /* 180 */
	{ 144, 144, 144, 218, 0, 0, 0, 0 }, /* 181 */
	{ 102, 102, 102, 180, 0, 0, 255, 255 }, /* 182 */
	{ 0, 0, 0, 252, 0, 0, 255, 255 }, /* 183 */
	{ 184, 184, 184, 38, 255, 255, 0, 0 }, /* 184 */
	{ 187, 187, 187, 0, 255, 255, 0, 0 }, /* 185 */
	{ 153, 153, 153, 216, 0, 0, 0, 0 }, /* 186 */
	{ 170, 170, 170, 36, 0, 0, 255, 255 }, /* 187 */
	{ 170, 170, 170, 144, 0, 0, 0, 0 }, /* 188 */
	{ 187, 187, 187, 0, 0, 0, 0, 0 }, /* 189 */
	{ 144, 144, 144, 110, 0, 0, 255, 255 }, /* 190 */
	{ 85, 85, 85, 216, 0, 0, 255, 255 }, /* 191 */
	{ 187, 187, 187, 36, 0, 0, 0, 0 }, /* 192 */
	{ 192, 192, 192, 38, 255, 255, 0, 0 }, /* 193 */
	{ 170, 170, 170, 180, 0, 0, 0, 0 }, /* 194 */
	{ 153, 153, 153, 108, 0, 0, 255, 255 }, /* 195 */
	{ 136, 136, 136, 144, 0, 0, 255, 255 }, /* 196 */
	{ 221, 221, 221, 180, 255, 255, 0, 0 }, /* 197 */
	{ 152, 152, 152, 110, 0, 0, 255, 255 }, /* 198 */
	{ 119, 119, 119, 180, 0, 0, 255, 255 }, /* 199 */
	{ 17, 17, 17, 252, 0, 0, 255, 255 }, /* 200 */
	{ 200, 200, 200, 38, 255, 255, 0, 0 }, /* 201 */
	{ 204, 204, 204, 0, 255, 255, 0, 0 }, /* 202 */
	{ 170, 170, 170, 216, 0, 0, 0, 0 }, /* 203 */
	{ 187, 187, 187, 36, 0, 0, 255, 255 }, /* 204 */
	{ 187, 187, 187, 144, 0, 0, 0, 0 }, /* 205 */
	{ 204, 204, 204, 0, 0, 0, 0, 0 }, /* 206 */
	{ 24, 24, 24, 254, 0, 0, 255, 255 }, /* 207 */
	{ 102, 102, 102, 216, 0, 0, 255, 255 }, /* 208 */
	{ 204, 204, 204, 36, 0, 0, 0, 0 }, /* 209 */
	{ 176, 176, 176, 74, 0, 0, 255, 255 }, /* 210 */
	{ 187, 187, 187, 180, 0, 0, 0, 0 }, /* 211 */
	{ 170, 170, 170, 108, 0, 0, 255, 255 }, /* 212 */
	{ 153, 153, 153, 144, 0, 0, 255, 255 }, /* 213 */
	{ 238, 238, 238, 180, 255, 255, 0, 0 }, /* 214 */
	{ 168, 168, 168, 110, 0, 0, 255, 255 }, /* 215 */
	{ 136, 136, 136, 180, 0, 0, 255, 255 }, /* 216 */
	{ 34, 34, 34, 252, 0, 0, 255, 255 }, /* 217 */
	{ 184, 184, 184, 74, 0, 0, 255, 255 }, /* 218 */
	{ 221, 221, 221, 0, 255, 255, 0, 0 }, /* 219 */
	{ 187, 187, 187, 216, 0, 0, 0, 0 }, /* 220 */
	{ 204, 204, 204, 36, 0, 0, 255, 255 }, /* 221 */
	{ 204, 204, 204, 144, 0, 0, 0, 0 }, /* 222 */
	{ 221, 221, 221, 0, 0, 0, 0, 0 }, /* 223 */
	{ 40, 40, 40, 254, 0, 0, 255, 255 }, /* 224 */
	{ 119, 119, 119, 216, 0, 0, 255, 255 }, /* 225 */
	{ 221, 221, 221, 36, 0, 0, 0, 0 }, /* 226 */
	{ 192, 192, 192, 74, 0, 0, 255, 255 }, /* 227 */
	{ 204, 204, 204, 180, 0, 0, 0, 0 }, /* 228 */
	{ 187, 187, 187, 108, 0, 0, 255, 255 }, /* 229 */
	{ 170, 170, 170, 144, 0, 0, 255, 255 }, /* 230 */
	{ 255, 255, 255, 180, 255, 255, 0, 0 }, /* 231 */
	{ 48, 48, 48, 254, 0, 0, 255, 255 }, /* 232 */
	{ 153, 153, 153, 180, 0, 0, 255, 255 }, /* 233 */
	{ 51, 51, 51, 252, 0, 0, 255, 255 }, /* 234 */
	{ 200, 200, 200, 74, 0, 0, 255, 255 }, /* 235 */
	{ 238, 238, 238, 0, 255, 255, 0, 0 }, /* 236 */
	{ 204, 204, 204, 216, 0, 0, 0, 0 }, /* 237 */
	{ 221, 221, 221, 36, 0, 0, 255, 255 }, /* 238 */
	{ 221, 221, 221, 144, 0, 0, 0, 0 }, /* 239 */
	{ 238, 238, 238, 0, 0, 0, 0, 0 }, /* 240 */
	{ 176, 176, 176, 146, 0, 0, 255, 255 }, /* 241 */
	{ 136, 136, 136, 216, 0, 0, 255, 255 }, /* 242 */
	{ 238, 238, 238, 36, 0, 0, 0, 0 }, /* 243 */
	{ 224, 224, 224, 110, 0, 0, 0, 0 }, /* 244 */
	{ 221, 221, 221, 180, 0, 0, 0, 0 }, /* 245 */
	{ 204, 204, 204, 108, 0, 0, 255, 255 }, /* 246 */
	{ 187, 187, 187, 144, 0, 0, 255, 255 }, /* 247 */
	{ 200, 200, 200, 110, 0, 0, 255, 255 }, /* 248 */
	{ 64, 64, 64, 254, 0, 0, 255, 255 }, /* 249 */
	{ 170, 170, 170, 180, 0, 0, 255, 255 }, /* 250 */
	{ 68, 68, 68, 252, 0, 0, 255, 255 }, /* 251 */
	{ 232, 232, 232, 110, 0, 0, 0, 0 }, /* 252 */
	{ 255, 255, 255, 0, 255, 255, 0, 0 }, /* 253 */
	{ 221, 221, 221, 216, 0, 0, 0, 0 }, /* 254 */
	{ 85, 85, 85, 252, 0, 0, 255, 255 }, /* 255 */
};

/**
 * Bit pattern representing each possible 8-bit grayscale value using
 * FXT1 compression.
 */
static const unsigned char piglit_fxt1_grayscale_blocks[256][16] = {
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, /* 0 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 0, 128, 16, 2 }, /* 1 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 0, 128, 16, 2 }, /* 2 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 0, 128, 16, 2 }, /* 3 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 0, 128, 16, 2 }, /* 4 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 0, 128, 16, 2 }, /* 5 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 0, 0, 66, 8 }, /* 6 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 0, 128, 82, 10 }, /* 7 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 132, 16, 2 }, /* 8 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 33, 4, 33, 4 }, /* 9 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 0, 128, 115, 14 }, /* 10 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 0, 0, 66, 8 }, /* 11 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 33, 4, 33, 4 }, /* 12 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 33, 4, 33, 4 }, /* 13 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 0, 128, 82, 10 }, /* 14 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 0, 128, 181, 22 }, /* 15 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66, 8, 33, 4 }, /* 16 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 66, 136, 49, 6 }, /* 17 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 0, 128, 214, 26 }, /* 18 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 33, 132, 82, 10 }, /* 19 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 66, 136, 49, 6 }, /* 20 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 66, 136, 49, 6 }, /* 21 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 0, 0, 66, 8 }, /* 22 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 33, 4, 198, 24 }, /* 23 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 140, 49, 6 }, /* 24 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 33, 4, 66, 8 }, /* 25 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 0, 128, 57, 39 }, /* 26 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 99, 12, 66, 8 }, /* 27 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 99, 12, 99, 12 }, /* 28 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 33, 4, 66, 8 }, /* 29 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 99, 12, 66, 8 }, /* 30 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 99, 12, 132, 16 }, /* 31 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 99, 12, 99, 12 }, /* 32 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 132, 16, 66, 8 }, /* 33 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 0, 128, 82, 10 }, /* 34 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 99, 140, 115, 14 }, /* 35 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 132, 144, 82, 10 }, /* 36 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 132, 144, 82, 10 }, /* 37 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 66, 8, 99, 12 }, /* 38 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 99, 12, 231, 28 }, /* 39 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 132, 144, 148, 18 }, /* 40 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 165, 148, 82, 10 }, /* 41 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 99, 12, 8, 33 }, /* 42 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 66, 136, 115, 14 }, /* 43 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 132, 16, 132, 16 }, /* 44 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 165, 20, 99, 12 }, /* 45 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 99, 140, 115, 14 }, /* 46 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 132, 144, 148, 18 }, /* 47 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 132, 144, 247, 30 }, /* 48 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 24, 99, 12 }, /* 49 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 66, 136, 115, 14 }, /* 50 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 132, 144, 24, 35 }, /* 51 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 165, 148, 148, 18 }, /* 52 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 198, 152, 115, 14 }, /* 53 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 198, 152, 115, 14 }, /* 54 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 132, 16, 132, 16 }, /* 55 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 165, 20, 8, 33 }, /* 56 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 231, 156, 115, 14 }, /* 57 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 165, 20, 132, 16 }, /* 58 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 99, 12, 132, 16 }, /* 59 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 231, 28, 132, 16 }, /* 60 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 231, 28, 165, 20 }, /* 61 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 165, 20, 132, 16 }, /* 62 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 231, 28, 132, 16 }, /* 63 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 231, 28, 198, 24 }, /* 64 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 231, 28, 165, 20 }, /* 65 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 33, 132, 16 }, /* 66 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 132, 144, 148, 18 }, /* 67 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 231, 156, 181, 22 }, /* 68 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 8, 161, 148, 18 }, /* 69 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 8, 161, 148, 18 }, /* 70 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 198, 24, 165, 20 }, /* 71 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 231, 28, 41, 37 }, /* 72 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 8, 161, 214, 26 }, /* 73 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 41, 165, 148, 18 }, /* 74 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 0, 128, 181, 22 }, /* 75 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 198, 152, 181, 22 }, /* 76 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 8, 33, 198, 24 }, /* 77 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 41, 37, 165, 20 }, /* 78 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 231, 156, 181, 22 }, /* 79 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 8, 161, 214, 26 }, /* 80 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 8, 161, 57, 39 }, /* 81 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 41, 165, 20 }, /* 82 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 198, 152, 181, 22 }, /* 83 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 33, 4, 198, 24 }, /* 84 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 41, 165, 214, 26 }, /* 85 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 74, 169, 181, 22 }, /* 86 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 74, 169, 181, 22 }, /* 87 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 8, 33, 198, 24 }, /* 88 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 41, 37, 74, 41 }, /* 89 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 107, 173, 181, 22 }, /* 90 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 41, 37, 198, 24 }, /* 91 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 231, 28, 198, 24 }, /* 92 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 107, 45, 198, 24 }, /* 93 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 107, 45, 231, 28 }, /* 94 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 41, 37, 198, 24 }, /* 95 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 107, 45, 198, 24 }, /* 96 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 107, 45, 8, 33 }, /* 97 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 107, 45, 231, 28 }, /* 98 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 140, 49, 198, 24 }, /* 99 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 99, 12, 231, 28 }, /* 100 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 107, 173, 247, 30 }, /* 101 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 140, 177, 214, 26 }, /* 102 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 140, 177, 214, 26 }, /* 103 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 74, 41, 231, 28 }, /* 104 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 107, 45, 107, 45 }, /* 105 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 140, 177, 24, 35 }, /* 106 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 173, 181, 214, 26 }, /* 107 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 132, 144, 247, 30 }, /* 108 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 74, 169, 247, 30 }, /* 109 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 140, 49, 8, 33 }, /* 110 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 173, 53, 231, 28 }, /* 111 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 107, 173, 247, 30 }, /* 112 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 140, 177, 24, 35 }, /* 113 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 140, 177, 123, 47 }, /* 114 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 57, 231, 28 }, /* 115 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 74, 169, 247, 30 }, /* 116 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 165, 20, 8, 33 }, /* 117 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 173, 181, 24, 35 }, /* 118 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 206, 185, 247, 30 }, /* 119 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 206, 185, 247, 30 }, /* 120 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 140, 49, 8, 33 }, /* 121 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 173, 53, 140, 49 }, /* 122 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 239, 189, 247, 30 }, /* 123 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 173, 53, 8, 33 }, /* 124 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 107, 45, 8, 33 }, /* 125 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 239, 61, 8, 33 }, /* 126 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 239, 61, 41, 37 }, /* 127 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 173, 53, 8, 33 }, /* 128 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 239, 61, 8, 33 }, /* 129 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 239, 61, 74, 41 }, /* 130 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 239, 61, 41, 37 }, /* 131 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 66, 8, 33 }, /* 132 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 231, 28, 41, 37 }, /* 133 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 239, 189, 57, 39 }, /* 134 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 16, 194, 24, 35 }, /* 135 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 16, 194, 24, 35 }, /* 136 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 206, 57, 41, 37 }, /* 137 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 239, 61, 173, 53 }, /* 138 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 16, 194, 90, 43 }, /* 139 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49, 198, 24, 35 }, /* 140 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 8, 161, 57, 39 }, /* 141 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 206, 185, 57, 39 }, /* 142 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 16, 66, 74, 41 }, /* 143 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 49, 70, 41, 37 }, /* 144 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 239, 189, 57, 39 }, /* 145 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 16, 194, 90, 43 }, /* 146 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 16, 194, 189, 55 }, /* 147 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82, 74, 41, 37 }, /* 148 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 206, 185, 57, 39 }, /* 149 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 41, 37, 74, 41 }, /* 150 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 49, 198, 90, 43 }, /* 151 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 82, 202, 57, 39 }, /* 152 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 82, 202, 57, 39 }, /* 153 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 16, 66, 74, 41 }, /* 154 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 49, 70, 206, 57 }, /* 155 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 115, 206, 57, 39 }, /* 156 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 49, 70, 74, 41 }, /* 157 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 239, 61, 74, 41 }, /* 158 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 115, 78, 74, 41 }, /* 159 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 115, 78, 107, 45 }, /* 160 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 49, 70, 74, 41 }, /* 161 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 115, 78, 74, 41 }, /* 162 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 115, 78, 140, 49 }, /* 163 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 115, 78, 107, 45 }, /* 164 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 148, 82, 74, 41 }, /* 165 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 107, 45, 107, 45 }, /* 166 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 115, 206, 123, 47 }, /* 167 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 148, 210, 90, 43 }, /* 168 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 148, 210, 90, 43 }, /* 169 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 82, 74, 107, 45 }, /* 170 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 115, 78, 239, 61 }, /* 171 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 148, 210, 156, 51 }, /* 172 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 214, 90, 43 }, /* 173 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 140, 177, 123, 47 }, /* 174 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 82, 202, 123, 47 }, /* 175 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 148, 82, 140, 49 }, /* 176 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 181, 86, 107, 45 }, /* 177 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 115, 206, 123, 47 }, /* 178 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 148, 210, 156, 51 }, /* 179 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 148, 210, 255, 63 }, /* 180 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 214, 90, 107, 45 }, /* 181 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 82, 202, 123, 47 }, /* 182 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 173, 53, 140, 49 }, /* 183 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 181, 214, 156, 51 }, /* 184 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 214, 218, 123, 47 }, /* 185 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 214, 218, 123, 47 }, /* 186 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 148, 82, 140, 49 }, /* 187 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 140, 177, 156, 51 }, /* 188 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 247, 222, 123, 47 }, /* 189 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 181, 86, 140, 49 }, /* 190 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 115, 78, 140, 49 }, /* 191 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 247, 94, 140, 49 }, /* 192 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 247, 94, 173, 53 }, /* 193 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 181, 86, 140, 49 }, /* 194 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 247, 94, 140, 49 }, /* 195 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 247, 94, 206, 57 }, /* 196 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 247, 94, 173, 53 }, /* 197 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 99, 140, 49 }, /* 198 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 239, 61, 173, 53 }, /* 199 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 247, 222, 189, 55 }, /* 200 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 24, 227, 156, 51 }, /* 201 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 24, 227, 156, 51 }, /* 202 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 214, 90, 173, 53 }, /* 203 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 206, 185, 189, 55 }, /* 204 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 24, 227, 222, 59 }, /* 205 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 231, 156, 51 }, /* 206 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 16, 194, 189, 55 }, /* 207 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 214, 218, 189, 55 }, /* 208 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 24, 99, 206, 57 }, /* 209 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 57, 103, 173, 53 }, /* 210 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 247, 222, 189, 55 }, /* 211 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 24, 227, 222, 59 }, /* 212 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 239, 61, 206, 57 }, /* 213 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 107, 173, 53 }, /* 214 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 214, 218, 189, 55 }, /* 215 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 49, 70, 206, 57 }, /* 216 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 57, 231, 222, 59 }, /* 217 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 90, 235, 189, 55 }, /* 218 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 90, 235, 189, 55 }, /* 219 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 24, 99, 206, 57 }, /* 220 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 16, 194, 222, 59 }, /* 221 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 239, 189, 55 }, /* 222 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 57, 103, 206, 57 }, /* 223 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 247, 94, 206, 57 }, /* 224 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 123, 111, 206, 57 }, /* 225 */
	{ 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 123, 111, 239, 61 }, /* 226 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 57, 103, 206, 57 }, /* 227 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 123, 111, 206, 57 }, /* 228 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 140, 177, 255, 63 }, /* 229 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 123, 111, 239, 61 }, /* 230 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 156, 115, 206, 57 }, /* 231 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 115, 78, 239, 61 }, /* 232 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 123, 239, 255, 63 }, /* 233 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 156, 243, 222, 59 }, /* 234 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 156, 243, 222, 59 }, /* 235 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 90, 107, 239, 61 }, /* 236 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 82, 202, 255, 63 }, /* 237 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 156, 243, 222, 59 }, /* 238 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 247, 222, 59 }, /* 239 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 148, 210, 255, 63 }, /* 240 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 90, 235, 255, 63 }, /* 241 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 189, 119, 239, 61 }, /* 242 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 189, 119, 239, 61 }, /* 243 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 123, 239, 255, 63 }, /* 244 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 24, 227, 255, 63 }, /* 245 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 189, 119, 239, 61 }, /* 246 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 222, 123, 239, 61 }, /* 247 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 90, 235, 255, 63 }, /* 248 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 123, 239, 255, 63 }, /* 249 */
	{ 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 222, 251, 255, 63 }, /* 250 */
	{ 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 222, 251, 255, 63 }, /* 251 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 222, 251, 255, 63 }, /* 252 */
	{ 36, 73, 146, 36, 73, 146, 36, 73, 146, 36, 73, 146, 222, 251, 255, 63 }, /* 253 */
	{ 109, 219, 182, 109, 219, 182, 109, 219, 182, 109, 219, 182, 222, 251, 255, 63 }, /* 254 */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 63 }, /* 255 */
};

/**
 * Bit pattern representing each possible 8-bit grayscale value using
 * S3TC compression.
 */
static const unsigned char piglit_s3tc_grayscale_blocks[256][8] = {
	{ 0, 0, 0, 0, 0, 0, 0, 0 }, /* 0 */
	{ 32, 0, 0, 0, 255, 255, 255, 255 }, /* 1 */
	{ 33, 8, 0, 0, 255, 255, 255, 255 }, /* 2 */
	{ 65, 8, 0, 0, 255, 255, 255, 255 }, /* 3 */
	{ 32, 0, 33, 8, 170, 170, 170, 170 }, /* 4 */
	{ 66, 16, 32, 0, 255, 255, 255, 255 }, /* 5 */
	{ 66, 16, 32, 0, 255, 255, 255, 255 }, /* 6 */
	{ 65, 8, 33, 8, 170, 170, 170, 170 }, /* 7 */
	{ 65, 8, 65, 8, 0, 0, 0, 0 }, /* 8 */
	{ 97, 8, 65, 8, 255, 255, 255, 255 }, /* 9 */
	{ 98, 16, 65, 8, 255, 255, 255, 255 }, /* 10 */
	{ 130, 16, 65, 8, 255, 255, 255, 255 }, /* 11 */
	{ 97, 8, 98, 16, 170, 170, 170, 170 }, /* 12 */
	{ 131, 24, 97, 8, 255, 255, 255, 255 }, /* 13 */
	{ 131, 24, 97, 8, 255, 255, 255, 255 }, /* 14 */
	{ 130, 16, 97, 8, 170, 170, 170, 170 }, /* 15 */
	{ 130, 16, 130, 16, 0, 0, 0, 0 }, /* 16 */
	{ 162, 16, 130, 16, 255, 255, 255, 255 }, /* 17 */
	{ 163, 24, 130, 16, 255, 255, 255, 255 }, /* 18 */
	{ 195, 24, 130, 16, 255, 255, 255, 255 }, /* 19 */
	{ 162, 16, 163, 24, 170, 170, 170, 170 }, /* 20 */
	{ 162, 16, 163, 24, 170, 170, 170, 170 }, /* 21 */
	{ 196, 32, 162, 16, 255, 255, 255, 255 }, /* 22 */
	{ 195, 24, 162, 16, 170, 170, 170, 170 }, /* 23 */
	{ 195, 24, 195, 24, 0, 0, 0, 0 }, /* 24 */
	{ 227, 24, 195, 24, 255, 255, 255, 255 }, /* 25 */
	{ 227, 24, 195, 24, 255, 255, 255, 255 }, /* 26 */
	{ 4, 33, 195, 24, 255, 255, 255, 255 }, /* 27 */
	{ 228, 32, 227, 24, 255, 255, 255, 255 }, /* 28 */
	{ 227, 24, 228, 32, 170, 170, 170, 170 }, /* 29 */
	{ 5, 41, 227, 24, 255, 255, 255, 255 }, /* 30 */
	{ 4, 33, 227, 24, 170, 170, 170, 170 }, /* 31 */
	{ 4, 33, 4, 33, 0, 0, 0, 0 }, /* 32 */
	{ 4, 33, 4, 33, 0, 0, 0, 0 }, /* 33 */
	{ 36, 33, 4, 33, 255, 255, 255, 255 }, /* 34 */
	{ 69, 41, 4, 33, 255, 255, 255, 255 }, /* 35 */
	{ 37, 41, 36, 33, 255, 255, 255, 255 }, /* 36 */
	{ 36, 33, 37, 41, 170, 170, 170, 170 }, /* 37 */
	{ 70, 49, 36, 33, 255, 255, 255, 255 }, /* 38 */
	{ 69, 41, 36, 33, 170, 170, 170, 170 }, /* 39 */
	{ 69, 41, 69, 41, 0, 0, 0, 0 }, /* 40 */
	{ 69, 41, 69, 41, 0, 0, 0, 0 }, /* 41 */
	{ 101, 41, 69, 41, 255, 255, 255, 255 }, /* 42 */
	{ 134, 49, 69, 41, 255, 255, 255, 255 }, /* 43 */
	{ 102, 49, 101, 41, 255, 255, 255, 255 }, /* 44 */
	{ 101, 41, 102, 49, 170, 170, 170, 170 }, /* 45 */
	{ 135, 57, 101, 41, 255, 255, 255, 255 }, /* 46 */
	{ 134, 49, 101, 41, 170, 170, 170, 170 }, /* 47 */
	{ 134, 49, 134, 49, 0, 0, 0, 0 }, /* 48 */
	{ 134, 49, 134, 49, 0, 0, 0, 0 }, /* 49 */
	{ 166, 49, 134, 49, 255, 255, 255, 255 }, /* 50 */
	{ 199, 57, 134, 49, 255, 255, 255, 255 }, /* 51 */
	{ 167, 57, 166, 49, 255, 255, 255, 255 }, /* 52 */
	{ 166, 49, 167, 57, 170, 170, 170, 170 }, /* 53 */
	{ 166, 49, 199, 57, 170, 170, 170, 170 }, /* 54 */
	{ 199, 57, 166, 49, 170, 170, 170, 170 }, /* 55 */
	{ 199, 57, 198, 49, 170, 170, 170, 170 }, /* 56 */
	{ 199, 57, 199, 57, 0, 0, 0, 0 }, /* 57 */
	{ 231, 57, 199, 57, 255, 255, 255, 255 }, /* 58 */
	{ 8, 66, 199, 57, 255, 255, 255, 255 }, /* 59 */
	{ 8, 66, 199, 57, 255, 255, 255, 255 }, /* 60 */
	{ 232, 65, 231, 57, 255, 255, 255, 255 }, /* 61 */
	{ 231, 57, 8, 66, 170, 170, 170, 170 }, /* 62 */
	{ 8, 66, 231, 57, 170, 170, 170, 170 }, /* 63 */
	{ 8, 66, 231, 57, 170, 170, 170, 170 }, /* 64 */
	{ 8, 66, 8, 66, 0, 0, 0, 0 }, /* 65 */
	{ 40, 66, 8, 66, 255, 255, 255, 255 }, /* 66 */
	{ 40, 66, 8, 66, 170, 170, 170, 170 }, /* 67 */
	{ 73, 74, 8, 66, 255, 255, 255, 255 }, /* 68 */
	{ 41, 74, 40, 66, 255, 255, 255, 255 }, /* 69 */
	{ 40, 66, 73, 74, 170, 170, 170, 170 }, /* 70 */
	{ 73, 74, 40, 66, 170, 170, 170, 170 }, /* 71 */
	{ 73, 74, 40, 66, 170, 170, 170, 170 }, /* 72 */
	{ 73, 74, 73, 74, 0, 0, 0, 0 }, /* 73 */
	{ 105, 74, 73, 74, 255, 255, 255, 255 }, /* 74 */
	{ 105, 74, 73, 74, 170, 170, 170, 170 }, /* 75 */
	{ 138, 82, 73, 74, 255, 255, 255, 255 }, /* 76 */
	{ 106, 82, 105, 74, 255, 255, 255, 255 }, /* 77 */
	{ 105, 74, 138, 82, 170, 170, 170, 170 }, /* 78 */
	{ 138, 82, 105, 74, 170, 170, 170, 170 }, /* 79 */
	{ 138, 82, 105, 74, 170, 170, 170, 170 }, /* 80 */
	{ 138, 82, 138, 82, 0, 0, 0, 0 }, /* 81 */
	{ 170, 82, 138, 82, 255, 255, 255, 255 }, /* 82 */
	{ 170, 82, 138, 82, 170, 170, 170, 170 }, /* 83 */
	{ 203, 90, 138, 82, 255, 255, 255, 255 }, /* 84 */
	{ 171, 90, 170, 82, 255, 255, 255, 255 }, /* 85 */
	{ 203, 90, 170, 82, 255, 255, 255, 255 }, /* 86 */
	{ 170, 82, 203, 90, 170, 170, 170, 170 }, /* 87 */
	{ 203, 90, 170, 82, 170, 170, 170, 170 }, /* 88 */
	{ 203, 90, 202, 82, 170, 170, 170, 170 }, /* 89 */
	{ 235, 90, 203, 90, 255, 255, 255, 255 }, /* 90 */
	{ 203, 90, 235, 90, 170, 170, 170, 170 }, /* 91 */
	{ 12, 99, 203, 90, 255, 255, 255, 255 }, /* 92 */
	{ 236, 98, 235, 90, 255, 255, 255, 255 }, /* 93 */
	{ 12, 99, 235, 90, 255, 255, 255, 255 }, /* 94 */
	{ 235, 90, 12, 99, 170, 170, 170, 170 }, /* 95 */
	{ 12, 99, 235, 90, 170, 170, 170, 170 }, /* 96 */
	{ 12, 99, 11, 91, 170, 170, 170, 170 }, /* 97 */
	{ 44, 99, 12, 99, 255, 255, 255, 255 }, /* 98 */
	{ 12, 99, 44, 99, 170, 170, 170, 170 }, /* 99 */
	{ 44, 99, 12, 99, 170, 170, 170, 170 }, /* 100 */
	{ 45, 107, 44, 99, 255, 255, 255, 255 }, /* 101 */
	{ 77, 107, 44, 99, 255, 255, 255, 255 }, /* 102 */
	{ 44, 99, 77, 107, 170, 170, 170, 170 }, /* 103 */
	{ 77, 107, 44, 99, 170, 170, 170, 170 }, /* 104 */
	{ 77, 107, 76, 99, 170, 170, 170, 170 }, /* 105 */
	{ 109, 107, 77, 107, 255, 255, 255, 255 }, /* 106 */
	{ 77, 107, 109, 107, 170, 170, 170, 170 }, /* 107 */
	{ 109, 107, 77, 107, 170, 170, 170, 170 }, /* 108 */
	{ 110, 115, 109, 107, 255, 255, 255, 255 }, /* 109 */
	{ 142, 115, 109, 107, 255, 255, 255, 255 }, /* 110 */
	{ 109, 107, 142, 115, 170, 170, 170, 170 }, /* 111 */
	{ 142, 115, 109, 107, 170, 170, 170, 170 }, /* 112 */
	{ 142, 115, 141, 107, 170, 170, 170, 170 }, /* 113 */
	{ 142, 115, 142, 115, 0, 0, 0, 0 }, /* 114 */
	{ 174, 115, 142, 115, 255, 255, 255, 255 }, /* 115 */
	{ 174, 115, 142, 115, 170, 170, 170, 170 }, /* 116 */
	{ 175, 123, 174, 115, 255, 255, 255, 255 }, /* 117 */
	{ 175, 123, 174, 115, 255, 255, 255, 255 }, /* 118 */
	{ 174, 115, 207, 123, 170, 170, 170, 170 }, /* 119 */
	{ 207, 123, 174, 115, 170, 170, 170, 170 }, /* 120 */
	{ 207, 123, 206, 115, 170, 170, 170, 170 }, /* 121 */
	{ 207, 123, 206, 115, 170, 170, 170, 170 }, /* 122 */
	{ 239, 123, 207, 123, 255, 255, 255, 255 }, /* 123 */
	{ 239, 123, 207, 123, 170, 170, 170, 170 }, /* 124 */
	{ 240, 131, 239, 123, 255, 255, 255, 255 }, /* 125 */
	{ 240, 131, 239, 123, 255, 255, 255, 255 }, /* 126 */
	{ 239, 123, 16, 132, 170, 170, 170, 170 }, /* 127 */
	{ 239, 123, 16, 132, 170, 170, 170, 170 }, /* 128 */
	{ 16, 132, 15, 124, 170, 170, 170, 170 }, /* 129 */
	{ 16, 132, 15, 124, 170, 170, 170, 170 }, /* 130 */
	{ 48, 132, 16, 132, 255, 255, 255, 255 }, /* 131 */
	{ 48, 132, 16, 132, 170, 170, 170, 170 }, /* 132 */
	{ 49, 140, 48, 132, 255, 255, 255, 255 }, /* 133 */
	{ 49, 140, 48, 132, 255, 255, 255, 255 }, /* 134 */
	{ 81, 140, 48, 132, 255, 255, 255, 255 }, /* 135 */
	{ 48, 132, 81, 140, 170, 170, 170, 170 }, /* 136 */
	{ 81, 140, 80, 132, 170, 170, 170, 170 }, /* 137 */
	{ 81, 140, 80, 132, 170, 170, 170, 170 }, /* 138 */
	{ 113, 140, 81, 140, 255, 255, 255, 255 }, /* 139 */
	{ 113, 140, 81, 140, 170, 170, 170, 170 }, /* 140 */
	{ 113, 140, 113, 140, 0, 0, 0, 0 }, /* 141 */
	{ 114, 148, 113, 140, 255, 255, 255, 255 }, /* 142 */
	{ 146, 148, 113, 140, 255, 255, 255, 255 }, /* 143 */
	{ 113, 140, 146, 148, 170, 170, 170, 170 }, /* 144 */
	{ 146, 148, 113, 140, 170, 170, 170, 170 }, /* 145 */
	{ 146, 148, 145, 140, 170, 170, 170, 170 }, /* 146 */
	{ 178, 148, 146, 148, 255, 255, 255, 255 }, /* 147 */
	{ 146, 148, 178, 148, 170, 170, 170, 170 }, /* 148 */
	{ 178, 148, 146, 148, 170, 170, 170, 170 }, /* 149 */
	{ 179, 156, 178, 148, 255, 255, 255, 255 }, /* 150 */
	{ 211, 156, 178, 148, 255, 255, 255, 255 }, /* 151 */
	{ 178, 148, 211, 156, 170, 170, 170, 170 }, /* 152 */
	{ 211, 156, 178, 148, 170, 170, 170, 170 }, /* 153 */
	{ 211, 156, 210, 148, 170, 170, 170, 170 }, /* 154 */
	{ 243, 156, 211, 156, 255, 255, 255, 255 }, /* 155 */
	{ 211, 156, 243, 156, 170, 170, 170, 170 }, /* 156 */
	{ 243, 156, 211, 156, 170, 170, 170, 170 }, /* 157 */
	{ 244, 164, 243, 156, 255, 255, 255, 255 }, /* 158 */
	{ 20, 165, 243, 156, 255, 255, 255, 255 }, /* 159 */
	{ 243, 156, 20, 165, 170, 170, 170, 170 }, /* 160 */
	{ 20, 165, 243, 156, 170, 170, 170, 170 }, /* 161 */
	{ 20, 165, 19, 157, 170, 170, 170, 170 }, /* 162 */
	{ 52, 165, 243, 156, 170, 170, 170, 170 }, /* 163 */
	{ 20, 165, 52, 165, 170, 170, 170, 170 }, /* 164 */
	{ 52, 165, 20, 165, 170, 170, 170, 170 }, /* 165 */
	{ 53, 173, 52, 165, 255, 255, 255, 255 }, /* 166 */
	{ 85, 173, 52, 165, 255, 255, 255, 255 }, /* 167 */
	{ 52, 165, 85, 173, 170, 170, 170, 170 }, /* 168 */
	{ 84, 165, 85, 173, 170, 170, 170, 170 }, /* 169 */
	{ 85, 173, 84, 165, 170, 170, 170, 170 }, /* 170 */
	{ 117, 173, 52, 165, 170, 170, 170, 170 }, /* 171 */
	{ 117, 173, 85, 173, 255, 255, 255, 255 }, /* 172 */
	{ 117, 173, 85, 173, 170, 170, 170, 170 }, /* 173 */
	{ 117, 173, 117, 173, 0, 0, 0, 0 }, /* 174 */
	{ 150, 181, 117, 173, 255, 255, 255, 255 }, /* 175 */
	{ 150, 181, 117, 173, 255, 255, 255, 255 }, /* 176 */
	{ 117, 173, 150, 181, 170, 170, 170, 170 }, /* 177 */
	{ 150, 181, 149, 173, 170, 170, 170, 170 }, /* 178 */
	{ 182, 181, 117, 173, 170, 170, 170, 170 }, /* 179 */
	{ 182, 181, 150, 181, 255, 255, 255, 255 }, /* 180 */
	{ 182, 181, 150, 181, 170, 170, 170, 170 }, /* 181 */
	{ 182, 181, 182, 181, 0, 0, 0, 0 }, /* 182 */
	{ 215, 189, 182, 181, 255, 255, 255, 255 }, /* 183 */
	{ 215, 189, 182, 181, 255, 255, 255, 255 }, /* 184 */
	{ 182, 181, 215, 189, 170, 170, 170, 170 }, /* 185 */
	{ 215, 189, 214, 181, 170, 170, 170, 170 }, /* 186 */
	{ 247, 189, 182, 181, 170, 170, 170, 170 }, /* 187 */
	{ 247, 189, 215, 189, 255, 255, 255, 255 }, /* 188 */
	{ 247, 189, 215, 189, 170, 170, 170, 170 }, /* 189 */
	{ 247, 189, 247, 189, 0, 0, 0, 0 }, /* 190 */
	{ 24, 198, 247, 189, 255, 255, 255, 255 }, /* 191 */
	{ 24, 198, 247, 189, 255, 255, 255, 255 }, /* 192 */
	{ 247, 189, 24, 198, 170, 170, 170, 170 }, /* 193 */
	{ 24, 198, 23, 190, 170, 170, 170, 170 }, /* 194 */
	{ 56, 198, 247, 189, 170, 170, 170, 170 }, /* 195 */
	{ 56, 198, 247, 189, 170, 170, 170, 170 }, /* 196 */
	{ 56, 198, 24, 198, 170, 170, 170, 170 }, /* 197 */
	{ 56, 198, 56, 198, 0, 0, 0, 0 }, /* 198 */
	{ 57, 206, 56, 198, 255, 255, 255, 255 }, /* 199 */
	{ 89, 206, 56, 198, 255, 255, 255, 255 }, /* 200 */
	{ 56, 198, 89, 206, 170, 170, 170, 170 }, /* 201 */
	{ 88, 198, 89, 206, 170, 170, 170, 170 }, /* 202 */
	{ 89, 206, 88, 198, 170, 170, 170, 170 }, /* 203 */
	{ 121, 206, 56, 198, 170, 170, 170, 170 }, /* 204 */
	{ 121, 206, 89, 206, 170, 170, 170, 170 }, /* 205 */
	{ 121, 206, 121, 206, 0, 0, 0, 0 }, /* 206 */
	{ 121, 206, 121, 206, 0, 0, 0, 0 }, /* 207 */
	{ 154, 214, 121, 206, 255, 255, 255, 255 }, /* 208 */
	{ 154, 214, 120, 198, 170, 170, 170, 170 }, /* 209 */
	{ 153, 206, 154, 214, 170, 170, 170, 170 }, /* 210 */
	{ 154, 214, 153, 206, 170, 170, 170, 170 }, /* 211 */
	{ 186, 214, 121, 206, 170, 170, 170, 170 }, /* 212 */
	{ 186, 214, 154, 214, 170, 170, 170, 170 }, /* 213 */
	{ 186, 214, 186, 214, 0, 0, 0, 0 }, /* 214 */
	{ 186, 214, 186, 214, 0, 0, 0, 0 }, /* 215 */
	{ 219, 222, 186, 214, 255, 255, 255, 255 }, /* 216 */
	{ 219, 222, 185, 206, 170, 170, 170, 170 }, /* 217 */
	{ 218, 214, 219, 222, 170, 170, 170, 170 }, /* 218 */
	{ 219, 222, 218, 214, 170, 170, 170, 170 }, /* 219 */
	{ 251, 222, 186, 214, 170, 170, 170, 170 }, /* 220 */
	{ 251, 222, 219, 222, 170, 170, 170, 170 }, /* 221 */
	{ 251, 222, 251, 222, 0, 0, 0, 0 }, /* 222 */
	{ 251, 222, 251, 222, 0, 0, 0, 0 }, /* 223 */
	{ 28, 231, 251, 222, 255, 255, 255, 255 }, /* 224 */
	{ 28, 231, 250, 214, 170, 170, 170, 170 }, /* 225 */
	{ 27, 223, 28, 231, 170, 170, 170, 170 }, /* 226 */
	{ 28, 231, 27, 223, 170, 170, 170, 170 }, /* 227 */
	{ 60, 231, 251, 222, 170, 170, 170, 170 }, /* 228 */
	{ 60, 231, 28, 231, 170, 170, 170, 170 }, /* 229 */
	{ 60, 231, 28, 231, 170, 170, 170, 170 }, /* 230 */
	{ 60, 231, 60, 231, 0, 0, 0, 0 }, /* 231 */
	{ 93, 239, 60, 231, 255, 255, 255, 255 }, /* 232 */
	{ 93, 239, 59, 223, 170, 170, 170, 170 }, /* 233 */
	{ 92, 231, 93, 239, 170, 170, 170, 170 }, /* 234 */
	{ 92, 231, 93, 239, 170, 170, 170, 170 }, /* 235 */
	{ 125, 239, 60, 231, 170, 170, 170, 170 }, /* 236 */
	{ 125, 239, 92, 231, 170, 170, 170, 170 }, /* 237 */
	{ 125, 239, 93, 239, 170, 170, 170, 170 }, /* 238 */
	{ 125, 239, 125, 239, 0, 0, 0, 0 }, /* 239 */
	{ 158, 247, 125, 239, 255, 255, 255, 255 }, /* 240 */
	{ 158, 247, 124, 231, 170, 170, 170, 170 }, /* 241 */
	{ 158, 247, 124, 231, 170, 170, 170, 170 }, /* 242 */
	{ 157, 239, 158, 247, 170, 170, 170, 170 }, /* 243 */
	{ 190, 247, 125, 239, 170, 170, 170, 170 }, /* 244 */
	{ 190, 247, 157, 239, 170, 170, 170, 170 }, /* 245 */
	{ 190, 247, 158, 247, 170, 170, 170, 170 }, /* 246 */
	{ 190, 247, 190, 247, 0, 0, 0, 0 }, /* 247 */
	{ 222, 247, 190, 247, 255, 255, 255, 255 }, /* 248 */
	{ 223, 255, 189, 239, 170, 170, 170, 170 }, /* 249 */
	{ 223, 255, 189, 239, 170, 170, 170, 170 }, /* 250 */
	{ 222, 247, 223, 255, 170, 170, 170, 170 }, /* 251 */
	{ 255, 255, 190, 247, 170, 170, 170, 170 }, /* 252 */
	{ 255, 255, 222, 247, 170, 170, 170, 170 }, /* 253 */
	{ 255, 255, 223, 255, 170, 170, 170, 170 }, /* 254 */
	{ 255, 255, 255, 255, 0, 0, 0, 0 }, /* 255 */
};
