# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is designed by Alexandre Moore (http://nuovext.pwsp.net/).

# Follows PEP8

import os
from core import ct, models
from lib.reverse_translation import _t


class Action(models.Action):
    """Defined variables: <filename> <type> <folder> <width> <height>"""

    label = _t('Write Tag')
    author = 'Stani'
    email = 'spe.stani.be@gmail.com'
    version = '0.1'
    tags = [_t('metadata')]
    __doc__ = _t('Write new value to a tag')

    def interface(self, fields):
        fields[_t('Tag (Exif, Iptc)')] = self.ExifItpcField(
            'Exif_Image_Copyright', choices=self.EXIF_IPTC)
        fields[_t('Value')] = self.CharField('Phatch')

    def apply(self, photo, setting, cache):
        info = photo.info
        tag = self.get_field('Tag (Exif, Iptc)', info)
        value = self.get_field('Value', info).strip()
        if value == '':
            value = None
        info[tag] = value
        return photo

    icon = \
'x\xda\x01\xda\x0c%\xf3\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x0c\x91IDATh\x81\xd5\x9ayp\x15\xd7\x95\xc6\x7f\xf7\
\xden\xbd\xf7$\x84v\x04BB\xb2\xd8\xc4\x8e\x11`D\x1c\x83\x8d\xe3\xd8Il&\xb30\
\xc58N\xaa\x92\x1a(/\xa1\xe2)\x8f\xe3\xa4\xca\x1e/\xb1\x13\xaa28\xa1\xe2\x05\
;\xd4\xd48C\x88\t`\x03\xb6\t\x06l\xb3\x1b\x8c-\xb3\x19c),\x12B\xdb{Z\x91\xf4\
\xb6\xee;\x7f\xf4{O\xad\x15\x81I\xa5\xdc\xafn=\xa9u\xba\xfb\xfb\xee\xf9\xce\
\xb9\xe7\xdc\x96\xd0Z\xf3U>\xe4\xdf\x1b\xc0\x97=\xbe\xf2\x04\x8c\xbf7\x00\
\xf7!\x10b\xe1y<\x89\x13ED\xdfGG\x07\xbd\xe6Zc`\xf1\xe2\xc5y\x05\x05\x05\xf3\
\xc7\x8d\x1bw[WWWSEE\xc5\xae@ \xf0\xf1\x96-[\xda\xaf\xe5~\xdfj\x12\xc3\x8d0\
\x1f\xa3\x19\xe7:\x1d\xd2\xf0\x93m\xa3\xf4\xcb\x03]w\xd5\x04V\xacXq\xef\x82\
\x05\x0bV\x17\x17\x17gvvvR]]\x8dR\x8a\xec\xecl\xa2\xd1(\x15\x15\x15\xe5\xfb\
\xf6\xed\xbbo\xfd\xfa\xf5\xa7\xae\xe6\xbe\xf7\x9c\x13w\xd8\x82\x1d\xfd\xfc\
\xe9\xfd\xb7\x8a\xf4m_\x9a\xc0\xe2\xc5\x8bs\x17.\\\xb8c\xd6\xacY3\xf6\xee\
\xdd\xcb\xe1\xc3\x87\xb1,+\x18\x0c\x06\xab\x01\xc3\xeb\xf5f{\xbd\xde\xd4y\
\xf3\xe6QTTd\x97\x97\x97\xff\xcf\xca\x95+\xff]\x0f\xf1\x01\xdf>#\xee\xd4\x82\
\xed}\xfe\xa0\xd9\xf3\xceD\xbdp\xa0\xeb\xfa\x8d\x01!\x84\xc0\tp\x010e\xca\
\x14\xb9d\xc9\x92wG\x8c\x181}\xf5\xea\xd5\xe1\xca\xca\xca\xbf\xd4\xd5\xd5U\
\xfa\xfd\xfe\x06\xdb\xb6-\xc0\x06TFFFFcc\xe3\x1d\xf9\xf9\xf9\xb3\x16-Z\xf4\
\xa3\xe5\xcb\x97\xfb\x85\x10?\x1b\n\t+\x04Z\x0c\x85\xea\x15\x08\x08!$\x90\
\x04$\x17\xdc\xc7\xa8$/\xe6\xdc\xe8\xdc\x15\xc5\xc5\xc5\xd37n\xdc\xd8r\xe8\
\xd0\xa1\xd7\xeb\xeb\xeb?\x07j\x80z\xc0\x0f\x04\x81\xe4\xe6\xe6\xe6\xe1\x07\
\x0e\x1c89f\xcc\x982\xc30\x96M\x9f>\xfd\xd1\xc5\x8b\x17\xef\x17B\xbc\xdd\x9b\
\xc4]\x1f\x8a\xa2\xa8\xc1KZ0\n@hR\x07\xc08\xfb\xf6\x8f\xc5\xa71\x9b(\x82\xb5\
;K\xf5K\xfd\x12p\x81\x1f1\xe7U\xee\xf7\xe6\xf1\xcfB\x8a\xb1\xc5\xe57\xb0\xf7\
\xa3\xdd\xd1\xbfN\xda~!gNh\xc2\xe8\x0c\xd2\xa4AXHl\xc0FbI\x93H\xcd\x1bl\xbb\
\xb8\x99CUUUg\x8e\x1c9\xa2322\x1e\xcc\xce\xce~\x02\xd8\x01D\xdc\xcf\x8aX|_\
\xdb\xdc\x19\xff}\x10\x17\xa5\x003\\6c\x81\xbe\x04\\\xb2IF16g\x01?6\xd3I\xd1\
g\xd3\xf0\x18^\x02\xa5\x87\x8d\xe2\xbbB3\x06~\x0ed\xdf\xcc\x0f\xd2\xa6\xb2\
\xf2\xd4\xd3\xbc^QQ\xb1\xb6\xa4\xa4\xe4\xeb\xb9\xb9\xb9Sc Z\xdc\xb6V\x88d\
\xaeA2\x80\xcf\xfdK\xef\x85L\x02>e2\xdaH%\x05\xc0<\x9fKKk\x0bU\r\xe7t\xd3\
\x87\x10\xed\x18\xf8\xceF\n)\xe3\x1e\x94O}m\xa3Ze\xa6a\xd6\xd4\xd4\xbc\xa1\
\xb5\xf6M\x9a4i\xb6\x10B\xb9m\xed\x08X\xe1k\x1b\x83\x11P@r\xce\x02&\xc7\x1f\
\xd7z\\DZ[Z\x83G\x1f\r\xbevt9/W\xfe\x8e\xe6Hs_\xf0\x02\x89\xc2\xc0\x10\x86\
\x18\xb5\xc0\xf8\xf6\xed;=\x1b:\xb2.u\xb6\xb7\xb7c\xdbv!`\xba\xed\xa3A\xb0C\
\xd76\x06" p$\x95\x9aw7\xdf\x01\xd0\x16\xd4\xec\x8c\xec\x0f\x85B\xde\x82\xfc\
\x82c]\r\xbcW\xf1"/\x04\x0e\x12\xee\xbe\xc8\x01\xae0P"60I\xbb!\xe9\x86\xe9/v\
=\xed\xb7.^hkk\x1b\x0e\xf8\x84\x102&U\xec0\x07\xed\x10\xfa\x1a\x08\x1c\xeeC \
vS\x05$g\xcc\xa6\xd8\x97\xcfd\x00\xa1 \xe9k~\x11\x08\x04())\xb9\x05\x8bKv\
\x88F_\x11vO\xe0&\x860Q\xc4\x87C\xc2\x93a\xf8F\xbf\\1f\xc2\xaf:\x96\x98i\x14\
\x03\xa9\x80\x12B\x88C\xff\xa2\xb7j\x8bb;LYl<\xdc\xafdB\x94\xc7m\xac s<9,\
\xea\xe1y\xadu<\xfb\xf8\x80\xfcY/\xf0\x9b\x94b\xee\xcc,u\x0cB~\xac\xae\'g7{[\
3}\x17}\'\xd6\xa5|\xb7v\xee\xe8\xbb\xd4L\x81D\t\x85@"\x89\x7fK\x84\x90\x08$"\
v\x06\x04\x02\xc1\xe5*\xeb\xc2\x91\xffj~\xf8\xc2\xb6\xf0A\xa0\x19\x88j\xad\
\xed8\x90\xb9k\x07X\xc8`\xcfG?\x1cd!s\xcd~JF\x19cS\xc7q\xabp\xa9\xd5\x93\x8d\
\xf2\xfc\xeeh\xb6\xb6a\xbc\x14\xcb$\x06\xd2\x05\\\xc6\t\x08I\xc7\x17\x12\xc3\
#I)\x94\t\xf0\x12\tB\x90^\x98Tx\xeb\x0b\x9eug\xca\xdaW\x1d\xfay\xf3\xef\x81\
\x06!D\x10\xd0Zkm\x85b"\xbe\xca#\x1e\x03\x060l\xe2\xfd\xfc\x08\x85Gz\xfb1\
\x94\x928x\x89J\xc8\xc79g \xc2\x06g\x9e38\xb2\xd4\xa0a\xbbs\xce\x10&R\x18\t[\
_\x8a\xc77cY\xf6\xcf\xef~+o\x8d\x99\xcex\\\x92\xd2\x16Uv\x18z\x0f+D\xd5`\x04\
T\x8cD\x12\x90=\xea;\xdci\xa61!)\r\xcc\xe1\xddF\xf1\xd9V\xa2\x1bx<he\xec\x9c\
\xa1\x14\xe9\x93\x14\xf5o\x1b\xf8w\x19D\x1a\x15\xd9s\x15\xcaP1\xa2\x0eq)\x94\
\xc8\x18\xe3\x1b;\xe1\x1f\xd3\xbe\xd5\xd1\x10\xaeh:\x1d\xf6\x03\xe1\xba\xed4\
\xe4,b?6\xe5\xdaf\x87\xb6\xd9\xa1-6Y\x92\xe7\x1f({\xb2k \x02\xf1\xc5\xcb\x0b\
\x14\x98Y\x94\xcdy\x85\xdf\xa4O#\xcdL\xef\x0b^\xf6\x04\x92\x90\x8f\x0e*\xce\
\xad\x91\xd4\xbc\xaeH\x9b,\xc9\xbfGr\xeeUI\xeaD\xc1\xac\xffv$\x14\xff\xb8u\
\x12\xe9\xb4\x82\'\xd65\xae\xda\xf7\xd3\xfaW\x81\x06\x9c\x92D\x0f\xb5\x00\
\x8c\x13\x1089:\x07\x83I\xf9\xff\xc0\xf7\n\x97\xf2\x83\x8cR0\x92\x07\x06\xaf\
b?\xfb\xdfWT\xacR\xe8\x90d\xe2\x8f\x15\xf9w;\x81\x1cm\x96(\x8f\xa4\xe3\xac\
\xc0\xba,\xc9)\xeb\x06/\\$\xb4\xd6\xba\xfaH\xeb\xee7\x97V>\x12i\xe1<\xd0\x01\
XC%\x11\xcfB\ng\xb9/@1c\xe6\xafy"i\x04\x133\xa7*R\xf3\xcc\x18p\xc3\x05\xde\
\xf9\xb9\xe5\xb0\xe2\xf8\xc3\x8a\xd1wK&<\xa4\xf0\x0cW\x08[\xd2z\\\x12\xd8+\t\
\x1c\x90Xm\x12\xb4\xa0\xe4Q\xc1\xc8\xdb\x85\x0b\xbc ^\xddh4\xad\x17\xbb\xaa\
\xf7<u\xe1\xe13\x1b[\xf7\xd3O\x96\xba\x12\x81\xb8\x1720\x18\x9bR\xc8\xd7K_\
\xe0\xc9p\x13\xdea#\x93\xc8\x99\xe6M\x04\xb0r\x11\x91(\xac6ER\xb2\xa2\xb5\\\
\x11\xd8+i>\xa0@Kr\x17H\xd2J$U\xeb$)c$\xd3\x9e\x16HS\xf4\x98\xfd\x84\x17\xd0\
\x80&\xdc\x19\r\x1e[\x7f\xe9\xf9\xdd\x8fT\xbf\xc2\x10%%\xe3n\x04\xa2@;Qj;\
\xces\xaa~\'o\xa7\x14BWK\x98\x9a\x0f\x82\x10\x91\t\xd9HW0{\x87\x1b\xe8\x0e\
\x83\x86\xb7\x9d\xa0N\x9fb\xa0\xa4A\xfa\x04\x93\xdaM&\xbe,\x83\xe9\x8f\x1b\
\x18\xa6c/\xa2\x06\x06fb\xb8\xb3\x997\xd9\xe3\x9d\xf3\xc3\xc2\xc7\x96\xfee\
\xd2\xef{g\xa9A=\x00=V\xe3a@!\x8a\x19\xf3\xff\xcc3\xbeQ\x8c\t\x07 \xdadPtS\
\x16)\xd9\xdeD\x1au{"A\x0eE\xd5:I\xcd\x06E\xf2(\xc9\xcc\x95\x12m\t\xea\xde\
\x924\x1d\x16\x84\x03\x02#\x05\xb2\xca\xa0\xe0_\xc1L\x8b\xfb@\xa3\xb5\x8d\
\x8d\x8dF\xd3\\s\xf9\xe2{OV\xfe\xe4J\x92\xea\xd1R\xc6H$\x01\x99\x18L\xc8*\
\xe5\xf6\x1bW\xf3\x98\x06#\xda\x0e\xc1\x1aA\xde\xf8\x1cFNL\xeb+)\x17\x99/VJ.\
\x9fV\xcc\xf8\xa5$\xdc \xa9\xfc\xadD\xf9\x04#\xbf!\xc8,\x15tU\x0b.ms\xf2\xfc\
\xd4\xe74\xd2\xebH\xc8\x01o\'\x88\x84:\xc3\xc1\xf2\xf5\xd5\xcf\xef~\xa4zMLR\
\xa1\xde$\xfa\xf4\xc4\xb1\xb2"\x19\x18\x85b\xea\xb4gyh\xe4\x1d\xdc\xa6\xa3`\
\x05!T\x07\xa9\xdet\xc6\xcf\x1b\x8d2\x8c>\x9e\x90(\xec\xcb\x8ah\x8b"e\x94\
\xe4\x93\x07$\x86O2\xf5\t\x89\xe1\x15\xb4\x9d\x12d\xdd\x04!?\x9c]\x0bc\x97\
\x83\x91f\xc7|`\xc7h\xc4\xbe\xb5ETGu\xd5\xc7\xfew7\xdd{\xfa\xc1P\x03\xd5@\
\xc4\x1d\x13\xfdmli\x9c\xe0i\xc2\xa2\xea\xb3\xa7\xf9S\xd8\x8f_\x18`$\x837\
\x1f:U\x0b\xc7w\x9d%\xd4n\xf5\x89\t%\x0c<\xa9\x06\xa9\x05\xb1\xcaT\x9bx\xbc&\
\xbeL\x83\xcb\'L\xce\xaf1\xb8\xf0\x8a\x89/\xcbd\xeaOM\xbc\xe9\xce\x8a\xadDw,\
\xb8\'\xc5\x10\x86\x18sc\xf67\x16\xfd\xa2hIL\x1d}\x83\xb8\x07z\x87\x9d\x85\
\x93\x8f\xeb\xad0\xe7*^\xe4\x8fB\xa0\x85\x04\xe5\x05\xcf\x08\x90\xb9]\x1c\
\xdf\xff9\x81\xea\xb6>\x12\x8a\x931\x0c\x83\x89\x0f\x19\x104\xa8\xf8\xa5I\
\xcd\x9f\x9c\xe0\xce\xfbf\x0c4=A\xc7\xcbq\xe9\x8a\xa7H\x87\x1d\xd9\xf9\xd4\
\x17k\xdfYv~[\x0c\xd7\xc01\xd0KJ*&\xa5|\x14\xd3f\xbf\xcc\x7ff\xcde\xb6\xd6\
\x80\r\xdav$\x15\xac\x83\xbc\xcc1\x94\xcc\x1c\x87\x92\x03H\xaaK\xd2\xf6\xa9S\
\xa1f\xcf\x93=\xa6M\xebn\xf98\x1f\xcb\x19\xda"P\xd3zy\xe3\xfd\xe5/U\xefm\xdf\
\x02|\x0e\xb4\xd2k\x91\x1b\x8c@\xbc\xc1I\xc7\xa4\xd8\x93M\xd9\xcd\x9by\xc6\
\x18\xc60ba\xa4m\xa75\x0c7\x81/\x94I\xe9M7\x92\xecM\xee\x11\xdc\x02\x99(;\
\xe2ev|-\xd0\x89O\x0c\xbc\xb6\x12\x04\xce~r\xa9n\xdd\xd2\x8f~\xddQ\x17\xdd\
\x03\x9c\x07\xda\xe8\xa5\xff~%\xd4\x8f\x94.\x13\xa1.\xd4\xc0\x99\x0b\xff\xcb\
f\xa1\x9cFG(\x10\x06(\x1fxGB$\xb3\x89\xfd\xfb\xf7\xd3\xd4\xd8\xd2C\x02\xcaU\
\x8d\xc6\x1b\x1d\xe9\x96Mb\xc4\xbc\xa6\x15\x9f\xbc\xf1\xd7\x93\xaf,:\xf4XG]t\
\x07P\x19\x9b\xf9>\xe0\x07\xf5\x80\xcb\x0b\x12gm(@1c\xfe\x06\x1e\x1f>\x99\
\x89\xb1)\xec&\x1c\x93T\xa8V0!w:\x93\'N\xe9\xd7\x13}=\xd0=\xf3\xc1`\xc8\xda\
\xfe\xdb\xc3\xbb\xde{\xb6r\rp\x1c\'uv1Hmt\xc5\xad\xc5^e\xc6\xf8\xb4I,\x98\
\xb7\x8e\xc7\xa5\xc7\xb5\x8b\x9c`\x01:\x02A?dF\n\x98_z\x0b^\xd3\xd7+&\xa4\
\xcb\\\'$\xd3\x1ch\r\xfd\xf1?>\xf8\xc3\xc9\xcd\xb5\x1bp\xf4\xee\x07\xc2\x80}\
\xc5Rb\xb0\xa3w\x99\xd1\xfa\x19\'.\xbe\xc9N\xa1@\xc8^\xc3\x00\xe9\x83\xe4\
\xd1\xd0\x96^\xcd\xbbG\xb6\xd2\xd2\xda\xdc#\xcd\xcaX\x0f\xed\xaenkkj#\xcf\
\x7fs\xeb\xaa\x93\x9bk_\x03N\x00\x8d8\x8b\xd6\x15\xab\xd2\xa1\xbe\xe0\xd0\
\xb1\xd9h\xc2\xa2\xfa\xd4/\xd8\xdcYEM\x0f\x12\xaa\xfb[&\x81\'\x1bda;\xbbN\
\xbfIe\xd5\xe7\t\t)\xe1\xd4B\xf1f\xe8\xe4\xd9r\x0e4n5s\xbf\xdf\x11\x01.\xe0l\
\x80\x85\x87R\x89\x0e\x99\x80+\xa0;\x81zl\xce\x9f~\x8e\xff\x03\xacD@\xf7C\
\xc2L\x85\x94\xb1\x16\xe5m\xef\xb1\xef\xc4Nl\xcbNxA\xdb\x9a\x0f\x8e\xbd\xc3\
\xa9\xf0>\x92\x8b4E\xdf\xe3\x81\x91\xf70\xcc5aC:\xae\xea\xfd\x80\xab\xcc\xc8\
C1\xad\xf4%V\xe4\xdd\xc5-\xdd\x06nc\x87\x0c8\x01\x1e\x0e\x80\xa71\x87;\xa6\
\xfd\x13I\xca\xc3;\xc76\xd0\x95]KR\x16\xc8\xd8&B\xb0\x9e\xf5;\xa6\xb1\x0c\
\xe8\x1c\xaa\x07\xae\x96@|m\x18\x0e\x14\x9b\x99\x94\xde\xba\x9bg=#\xc8\xec\
\xb6!\xd1\xe7\tW\x07\xa9-\x88\xb6C4\x90\x84)M\xec\xf4\x0e\xcc\xe1\x0e\xc9\
\xce*\xce\xb5}\xc6\xce\xda\xad\xbcV\xb5\x89\xe3@\xc7\xdf\x84\x80\x8b\x84\x07\
\xa7\x05-)\xba\x97\xefN\xff\x15\xf7\xc7\x81\nw\xc3\xd5\xeb\xd06\x897^\xc1Z\
\xea\xfc\x87)?\xff\x07\xf66\x1f\xe5\x0c\x16\x17q\xb6\xec\x9b\xb8\x8a\x18\xb8\
\xa6wd\xae\x164\x1f\xc5\xb4\xf9\x7f\xe6\xb1\x9c\x9b\x99y\xa5\xeb\xba\xea\xf1\
7\x1d\xe4\xd3\xaa\xd7\xd9\xdf\xb0\x873\x08\x02\x08\x9a\x89\xd0\x82\xb3Xu\x00\
!\xae\x90:\xaf\x07\x81\xf8\xda\x90\x1ekA\xcb\x16\xbe\xcb3F*\xc9\xbdm\xc3\x01\
Z\x02\x1fr\xbcz\x13\x07j\xb7s\xb2\x17\xe8\xcb8\x89!\x8c\xf3\xfe\xc0\xe2jw%\
\xae\xf5-e,\xa0\xbd@.\x8aI\x93\x7f\xc6\xbf\x8d_\xc1\xbd\x00\x91\x16\xda\x03G\
9yi\x0b\x07\xab7\xf2)\x10@\xd2D\x84V\xa0=\x06:\x84\xb3\xbeX8Y\xe7\xaa\x80_\
\x0f\x02\xee\x16t4\x8aq\xb3\xd7p_\xd3\x87T\x9d}\x8dcX\xf8\x114\x11\xa5\xa5\
\x17\xe8\xc4L_+\xe8\xebB\xc0E\xc2\xc4i\xbe\xb3q\xb2\x138Z\xee\x0f\xb4\xcdu\
\x00\xdd\x03\xc3\x97\xbdWLJ\x06Nf2q@F\xf9\x1b\x82\xee\xf1\xfc\xebq\xdf\x98\'\
\xdc\xfb\x86\xd7E\x1eCz\xf6W\xfd\xdfm\xfe\x1f1G\xd5R[\x10\xbd*\x00\x00\x00\
\x00IEND\xaeB`\x82\xc7\xf02\xd5'
