/*!
 * \file src/main-test.c
 *
 * \brief .
 *
 * <hr>
 *
 * <h1><b>Copyright.</b></h1>\n
 *
 * PCB, interactive printed circuit board design
 *
 * Copyright (C) 2015 Andrew Poelstra
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Contact addresses for paper mail and Email:
 * Andrew Poelstra, 16966 60A Ave, V3S 8X5 Surrey, BC, Canada
 * asp11@sfu.ca
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "global.h"
#include "pcb-printf.h"
#include "object_list.h"

int
main (int argc, char *argv[])
{
  initialize_units ();
  pcb_printf_register_tests ();
  object_list_register_tests ();

  g_test_init (&argc, &argv, NULL);
  g_test_run ();
  return 0;
}

