#include <ossim/init/ossimInit.h>
#include <ossim/base/ossimArgumentParser.h>
#include <ossim/base/ossimApplicationUsage.h>
#include <ossim/base/ossimGeoidManager.h>
#include <ossim/elevation/ossimElevManager.h>

#include <cstdlib>

int main(int argc, char* argv[])
{
   ossimArgumentParser argumentParser(&argc, argv);
   ossimInit::instance()->addOptions(argumentParser);
   ossimInit::instance()->initialize(argumentParser);
   argumentParser.getApplicationUsage()->setApplicationName(
      argumentParser.getApplicationName());
   argumentParser.getApplicationUsage()->setDescription(
      argumentParser.getApplicationName()+
      " Returns a MSL and ellipoid height given a lat lon position");
   argumentParser.getApplicationUsage()->addCommandLineOption(
      "-h or --help", "Shows help");
   argumentParser.getApplicationUsage()->setCommandLineUsage(
      argumentParser.getApplicationName()+
      " <lat degrees> <lon degrees>");

   if(argumentParser.read("-h") || argumentParser.read("--help")||
      (argc != 3))
   {
      argumentParser.getApplicationUsage()->write(std::cout);
      exit(0);
   }
   
   if (argumentParser.errors())
   {
      argumentParser.writeErrorMessages(std::cout);
      exit(1);
   }

   ossimGpt gpt;
   gpt.latd(ossimString(argumentParser.argv()[1]).toDouble());
   gpt.lond(ossimString(argumentParser.argv()[2]).toDouble());

   ossim_float64 geoidOffset       = ossimGeoidManager::instance()->
      offsetFromEllipsoid(gpt);
   ossim_float64 hgtAboveMsl       = ossimElevManager::instance()->
      getHeightAboveMSL(gpt);
   ossim_float64 hgtAboveEllipsoid = ossimElevManager::instance()->
      getHeightAboveEllipsoid(gpt);
   ossimFilename cellName          = ossimElevManager::instance()->
      getCellFilenameForPoint(gpt);

   if (cellName.empty() != true)
   {
      std::cout << "Opened cell:  " << cellName.c_str() << std::endl;
   }
   else
   {
      std::cout << "Did not find cell for point!" << std::endl;
   }
 
   std::cout << "Geoid offset:            ";
   if (!ossim::isnan(geoidOffset))
   {
      std::cout << geoidOffset;
   }
   else
   {
      std::cout << "nan";
   }
   std::cout << "\nHeight above MSL:        ";
   if (!ossim::isnan(hgtAboveMsl))
   {
      std::cout << hgtAboveMsl;
   }
   else
   {
      std::cout << "nan";
   }
   std::cout << "\nHeight above ellipsoid:  ";
   if (!ossim::isnan(hgtAboveEllipsoid))
   {
      std::cout << hgtAboveEllipsoid << std::endl;
   }
   else
   {
      std::cout << "nan" << std::endl;
   }
    
   return 0;
}
